<?php
//机柜空调 A接口协议(机柜空调)2019.xlsm
function Get_unicom_ac2_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['设定回风温度（℃）']);
        case '回风温度':
            return array(0, $dataArray['回风温度值（℃）']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_unicom_ac2_Signals($type){
    switch($type){
        case "AI":
            return array("601130A00001","601130900001","601110400001","601110C00001");
        case "DI":
            return array("6013002FF001","6013002FF002","6013002FF003","601300EFF001");
        case "AO":
            //开机温度参数-6016A2101,回风温度参数
            return array("6016A2101001","601630A01001");
        case "DO":
            //遥控开机-601500201,遥控关机-601500200
            return array("601500201001","601500200001");
        case "ALARM":
            return array("601230A04001","601230A02001","601433301001","601460201001","601210404001","601210402001");
        default:
            return array();
    }

}



function Get_unicom_ac2_RtData($memData, &$dataArray, $extraPara = false)
{
      if(empty($memData)) {
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
      } else {
            $dataArray['无数据'] = false;

            $v = unpack('l*', substr($memData, 4, 4 * 2));

            $dataArray["机柜温度[回风温度]"] = number_format($v[1]/100,1);
            $dataArray["AI"]["601130A00001"] = "机柜温度[回风温度]";

            $dataArray["空调送风温度"] = number_format($v[2]/100,1);
            $dataArray["AI"]["601130900001"] = "空调送风温度";

            $v = unpack('L*', substr($memData, 4 + 4 * 2,4 * 2));
            $dataArray["交流电压"] = number_format($v[1]/100,1);
            $dataArray["AI"]["601110400001"] = "交流电压";

            $dataArray["工作电流"] = number_format($v[2]/100,1);
            $dataArray["AI"]["601110C00001"] = "工作电流";


            $v = unpack('c*', substr($memData, 4 + 4 * 2 + 4 * 2,1 * 11));

            $dataArray["开关机状态"] = $v[1] == 0 ? "开机" : "关机";
            $dataArray["DI"]["601300200001"] = $v[1] ? 0 : 1; //关机
            $dataArray["DI"]["601300201001"] = $v[1] ? 1 : 0;//开机
            // $dataArray["DI"]["602130900"] = "开关机状态";

            $dataArray["内风机状态"] = $v[2] == 0 ? "开机" : "关机";
            $dataArray["DI"]["601300200002"] = $v[2] ? 0 : 1; //关机
            $dataArray["DI"]["601300201002"] = $v[2] ? 1 : 0;//开机
            // $dataArray["B"]["602130900"] = "内风机状态";

            $dataArray["外风机状态"] = $v[3] == 0 ? "开机" : "关机";
            $dataArray["DI"]["601300200003"] = $v[3] ? 0 : 1; //关机
            $dataArray["DI"]["601300201003"] = $v[3] ? 1 : 0;//开机
            // $dataArray["B"]["602130900"] = "外风机状态";

            $dataArray["制冷热状态"] = $v[4] == 0 ? "制冷" : "制热";
            $dataArray["DI"]["601300E00001"] = $v[4] ? 0 : 1;//"制冷";
            $dataArray["DI"]["601300E01001"] = $v[4] ? 1 : 0;//制热

            //$dataArray["B"]["601300E"] = "制冷/热状态";


            $dataArray["制冷告警"] = $v[5] == 0 ? "正常" : "告警";
            // $dataArray["B"]["602130900"] = "制冷告警";

            $dataArray["高温告警"] = $v[6] == 0 ? "正常" : "告警";
            $dataArray["ALARM"]["601230A04001"] = "高温告警";

            $dataArray["低温告警"] = $v[7] == 0 ? "正常" : "告警";
            $dataArray["ALARM"]["601230A02001"] = "低温告警";

            $dataArray["加热器告警"] = $v[8] == 0 ? "正常" : "告警";
            // $dataArray["B"]["602130900"] = "加热器告警";

            $dataArray["温度传感器故障"] = $v[9] == 0 ? "正常" : "告警";
            $dataArray["ALARM"]["601460201001"] = "温度传感器故障";

            $dataArray["过电压告警"] = $v[10] == 0 ? "正常" : "告警";
            $dataArray["ALARM"]["601210404001"] = "过电压告警";

            $dataArray["欠电压告警"] = $v[11] == 0 ? "正常" : "告警";
            $dataArray["ALARM"]["601210402001"] = "欠电压告警";



            $v = unpack('l*', substr($memData, 4 + 4 * 2 + 4 * 2 + 1 * 11,4 * 1));
            $dataArray["空调开启点"] = number_format($v[1]/100,1);
            // $dataArray["B"]["602130900"] = "空调开启点";


            $v = unpack('L*', substr($memData, 4 + 4 * 2 + 4 * 2 + 1 * 11 + 4 * 1,4 * 1));

            $dataArray["空调灵敏点"] = number_format($v[1]/100,1);
            // $dataArray["B"]["602130900"] = "空调灵敏点";

            $v = unpack('l*', substr($memData, 4 + 4 * 2 + 4 * 2 + 1 * 11 + 4 * 1 + 4 * 1,4 * 1));

            $dataArray["加热开启点"] = number_format($v[1]/100,1);
            // $dataArray["B"]["602130900"] = "加热开启点";

            $v = unpack('L*', substr($memData, 4 + 4 * 2 + 4 * 2 + 1 * 11 + 4 * 1 + 4 * 1 + 4 * 1,4 * 1));

            $dataArray["加热灵敏度"] = number_format($v[1]/100,1);
            // $dataArray["B"]["602130900"] = "加热灵敏度";

            $v = unpack('l*', substr($memData, 4 + 4 * 2 + 4 * 2 + 1 * 11 + 4 * 1 + 4 * 1 + 4 * 1 + 4 * 1,4 * 2));

            $dataArray["高温告警点"] = number_format($v[1]/100,1);
            // $dataArray["B"]["602130900"] = "高温告警点";
            $dataArray["低温告警点"] = number_format($v[2]/100,1);
            // $dataArray["B"]["602130900"] = "低温告警点";

            $v = unpack('c*', substr($memData, 4 + 4 * 2 + 4 * 2 + 1 * 11 + 4 * 1 + 4 * 1 + 4 * 1 + 4 * 1 + 4 * 2,1 * 6));

            $dataArray["年"] = number_format($v[1]);
            $dataArray["月"] = number_format($v[2]);
            $dataArray["日"] = number_format($v[3]);
            $dataArray["时"] = number_format($v[4]);
            $dataArray["分"] = number_format($v[5]);
            $dataArray["秒"] = number_format($v[6]);


            $v = unpack('S*', substr($memData, 4 + 4 * 2 + 4 * 2 + 1 * 11 + 4 * 1 + 4 * 1 + 4 * 1 + 4 * 1 + 4 * 2 + 1 * 6,2));
            $year = $v[1];
            $v = unpack('C*', substr($memData,  4 + 4 * 2 + 4 * 2 + 1 * 11 + 4 * 1 + 4 * 1 + 4 * 1 + 4 * 1 + 4 * 2 + 1 * 6 + 2, 5));
            $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

      }
}
