<?php

function Get_unicom_acrpz96_Standard_Variable($dataArray, $varname)
{
    switch ($varname) {
        case "[总电能]":
            return array(0, $dataArray['正向有功电能EPI2']);
    }
    return array(1, '设备无此信号数据:' . $varname);
}

function Get_unicom_acrpz96_Size()
{
    return 125;
}


function Get_unicom_acrpz96_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
        $v = unpack("S*", substr($memData, $offset, 2 * 2));
        $dataArray['电压变比'] = $v[1];
        $dataArray['电流变比'] = $ct = $v[2];

        $offset += 2 * 2;
        $v = unpack("S*", substr($memData, $offset, 11 * 2));
        $dataArray['中性线电流'] = number_format($v[1] / 1000, 2) . ' A';
        $dataArray['A相电压'] = number_format($v[2] / 10, 2) . ' V';
        $dataArray['B相电压'] = number_format($v[3] / 10, 2) . ' V';
        $dataArray['C相电压'] = number_format($v[4] / 10, 2) . ' V';
        $dataArray['AB相电压'] = number_format($v[5] / 10, 2) . ' V';
        $dataArray['BC相电压'] = number_format($v[6] / 10, 2) . ' V';
        $dataArray['CA相电压'] = number_format($v[7] / 10, 2) . ' V';
        $dataArray['A相电流'] = number_format($v[8] * $ct / 1000, 2) . ' A';
        $dataArray['B相电流'] = number_format($v[9] * $ct / 1000, 2) . ' A';
        $dataArray['C相电流'] = number_format($v[10] * $ct / 1000, 2) . ' A';
        $dataArray['频率'] = number_format($v[11] / 100, 2) . ' Hz';
        $offset += 11 * 2;
        $newMem = '';
        $mem = substr($memData, $offset, 12 * 4);
        for ($i = 0; $i < strlen($mem); $i += 4) {
            $newMem .= $mem[$i + 2] . $mem[$i + 3] . $mem[$i] . $mem[$i + 1];
        }
        $v = unpack("i*", $newMem);
        $dataArray['A相有功功率'] = number_format($v[1] * $ct / 1000/100,2) . ' kW';
        $dataArray['B相有功功率'] = number_format($v[2] * $ct / 1000/100,2) . ' kW';
        $dataArray['C相有功功率'] = number_format($v[3] * $ct / 1000/100,2) . ' kW';
        $dataArray['三相总有功功率'] = number_format($v[4] * $ct / 1000/100,2) . ' kW';
        $dataArray['A相无功功率'] = number_format($v[5] * $ct / 1000/100,2) . ' kvar';
        $dataArray['B相无功功率'] = number_format($v[6] * $ct / 1000/100,2) . ' kvar';
        $dataArray['C相无功功率'] = number_format($v[7] * $ct / 1000/100,2) . ' kvar';
        $dataArray['三相总无功功率'] = number_format($v[8] * $ct / 1000/100,2) . ' kvar';
        $dataArray['A相视在功率'] = number_format($v[9] * $ct / 1000/100,2) . ' kVA';
        $dataArray['B相视在功率'] = number_format($v[10] * $ct / 1000/100,2) . ' kVA';
        $dataArray['C相视在功率'] = number_format($v[11] * $ct / 1000/100,2) . ' kVA';
        $dataArray['三相总视在功率'] = number_format($v[12] * $ct / 1000/100,2) . ' kVA';
        $offset += 12 * 4;
        $v = unpack("S*", substr($memData, $offset, 4 * 2));
        $dataArray['A相功率因数'] = number_format($v[1] / 1000, 2);
        $dataArray['B相功率因数'] = number_format($v[2] / 1000, 2);
        $dataArray['C相功率因数'] = number_format($v[3] / 1000, 2);
        $dataArray['总功率因数'] = number_format($v[4] / 1000, 2);

        $offset += 4 * 2;
        $newMem = '';
        $mem = substr($memData, $offset, 4 * 4);
        for ($i = 0; $i < strlen($mem); $i += 4) {
            $newMem .= $mem[$i + 2] . $mem[$i + 3] . $mem[$i] . $mem[$i + 1];
        }
        $v = unpack("i*", $newMem);
        $dataArray['正向有功电能EPI'] = number_format($v[1] * $ct / 100/1000, 2) . ' kWh';
        $dataArray['正向有功电能EPI2'] = number_format($v[1] * $ct / 100/1000, 2);
        $dataArray['反向有功电能EPE'] = number_format($v[2] * $ct / 100/1000, 2) . ' kWh';
        $dataArray['正向有功电能EQL'] = number_format($v[3] * $ct / 100/1000, 2) . ' kWh';
        $dataArray['反向有功电能EQC'] = number_format($v[4] * $ct / 100/1000, 2) . ' kWh';
        $offset += 4 * 4;

        $offset += 8 * 2;
        $v = unpack('v', substr($memData, $offset, 2));
        $offset += 2;
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
