<?php


function Get_unicom_coolfree_Signals($type)
{
    switch ($type) {
        case "AI":
            return array("911143200001", "911143200001");
        case "DI":
            return array();
        case "AO":
            return array("911643201001");
        case "DO":
            return array();
        case "ALARM":
            return array();
        default:
            return array();
    }

}


function Get_unicom_coolfree_UnicomCategory()
{
    return "911";
}

function Get_unicom_coolfree_RtData($memData, &$dataArray, $extraPara = false)
{
    if ($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
        $v = unpack('S*', substr($memData, $offset, 2 * 21));
        $dataArray['回风温度测量值'] = number_format($v[1] / 10, 1) . ' ℃';
        $dataArray['回风湿度测量值'] = number_format($v[2] / 10, 1) . ' %RH';
        $dataArray['泵柜1侧环境温度'] = number_format($v[3] / 10, 1) . ' ℃';
        $dataArray['泵柜2侧环境温度'] = number_format($v[4] / 10, 1) . '  ℃';


        //$v[8] - $v[13]
        $dataArray['高压1报警'] = (($v[8] >> 0) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['高压1报警'] = (($v[8] >> 0) & 0x1);

        $dataArray['高压2报警'] = (($v[8] >> 1) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['高压2报警'] = (($v[8] >> 1) & 0x1);

        $dataArray['低压1报警'] = (($v[8] >> 2) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['低压1报警'] = (($v[8] >> 2) & 0x1);

        $dataArray['低压2报警'] = (($v[8] >> 3) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['低压2报警'] = (($v[1] >> 3) & 0x1);

        $dataArray['排气1高温报警'] = (($v[8] >> 4) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['排气1高温报警'] = (($v[8] >> 4) & 0x1);

        $dataArray['排气2高温报警'] = (($v[8] >> 5) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['排气2高温报警'] = (($v[8] >> 5) & 0x1);

        $dataArray['排气1低温告警'] = (($v[8] >> 6) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['排气1低温告警'] = (($v[8] >> 6) & 0x1);

        $dataArray['排气2低温告警'] = (($v[8] >> 7) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['排气2低温告警'] = (($v[8] >> 7) & 0x1);

        $dataArray['风机故障报警'] = (($v[8] >> 8) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['风机故障报警'] = (($v[8] >> 8) & 0x1);

        $dataArray['高温报警'] = (($v[8] >> 9) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['高温报警'] = (($v[8] >> 9) & 0x1);

        $dataArray['低温报警'] = (($v[8] >> 10) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['低温报警'] = (($v[8] >> 10) & 0x1);

        $dataArray['高湿报警'] = (($v[8] >> 11) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['高湿报警'] = (($v[8] >> 11) & 0x1);

        $dataArray['低湿报警'] = (($v[8] >> 12) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['低湿报警'] = (($v[8] >> 12) & 0x1);

        $dataArray['加湿器故障报警'] = (($v[8] >> 13) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['加湿器故障报警'] = (($v[8] >> 13) & 0x1);

        $dataArray['气流丢失报警'] = (($v[8] >> 14) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['气流丢失报警'] = (($v[8] >> 14) & 0x1);

        $dataArray['远程关机报警'] = (($v[8] >> 15) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['远程关机报警'] = (($v[8] >> 15) & 0x1);

        //告警状态2
        $dataArray['温湿度检测板报警'] = (($v[9] >> 0) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['温湿度检测板报警'] = (($v[9] >> 0) & 0x1);

        $dataArray['NTC1故障报警'] = (($v[9] >> 1) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['NTC1故障报警'] = (($v[9] >> 1) & 0x1);

        $dataArray['NTC2故障报警'] = (($v[9] >> 2) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['NTC2故障报警'] = (($v[9] >> 2) & 0x1);

        $dataArray['NTC3故障报警'] = (($v[9] >> 3) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['NTC3故障报警'] = (($v[9] >> 3) & 0x1);

        $dataArray['烟雾传感器报警'] = (($v[9] >> 4) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['烟雾传感器报警'] = (($v[9] >> 4) & 0x1);

        $dataArray['电加热故障报警'] = (($v[9] >> 5) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电加热故障报警'] = (($v[9] >> 5) & 0x1);

        $dataArray['群控地址重复'] = (($v[9] >> 6) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['群控地址重复'] = (($v[9] >> 6) & 0x1);

        $dataArray['群控从机丢失'] = (($v[9] >> 7) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['群控从机丢失'] = (($v[9] >> 7) & 0x1);

        $dataArray['群控主机丢失'] = (($v[9] >> 8) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['群控主机丢失'] = (($v[9] >> 8) & 0x1);

        $dataArray['电极加湿排水故障'] = (($v[9] >> 11) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电极加湿排水故障'] = (($v[9] >> 11) & 0x1);

        $dataArray['电极加湿板故障'] = (($v[9] >> 12) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电极加湿板故障'] = (($v[9] >> 12) & 0x1);

        $dataArray['电极加湿大电流'] = (($v[9] >> 13) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电极加湿大电流'] = (($v[9] >> 13) & 0x1);

        $dataArray['电极加湿小电流'] = (($v[9] >> 14) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电极加湿小电流'] = (($v[9] >> 14) & 0x1);

        $dataArray['电极加湿维护'] = (($v[9] >> 15) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电极加湿维护'] = (($v[9] >> 15) & 0x1);

        //告警状态3
        $dataArray['电源丢失报警'] = (($v[10] >> 0) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电源丢失报警'] = (($v[10] >> 0) & 0x1);

        $dataArray['电源故障报警'] = (($v[10] >> 1) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['电源故障报警'] = (($v[10] >> 1) & 0x1);

        $dataArray['地板溢水报警'] = (($v[10] >> 6) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['地板溢水报警'] = (($v[10] >> 6) & 0x1);

        $dataArray['高压1锁定报警'] = (($v[10] >> 7) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['高压1锁定报警'] = (($v[10] >> 7) & 0x1);

        $dataArray['高压2锁定报警'] = (($v[10] >> 8) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['高压2锁定报警'] = (($v[10] >> 8) & 0x1);

        $dataArray['低压1锁定报警'] = (($v[10] >> 9) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['低压1锁定报警'] = (($v[10] >> 9) & 0x1);

        $dataArray['低压2锁定报警'] = (($v[10] >> 10) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['低压2锁定报警'] = (($v[10] >> 10) & 0x1);

        $dataArray['盘管冻结1报警'] = (($v[10] >> 11) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['盘管冻结1报警'] = (($v[10] >> 11) & 0x1);

        $dataArray['盘管冻结2报警'] = (($v[10] >> 12) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['盘管冻结2报警'] = (($v[10] >> 12) & 0x1);

        $dataArray['红外加湿器高水位报警'] = (($v[10] >> 13) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['红外加湿器高水位报警'] = (($v[10] >> 13) & 0x1);

        $dataArray['排气1高温锁定'] = (($v[10] >> 14) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['排气1高温锁定'] = (($v[10] >> 14) & 0x1);

        $dataArray['排气2高温锁定警'] = (($v[10] >> 15) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['排气2高温锁定'] = (($v[10] >> 15) & 0x1);

        //告警状态4
        $dataArray['排气1低温锁定'] = (($v[11] >> 0) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['排气1低温锁定'] = (($v[11] >> 0) & 0x1);

        $dataArray['排气2低温锁定'] = (($v[11] >> 1) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['排气2低温锁定'] = (($v[11] >> 1) & 0x1);

        $dataArray['低压传感器1失效报警'] = (($v[11] >> 2) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['低压传感器1失效报警'] = (($v[11] >> 2) & 0x1);

        $dataArray['低压传感器2失效报警'] = (($v[11] >> 3) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['低压传感器2失效报警'] = (($v[11] >> 3) & 0x1);

        $dataArray['过滤网堵塞报警'] = (($v[11] >> 4) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['过滤网堵塞报警'] = (($v[11] >> 4) & 0x1);

        $dataArray['泵1进压故障报警'] = (($v[11] >> 5) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1进压故障报警'] = (($v[11] >> 5) & 0x1);

        $dataArray['泵1出压故障报警'] = (($v[11] >> 6) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1出压故障报警'] = (($v[11] >> 6) & 0x1);

        $dataArray['泵2进压故障报警'] = (($v[11] >> 7) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2进压故障报警'] = (($v[11] >> 7) & 0x1);

        $dataArray['泵2出压故障报警'] = (($v[11] >> 8) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2出压故障报警'] = (($v[11] >> 8) & 0x1);

        $dataArray['泵柜1环境NTC失效报警'] = (($v[11] >> 9) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵柜1环境NTC失效报警'] = (($v[11] >> 9) & 0x1);

        $dataArray['泵柜2环境NTC失效报警'] = (($v[11] >> 10) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵柜2环境NTC失效报警 '] = (($v[11] >> 10) & 0x1);

        $dataArray['泵1过温报警'] = (($v[11] >> 11) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1过温报警'] = (($v[11] >> 11) & 0x1);

        $dataArray['泵2过温报警'] = (($v[11] >> 12) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2过温报警'] = (($v[11] >> 12) & 0x1);

        $dataArray['泵1过温锁定报警'] = (($v[11] >> 13) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1过温锁定报警'] = (($v[11] >> 13) & 0x1);

        $dataArray['泵2过温锁定报警'] = (($v[11] >> 14) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2过温锁定报警'] = (($v[11] >> 14) & 0x1);

        $dataArray['泵1高扬程报警'] = (($v[11] >> 15) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1高扬程报警'] = (($v[11] >> 15) & 0x1);

        //告警状态5
        $dataArray['泵1低扬程报警'] = (($v[12] >> 0) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1低扬程报警'] = (($v[12] >> 0) & 0x1);

        $dataArray['泵1高扬程锁定报警'] = (($v[12] >> 1) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1高扬程锁定报警'] = (($v[12] >> 1) & 0x1);

        $dataArray['泵1低扬程锁定报警'] = (($v[12] >> 2) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1低扬程锁定报警'] = (($v[12] >> 2) & 0x1);

        $dataArray['泵2高扬程报警'] = (($v[12] >> 3) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2高扬程报警'] = (($v[12] >> 3) & 0x1);

        $dataArray['泵2低扬程报警'] = (($v[12] >> 4) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2低扬程报警'] = (($v[12] >> 4) & 0x1);

        $dataArray['泵2高扬程锁定报警'] = (($v[12] >> 5) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2高扬程锁定报警'] = (($v[12] >> 5) & 0x1);

        $dataArray['泵2低扬程锁定报警'] = (($v[12] >> 6) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2低扬程锁定报警'] = (($v[12] >> 6) & 0x1);

        $dataArray['泵1控制器故障报警'] = (($v[12] >> 7) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1控制器故障报警'] = (($v[12] >> 7) & 0x1);

        $dataArray['泵2控制器故障报警'] = (($v[12] >> 8) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2控制器故障报警'] = (($v[12] >> 8) & 0x1);

        $dataArray['泵1通信故障报警'] = (($v[12] >> 9) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵1通信故障报警'] = (($v[12] >> 9) & 0x1);

        $dataArray['泵2通信故障报警'] = (($v[12] >> 10) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['泵2通信故障报警'] = (($v[12] >> 10) & 0x1);

        $dataArray['冷凝器1压力故障报警'] = (($v[12] >> 11) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['冷凝器1压力故障报警'] = (($v[12] >> 11) & 0x1);

        $dataArray['冷凝器2压力故障报警'] = (($v[12] >> 12) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['冷凝器2压力故障报警'] = (($v[12] >> 12) & 0x1);

        $dataArray['冷凝器1风机过温报警'] = (($v[12] >> 13) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['冷凝器1风机过温报警'] = (($v[12] >> 13) & 0x1);

        $dataArray['冷凝器2风机过温报警'] = (($v[12] >> 14) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['冷凝器2风机过温报警'] = (($v[12] >> 14) & 0x1);

        $dataArray['冷凝器1风机过温锁定'] = (($v[12] >> 15) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['冷凝器1风机过温锁定'] = (($v[12] >> 15) & 0x1);

        //告警状态6
        $dataArray['冷凝器2风机过温锁定'] = (($v[13] >> 0) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['冷凝器2风机过温锁定'] = (($v[13] >> 0) & 0x1);

        $dataArray['风机调速器1故障报警'] = (($v[13] >> 1) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['风机调速器1故障报警'] = (($v[13] >> 1) & 0x1);

        $dataArray['风机调速器2故障报警'] = (($v[13] >> 2) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['风机调速器2故障报警'] = (($v[13] >> 2) & 0x1);

        $dataArray['风机调速器1通讯故障报警'] = (($v[13] >> 3) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['风机调速器1通讯故障报警'] = (($v[13] >> 3) & 0x1);

        $dataArray['风机调速器2通讯故障报警'] = (($v[13] >> 4) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['风机调速器2通讯故障报警'] = (($v[13] >> 4) & 0x1);

        $dataArray['系统1EEV通讯故障报警'] = (($v[13] >> 5) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['系统1EEV通讯故障报警'] = (($v[13] >> 5) & 0x1);

        $dataArray['系统1EEV故障报警'] = (($v[13] >> 6) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['系统1EEV故障报警'] = (($v[13] >> 6) & 0x1);

        $dataArray['系统2EEV通讯故障报警'] = (($v[13] >> 7) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['系统2EEV通讯故障报警'] = (($v[13] >> 7) & 0x1);

        $dataArray['系统2EEV故障报警'] = (($v[13] >> 8) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['系统2EEV故障报警'] = (($v[13] >> 8) & 0x1);

        $dataArray['吸气温度传感器1失效报警'] = (($v[13] >> 9) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['吸气温度传感器1失效报警'] = (($v[13] >> 9) & 0x1);

        $dataArray['吸气温度传感器2失效报警'] = (($v[13] >> 10) & 0x1) == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['吸气温度传感器2失效报警'] = (($v[13] >> 10) & 0x1);

        switch($v[14])
        {
            case 0:
                $dataArray['机组运行状态'] = "关机";
                break;
            case 1:
                $dataArray['机组运行状态'] = "运行";
                break;
            case 2:
                $dataArray['机组运行状态'] = "待机";
                break;
            case 4:
                $dataArray['机组运行状态'] = "本地关机";
                break;
            case 8:
                $dataArray['机组运行状态'] = "远程关机";
                break;
            case 16:
                $dataArray['机组运行状态'] = "监控关机";
                break;
        }
        switch($v[15])
        {
            case 0:
                $dataArray['系统1制冷模式'] = "空闲模式";
                break;
            case 1:
                $dataArray['系统1制冷模式'] = "压缩机模式";
                break;
            case 2:
                $dataArray['系统1制冷模式'] = "混合模式";
                break;
            case 3:
                $dataArray['系统1制冷模式'] = "泵模式";
                break;
        }
        switch($v[16])
        {
            case 0:
                $dataArray['系统2制冷模式'] = "空闲模式";
                break;
            case 1:
                $dataArray['系统2制冷模式'] = "压缩机模式";
                break;
            case 2:
                $dataArray['系统2制冷模式'] = "混合模式";
                break;
            case 3:
                $dataArray['系统2制冷模式'] = "泵模式";
                break;
        }
        $dataArray["回风温度设定"] = number_format($v[17] / 10, 1) . ' ℃';
        $dataArray["温度精度设定"] = number_format($v[18] / 10, 1) . ' ℃';
        $dataArray["回风湿度设定"] = number_format($v[19] / 10, 1) . ' %RH';
        $dataArray["湿度精度设定"] = number_format($v[20] / 10, 1) . ' %RH';
        $dataArray["监控开关机"] = $v[21] == 0 ? "开机" : "关机";

        $offset += 2 * 21;
        $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $offset += 2;
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }

}
