<?php

function Get_unicom_coolmaster3k_Size()
{
    return 150;
}

function Get_unicom_coolmaster3k_DeviceIoControl_Parameter($action, $parameter)
{
    if($action == 106 && count($parameter) == 1){
        return pack("S", intval($parameter[0]));
    }
    return -1;
}

function Get_unicom_coolmaster3k_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
        $v = unpack("s*", substr($memData, $offset, 20 * 2));
        $dataArray['回风温度测量值'] = number_format($v[1]/10,1) . ' ℃';
        $dataArray['回风湿度测量值'] = $v[2] . ' %';
        $dataArray['内风机运行时间'] = $v[11] . ' 小时';
        $dataArray['外风机运行时间'] = $v[12] . ' 小时';
        $dataArray['压缩机运行时间'] = $v[13] . ' 小时';
        $dataArray['电加热运行时间'] = $v[16] . ' 小时';
        $dataArray['加湿器运行时间'] = $v[17] . ' 小时';
        $dataArray['电源频率'] = number_format($v[18]/10,1) . ' Hz';
        $dataArray['加热设定'] = number_format($v[19]/10,1) . ' ℃';
        $dataArray['加热范围'] = number_format($v[20]/10,1) . ' ℃';

        $offset += 20 * 2;
        $v = unpack("S*", substr($memData, $offset, 10 * 2));
        $dataArray['高温报警值'] = number_format($v[1]/10,1) . ' ℃';
        $dataArray['低温报警值'] = number_format($v[2]/10,1) . ' ℃';
        $dataArray['高湿报警值'] = $v[3] . ' %';
        $dataArray['低湿报警值'] = $v[4] . ' %';
        $dataArray['制冷设点'] = number_format($v[7]/10, 1) . ' ℃';
        $dataArray['制冷范围'] = number_format($v[8]/10, 1) . ' ℃';
        $dataArray['湿度设点'] = number_format($v[9]/10, 1) . ' %';
        $dataArray['湿度范围'] = number_format($v[10]/10, 1) * 10 . ' %';

        $offset += 10 * 2;
        $v = unpack("S*", substr($memData, $offset, 7 * 2));
        $dataArray['年'] = $v[1];
        $dataArray['月'] = $v[2];
        $dataArray['日'] = $v[3];
        $dataArray['时'] = $v[4];
        $dataArray['分'] = $v[5];
        $dataArray['秒'] = $v[6];
        switch ($v[7]) {
            case 0:
                $dataArray['运行状态'] = '本地关机';
                break;
            case 1:
                $dataArray['运行状态'] = '远程关机';
                break;
            case 2:
                $dataArray['运行状态'] = '监控关机';
                break;
            case 3:
                $dataArray['运行状态'] = '组网待机';
                break;
            case 4:
                $dataArray['运行状态'] = '电源保护';
                break;
            case 5:
                $dataArray['运行状态'] = '气流保护';
                break;
            case 6:
                $dataArray['运行状态'] = '压机锁定';
                break;
            case 7:
                $dataArray['运行状态'] = '系统开机';
                break;
            default:
                $dataArray['运行状态'] = '未定义';
        }

        $offset += 7 * 2;
        $v = unpack("C*", substr($memData, $offset, 65));
        $dataArray['制冷状态'] = $v[1] == 1 ? '开启' : '停止';
        $dataArray["AlertArray"]["制冷状态"] = $v[1] == 1;
        $dataArray['加热状态'] = $v[2] == 1 ? '开启' : '停止';
        $dataArray["AlertArray"]["加热状态"] = $v[2] == 1;
        $dataArray['加湿状态'] = $v[3] == 1 ? '开启' : '停止';
        $dataArray["AlertArray"]["加湿状态"] = $v[3] == 1;
        $dataArray['除湿状态'] = $v[4] == 1 ? '开启' : '停止';
        $dataArray["AlertArray"]["除湿状态"] = $v[4] == 1;
        $dataArray['监控关机'] = $v[8] == 1 ? '开启' : '停止';
        $dataArray["AlertArray"]["监控关机"] = $v[8] == 1;
        $dataArray['送风温度故障'] = $v[26] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["送风温度故障"] = $v[26] == 1;
        $dataArray['高温报警'] = $v[27] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["高温报警"] = $v[27] == 1;
        $dataArray['低温报警'] = $v[28] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["低温报警"] = $v[28] == 1;
        $dataArray['高湿报警'] = $v[29] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["高湿报警"] = $v[29] == 1;
        $dataArray['低湿报警'] = $v[30] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["低湿报警"] = $v[30] == 1;
        $dataArray['高压报警'] = $v[31] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["高压报警"] = $v[31] == 1;
        $dataArray['高压锁定'] = $v[32] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["高压锁定"] = $v[32] == 1;
        $dataArray['低压报警'] = $v[35] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["低压报警"] = $v[35] == 1;
        $dataArray['低压锁定'] = $v[36] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["低压锁定"] = $v[36] == 1;
        $dataArray['防雷告警'] = $v[37] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["防雷告警"] = $v[37] == 1;
        $dataArray['排气报警'] = $v[39] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["排气报警"] = $v[39] == 1;
        $dataArray['排气锁定'] = $v[40] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["排气锁定"] = $v[40] == 1;
        $dataArray['加湿过流'] = $v[41] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["加湿过流"] = $v[41] == 1;
        $dataArray['内风机故障'] = $v[43] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["内风机故障"] = $v[43] == 1;
        $dataArray['地板溢水'] = $v[44] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["地板溢水"] = $v[44] == 1;
        $dataArray['气流丢失'] = $v[45] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["气流丢失"] = $v[45] == 1;
        $dataArray['备用'] = $v[46] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["备用"] = $v[46] == 1;
        $dataArray['加湿器故障'] = $v[47] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["加湿器故障"] = $v[47] == 1;
        $dataArray['加热器故障'] = $v[48] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["加热器故障"] = $v[48] == 1;
        $dataArray['回风温度故障'] = $v[50] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["回风温度故障"] = $v[50] == 1;
        $dataArray['回风湿度故障'] = $v[51] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["回风湿度故障"] = $v[51] == 1;
        $dataArray['冷凝压力故障'] = $v[54] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["冷凝压力故障"] = $v[54] == 1;
        $dataArray['烟感告警'] = $v[56] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["烟感告警"] = $v[56] == 1;
        $dataArray['缺相告警'] = $v[57] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["缺相告警"] = $v[57] == 1;
        $dataArray['相序错误'] = $v[58] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["相序错误"] = $v[58] == 1;
        $dataArray['远程关机报警'] = $v[63] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["远程关机报警"] = $v[63] == 1;
        $dataArray['电源丢失报警'] = $v[64] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["电源丢失报警"] = $v[64] == 1;
        $dataArray['组网失败报警'] = $v[65] == 1 ? '告警' : '正常';
        $dataArray["AlertArray"]["组网失败报警"] = $v[65] == 1;

        $offset += 65;
        $v = unpack('v', substr($memData, $offset, 2));
        $offset += 2;
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
