<?php

function Get_cuc21vb_Standard_Variable($dataArray, $varname)
{
    switch ($varname) {
        case '直流负载电流':
            $total = 0.0;
            for ($i = 1; $i <= 5; $i++) {
                if (isset($dataArray["直流屏" . $i])) {
                    $total += floatval($dataArray["直流屏" . $i]["负载总电流"]);
                    continue;
                }
                break;
            }
            return array(0, $total . "A");
        default:
            break;
    }
    return array(1, '设备无此信号数据:' . $varname);
}

function _GetCheckCuc21vbShutDown($value)
{
    switch ($value) {
        case 0:
            return '开机';
        case 1:
            return '关机';
        case 225:
            return '效能待机';
        case 240:
            return '模块屏蔽';
        case 254:
            return '通讯中断';
        default :
            break;
    }
    return '无效';
}

function _GetCheckCuc21vbILimit($value)
{
    switch ($value) {
        case 0:
            return '限流';
        case 1:
            return '不限流';
        case 240:
            return '模块屏蔽';
        case 254:
            return '通讯中断';
        default :
            break;
    }
    return '无效';
}

function _GetCheckCuc21vbCharge($value)
{
    switch ($value) {
        case 0:
            return '浮充';
        case 1:
            return '均充';
        case 2:
            return '测试';
        case 240:
            return '模块屏蔽';
        case 241:
            return '电池放电';
        case 242:
            return '市电中断';
        case 254:
            return '通讯中断';
        default :
            break;
    }
    return '无效';
}

function _GetCheckCuc21vbFault($value)
{
    switch ($value) {
        case 0:
            return '正常';
        case 1:
            return '告警';
        case 240:
            return '模块屏蔽';
        case 254:
            return '通讯中断';
        default :
            break;
    }
    return '无效';
}

function Is_cuc21vb_NeedExtraPara()
{
    return true;
}

function Get_unicom_dps6000_RtData($memData, &$dataArray, $extraPara = false)
{
    if (strlen($memData) >= 70) {
        $dataArray["无数据"] = false;
        //1
        $offset = 4;
        $v = unpack('f', substr($memData, $offset, 4));    //float
        $dataArray["整流器输出电压"] = number_format($v[1], 2) . "V";
        //2
        $offset += 4;
        $v = unpack('C', substr($memData, $offset, 1));//unsigned char
        $dataArray["整流模块数"] = $channel_count = $v[1];
        //3 UNICOM_DPS6000_rc_channel
        $offset += 1;
        for ($i = 0; $i < 64; $i++) {
            $channelObj = array();
            $channelObj["AlertArray"] = array();
            $channelData = substr($memData, $offset + $i * 8, 8);
            $v = unpack('f*', substr($channelData, 0, 4 * 1));//float
            $dataArray["模块" . ($i + 1) . "输出电流"] = number_format($v[1], 2) . "A";
            $v = unpack('C*', substr($channelData, 4, 1 * 4));//signed char
            $dataArray["模块" . ($i + 1) . "开机/关机状态"] = _GetCheckCuc21vbShutDown($v[1]);
            $dataArray["模块" . ($i + 1) . "限流/不限流状态"] = _GetCheckCuc21vbILimit($v[2]);
            $dataArray["模块" . ($i + 1) . "浮充/均充/测试状态"] = _GetCheckCuc21vbCharge($v[3]);
            $dataArray["模块" . ($i + 1) . "告警状态"] = _GetCheckCuc21vbFault($v[4]);
            $dataArray["AlertArray"]["模块" . ($i + 1) . "告警状态"] = $v[4] == 1;
        }
        //4 UNICOM_DPS6000_BatteryInfo
        $offset += 64 * 8;
        for ($i = 0; $i < 4; $i++) {
            $batteryObj = array();
            $batteryData = substr($memData, $offset + $i * 14, 14);
            $v = unpack('I*', substr($batteryData, 0, 4));
            $v = unpack('S*', substr($batteryData, 4, 2 * 5));
            $dataArray["电池组" . ($i + 1) . "电压"] = ($v[1] / 10) . "V";
            $dataArray["电池组" . ($i + 1) . "电流"] = $v[2];
            $dataArray["电池组" . ($i + 1) . "温度"] = number_format($v[3] / 10, 1) . "℃";
            $dataArray["电池组" . ($i + 1) . "剩余电量"] = $v[4] . "AH";
            $dataArray["电池组" . ($i + 1) . "浅放电容量"] = $v[5];
        }
        //5 alarm_item 跳过
        $offset += 56;
        $v = unpack('S*', substr($memData, $offset, 50 * 4));

        //6 41_86 看文档 charge[27]
        $offset += 50 * 4;
        $v = unpack('S*', substr($memData, $offset, 27 * 2));
        $dataArray["均充功能"] = $v[1] == 1 ? '开启' : '关闭';
        $dataArray["均充电压值"] = number_format($v[2] / 10, 2) . "V";
        $dataArray["最大均充时间"] = $v[3] . "Hr";
        $dataArray["均充持续时间"] = $v[4] . "Hr";
        $dataArray["均充结束电流"] = $v[5] . "C10";
        $dataArray["电压触发功能"] = $v[6] == 1 ? '开启' : '关闭';
        $dataArray["均充触发电压"] = number_format($v[7] / 10, 2) . "V";
        $dataArray["电流触发功能"] = $v[8] == 1 ? '开启' : '关闭';
        $dataArray["均充触发电流"] = $v[9] . "C10";
        $dataArray["均充周期"] = $v[10] . "月";
        $dataArray["下次均充开始时间"] = $v[11];
        $dataArray["复电均充放电%"] = $v[12] . '%';
        $dataArray["累计浅放电容量"] = $v[13] == 0 ? '关闭' : $v[13] . 'C10';
        $dataArray["浮充电压值"] = number_format($v[14] / 10, 2) . "V";
        switch ($v[15]) {
            case 0:
                $str = "关";
                break;
            case 1:
                $str = "浮充补偿";
                break;
            case 2:
                $str = "均浮充补偿";
                break;
            default :
                $str = "未定义";
                break;
        }
        $dataArray["温度补偿功能"] = $str;
        $dataArray["温度补偿系数"] = $v[16] . 'mV/℃/Cell';
        $dataArray["补偿电压上限"] = number_format($v[17] / 10, 2) . "V";
        $dataArray["补偿电压下限"] = number_format($v[18] / 10, 2) . "V";
        switch ($v[19]) {
            case 0:
                $str = "手动";
                break;
            case 1:
                $str = "恒压限流";
                break;
            case 2:
                $str = "三段限流";
                break;
            default :
                $str = "未定义";
                break;
        }
        $dataArray["限流模式"] = $str;
        $dataArray["模块手动限流值"] = $v[20] . '%';
        $dataArray["恒压限流值"] = $v[21] . 'C10';
        $dataArray["浮充限流值"] = $v[22] . 'C10';
        $dataArray["均充限流值"] = $v[23] . 'C10';
        $dataArray["深度放电限流值"] = $v[24] . 'C10';
        $dataArray["最小模块总电流"] = $v[25] . 'C10';
        $dataArray["充电过流告警值"] = $v[26] . 'C10';
        $dataArray["放电不平衡告警值"] = $v[27] . 'C10';


        //7
        $offset += 27*2;
        $v = unpack('f*', substr($memData, $offset, 3 * 4));    //float
        $dataArray["交流1A相电压"] = number_format($v[1],2) . "V";
        $dataArray["交流1B相电压"] = number_format($v[2],2) . "V";
        $dataArray["交流1C相电压"] = number_format($v[3],2) . "V";

        //8
        $offset += 3 * 4;
        $v = unpack('f*', substr($memData, $offset, 3 * 4));    //float
        $dataArray["交流2A相电压"] = number_format($v[1],2) . "V";
        $dataArray["交流2B相电压"] = number_format($v[2],2) . "V";
        $dataArray["交流2C相电压"] = number_format($v[3],2) . "V";

        //9
        $offset += 3 * 4;
        $v = unpack('f*', substr($memData, $offset, 4 * 4));    //float
        $dataArray["交流A相负载电流"] = number_format($v[1],2) . "A";
        $dataArray["交流B相负载电流"] = number_format($v[2],2) . "A";
        $dataArray["交流V相负载电流"] = number_format($v[3],2) . "A";
        $dataArray["零线"] = number_format($v[4],2) . "A";

        //10
        $offset += 4 * 4;
        $v = unpack('f*', substr($memData, $offset, 2 * 4));    //float
        $dataArray["交流1频率"] = number_format($v[1]*10, 2) . "Hz";
        $dataArray["交流2频率"] = number_format($v[1]*10, 2) . "Hz";

        //11 12 13
        $offset += 2 * 4;
        $v = unpack('C*', substr($memData, $offset, 3));
        switch ($v[1]) {
            case 0:
                $str = "位置0";
                break;
            case 1:
                $str = "位置1";
                break;
            case 2:
                $str = "位置2";
                break;
            default :
                $str = "未定义";
                break;
        }
        $dataArray["ATS状态"] = $str;
        switch ($v[2]) {
            case 0:
                $str = "自动";
                break;
            case 1:
                $str = "手动";
                break;
            case 2:
                $str = "维护";
                break;
            default :
                $str = "未定义";
                break;
        }
        $dataArray["ATS工作模式"] = $str;
        switch ($v[3]) {
            case '0':
                $str = "AC全断";
                break;
            case '1':
                $str = "AC1供电";
                break;
            case '2':
                $str = "AC2供电";
                break;
            case '3':
                $str = "AC3供电";
                break;
            default :
                $str = "未定义";
                break;
        }
        $dataArray["交流投入状态"] = $str;

        //14 15
        $offset += 3;
        $v = unpack('c*', substr($memData, $offset, 2));
        $dataArray["限流状态"] = $v[1] == 1 ? '限流' : '不限流';
        switch ($v[2]) {
            case 1:
                $dataArray["系统状态"] = '电池放电';
                break;
            case 2:
                $dataArray["系统状态"] = '浮充';
                break;
            case 3:
                $dataArray["系统状态"] = '手动均充';
                break;
            case 4:
                $dataArray["系统状态"] = '周期均充';
                break;
            case 5:
                $dataArray["系统状态"] = '交流复电均充';
                break;
            case 6:
                $dataArray["系统状态"] = '整流屏交流中断';
                break;
            default:
                $dataArray["系统状态"] = '无效';
                break;
        }
        //16
        $offset += 2;
        $v = unpack('f*', substr($memData, $offset, 4));
        $dataArray["系统负载电流"] = number_format($v[1], 2) . "A";

        //时间
        $v = unpack('v', substr($memData, $offset + 4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 4 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    } else {
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }
}


?>
