<?php

function Get_unicom_hmi2796s_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        //直流主路数据
        $v = unpack("S*", substr($memData, 4 + 2 + 48 + 6, 5 * 2));
        $dataArray["直流主路电压"] = number_format($v[1] / 10, 2) . "V";
        $dataArray["直流主路电流"] = number_format($v[2] / 10, 2) . "A";
        $dataArray["直流主路功率"] = number_format($v[3] / 100, 2) . "KW";
        $dataArray["直流主路电能"] = number_format((($v[5] << 16) + $v[4]) / 100 , 2) . "kWh";


        //直流I电压
        $v = unpack("S*", substr($memData, 4 + 2 + 48 + 6 + 5 * 2, 48 * 2));
        for($i = 1; $i <= 48; $i++) {
            $dataArray["直流支路电压" . $i] = number_format($v[$i] / 10, 2) . "V";
        }

        //直流I电流
        $v = unpack("S*", substr($memData, 4 + 2 + 48 + 6 + 5 * 2 + 48 * 2, 48 * 2));
        for($i = 1; $i <= 48; $i++) {
            $dataArray["直流支路电流" . $i] = number_format($v[$i] / 10, 2) . "A";
        }

        //直流I功率
        $v = unpack("S*", substr($memData, 4 + 2 + 48 + 6 + 5 * 2 + 48 * 2 + 48 * 2, 48 * 2));
        for($i = 1; $i <= 48; $i++) {
            $dataArray["直流支路功率" . $i] = number_format($v[$i] / 100, 2) . "kW";
        }

        //直流I电能
        $v = unpack("S*", substr($memData, 4 + 2 + 48 + 6 + 5 * 2 + 48 * 2 + 48 * 2 + 48 * 2, 48 * 4));
        for($i = 1; $i <= 48; $i++) {
            $dataArray["直流支路电能" . $i] = number_format((($v[$i*2] << 16) + $v[$i*2-1]) / 100 , 2) . "kWh";
        }

        $v = unpack('v', substr($memData, 4 + 2 + 48 + 6 + 5 * 2 + 48 * 2 + 48 * 2 + 48 * 2 + 48 * 4 + 6 * 2, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2 + 48 + 6 + 5 * 2 + 48 * 2 + 48 * 2 + 48 * 2 + 48 * 4 + 6 * 2 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
