<?php

function Get_unicom_iplu_2801bm_DeviceIoControl_Parameter($action, $parameter)
{
    return null;
}
function Get_unicom_iplu_2801bm_Standard_Variable($dataArray, $varname){
    return array(1 , '设备无此信号数据:'. $varname);
}


include_once "application/helpers/unicom_b/461.php";
function Get_unicom_iplu_2801bm_Signals($type){
    switch($type){
        case "AI":
            $aiArr = get_461_Signals($type);
            for($i=1;$i<24;$i++){
                $aiArr[] = "461127100".str_pad($i, 3, "0", STR_PAD_LEFT);
            }
            for($i=1;$i<24;$i++){
                $aiArr[] = "461127200".str_pad($i, 3, "0", STR_PAD_LEFT);
            }
            return $aiArr;
        default:
            return get_461_Signals($type);
    }

}


function Get_unicom_iplu_2801bm_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData) ) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray["AI"] = array();
        $v = unpack('C', substr($memData, 4, 1));
        $dataArray["电池数量"] = $v[1];
        $v = unpack('f*', substr($memData, 4+1, 4*255));
        for($i=1;$i<=24;$i++){
            $dataArray["电池".$i."电压"] = number_format($v[$i],3);
            $dataArray["AI"]["461127100".str_pad($i, 3, "0", STR_PAD_LEFT)] = "电池".$i."电压";
        }
        $v = unpack('C', substr($memData, 4 + 1 + 4*255, 1));
        $dataArray["温度数量"] = $v[1];
        $v = unpack('f*', substr($memData, 4+1 + 4*255 + 1, 4*255));
        for($i=1;$i<=24;$i++){
            $dataArray["电池".$i."温度"] = number_format($v[$i],3);
            $dataArray["AI"]["461127200".str_pad($i, 3, "0", STR_PAD_LEFT)] = "电池".$i."温度";
        }
        $v = unpack('f*', substr($memData, 4+1 + 4*255 + 1 + 4*255, 4*2));
        $dataArray["电流"] = number_format($v[1],2);
        $dataArray["AI"]["461127500001"] = "电流";
        $dataArray["整组电压"] = number_format($v[2],2);
        $dataArray["AI"]["461127400001"] = "整组电压";

	    $v = unpack('v', substr($memData, 4+1 + 4*255 + 1 + 4*255 + 4*2 + 255 + 255 + 2, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4+1 + 4*255 + 1 + 4*255 + 4*2 + 255 + 255 + 2 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }
}
