<?php

function _unicom_ll13_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

function Get_unicom_ll13_RtData($memData,&$dataArray,$extraPara = false) {
	if ($memData == false) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {
		$dataArray['无数据'] = false;
		
		$offset = 4;
		//新风机组
		$fName = ["新风机组1-4-1","新风机组1-4-2","新风机组1-4-3","新风机组1-4-4","新风机组1-4-5","新风机组1-4-6",
			"新风机组1-7-1","新风机组1-7-2","新风机组1-7-3","新风机组1-7-4","新风机组1-7-5","新风机组1-7-6","新风机组1-7-7",
			"新风机组1-8-1","新风机组1-8-2","新风机组1-8-3","新风机组1-8-4","新风机组1-8-5","新风机组1-8-6","新风机组1-8-7","新风机组1-8-8",
			"新风机组2-7-1","新风机组2-7-2","新风机组2-7-3","新风机组2-7-4","新风机组2-7-5","新风机组2-7-6","新风机组2-7-7","新风机组2-7-8",
			"新风机组2-8-1","新风机组2-8-2","新风机组2-8-3","新风机组2-8-4","新风机组2-8-5","新风机组2-8-6","新风机组2-8-7"];
		foreach($fName as $i=>$name)
		{
			$lsMem = substr($memData, $offset , 4*17);
			$v = unpack("f*", $lsMem);
			$dataArray[$name."-室内温度"] = number_format($v[1], 2);
			$dataArray[$name."-室内湿度"] = number_format($v[2], 2);
			$dataArray[$name."-送风温度"] = number_format($v[3], 2);
			$dataArray[$name."-送风湿度"] = number_format($v[4], 2);
			$dataArray[$name."-室外温度"] = number_format($v[5], 2);
			$dataArray[$name."-室外湿度"] = number_format($v[6], 2);
			$dataArray[$name."-湿球温度"] = number_format($v[7], 2);

			$dataArray[$name."-冷冻水1进水温度"] = number_format($v[10], 2);
			$dataArray[$name."-冷冻水1出水温度"] = number_format($v[11], 2);
			$dataArray[$name."-回风温度"] = number_format($v[12], 2);
			$dataArray[$name."-回风湿度"] = number_format($v[13], 2);
			$dataArray[$name."-EC风机转速"] = number_format($v[14], 2);
			$dataArray[$name."-水阀开度"] = number_format($v[15], 2);
			
			$offset += 4*17;
			$v = unpack("I*", substr($memData,  + 4*17, 4));
			$dataArray[$name."-送风机运行状态"] = ($v[1] & 0x1) ? "运行" : "停止";
			$dataArray[$name."-送风机故障状态"] = ( ($v[1]>>1) & 0x1) ? "故障" : "正常";
			$dataArray[$name."-立管风机运行状态"] = ( ($v[1]>>2) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-立管水泵运行状态"] = ( ($v[1]>>3) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-1#排风机运行状态"] = ( ($v[1]>>4) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-2#排风机运行状态"] = ( ($v[1]>>5) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-加湿泵运行状态"] = ( ($v[1]>>6) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-1#新风阀状态"] = ( ($v[1]>>7) & 0x1) ? "开启" : "关闭";
			$dataArray[$name."-2#新风阀状态"] = ( ($v[1]>>8) & 0x1) ? "开启" : "关闭";
			$dataArray[$name."-混风阀状态"] = ( ($v[1]>>9) & 0x1) ? "开启" : "关闭";
			$dataArray[$name."-回风阀状态"] = ( ($v[1]>>10) & 0x1) ? "开启" : "关闭";
			$dataArray[$name."-立管补水阀状态"] = ( ($v[1]>>11) & 0x1) ? "开启" : "关闭";
			$dataArray[$name."-湿膜补水阀状态"] = ( ($v[1]>>12) & 0x1) ? "开启" : "关闭";
			$dataArray[$name."-立管排水阀状态"] = ( ($v[1]>>13) & 0x1) ? "开启" : "关闭";
			$dataArray[$name."-湿膜排水阀状态"] = ( ($v[1]>>14) & 0x1) ? "开启" : "关闭";

			_unicom_ll13_ShowAlert($dataArray, $name."-立管水位高限报警", (($v[1]>>15) & 0x1), 0);
			_unicom_ll13_ShowAlert($dataArray, $name."-立管水位低限报警", (($v[1]>>16) & 0x1), 0);
			_unicom_ll13_ShowAlert($dataArray, $name."-湿膜水位高限报警", (($v[1]>>17) & 0x1), 0);
			_unicom_ll13_ShowAlert($dataArray, $name."-湿膜水位低限报警", (($v[1]>>18) & 0x1), 0);

			$dataArray[$name."-排风阀状态"] = (($v[1]>>19) & 0x1) ? "开启" : "关闭";

			$offset += 4;
		}
		//冷水机组
		$fName = ["冷水机组东12机组","冷水机组东34机组","冷水机组东56机组","冷水机组东78机组","冷水机组东910机组","冷水机组东11机组",
			"冷水机组中12机组","冷水机组中34机组","冷水机组中56机组","冷水机组中78机组","冷水机组中910机组","冷水机组中11机组",
			"冷水机组西12机组","冷水机组西34机组","冷水机组西56机组","冷水机组西78机组","冷水机组西910机组","冷水机组西11机组"];
		foreach($fName as $i=>$name)
		{
			$lsMem = substr($memData, $offset , 4*20);
			$v = unpack("f*", $lsMem);
			$dataArray[$name."-1#机组直接段风机1频率反馈"] = number_format($v[1], 2);
			$dataArray[$name."-1#机组直接段风机2频率反馈"] = number_format($v[2], 2);
			$dataArray[$name."-1#机组清水出水温度T1"] = number_format($v[3], 2);
			$dataArray[$name."-1#机组清水回水温度T2"] = number_format($v[4], 2);
			$dataArray[$name."-1#机组乙二醇出水温度T3"] = number_format($v[5], 2);
			$dataArray[$name."-1#机组乙二醇回水温度T4"] = number_format($v[6], 2);
			$dataArray[$name."-1#机组回水阀开度反馈"] = number_format($v[7], 2);
			$dataArray[$name."-1#机组流量计"] = number_format($v[8], 2);
			$dataArray[$name."-2#机组直接段风机1频率反馈"] = number_format($v[9], 2);
			$dataArray[$name."-2#机组直接段风机2频率反馈"] = number_format($v[10], 2);
			$dataArray[$name."-2#机组清水出水温度T1"] = number_format($v[11], 2);
			$dataArray[$name."-2#机组清水回水温度T2"] = number_format($v[12], 2);
			$dataArray[$name."-2#机组乙二醇出水温度T3"] = number_format($v[13], 2);
			$dataArray[$name."-2#机组乙二醇回水温度T4"] = number_format($v[14], 2);
			$dataArray[$name."-2#机组回水阀开度反馈"] = number_format($v[15], 2);
			$dataArray[$name."-2#机组流量计"] = number_format($v[16], 2);
			$dataArray[$name."-机组1乙二醇回水流量"] = number_format($v[17], 2);
			$dataArray[$name."-机组1乙二醇出水流量"] = number_format($v[18], 2);
			$dataArray[$name."-机组2乙二醇回水流量"] = number_format($v[19], 2);
			$dataArray[$name."-机组2乙二醇出水流量"] = number_format($v[20], 2);
			
			$offset += 4*20;
			$v = unpack("I*", substr($memData,  + 4*20, 4));
			$dataArray[$name."-1#机组直接段风机1运行状态"] = ($v[1] & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-1#机组直接段风机1故障状态", (($v[1]>>1) & 0x1), 0);
			$dataArray[$name."-1#机组直接段风机2运行状态"] = ( ($v[1]>>2) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-1#机组直接段风机1故障状态", ( ($v[1]>>3) & 0x1), 0);
			$dataArray[$name."-1#机组间接段风机1运行状态"] = ( ($v[1]>>4) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-1#机组间接段风机1故障状态", ( ($v[1]>>5) & 0x1), 0);
			$dataArray[$name."-1#机组间接段风机2运行状态"] = ( ($v[1]>>6) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-1#机组间接段风机2故障状态", ( ($v[1]>>7) & 0x1), 0);
			$dataArray[$name."-1#机组间接段风机3运行状态"] = ( ($v[1]>>8) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-1#机组间接段风机3故障状态", ( ($v[1]>>9) & 0x1), 0);
			$dataArray[$name."-1#机组间接段风机4运行状态"] = ( ($v[1]>>10) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-1#机组间接段风机4故障状态", ( ($v[1]>>11) & 0x1), 0);
			$dataArray[$name."-1#机组循环水泵1运行状态"] = ( ($v[1]>>12) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-1#机组循环水泵2运行状态"] = ( ($v[1]>>13) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-1#机组回水阀开到位"] = ( ($v[1]>>14) & 0x1) ? "正常" : "未";
			$dataArray[$name."-1#机组回水阀开到位"] = ( ($v[1]>>15) & 0x1) ? "正常" : "未";

			$dataArray[$name."-2#机组直接段风机1运行状态"] = ( ($v[1]>>16) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-2#机组直接段风机1故障状态", (($v[1]>>17) & 0x1), 0);
			$dataArray[$name."-2#机组直接段风机2运行状态"] = ( ($v[1]>>18) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-2#机组直接段风机1故障状态", ( ($v[1]>>19) & 0x1), 0);
			$dataArray[$name."-2#机组间接段风机1运行状态"] = ( ($v[1]>>20) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-2#机组间接段风机1故障状态", ( ($v[1]>>21) & 0x1), 0);
			$dataArray[$name."-2#机组间接段风机2运行状态"] = ( ($v[1]>>22) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-2#机组间接段风机2故障状态", ( ($v[1]>>23) & 0x1), 0);
			$dataArray[$name."-2#机组间接段风机3运行状态"] = ( ($v[1]>>24) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-2#机组间接段风机3故障状态", ( ($v[1]>>25) & 0x1), 0);
			$dataArray[$name."-2#机组间接段风机4运行状态"] = ( ($v[1]>>26) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $name."-2#机组间接段风机4故障状态", ( ($v[1]>>27) & 0x1), 0);
			$dataArray[$name."-2#机组循环水泵1运行状态"] = ( ($v[1]>>28) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-2#机组循环水泵2运行状态"] = ( ($v[1]>>29) & 0x1) ? "运行" : "停止";
			$dataArray[$name."-2#机组回水阀开到位"] = ( ($v[1]>>30) & 0x1) ? "正常" : "未";
			$dataArray[$name."-2#机组回水阀开到位"] = ( ($v[1]>>31) & 0x1) ? "正常" : "未";
			$offset += 4;
		}
		//板换间
		for($i=1;$i<=3;$i++)
		{
			$lsMem = substr($memData, $offset + 23*4*($i-1), 23*4);
			$v = unpack("f*", $lsMem);
			$dataArray[$i."#夏季板换一次侧进水温度"] = number_format($v[1], 2);
			$dataArray[$i."#夏季板换一次侧出水温度"] = number_format($v[2], 2);
			$dataArray[$i."#夏季板换一次侧进水压力"] = number_format($v[3], 2);
			$dataArray[$i."#夏季板换一次侧出水压力"] = number_format($v[4], 2);
			$dataArray[$i."#夏季板换一次侧流量"] = number_format($v[5], 2);
			$dataArray[$i."#夏季板换二次侧进水温度"] = number_format($v[6], 2);
			$dataArray[$i."#夏季板换二次侧出水温度"] = number_format($v[7], 2);
			$dataArray[$i."#夏季板换二次侧进水压力"] = number_format($v[8], 2);
			$dataArray[$i."#夏季板换二次侧出水压力"] = number_format($v[9], 2);
			$dataArray[$i."#夏季板换二次侧流量"] = number_format($v[10], 2);
			$dataArray[$i."#冬季板换一次侧进水温度"] = number_format($v[11], 2);
			$dataArray[$i."#冬季板换一次侧出水温度"] = number_format($v[12], 2);
			$dataArray[$i."#冬季板换一次侧进水压力"] = number_format($v[13], 2);
			$dataArray[$i."#冬季板换一次侧出水压力"] = number_format($v[14], 2);
			$dataArray[$i."#冬季板换一次侧流量"] = number_format($v[15], 2);
			$dataArray[$i."#冬季板换二次侧进水温度"] = number_format($v[16], 2);
			$dataArray[$i."#冬季板换二次侧出水温度"] = number_format($v[17], 2);
			$dataArray[$i."#冬季板换二次侧进水压力"] = number_format($v[18], 2);
			$dataArray[$i."#冬季板换二次侧出水压力"] = number_format($v[19], 2);
			$dataArray[$i."#冬季板换二次侧流量"] = number_format($v[20], 2);
			$dataArray["夏季".$i."#冷却泵反馈"] = number_format($v[21], 2);
			$dataArray["冬季".$i."#冷却泵反馈"] = number_format($v[22], 2);
			$dataArray[$i."#冷冻泵反馈"] = number_format($v[23], 2);
		}
		$offset += 23*4*3;
		//群控1
		for($i=1;$i<=2;$i++)
		{
			$lsMem = substr($memData, $offset + 25*4*($i-1), 25*4);
			$v = unpack("f*", $lsMem);
			$dataArray[$i."#夏季冷却水进水温度"] = number_format($v[1], 2);
			$dataArray[$i."#夏季冷却水回水温度"] = number_format($v[2], 2);
			$dataArray[$i."#夏季冷却水进水压力"] = number_format($v[3], 2);
			$dataArray[$i."#夏季冷却水回水压力"] = number_format($v[4], 2);
			$dataArray[$i."#夏季环路冷却水进水温度"] = number_format($v[5], 2);
			$dataArray[$i."#夏季环路冷却水回水温度"] = number_format($v[6], 2);
			$dataArray[$i."#夏季环路冷却水进水压力"] = number_format($v[7], 2);
			$dataArray[$i."#夏季环路冷却水回水压力"] = number_format($v[8], 2);
			$dataArray[$i."#夏季一次环路旁通阀反馈"] = number_format($v[9], 2);
			$dataArray[$i."#冬季一次环路供水温度"] = number_format($v[10], 2);
			$dataArray[$i."#冬季一次环路回水温度"] = number_format($v[11], 2);
			$dataArray[$i."#冬季一次环路供水压力"] = number_format($v[12], 2);
			$dataArray[$i."#冬季一次环路回水压力"] = number_format($v[13], 2);
			$dataArray[$i."#冬季一次环路旁通阀反馈"] = number_format($v[14], 2);
			$dataArray[$i."#冷冻二次环路供水温度"] = number_format($v[15], 2);
			$dataArray[$i."#冷冻二次环路回水温度"] = number_format($v[16], 2);
			$dataArray[$i."#冷冻二次环路供水压力"] = number_format($v[17], 2);
			$dataArray[$i."#冷冻二次环路回水压力"] = number_format($v[18], 2);
			$dataArray[$i."#二次环路旁通阀反馈"] = number_format($v[19], 2);
			$dataArray[$i."#二次冷却供水温度"] = number_format($v[20], 2);

			$dataArray[$i."#二次冷却回水温度"] = number_format($v[21], 2);
			$dataArray[$i."#二次冷却供水压力"] = number_format($v[22], 2);
			$dataArray[$i."#二次冷却回水压力"] = number_format($v[23], 2);
			$dataArray[$i."#二次冷却供水流量"] = number_format($v[24], 2);
			$dataArray[$i."#二次冷却回水流量"] = number_format($v[26], 2);
		}
		$offset += 25*4*2;
		$v = unpack("f*", substr($memData, $offset, 4*4));
		$dataArray["定压补水清水流量计"] = number_format($v[1], 2);
		$dataArray["定压补水乙二醇流量计"] = number_format($v[2], 2);
		$dataArray["一次冷却水回水流量"] = number_format($v[3], 2);
		$dataArray["二次冷却回水流量"] = number_format($v[4], 2);
		$offset += 4*4;

		$v = unpack("S*", substr($memData, $offset, 2*12));

		$dataArray["夏季一次环路旁通阀1自动"] = (($v[1]>>1) & 0x1) ? "激活" : "未激活";
		$dataArray["夏季一次环路旁通阀1手动"] = (($v[1]>>2) & 0x1) ? "激活" : "未激活";
		$dataArray["冬季一次环路旁通阀1自动"] = (($v[1]>>3) & 0x1) ? "激活" : "未激活";
		$dataArray["冬季一次环路旁通阀1手动"] = (($v[1]>>4) & 0x1) ? "激活" : "未激活";
		$dataArray["二次环路旁通阀1自动"] = (($v[1]>>5) & 0x1) ? "激活" : "未激活";
		$dataArray["二次环路旁通阀1手动"] = (($v[1]>>6) & 0x1) ? "激活" : "未激活";


		$dataArray["夏季一次环路旁通阀2自动"] = (($v[1]>>9) & 0x1) ? "激活" : "未激活";
		$dataArray["夏季一次环路旁通阀2手动"] = (($v[1]>>10) & 0x1) ? "激活" : "未激活";
		$dataArray["冬季一次环路旁通阀2自动"] = (($v[1]>>11) & 0x1) ? "激活" : "未激活";
		$dataArray["冬季一次环路旁通阀2手动"] = (($v[1]>>12) & 0x1) ? "激活" : "未激活";
		$dataArray["二次环路旁通阀2自动"] = (($v[1]>>13) & 0x1) ? "激活" : "未激活";
		$dataArray["二次环路旁通阀2手动"] = (($v[1]>>14) & 0x1) ? "激活" : "未激活";

		$offset += 2*12;
		//群控2
		for($i=1;$i<=3;$i++)
		{
			$lsMem = substr($memData, $offset + 23*4*($i-1), 23*4);
			$v = unpack("f*", $lsMem);
			$dataArray[$i."#夏季板换一次侧进水温度"] = number_format($v[1], 2);
			$dataArray[$i."#夏季板换一次侧出水温度"] = number_format($v[2], 2);
			$dataArray[$i."#夏季板换一次侧进水压力"] = number_format($v[3], 2);
			$dataArray[$i."#夏季板换一次侧出水压力"] = number_format($v[4], 2);
			$dataArray[$i."#夏季板换一次侧流量"] = number_format($v[5], 2);
			$dataArray[$i."#夏季板换二次侧进水温度"] = number_format($v[6], 2);
			$dataArray[$i."#夏季板换二次侧出水温度"] = number_format($v[7], 2);
			$dataArray[$i."#夏季板换二次侧进水压力"] = number_format($v[8], 2);
			$dataArray[$i."#夏季板换二次侧出水压力"] = number_format($v[9], 2);
			$dataArray[$i."#夏季板换二次侧流量"] = number_format($v[10], 2);
			$dataArray[$i."#冬季板换一次侧进水温度"] = number_format($v[11], 2);
			$dataArray[$i."#冬季板换一次侧出水温度"] = number_format($v[12], 2);
			$dataArray[$i."#冬季板换一次侧进水压力"] = number_format($v[13], 2);
			$dataArray[$i."#冬季板换一次侧出水压力"] = number_format($v[14], 2);
			$dataArray[$i."#冬季板换一次侧流量"] = number_format($v[15], 2);
			$dataArray[$i."#冬季板换二次侧进水温度"] = number_format($v[16], 2);
			$dataArray[$i."#冬季板换二次侧出水温度"] = number_format($v[17], 2);
			$dataArray[$i."#冬季板换二次侧进水压力"] = number_format($v[18], 2);
			$dataArray[$i."#冬季板换二次侧出水压力"] = number_format($v[19], 2);
			$dataArray[$i."#冬季板换二次侧流量"] = number_format($v[20], 2);

			$dataArray[$i."#夏季冷却泵反馈"] = number_format($v[21], 2);
			$dataArray[$i."#冬季冷却泵反馈"] = number_format($v[22], 2);
			$dataArray[$i."#冻泵反馈"] = number_format($v[23], 2);
		}
		$offset += 23*4*3;

		$v = unpack("S*", substr($memData, $offset, 2*6));
		for($i=1;$i<=3;$i++){
			$index = 2*($i-1);
			$dataArray[$i."#夏季板换一次侧阀自动"] = (($v[$index]>>1) & 0x1) ? "自动" : "手动";
			$dataArray[$i."#夏季板换一次侧阀开"] = (($v[$index]>>2) & 0x1) ? "开" : "关";
			$dataArray[$i."#夏季板换一次侧阀关"] = (($v[$index]>>3) & 0x1) ? "关" : "开";
			$dataArray[$i."#夏季板换二次侧阀自动"] = (($v[$index]>>4) & 0x1) ? "自动" : "手动";
			$dataArray[$i."#夏季板换二次侧阀开"] = (($v[$index]>>5) & 0x1) ? "开" : "关";
			$dataArray[$i."#夏季板换二次侧阀关"] = (($v[$index]>>6) & 0x1) ? "关" : "开";
	
			$dataArray[$i."#冬季板换一次侧阀自动"] = (($v[$index]>>7) & 0x1) ? "自动" : "手动";
			$dataArray[$i."#冬季板换一次侧阀开"] = (($v[$index]>>8) & 0x1) ? "关" : "开";
			$dataArray[$i."#冬季板换一次侧阀关"] = (($v[$index]>>9) & 0x1) ? "关" : "开";
			$dataArray[$i."#冬季板换一次侧阀自动"] = (($v[$index]>>10) & 0x1) ? "自动" : "手动";
			$dataArray[$i."#冬季板换一次侧阀开"] = (($v[$index]>>11) & 0x1) ? "关" : "开";
			$dataArray[$i."#冬季板换一次侧阀关"] = (($v[$index]>>12) & 0x1) ? "关" : "开";
			$dataArray[$i."#夏季泵自动"] = (($v[$index]>>13) & 0x1) ? "自动" : "手动";
			$dataArray[$i."#夏季泵运行"] = (($v[$index]>>14) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $i."#夏季泵故障", (($v[$index]>>15) & 0x1), 0);
	
			$dataArray[$i."#冬季泵自动"] = (($v[$index+1]) & 0x1) ? "自动" : "手动";
			$dataArray[$i."#冬季泵运行"] = (($v[$index+1]>>1) & 0x1) ? "运行" : "停止";
			_unicom_ll13_ShowAlert($dataArray, $i."#夏季泵故障", (($v[$index+1]>>2) & 0x1), 0);
			$dataArray[$i."#二次泵自动"] = (($v[$index+1]>>3) & 0x1) ? "自动" : "手动";
			$dataArray[$i."#二次泵运行"] = (($v[$index+1]>>4) & 0x1) ? "开" : "关";
			_unicom_ll13_ShowAlert($dataArray, $i."#二次泵故障", (($v[$index+1]>>5) & 0x1), 0);
		}
		$offset += 2*6;
		$v = unpack("f*", substr($memData, $offset, 4*15));
		$dataArray["夏季1#泵运行时长"] = number_format($v[1], 2);
		$dataArray["夏季2#泵运行时长"] = number_format($v[2], 2);
		$dataArray["夏季3#泵运行时长"] = number_format($v[3], 2);
		$dataArray["冬季1#泵运行时长"] = number_format($v[4], 2);
		$dataArray["冬季2#泵运行时长"] = number_format($v[5], 2);
		$dataArray["冬季3#泵运行时长"] = number_format($v[6], 2);
		$dataArray["二次侧1#泵运行时长"] = number_format($v[7], 2);
		$dataArray["二次侧2#泵运行时长"] = number_format($v[8], 2);
		$dataArray["二次侧3#泵运行时长"] = number_format($v[9], 2);
		$dataArray["夏季1#板换运行时长"] = number_format($v[10], 2);
		$dataArray["夏季2#板换运行时长"] = number_format($v[11], 2);
		$dataArray["夏季3#板换运行时长"] = number_format($v[12], 2);
		$dataArray["冬季1#板换运行时长"] = number_format($v[13], 2);
		$dataArray["冬季2#板换运行时长"] = number_format($v[14], 2);
		$dataArray["冬季3#板换运行时长"] = number_format($v[15], 2);
		$offset += 4*15;
		$v = unpack('v',substr($memData, $offset, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData, $offset + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
	}
}
