<?php

function Get_unicom_nhbaccontroller_DeviceIoControl_Parameter($action, $parameter)
{
    switch($action)
    {
        case 322://START_RESIST
        {
            return pack("S", $parameter);
        }
    }
    return null;
}
function Get_unicom_nhbaccontroller_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['设定回风温度（℃）']);
        case '回风温度':
            return array(0, $dataArray['回风温度值（℃）']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_unicom_nhbaccontroller_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        $v = unpack('n*', substr($memData, 4, 2 * 8));
        $dataArray["主机电源相电压A"] = $v[1] < 2000 ? number_format($v[1],1) : 0;

        $dataArray["主机电源相电压B"] = $v[2] < 2000 ? number_format($v[2],1) : 0;

        $dataArray["主机电源相电压C"] = $v[3] < 2000 ? number_format($v[3],1) : 0;

        $dataArray["主机/压缩机工作电流A相"] = $v[4] < 10000 ? number_format($v[4]/100,2) : 0;

        $dataArray["主机/压缩机工作电流B相"] = $v[5] < 10000 ? number_format($v[5]/100,2) : 0;

        $dataArray["主机/压缩机工作电流C相"] = $v[6] < 10000 ? number_format($v[6]/100,2) : 0;

        $dataArray["送风温度"] = $v[7] < 2000 ? number_format($v[7],1) : 0;

        $dataArray["回风温度/室内环境温度"] = $v[8] < 2000 ? number_format($v[8],1) : 0;

        $v = unpack('C*', substr($memData, 4 + 2 * 8 , 7));

        $dataArray["开关机状态"] = $v[1] == 0 ? "关机" : "开机";

        $dataArray["制冷状态异常告警"] = $v[2] == 1 ? "告警" : "正常";

        $dataArray["制热状态异常告警"] = $v[3] == 1 ? "告警" : "正常";

        $dataArray["电源告警"] = $v[4] == 1 ? "告警" : "正常";

        $dataArray["电流传感器故障"] = $v[5] == 1 ? "告警" : "正常";

        $dataArray["回风温度传感器故障"] = $v[6] == 1 ? "告警" : "正常";

        $dataArray["出风温度传感器故障"] = $v[7] == 1 ? "告警" : "正常";
	$v = unpack('n*', substr($memData, 4 + 2 * 8 + 7, 2*7));
	$dataArray["空调开机温度"] = $v[1];
	$dataArray["空调关机温度"] = $v[2];
	$dataArray["回风温度上限"] = $v[3];
	$dataArray["回风温度下限"] = $v[4];
	$dataArray["温度设定值"] = $v[5];
	switch($v[6]){
	    case 0:
		$dataArray["运行模式设定"] = "自动";
		break;
	    case 1:
		$dataArray["运行模式设定"] = "制冷";
		break;
	    case 2:
		$dataArray["运行模式设定"] = "除湿";
		break;
	    case 3:
		$dataArray["运行模式设定"] = "送风";
		break;
	    case 4:
		$dataArray["运行模式设定"] = "制热";
		break;
	}	
	switch($v[7]){
	    case 0:
		$dataArray["内风机风速设定"] = "低风";
		break;
	    case 1:
		$dataArray["内风机风速设定"] = "中风";
		break;
	    case 3:
		$dataArray["内风机风速设定"] = "高风";
		break;
	}
	$v = unpack('i*', substr($memData, 4 + 2 * 8 + 7 + 2*7, 4*2));
	$dataArray["前一日总耗电有功电量"] = number_format($v[1]/100, 2)."KWH";
	$dataArray["当日总耗电有功电量"] = number_format($v[2]/100, 2)."KWH";

	$v = unpack('v', substr($memData, 4 + 2 * 8 + 7 + 2*7 + 4*2 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 2 * 8 + 7 + 2*7 + 4*2  + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }
}
