<?php
function Get_unicom_p14_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case "[总电能]":
            return array(0, $dataArray['有功电能总和2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_unicom_p14_Signals($type)
{
    switch ($type) {
        case "AI":
            return array("911143200001", "911143200001");
        case "DI":
            return array();
        case "AO":
            return array("911643201001");
        case "DO":
            return array();
        case "ALARM":
            return array();
        default:
            return array();
    }

}


function Get_unicom_p14_UnicomCategory()
{
    return "911";
}

function Get_unicom_p14_RtData($memData, &$dataArray, $extraPara = false)
{
    if ($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $offset = 4;
        $v = unpack('S*', substr($memData, 4, 12*2));
        $dataArray['Ia幅值'] = number_format( (($v[1]<<16) | $v[2]) / 1000, 3,".","") . ' A';
        $dataArray['Ib幅值'] = number_format( (($v[3]<<16) | $v[4]) / 1000, 3,".","") . ' A';
        $dataArray['Ic幅值'] = number_format( (($v[5]<<16) | $v[6]) / 1000, 3,".","") . ' A';
        $dataArray['Uab幅值'] = number_format( (($v[7]<<16) | $v[8]) / 1000, 3,".","") . ' V';
        $dataArray['Ubc幅值'] = number_format( (($v[9]<<16) | $v[10]) / 1000, 3,".","") . ' V';
        $dataArray['Uca幅值'] = number_format( (($v[11]<<16) | $v[12]) / 1000, 3,".","") . ' V';

        $v = unpack('S*', substr($memData, 4 + 12*2, 2*2));
        $dataArray['3相功率因数'] = number_format( $v[1]  / 100, 3,".","") ;
        $dataArray['频率'] = number_format( $v[2]  / 100, 3,".","") . "Hz";

	$newMem = '';
        $mem = substr($memData,4 + 12*2 + 2*2, 2*2*7);
        for ($i = 0; $i < strlen($mem); $i += 4) {
            $newMem .= $mem[$i + 2] . $mem[$i + 3] . $mem[$i] . $mem[$i + 1];
        }

        $v = unpack('f*', $newMem);
	$dataArray['3相有功功率2'] = number_format($v[1], 3,".","")."kW";
	$dataArray['3相无功功率2'] = number_format($v[2], 3,".","")."kVar";
	$dataArray['3相视在功率2'] = number_format($v[3], 3,".","")."kVar";
	$dataArray['正向有功电度'] = number_format($v[4]/1000000, 3,".","")."kWh";
	$dataArray['反向有功电度'] = number_format($v[5]/1000000, 3,".","")."kWh";
	$dataArray['正向无功电度'] = number_format($v[6]/1000000, 3,".","")."kVarh";
	$dataArray['反向无功电度'] = number_format($v[7]/1000000, 3,".","")."kVarh";
	
	$v = unpack('S*', substr($memData, 4 + 12*2 + 2*2 + 2*2*7, 2*2));
        $dataArray['外部输入的零序电流'] = number_format( (($v[1]<<16) | $v[2]) , 3,".","") . ' A';

	$v = unpack('S*', substr($memData, 4 + 12*2 + 2*2 + 2*2*7 + 2*2, 2*2));
        $dataArray['自产的零序电流'] = number_format( (($v[1]<<16) | $v[2]) , 3,".","") . ' A';

	$v = unpack('S*', substr($memData, 4 + 12*2 + 2*2 + 2*2*7 + 2*2 + 2*2, 2*2));
        $dataArray['自产零序电压'] = number_format( (($v[1]<<16) | $v[2]) , 3,".","") . ' A';

	$offset = 4 + 12*2 + 2*2 + 2*2*7 + 2*2 + 2*2 + 2*2 + 2*4;
        $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $offset += 2;
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }

}
