<?php

function Get_unicom_powermetertype1_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case "[总电能]":
            return array(0, $dataArray['正向有功电能']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_unicom_powermetertype1_Size()
{
    return 111;
}


function Get_unicom_powermetertype1_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
        $v = unpack('S*', substr($memData, 4 + 47 * 2, 3 * 2));
        $dataArray['电压变比'] = $v[1];
        $dataArray['电流变比'] = $ct = $v[3];

        $v = unpack("s*", substr($memData, $offset, 27 * 2));
        $dataArray['Ua相电压'] = number_format($v[1] / 10, 2) . ' V';
        $dataArray['Uca线电压'] = number_format($v[2] / 10, 2) . ' V';
        $dataArray['A相电流'] = number_format($v[3] * $ct / 1000,2) . ' A';
        $dataArray['开入状态'] = $v[4];
        $dataArray['A相有功功率'] = number_format($v[5] * $ct,2) . ' W';
        $dataArray['A相功率因数'] = number_format($v[6] / 10000, 2);
        $dataArray['A相无功功率'] = number_format($v[7] * $ct,2) . ' var';
        $dataArray['A相视在功率'] = number_format($v[8] * $ct,2) . ' VA';
        $dataArray['Ub相电压'] = number_format($v[9]/10,2) . ' V';
        $dataArray['Uab线电压'] = number_format($v[10]/10,2) . ' V';
        $dataArray['B相电流'] = number_format($v[11] * $ct / 1000,2) . ' A';
        $dataArray['开出状态'] = $v[12];
        $dataArray['B相有功功率'] = number_format($v[13] * $ct,2) . ' W';
        $dataArray['B相功率因数'] = number_format($v[14] / 10000, 2);
        $dataArray['B相无功功率'] = number_format($v[15] * $ct,2) . ' var';
        $dataArray['B相视在功率'] = number_format($v[16] * $ct,2) . ' VA';
        $dataArray['Uc相电压'] = number_format($v[17]/10,2) . ' V';
        $dataArray['Ubc线电压'] = number_format($v[18]/10,2) . ' V';
        $dataArray['C相电流'] = number_format($v[19] * $ct / 1000,2) . ' A';
        $dataArray['C相有功功率'] = number_format($v[21] * $ct,2) . ' W';
        $dataArray['C相功率因数'] = number_format($v[22] / 10000, 2);
        $dataArray['C相无功功率'] = number_format($v[23] * $ct,2) . ' var';
        $dataArray['C相视在功率'] = number_format($v[24] * $ct,2) . ' VA';
        $dataArray['三相平均线电压'] = number_format($v[25]/10,2) . ' V';
        $dataArray['三相平均相电压'] = number_format($v[26]/10,2) . ' V';
        $dataArray['三相平均相电流'] = number_format($v[27] * $ct / 1000,2) . ' A';

        $offset += 27 * 2;
        $v = unpack('S*', substr($memData, $offset, 1*2));
        $dataArray['频率'] = number_format($v[1] * 0.00106813,2) . ' Hz';
        $offset += 1 * 2;
        $v = unpack('s*', substr($memData, $offset, 4*2));
        $dataArray['三相有功功率'] = number_format($v[1] * $ct,2) . ' W';
        $dataArray['三相总功率因数'] = number_format($v[2] / 10000, 2);
        $dataArray['三相无功功率'] = number_format($v[3] * $ct,2) . ' var';
        $dataArray['三相视在功率'] = number_format($v[4] * $ct,2) . ' VA';
        $offset += 4 * 2;
        $v = unpack('S*', substr($memData, $offset, 15*2));
        $dataArray['正向有功电能'] = number_format((($v[3] << 16) + $v[2]) * $ct / 1000 , 2) ." kWh";
        $dataArray['负向有功电能'] = number_format((($v[5] << 16) + $v[4]) * $ct / 1000 , 2) ." kWh";
        $dataArray['正向无功电能'] = number_format((($v[7] << 16) + $v[6]) * $ct / 1000 , 2) ." kvarh";
        $dataArray['负向无功电能'] = number_format((($v[9] << 16) + $v[8]) * $ct / 1000 , 2) ." kvarh";

        $offset += 15 * 2;

        $offset += 3 * 2;
        $v = unpack('v', substr($memData, $offset, 2));
        $offset += 2;
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
