<?php
function Get_unicom_spm33_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case "[总电能]":
            return array(0, $dataArray['有功电能总和2']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_unicom_spm33_Signals($type)
{
    switch ($type) {
        case "AI":
            return array("911143200001", "911143200001");
        case "DI":
            return array();
        case "AO":
            return array("911643201001");
        case "DO":
            return array();
        case "ALARM":
            return array();
        default:
            return array();
    }

}


function Get_unicom_spm33_UnicomCategory()
{
    return "911";
}

function Get_unicom_spm33_RtData($memData, &$dataArray, $extraPara = false)
{
    if ($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $offset = 4;
        $v = unpack('S*', substr($memData, 4 + 2 * 10 + 2 * 4 + 2 * 11 + 6 * 4 + 2 * 3, 2 * 2));
        $dataArray['CT一次侧'] = $ct = $v[1]/5;
        $dataArray['PT一次侧'] = $v[2];
        $v = unpack('S*', substr($memData, $offset, 2 * 10));
        $dataArray['A相电压'] = number_format($v[1] / 100, 2) . ' V';
        $dataArray['B相电压'] = number_format($v[2] / 100) . ' V';
        $dataArray['C相电压'] = number_format($v[3] / 100) . ' V';
        $dataArray['AB线电压'] = number_format($v[4] / 100) . ' V';
        $dataArray['BC线电压'] = number_format($v[5] / 100) . ' V';
        $dataArray['CA线电压'] = number_format($v[6] / 100) . ' V';
        $dataArray['A相电流'] = number_format($v[7] * $ct / 1000, 3) . "A";
        $dataArray['B相电流'] = number_format($v[8] * $ct / 1000, 3) . "A";
        $dataArray['C相电流'] = number_format($v[9] * $ct / 1000, 3) . "A";
        $dataArray['零序电流'] = number_format($v[10] * $ct / 1000, 3) . "A";

        $offset += 2 * 10;
        $v = unpack('i*', substr($memData, $offset, 2 * 4));
        $dataArray['总有功功率'] = number_format($v[1] / 10000, 2) . " kW";
        $dataArray['总无功功率'] = number_format($v[2] / 10000, 2) . " kvar";

        $offset += 2 * 4;
        $v = unpack('s*', substr($memData, $offset, 2 * 11));
        $dataArray['总功率因数'] = number_format($v[1] / 1000, 3);
        $dataArray['A相有功功率'] = number_format($v[2] * $ct / 10000, 2) . ' kW';
        $dataArray['B相有功功率'] = number_format($v[3] * $ct / 10000, 2) . ' kW';
        $dataArray['C相有功功率'] = number_format($v[4] * $ct / 10000, 2) . ' kW';
        $dataArray['A相无功功率'] = number_format($v[5] * $ct / 10000, 2) . ' kvar';
        $dataArray['B相无功功率'] = number_format($v[6] * $ct / 10000, 2) . ' kvar';
        $dataArray['C相无功功率'] = number_format($v[7] * $ct / 10000, 2) . ' kvar';
        $dataArray['A相功率因数'] = number_format($v[8] / 1000, 3);
        $dataArray['B相功率因数'] = number_format($v[9] / 1000, 3);
        $dataArray['C相功率因数'] = number_format($v[10] / 1000, 3);
        $dataArray['频率'] = number_format($v[11] / 100, 2) . ' Hz';
        $offset += 2 * 11;
        $v = unpack('i*', substr($memData, $offset, 6 * 4));
        $dataArray['有功电能总和'] = number_format($v[1] / 10, 2) . ' kWh';
        $dataArray['有功电能总和2'] = number_format($v[1] / 10, 2);
        $dataArray['无功电能总和'] = number_format($v[2] / 10, 2) . ' kWh';
        $dataArray['输入有功电能'] = number_format($v[3] / 10, 2) . ' kWh';
        $dataArray['输出有功电能'] = number_format($v[4] / 10, 2) . ' kWh';
        $dataArray['输入无功电能'] = number_format($v[5] / 10, 2) . ' kvarh';
        $dataArray['输出无功电能'] = number_format($v[6] / 10, 2) . ' kvarh';

        $offset += 6 * 4;
        //$v = unpack('S*', substr($memData, $offset, 2 * 12));
        $v = unpack('S*', substr($memData, $offset, 2 * 3));
        $dataArray['开关量状态'] = $v[1] == 0 ? '断开' : '闭合';
        $dataArray['继电器状态'] = $v[2] == 0 ? '断开' : '闭合';
        $dataArray['报警状态'] = $v[3] == 0 ? '正常' : '告警';
        $dataArray['AlertArray']['报警状态'] = $v[3] == 1;

        $offset += 2 * 3;//


        $offset += 2 * 2;
        $v = unpack('S*', substr($memData, $offset, 2 * 7));
        $dataArray['平均相电压'] = number_format($v[1] / 100, 2) . ' V';
        $dataArray['平均线电压'] = number_format($v[2] / 100, 2) . ' V';
        $dataArray['平均相电流'] = number_format($v[3] * $ct / 1000, 2) . ' A';
        $dataArray['电流不平衡率'] = number_format($v[4] / 1000, 2);
        $dataArray['A相视在功率'] = number_format($v[5] * $ct * 10 /1000, 2) . ' kVA';
        $dataArray['B相视在功率'] = number_format($v[6] * $ct * 10 /1000, 2) . ' kVA';
        $dataArray['C相视在功率'] = number_format($v[7] * $ct * 10 /1000, 2) . ' kVA';

        $offset += 2 * 7;
        $v = unpack('i*', substr($memData, $offset, 2 * 4));
        $dataArray['总视在功率'] = number_format($v[1] * $ct * 10/1000, 2) . ' kVA';
        $dataArray['电网输入有功电能'] = number_format($v[2] * $ct / 10, 2) . ' kWh';

        $offset += 2 * 4;
        $v = unpack('S*', substr($memData, $offset, 2 * 186));
        $dataArray['A相电压THD'] = number_format($v[1] / 10, 2);
        $dataArray['B相电压THD'] = number_format($v[2] / 10, 2);
        $dataArray['C相电压THD'] = number_format($v[3] / 10, 2);
        $dataArray['A相电流THD'] = number_format($v[4] / 10, 2);
        $dataArray['B相电流THD'] = number_format($v[5] / 10, 2);
        $dataArray['C相电流THD'] = number_format($v[6] / 10, 2);

        $j = 7;
        for ($i = 2; $i <= 31; $i++) {
            $dataArray['A相' . $i . '次谐波电压含有率'] = number_format($v[$j] / 10, 2) . ' %';
            $j++;
        }

        for ($i = 2; $i <= 31; $i++) {
            $dataArray['B相' . $i . '次谐波电压含有率'] = number_format($v[$j] / 10, 2) . ' %';
            $j++;
        }

        for ($i = 2; $i <= 31; $i++) {
            $dataArray['C相' . $i . '次谐波电压含有率'] = number_format($v[$j] / 10, 2) . ' %';
            $j++;
        }

        for ($i = 2; $i <= 31; $i++) {
            $dataArray['A相' . $i . '次谐波电流含有率'] = number_format($v[$j] / 10, 2) . ' %';
            $j++;
        }

        for ($i = 2; $i <= 31; $i++) {
            $dataArray['B相' . $i . '次谐波电流含有率'] = number_format($v[$j] / 10, 2) . ' %';
            $j++;
        }

        for ($i = 2; $i <= 31; $i++) {
            $dataArray['C相' . $i . '次谐波电流含有率'] = number_format($v[$j] / 10, 2) . ' %';
            $j++;
        }
        $offset += 2 * 186;
        $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $offset += 2;
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }

}
