<?php

function Get_unicom_ups_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['设定回风温度（℃）']);
        case '回风温度':
            return array(0, $dataArray['回风温度值（℃）']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_unicom_ups_Signals($type){
    switch($type){
        case "AI":
            $aiArr = array("2A1110500001","2A1110600001","2A1110700001","2A1110100001","2A1110200001","2A1110300001","2A1111100001","2A1111200001",
        "2A1111300001","2A1111500001","2A1111600001","2A1111700001","2A1127400001","2A1113A00001");
        for($i=1;$i<=40;$i++){
            $aiArr[] = "2A1127100".str_pad($i, 3, "0", STR_PAD_LEFT);
        }
        for($i=1;$i<=40;$i++){
            $aiArr[] = "2A1127200".str_pad($i, 3, "0", STR_PAD_LEFT);
        }
        $aiArr = array_merge($aiArr, array("2A1113900001","2A1110900001","2A1110A00001","2A1110B00001","2A1112500001","2A1112600001","2A1112700001","2A1140100001","2A1127500001",
        "2A1116300001","2A1112D00001","2A1112E00001","2A1112F00001","2A1111D00001","2A1111E00001","2A1111F00001","2A1121100001","2A1121200001","2A1121300001"));
        return $aiArr;
        case "DI":
            //电池浮充工作状态
            return array("2A13006FF001");
        case "AO":
            //输出频率参数-2A1613A01,设备温度参数-2A1640101,旁路电源频率参数-2A1616301
            return array("2A1613A01001","2A1640101001","2A1616301001");
        case "DO":
            return array();
        case "ALARM":
            $alertArray = array("2A1430401001", "2A1415601001","2A1415001001","2A1430801001","2A1430701001","2A1430301001",
            "2A1227402001","2A1227404001","2A1227401001","2A1227403001");
            for($i=1; $i <= 10; $i++)
            {
                $alertArray[] = "2A1227102".str_pad($i, 3, "0", STR_PAD_LEFT);
                $alertArray[] = "2A1227104".str_pad($i, 3, "0", STR_PAD_LEFT);
                $alertArray[] = "2A1227101".str_pad($i, 3, "0", STR_PAD_LEFT);
                $alertArray[] = "2A1227103".str_pad($i, 3, "0", STR_PAD_LEFT);
                //$alertArray[] = "2A1400201".str_pad($i+1, 3, "0", STR_PAD_LEFT);
                //$alertArray[] = "2A1400101".str_pad($i+1, 3, "0", STR_PAD_LEFT);
            }
            for($i=0; $i <5; $i++){
                $alertArray[] = "2A1227204".str_pad($i+1, 3, "0", STR_PAD_LEFT);
                $alertArray[] = "2A1227203".str_pad($i+1, 3, "0", STR_PAD_LEFT);
                //$alertArray[] = "2A1400201".str_pad($i+1, 3, "0", STR_PAD_LEFT);
                //$alertArray[] = "2A1400101".str_pad($i+1, 3, "0", STR_PAD_LEFT);
            }
            $alertArray[] = "2A1460201001";
            $alertArray[] = "2A1415201001";
            $alertArray[] = "2A1213A05001";
            $alertArray[] = "2A1433201001";
            $alertArray[] = "2A1433601001";
            //Ao related
            $alertArray = array_merge($alertArray, array("2A1240103001","2A1216303001","2A1213A03001","2A1240104001","2A1216304001","2A1213A04001","2A1216301001","2A1213A01001","2A1216302001","2A1213A02001"));
            return array_unique($alertArray);
        default:
            return array();
    }

}
function Get_unicom_ups_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        $v = unpack('L*', substr($memData, 4, 4 * 14));
        $dataArray["AI"] = array();
        $dataArray["交流输入线电压UAB"] = number_format($v[1] / 10,1);
        $dataArray["AI"]["2A1110500001"] = "交流输入线电压UAB";
        $dataArray["交流输入线电压UBC"] = number_format($v[2] / 10,1);
        $dataArray["AI"]["2A1110600001"] = "交流输入线电压UBC";
        $dataArray["交流输入线电压UCA"] = number_format($v[3] / 10,1);
        $dataArray["AI"]["2A1110700001"] = "交流输入线电压UCA";


        $dataArray["交流输入相电压UA"] = number_format($v[4] / 10,1);
        $dataArray["AI"]["2A1110100001"] = "交流输入相电压UA";
        $dataArray["交流输入相电压UB"] = number_format($v[5] / 10,1);
        $dataArray["AI"]["2A1110200001"] = "交流输入相电压UB";
        $dataArray["交流输入相电压UC"] = number_format($v[6] / 10,1);
        $dataArray["AI"]["2A1110300001"] = "交流输入相电压UC";


        $dataArray["交流输出线电压UAB"] = number_format($v[7] / 10,1);
        $dataArray["AI"]["2A1111100001"] = "交流输出线电压UAB";

        $dataArray["交流输出线电压UBC"] = number_format($v[8] / 10,1);
        $dataArray["AI"]["2A1111200001"] = "交流输出线电压UBC";

        $dataArray["交流输出线电压UCA"] = number_format($v[9] / 10,1);
        $dataArray["AI"]["2A1111300001"] = "交流输出线电压UCA";


        $dataArray["交流输出电流IA"] = number_format($v[10] / 10,1);
        $dataArray["AI"]["2A1111500001"] = "交流输出电流IA";
        $dataArray["交流输出电流IB"] = number_format($v[11] / 10,1);
        $dataArray["AI"]["2A1111600001"] = "交流输出电流IB";
        $dataArray["交流输出电流IC"] = number_format($v[12] / 10,1);
        $dataArray["AI"]["2A1111700001"] = "交流输出电流IC";

        $dataArray["蓄电池总电压"] = number_format($v[13] / 10,1);
        $dataArray["AI"]["2A1127400001"] = "蓄电池总电压";
        $dataArray["输出频率"] = number_format($v[14] / 10,1);
        $dataArray["AI"]["2A1113A00001"] = "输出频率";

        $v = unpack('c*', substr($memData, 4 + 4 * 14 , 1 * 1));

	   $dataArray["电池电压数量"] = number_format($v[1] / 10);


        $v = unpack('l*', substr($memData, 4 + 4 * 14 + 1 * 1,4 * 40));

    	for($i = 1;$i <= 40;$i++) {
    		$dataArray["单体{$i}电压"] = number_format($v[$i] / 1000,1);
            $num = sprintf('%03d',$i);
            $dataArray["AI"]["2A1127100{$num}"] = "单体{$i}电压";
    	}

        $v = unpack('c*', substr($memData, 4 + 4 * 14 + 1 * 1 + 4 * 40,1 * 1));

        $dataArray["标示电池温度数量"] = number_format($v[1] / 1000);

        $v = unpack('l*', substr($memData, 4 + 4 * 14 + 1 * 1 + 4 * 40 + 1 * 1,4 * 20));

        for($i = 1;$i <= 20;$i++) {
            $num = sprintf('%03d',$i);
            $dataArray["温度{$i}(℃)"] = number_format($v[$i] / 100,1);
            $dataArray["AI"]["2A1127200{$num}"] = "温度{$i}(℃)";

        }

        $v = unpack('L*', substr($memData, 4 + 4 * 14 + 1 * 1 + 4 * 40 + 1 * 1 + 4 * 20,4 * 7));

        $dataArray["输入频率"] = number_format($v[1] / 100);
        $dataArray["AI"]["2A1113900001"] = "输入频率";


        $dataArray["输入相电流Ia"] = number_format($v[2] / 100);
        $dataArray["AI"]["2A1110900001"] = "输入相电流Ia";
        $dataArray["输入相电流Ib"] = number_format($v[3] / 100);
        $dataArray["AI"]["2A1110A00001"] = "输入相电流Ib";
        $dataArray["输入相电流Ic"] = number_format($v[4] / 100);
        $dataArray["AI"]["2A1110B00001"] = "输入相电流Ic";

        $dataArray["A相输出功率因数"] = number_format($v[5] / 100,1);
        $dataArray["AI"]["2A1112500001"] = "A相输出功率因数";
        $dataArray["B相输出功率因数"] = number_format($v[6] / 100,1);
        $dataArray["AI"]["2A1112600001"] = "B相输出功率因数";
        $dataArray["C相输出功率因数"] = number_format($v[7] / 100,1);
        $dataArray["AI"]["2A1112700001"] = "C相输出功率因数";

        $v = unpack('l*', substr($memData, 4 + 4 * 14 + 1 * 1 + 4 * 40 + 1 * 1 + 4 * 20 + 4 * 7,4 * 2));

        $dataArray["设备温度"] = number_format($v[1] / 100,1);
        $dataArray["AI"]["2A1140100001"] = "设备温度";
        $dataArray["蓄电池充电电流"] = number_format($v[2] / 100,1);
        $dataArray["AI"]["2A1127500001"] = "蓄电池充电电流";


        $v = unpack('L*', substr($memData, 4 + 4 * 14 + 1 * 1 + 4 * 40 + 1 * 1 + 4 * 20 + 4 * 7 + 4 * 2 , 4 * 10));

        $dataArray["旁路频率"] = number_format($v[1] / 100,1);
        $dataArray["AI"]["2A1116300001"] = "旁路频率";
        $dataArray["A相输出有功功率"] = number_format($v[2] / 100,1);
        $dataArray["AI"]["2A1112D00001"] = "A相输出有功功率";
        $dataArray["B相输出有功功率"] = number_format($v[3] / 100,1);
        $dataArray["AI"]["2A1112E00001"] = "B相输出有功功率";
        $dataArray["C相输出有功功率"] = number_format($v[4] / 100,1);
        $dataArray["AI"]["2A1112F00001"] = "C相输出有功功率";
        $dataArray["A相输出视在功率"] = number_format($v[5] / 100,1);
        $dataArray["AI"]["2A1111D00001"] = "A相输出视在功率";
        $dataArray["B相输出视在功率"] = number_format($v[6] / 100,1);
        $dataArray["AI"]["2A1111E00001"] = "B相输出视在功率";
        $dataArray["C相输出视在功率"] = number_format($v[7] / 100,1);
        $dataArray["AI"]["2A1111F00001"] = "C相输出视在功率";
        $dataArray["A相输出负载率"] = number_format($v[8] / 100,1);
        $dataArray["AI"]["2A1121100001"] = "A相输出负载率";
        $dataArray["B相输出负载率"] = number_format($v[9] / 100,1);
        $dataArray["AI"]["2A1121200001"] = "B相输出负载率";
        $dataArray["C相输出负载率"] = number_format($v[10] / 100,1);
        $dataArray["AI"]["2A1121300001"] = "C相输出负载率";

        $v = unpack('c*', substr($memData, 4 + 4 * 14 + 1 * 1 + 4 * 40 + 1 * 1 + 4 * 20 + 4 * 7 + 4 * 2 + 4 * 10,1));

        $dataArray["电池状态"] = $v[1] == 0 ? "浮充" : "均充";
        $dataArray["DI"]["2A1300600001"] = $v[1] == 0;
        $dataArray["DI"]["2A1300601001"] = $v[1];
        $v = unpack('c*', substr($memData, 4 + 4 * 14 + 1 * 1 + 4 * 40 + 1 * 1 + 4 * 20 + 4 * 7 + 4 * 2 + 4 * 10 + 1 , 29));
        $dataArray["不同步"] = $v[1] == 0 ? "正常" : "异常";

        switch ($v[2]) {
            case '0':
                $dataArray["旁路电源供电"] = "正常";
                break;
            case '1':
                $dataArray["旁路电源供电"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["旁路电源供电"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["旁路电源供电"] = "低（预警值）";
                break;
            case '4':
                $dataArray["旁路电源供电"] = "高（预警值）";
                break;
            case '5':
                $dataArray["旁路电源供电"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[3]) {
            case '0':
                $dataArray["输入电源中断"] = "正常";
                break;
            case '1':
                $dataArray["输入电源中断"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["输入电源中断"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["输入电源中断"] = "低（预警值）";
                break;
            case '4':
                $dataArray["输入电源中断"] = "高（预警值）";
                break;
            case '5':
                $dataArray["输入电源中断"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[4]) {
            case '0':
                $dataArray["整流器故障"] = "正常";
                break;
            case '1':
                $dataArray["整流器故障"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["整流器故障"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["整流器故障"] = "低（预警值）";
                break;
            case '4':
                $dataArray["整流器故障"] = "高（预警值）";
                break;
            case '5':
                $dataArray["整流器故障"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[5]) {
            case '0':
                $dataArray["逆变器故障"] = "正常";
                break;
            case '1':
                $dataArray["逆变器故障"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["逆变器故障"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["逆变器故障"] = "低（预警值）";
                break;
            case '4':
                $dataArray["逆变器故障"] = "高（预警值）";
                break;
            case '5':
                $dataArray["逆变器故障"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[6]) {
            case '0':
                $dataArray["并机系统故障"] = "正常";
                break;
            case '1':
                $dataArray["并机系统故障"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["并机系统故障"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["并机系统故障"] = "低（预警值）";
                break;
            case '4':
                $dataArray["并机系统故障"] = "高（预警值）";
                break;
            case '5':
                $dataArray["并机系统故障"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[7]) {
            case '0':
                $dataArray["电池总电压"] = "正常";
                break;
            case '1':
                $dataArray["电池总电压"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["电池总电压"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["电池总电压"] = "低（预警值）";
                break;
            case '4':
                $dataArray["电池总电压"] = "高（预警值）";
                break;
            case '5':
                $dataArray["电池总电压"] = "异常";
                break;
            default:
                break;
        }

        $dataArray["标示电池数量"] = $v[8];
        switch ($v[9]) {
            case '0':
                $dataArray["单体电池电压1"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压1"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压1"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压1"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压1"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压1"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[10]) {
            case '0':
                $dataArray["单体电池电压2"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压2"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压2"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压2"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压2"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压2"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[11]) {
            case '0':
                $dataArray["单体电池电压3"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压3"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压3"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压3"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压3"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压3"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[12]) {
            case '0':
                $dataArray["单体电池电压4"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压4"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压4"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压4"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压4"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压4"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[13]) {
            case '0':
                $dataArray["单体电池电压5"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压5"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压5"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压5"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压5"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压5"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[14]) {
            case '0':
                $dataArray["单体电池电压6"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压6"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压6"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压6"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压6"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压6"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[15]) {
            case '0':
                $dataArray["单体电池电压7"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压7"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压7"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压7"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压7"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压7"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[16]) {
            case '0':
                $dataArray["单体电池电压8"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压8"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压8"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压8"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压8"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压8"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[17]) {
            case '0':
                $dataArray["单体电池电压9"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压9"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压9"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压9"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压9"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压9"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[18]) {
            case '0':
                $dataArray["单体电池电压10"] = "正常";
                break;
            case '1':
                $dataArray["单体电池电压10"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["单体电池电压10"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["单体电池电压10"] = "低（预警值）";
                break;
            case '4':
                $dataArray["单体电池电压10"] = "高（预警值）";
                break;
            case '5':
                $dataArray["单体电池电压10"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[19]) {
            case '0':
                $dataArray["标示温度数量"] = "正常";
                break;
            case '1':
                $dataArray["标示温度数量"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["标示温度数量"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["标示温度数量"] = "低（预警值）";
                break;
            case '4':
                $dataArray["标示温度数量"] = "高（预警值）";
                break;
            case '5':
                $dataArray["标示温度数量"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[20]) {
            case '0':
                $dataArray["电池温度1"] = "正常";
                break;
            case '1':
                $dataArray["电池温度1"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["电池温度1"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["电池温度1"] = "低（预警值）";
                break;
            case '4':
                $dataArray["电池温度1"] = "高（预警值）";
                break;
            case '5':
                $dataArray["电池温度1"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[21]) {
            case '0':
                $dataArray["电池温度2"] = "正常";
                break;
            case '1':
                $dataArray["电池温度2"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["电池温度2"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["电池温度2"] = "低（预警值）";
                break;
            case '4':
                $dataArray["电池温度2"] = "高（预警值）";
                break;
            case '5':
                $dataArray["电池温度2"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[22]) {
            case '0':
                $dataArray["电池温度3"] = "正常";
                break;
            case '1':
                $dataArray["电池温度3"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["电池温度3"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["电池温度3"] = "低（预警值）";
                break;
            case '4':
                $dataArray["电池温度3"] = "高（预警值）";
                break;
            case '5':
                $dataArray["电池温度3"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[23]) {
            case '0':
                $dataArray["电池温度4"] = "正常";
                break;
            case '1':
                $dataArray["电池温度4"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["电池温度4"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["电池温度4"] = "低（预警值）";
                break;
            case '4':
                $dataArray["电池温度4"] = "高（预警值）";
                break;
            case '5':
                $dataArray["电池温度4"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[24]) {
            case '0':
                $dataArray["电池温度5"] = "正常";
                break;
            case '1':
                $dataArray["电池温度5"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["电池温度5"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["电池温度5"] = "低（预警值）";
                break;
            case '4':
                $dataArray["电池温度5"] = "高（预警值）";
                break;
            case '5':
                $dataArray["电池温度5"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[25]) {
            case '0':
                $dataArray["温度传感器故障"] = "正常";
                break;
            case '1':
                $dataArray["温度传感器故障"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["温度传感器故障"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["温度传感器故障"] = "低（预警值）";
                break;
            case '4':
                $dataArray["温度传感器故障"] = "高（预警值）";
                break;
            case '5':
                $dataArray["温度传感器故障"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[26]) {
            case '0':
                $dataArray["输入电源缺相"] = "正常";
                break;
            case '1':
                $dataArray["输入电源缺相"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["输入电源缺相"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["输入电源缺相"] = "低（预警值）";
                break;
            case '4':
                $dataArray["输入电源缺相"] = "高（预警值）";
                break;
            case '5':
                $dataArray["输入电源缺相"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[27]) {
            case '0':
                $dataArray["输出频率异常"] = "正常";
                break;
            case '1':
                $dataArray["输出频率异常"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["输出频率异常"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["输出频率异常"] = "低（预警值）";
                break;
            case '4':
                $dataArray["输出频率异常"] = "高（预警值）";
                break;
            case '5':
                $dataArray["输出频率异常"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[28]) {
            case '0':
                $dataArray["逆变器过载"] = "正常";
                break;
            case '1':
                $dataArray["逆变器过载"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["逆变器过载"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["逆变器过载"] = "低（预警值）";
                break;
            case '4':
                $dataArray["逆变器过载"] = "高（预警值）";
                break;
            case '5':
                $dataArray["逆变器过载"] = "异常";
                break;
            default:
                break;
        }

        switch ($v[29]) {
            case '0':
                $dataArray["滤波器故障"] = "正常";
                break;
            case '1':
                $dataArray["滤波器故障"] = "低于下限（过低）";
                break;
            case '2':
                $dataArray["滤波器故障"] = "高于上限（过高）";
                break;
            case '3':
                $dataArray["滤波器故障"] = "低（预警值）";
                break;
            case '4':
                $dataArray["滤波器故障"] = "高（预警值）";
                break;
            case '5':
                $dataArray["滤波器故障"] = "异常";
                break;
            default:
                break;
        }

        $v = unpack('v', substr($memData, 4 + 4 * 14 + 1 * 1 + 4 * 40 + 1 * 1 + 4 * 20 + 4 * 7 + 4 * 2 + 4 * 10 + 1 * 30, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 4 * 14 + 1 * 1 + 4 * 40 + 1 * 1 + 4 * 20 + 4 * 7 + 4 * 2 + 4 * 10 + 1 * 30 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }
}
