<?php


function Get_unicom_ups5000_Signals($type)
{
    switch ($type) {
        case "AI":
            return array("911143200001", "911143200001");
        case "DI":
            return array();
        case "AO":
            return array("911643201001");
        case "DO":
            return array();
        case "ALARM":
            return array();
        default:
            return array();
    }

}


function Get_unicom_ups5000_UnicomCategory()
{
    return "911";
}

function Get_unicom_ups5000_RtData($memData, &$dataArray, $extraPara = false)
{
    if ($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $offset = 4;
        //1
        $v = unpack('S*', substr($memData, $offset, 2 * 17));
        $dataArray['A相输入电压'] = number_format($v[1] / 10) . ' V';
        $dataArray['B相输入电压'] = number_format($v[2] / 10) . ' V';
        $dataArray['C相输入电压'] = number_format($v[3] / 10) . ' V';
        $dataArray['AB输入线电压'] = number_format($v[4] / 10) . ' V';
        $dataArray['BC输入线电压'] = number_format($v[5] / 10) . ' V';
        $dataArray['CA输入线电压'] = number_format($v[6] / 10) . ' V';
        $dataArray['A相输入电流'] = number_format($v[7] / 10) . "A";
        $dataArray['B相输入电流'] = number_format($v[8] / 10) . "A";
        $dataArray['C相输入电流'] = number_format($v[9] / 10) . "A";
        $dataArray['输入频率'] = number_format($v[10] / 100) . "Hz";
        $dataArray['A相输入功率因数'] = number_format($v[11] / 100);
        $dataArray['B相输入功率因数'] = number_format($v[12] / 100);
        $dataArray['C相输入功率因数'] = number_format($v[13] / 100);
        $dataArray['正母线电压'] = number_format($v[14] / 10, 2) . ' V';
        $dataArray['负母线电压'] = number_format($v[15] / 10, 2) . ' V';
        $dataArray['零序电流'] = number_format($v[16] / 10, 2) . ' A';
        $dataArray['模块温度'] = number_format($v[17] / 10, 2) . ' °C';

        //2
        $offset += 2 * 17;
        $v = unpack('S*', substr($memData, $offset, 2 * 15));
        $dataArray['旁路A相输入电压'] = number_format($v[1] / 10, 2) . ' V';
        $dataArray['旁路B相输入电压'] = number_format($v[2] / 10, 2) . ' V';
        $dataArray['旁路C相输入电压'] = number_format($v[3] / 10, 2) . ' V';
        $dataArray['旁路AB输入线电压'] = number_format($v[4] / 10, 2) . ' V';
        $dataArray['旁路BC输入线电压'] = number_format($v[5] / 10, 2) . ' V';
        $dataArray['旁路CA输入线电压'] = number_format($v[6] / 10, 2) . ' V';
        $dataArray['旁路输入频率'] = number_format($v[7] / 10, 2) . ' V';
        $dataArray['环境温度'] = number_format($v[14] / 10, 2) . ' °C';

        $dataArray['环境湿度'] = number_format($v[15] / 10, 2) . ' °C';

        //3
        $offset += 2 * 15;
        $v = unpack('S*', substr($memData, $offset, 2 * 28));
        $dataArray['机架A相输出电压'] = number_format($v[1] / 10) . ' V';
        $dataArray['机架B相输出电压'] = number_format($v[2] / 10) . ' V';
        $dataArray['机架C相输出电压'] = number_format($v[3] / 10) . ' V';
        $dataArray['机架AB输出线电压'] = number_format($v[4] / 10) . ' V';
        $dataArray['机架BC输出线电压'] = number_format($v[5] / 10) . ' V';
        $dataArray['机架CA输出线电压'] = number_format($v[6] / 10) . ' V';
        $dataArray['机架A相输出电流'] = number_format($v[7] / 10) . "A";
        $dataArray['机架B相输出电流'] = number_format($v[8] / 10) . "A";
        $dataArray['机架C相输出电流'] = number_format($v[9] / 10) . "A";
        $dataArray['机架输出频率'] = number_format($v[10] / 100) . "Hz";
        $dataArray['机架A相输出有功功率'] = number_format($v[11] / 10) . ' KW';
        $dataArray['机架B相输出有功功率'] = number_format($v[12] / 10) . ' KW';
        $dataArray['机架C相输出有功功率'] = number_format($v[13] / 10) . ' KW';
        $dataArray['机架A相输出视在功率'] = number_format($v[14] / 10) . ' KVA';
        $dataArray['机架B相输出视在功率'] = number_format($v[15] / 10) . ' KVA';
        $dataArray['机架C相输出视在功率'] = number_format($v[16] / 10) . ' KVA';
        $dataArray['机架A相输出无功功率'] = number_format($v[17] / 10) . ' KVAR';
        $dataArray['机架B相输出无功功率'] = number_format($v[18] / 10) . ' KVAR';
        $dataArray['机架C相输出无功功率'] = number_format($v[19] / 10) . ' KVAR';
        $dataArray['机架A相输出功率因数'] = number_format($v[20] / 100);
        $dataArray['机架B相输出功率因数'] = number_format($v[21] / 100);
        $dataArray['机架C相输出功率因数'] = number_format($v[22] / 100);
        $dataArray['机架A相输出负载率'] = number_format($v[23] / 10) . ' %';
        $dataArray['机架B相输出负载率'] = number_format($v[24] / 10) . ' %';
        $dataArray['机架C相输出负载率'] = number_format($v[25] / 10) . ' %';
        $dataArray['机架A相输出峰值比'] = number_format($v[26] / 10);
        $dataArray['机架B相输出峰值比'] = number_format($v[27] / 10);
        $dataArray['机架C相输出峰值比'] = number_format($v[28] / 10);

        //4
        $offset += 2 * 28;
        $v = unpack('S*', substr($memData, $offset, 2 * 44));
        $dataArray['系统A相输出有功功率'] = (intval($v[1]) << 16 + $v[2]) . ' KW';
        $dataArray['系统B相输出有功功率'] = (intval($v[3]) << 16 + $v[4]) . ' KW';
        $dataArray['系统C相输出有功功率'] = (intval($v[5]) << 16 + $v[6]) . ' KW';
        $dataArray['系统A相输出视在功率'] = (intval($v[7]) << 16 + $v[8]) . ' KVA';
        $dataArray['系统A相输出有功功率'] = number_format($v[9] / 10) . ' KW';
        $dataArray['系统B相输出有功功率'] = number_format($v[10] / 10) . ' KW';
        $dataArray['系统C相输出有功功率'] = number_format($v[11] / 10) . ' KW';
        $dataArray['系统A相输出视在功率'] = number_format($v[12] / 10) . ' KVA';
        $dataArray['系统B相输出视在功率'] = number_format($v[13] / 10) . ' KVA';
        $dataArray['系统C相输出视在功率'] = number_format($v[14] / 10) . ' KVA';
        $dataArray['系统A相输出无功功率'] = number_format($v[15] / 10) . ' KVAR';
        $dataArray['系统B相输出无功功率'] = number_format($v[16] / 10) . ' KVAR';
        $dataArray['系统C相输出无功功率'] = number_format($v[17] / 10) . ' KVAR';
        $dataArray['系统B相输出视在功率'] = (intval($v[18]) << 16 + $v[19]) . ' KVA';
        $dataArray['系统C相输出视在功率'] = (intval($v[20]) << 16 + $v[21]) . ' KVA';
        $dataArray['系统A相输出无功功率'] = (intval($v[22]) << 16 + $v[23]) . ' KVAR';
        $dataArray['系统B相输出无功功率'] = (intval($v[23]) << 16 + $v[24]) . ' KVAR';
        $dataArray['系统C相输出无功功率1'] = (intval($v[25]) << 16 + $v[26]) . ' KVAR';

        //5
        $offset += 2 * 44;
        $v = unpack('S*', substr($memData, $offset, 2 * 16));
        $dataArray['正组电池电压'] = number_format($v[1] / 10) . ' V';
        $dataArray['负组电池电压'] = number_format($v[2] / 10) . ' V';
        $dataArray['正组电池电流'] = number_format($v[3] / 10) . ' A';
        $dataArray['负组电池电流'] = number_format($v[4] / 10) . ' A';
        $dataArray['电压'] = number_format($v[5] / 10) . ' V';
        $dataArray['电流'] = number_format($v[6] / 10) . ' A';
        $dataArray['温度'] = number_format($v[8] / 10) . ' °C';
        $dataArray['备电时间'] = $v[9] . ' S';
        $dataArray['剩余容量'] = $v[10] . ' %';
        $dataArray['正组电池电流'] = (intval($v[11]) << 16 + $v[12]) . ' A';
        $dataArray['负组电池电流'] = (intval($v[13]) << 16 + $v[14]) . ' A';
        $dataArray['电流'] = (intval($v[15]) << 16 + $v[16]) . ' A';

        //6
        $offset += 2 * 16 + 2;
        $v = unpack('S*', substr($memData, $offset, 2 * 4));
        $dataArray['整流器限功率状态'] = ($v[1] & 0x1) == 1 ? '限功率' : '未限功率';
        $dataArray['充电器限功率状态'] = (($v[1] >> 1) & 0x1) == 1 ? '限功率' : '未限功率';
        $dataArray['电池自检状态'] = (($v[1] >> 2) & 0x1) == 1 ? '自检中' : '没自检';
        switch (($v[1] >> 3) & 0x3) {
            case 0:
                $str = '均不供电';
                break;
            case 1:
                $str = '市电供电';
                break;
            case 2:
                $str = '电池供电';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['整流侧供电状态'] = $str;
        $dataArray['市电输入告警状态'] = (($v[1] >> 5) & 0x3) == 1 ? '异常' : '正常';
        $dataArray['AlertArray']['市电输入告警状态'] = (($v[1] >> 5) & 0x3) == 1;
        switch (($v[1] >> 7) & 0x3) {
            case 0:
                $str = '正常';
                break;
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['电池告警状态'] = $str;
        $dataArray['AlertArray']['电池告警状态'] = ($v[1] >> 7) & 0x3 == 1 || ($v[1] >> 7) & 0x3 == 2;
        switch (($v[1] >> 9) & 0x3) {
            case 0:
                $str = '正常';
                break;
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['整流器告警状态'] = $str;
        $dataArray['AlertArray']['整流器告警状态'] = ($v[1] >> 9) & 0x3 == 1 || ($v[1] >> 9) & 0x3 == 2;

        switch (($v[1] >> 11) & 0x3) {
            case 0:
                $str = '正常';
                break;
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['充电器告警状态'] = $str;
        $dataArray['AlertArray']['充电器告警状态'] = ($v[1] >> 11) & 0x3 == 1 || ($v[1] >> 11) & 0x3 == 2;

        switch (($v[1] >> 13) & 0x3) {
            case 0:
                $str = '正常';
                break;
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['放电器告警状态'] = $str;
        $dataArray['AlertArray']['放电器告警状态'] = ($v[1] >> 13) & 0x3 == 1 || ($v[1] >> 13) & 0x3 == 2;

        switch ($v[2] & 0x3) {
            case 0:
                $str = '停止';
                break;
            case 1:
                $str = 'SCR软启动';
                break;
            case 2:
                $str = 'AC-BOOST软启动';
                break;
            case 3:
                $str = '正常运行';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['整流器工作状态'] = $str;
        $dataArray['整流器休眠状态'] = (($v[2] >> 2) & 0x1) == 1 ? '休眠' : '未休眠';
        switch (($v[2] >> 3) & 0x3) {
            case 0:
                $str = '停止';
                break;
            case 1:
                $str = '软启动';
                break;
            case 2:
                $str = '正常运行';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['充电器工作状态'] = $str;
        switch (($v[2] >> 5) & 0x3) {
            case 0:
                $str = '停止';
                break;
            case 1:
                $str = '电池冷启动';
                break;
            case 2:
                $str = 'DC-BOOST软启动';
                break;
            case 3:
                $str = '正常运行';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['放电器工作状态'] = $str;

        $dataArray['休眠状态'] = $v[4] & 0x1 == 1 ? '休眠' : '未休眠';
        $dataArray['模块降额运行'] = ($v[4] >> 1) & 0x1 == 1 ? '降额' : '未降额';
        $dataArray['开机允许状态'] = ($v[4] >> 2) & 0x1 == 1 ? '允许' : '不允许';
        switch (($v[4] >> 3) & 0x3) {
            case 0:
                $str = '均不供电';
                break;
            case 1:
                $str = '市电供电';
                break;
            case 2:
                $str = '电池供电';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['逆变侧供电状态'] = $str;
        $dataArray['自老化状态'] = (($v[4] >> 5) & 0x1) == 1 ? '自老化' : '非自老化';
        switch (($v[4] >> 6) & 0x1) {
            case 0:
                $str = '正常';
                break;
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['逆变器告警状态'] = $str;
        $dataArray['AlertArray']['逆变器告警状态'] = ($v[4] >> 6) & 0x1 == 1 || ($v[4] >> 6) & 0x1 == 2;
        switch (($v[4] >> 8) & 0x1) {
            case 0:
                $str = '停止';
                break;
            case 1:
                $str = '软启动';
                break;
            case 2:
                $str = '正常运行';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['逆变器工作状态'] = $str;
        $dataArray['自检中'] = (($v[4] >> 10) & 0x1) == 1 ? '自检中' : '未自检';
        $dataArray['逆变继电器状态'] = (($v[4] >> 11) & 0x1) == 1 ? '闭合' : '断开';
        $dataArray['输出谐波状态'] = (($v[4] >> 12) & 0x1) == 1 ? '偏大' : '正常';

        //7
        $offset += 2 * 4 + 3 * 2;
        $v = unpack('S*', substr($memData, $offset, 2 * 11));
        $dataArray['次要告警或紧急告警'] = $v[1] == 1 ? '有' : '无';
        $dataArray['提示告警'] = $v[2] == 1 ? '有' : '无';
        $dataArray['电池供电'] = $v[3] == 1 ? '电池供电' : '非电池供电';
        $dataArray['旁路供电'] = $v[4] == 1 ? '电池供电' : '非电池供电';
        switch ($v[5] & 0x3) {
            case 0:
                $str = '正常';
                break;
            case 1:
                $str = 'SCR软启动';
                break;
            case 2:
                $str = 'AC-BOOST软启动';
                break;
            default:
                $str = '正常运行';
        }
        $dataArray['整流工作状态'] = $str;
        switch ($v[6] & 0x3) {
            case 0:
                $str = '均不供电';
                break;
            case 1:
                $str = '市电供电';
                break;
            case 2:
                $str = '电池供电';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['整流侧供电状态'] = $str;
        switch ($v[7] & 0x3) {
            case 0:
                $str = '正常';
                break;
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['整流告警状态'] = $str;
        switch ($v[8] & 0x3) {
            case 0:
                $str = '停止';
                break;
            case 1:
                $str = '软起动';
                break;
            case 2:
                $str = '正常运行';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['逆变工作状态'] = $str;
        switch ($v[9] & 0x3) {
            case 0:
                $str = '均不供电';
                break;
            case 1:
                $str = '旁路供电';
                break;
            case 2:
                $str = '逆变供电';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['逆变侧供电状态'] = $str;
        switch ($v[10] & 0x3) {
            case 0:
                $str = '正常';
                break;
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['逆变告警状态'] = $str;
        $dataArray['电池低压预告警'] = ($v[11] & 0x1) == 1 ? '异常' : '正常';

        //8
        $offset += 2 * 11;
        $v = unpack('S*', substr($memData, $offset, 2 * 11));
        $dataArray['维修空开闭合'] = ($v[1] & 0x1) == 1 ? '闭合' : '断开';
        $dataArray['配电柜旁路输入闭合'] = (($v[1] >> 1) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['配电柜市电输入闭合'] = (($v[1] >> 2) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['配电柜输出空开闭合'] = (($v[1] >> 3) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['配电柜维修空开闭合'] = (($v[1] >> 4) & 0x1) == 1 ? '闭合' : '断开';
        $dataArray['市电输入空开闭合'] = (($v[1] >> 5) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['旁路输入空开闭合'] = (($v[1] >> 6) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['输出空开闭合'] = (($v[1] >> 7) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['旁路告警状态'] = (($v[1] >> 8) & 0x3) == 1 ? '异常' : '正常';
        $dataArray['旁路通讯失败'] = (($v[1] >> 10) & 0x1) == 1 ? '通讯失败' : '正常';
        $dataArray['旁路配置失败'] = (($v[1] >> 11) & 0x1) == 1 ? '配置失败' : '正常';
        $dataArray['旁路供电状态'] = (($v[1] >> 13) & 0x1) == 1 ? '旁路供电' : '非旁路供电';
        $dataArray['旁路接管状态'] = (($v[1] >> 14) & 0x1) == 1 ? '旁路被接管' : '旁路未被接管';
        $dataArray['电池自检状态'] = ($v[1] >> 15 & 0x1) == 1 ? '自检中' : '没自检';
        $dataArray['旁路配置中'] = ($v[2] & 0x1) == 1 ? '配置中' : '正常';
        $dataArray['加载中'] = ($v[2] >> 1 & 0x1) == 1 ? '加载中' : '正常';
        $dataArray['加载失败'] = ($v[2] >> 2 & 0x1) == 1 ? '加载失败' : '正常';
        //电池
        $dataArray['强制均充'] = ($v[4] & 0x1) == 1 ? '强制均充' : '未强制均充';
        $dataArray['浅放电测试'] = (($v[4] >> 1) & 0x1) == 1 ? '测试中' : '未测试';
        $dataArray['定时浅放电测试'] = (($v[4] >> 2) & 0x1) == 1 ? '测试中' : '未测试';
        $dataArray['核对性容量测试'] = (($v[4] >> 3) & 0x1) == 1 ? '测试中' : '未测试';
        switch ($v[4] >> 4 & 0x3) {
            case 0:
                $str = '良好';
                break;
            case 1:
                $str = '需要维护';
                break;
            case 2:
                $str = '需要更换';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['电池SOH备注：电池类型为铅酸电池时有此信号'] = $str;
        $dataArray['分组核对性容量测试'] = (($v[4] >> 6) & 0x1) == 1 ? '测试中' : '未测试';

        //ECU综合
        $dataArray['维修空开状态'] = ($v[6] & 0x1) == 1 ? '闭合' : '断开';
        $dataArray['配电柜旁路输入空开状态'] = (($v[6] >> 1) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['配电柜市电输入空开状态'] = (($v[6] >> 2) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['配电柜输出空开状态'] = (($v[6] >> 3) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['配电柜维修空开状态'] = (($v[6] >> 4) & 0x1) == 1 ? '闭合' : '断开';
        $dataArray['市电输入空开状态'] = (($v[6] >> 5) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['旁路输入空开状态'] = (($v[6] >> 6) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['输出空开状态'] = (($v[6] >> 7) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['电池空开状态'] = (($v[6] >> 8) & 0x1) == 1 ? '断开' : '闭合';
        $dataArray['发电机接入'] = (($v[6] >> 10) & 0x1) == 1 ? '接入' : '断开';
        switch (($v[6] >> 11) & 0x7) {
            case 0:
                $str = '无提示';
                break;
            case 1:
                $str = '关机导致系统过载';
                break;
            case 2:
                $str = '关机导致系统切旁路';
                break;
            case 3:
                $str = '关机导致系统间断切旁路';
                break;
            case 4:
                $str = '关机导致系统掉电';
                break;
            default :
                $str = '未定义';
        }
        $dataArray['切换提示'] = $str;
        switch (($v[6] >> 14) & 0x3) {
            case 0:
                $str = '未接入';
                break;
            case 1:
                $str = '闭合';
                break;
            case 2:
                $str = '断开';
                break;
            default:
                $str = '未定义';
        }
        $dataArray['BCB状态'] = $str;

        switch ($v[7] & 0xF) {
            case 0:
                $str = '无切换';
                break;
            case 1:
                $str = '无输出切旁路';
                break;
            case 2:
                $str = '无输出切INV';
                break;
            case 3:
                $str = '旁路切无输出';
                break;
            case 4:
                $str = 'INV切无输出';
                break;
            case 5:
                $str = 'INV无间断切旁路';
                break;
            case 6:
                $str = '旁路无间断切INV';
                break;
            case 7:
                $str = 'INV间断切旁路';
                break;
            case 8:
                $str = '旁路间断切INV';
                break;
            default :
                $str = '无效';
        }
        $dataArray['切换方式'] = $str;
        switch (($v[7] >> 4) & 0x3) {
            case 0:
                $str = '均不供电';
                break;
            case 1:
                $str = '旁路供电';
                break;
            case 2:
                $str = '逆变供电';
                break;
            default:
                $str = '无效';
        }
        $dataArray['机架供电状态'] = $str;
        $dataArray['机架供电模块个数'] = (($v[7] >> 6) & 0xF) . ' 个';
        $dataArray['集中控制器身份'] = (($v[7] >> 10) & 0x1) == 1 ? '机架主机' : '从机';
        $dataArray['集中控制器系统身份'] = (($v[7] >> 11) & 0x1) == 1 ? '系统主机' : '从机';
        switch (($v[7] >> 12) & 0x3) {
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '正常';
        }
        $dataArray['ECM告警状态'] = $str;
        $dataArray['旁路输入告警状态'] = ($v[7] >> 14) & 0x3 == 1 ? '异常' : '正常';

        switch ($v[8] & 0x3) {
            case 1:
                $str = '有次要告警';
                break;
            case 2:
                $str = '有紧急告警';
                break;
            default:
                $str = '正常';
        }
        $dataArray['旁路单元告警状态'] = $str;
        $dataArray['输出允许状态'] = ($v[8] >> 2) & 0x1 == 1 ? '允许' : '禁止输出';
        $dataArray['输出状态'] = ($v[8] >> 3) & 0x1 == 1 ? '有输出' : '无输出';
        switch (($v[8] >> 4) & 0x3) {
            case 0:
                $str = '均不供电';
                break;
            case 1:
                $str = '旁路供电';
                break;
            case 2:
                $str = '逆变供电';
                break;
            default:
                $str = '无效';
        }
        $dataArray['系统供电状态'] = $str;
        switch (($v[8] >> 7) & 0x3) {
            case 0:
                $str = '未激活';
                break;
            case 1:
                $str = 'BSC主系统';
                break;
            case 2:
                $str = 'BSC从系统';
                break;
            default:
                $str = '无效';
        }
        $dataArray['BSC系统状态'] = $str;
        $dataArray['系统逆变开启容量不足'] = ($v[8] >> 9) & 0x1 == 1 ? '容量不足' : '容量足';
        $dataArray['系统输出空开状态'] = ($v[8] >> 10) & 0x1 == 1 ? '断开' : '闭合';
        $dataArray['系统维修空开状态'] = ($v[8] >> 11) & 0x1 == 1 ? '断开' : '闭合';
        $dataArray['开机允许状态'] = ($v[8] >> 12) & 0x1 == 1 ? '允许' : '不允许';
        $dataArray['机架供电模块个数'] = ($v[9] & 0xF) . ' 个';

        //系统告警
        //40153
        $dataArray['机架数目不符'] = ($v[10] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['模块数目不符1'] = (($v[10] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['模块数目不符2'] = (($v[10] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池巡检仪数目不符'] = (($v[10] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['MUE07A板通讯失败'] = (($v[10] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池温度传感器通讯失败1'] = (($v[10] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池温度传感器通讯失败2'] = (($v[10] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池温度传感器通讯失败3'] = (($v[10] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池温度传感器通讯失败4'] = (($v[10] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['环境传感器通讯失败1'] = (($v[10] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['环境传感器通讯失败2'] = (($v[10] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['环境传感器通讯失败3'] = (($v[10] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['环境传感器通讯失败4'] = (($v[10] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池温度传感器数目不符'] = (($v[10] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['环境传感器数目不符'] = (($v[10] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['NTC失效'] = (($v[10] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['机架数目不符'] = ($v[10] & 0x1) == 1;
        $dataArray['AlertArray']['模块数目不符1'] = (($v[10] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['模块数目不符2'] = (($v[10] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['电池巡检仪数目不符'] = (($v[10] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['MUE07A板通讯失败'] = (($v[10] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['电池温度传感器通讯失败1'] = (($v[10] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['电池温度传感器通讯失败2'] = (($v[10] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['电池温度传感器通讯失败3'] = (($v[10] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['电池温度传感器通讯失败4'] = (($v[10] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['环境传感器通讯失败1'] = (($v[10] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['环境传感器通讯失败2'] = (($v[10] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['环境传感器通讯失败3'] = (($v[10] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['环境传感器通讯失败4'] = (($v[10] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['电池温度传感器数目不符'] = (($v[10] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['环境传感器数目不符'] = (($v[10] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['NTC失效'] = (($v[10] >> 15) & 0x1) == 1;
        //40154
        $dataArray['发电机接入'] = (($v[11] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电机启动失败'] = (($v[11] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['发电机关闭失败'] = (($v[11] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['ATS故障'] = (($v[11] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['功率单元数目不符1'] = (($v[11] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['功率单元数目不符2'] = (($v[11] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机型参数读取失败'] = (($v[11] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DRYB通讯失败'] = (($v[11] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['BCB断开异常'] = (($v[11] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['故障清除'] = (($v[11] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['ECM主备倒换'] = (($v[11] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['环境高温'] = (($v[11] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['系统时间异常'] = (($v[11] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['紧急关机'] = (($v[11] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机型不一致'] = (($v[11] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['发电机接入'] = (($v[11] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['发电机启动失败'] = (($v[11] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['发电机关闭失败'] = (($v[11] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['ATS故障'] = (($v[11] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['功率单元数目不符1'] = (($v[11] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['功率单元数目不符2'] = (($v[11] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['机型参数读取失败'] = (($v[11] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['DRYB通讯失败'] = (($v[11] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['BCB断开异常'] = (($v[11] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['故障清除'] = (($v[11] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['ECM主备倒换'] = (($v[11] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['环境高温'] = (($v[11] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['系统时间异常'] = (($v[11] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['紧急关机'] = (($v[11] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['机型不一致'] = (($v[11] >> 15) & 0x1) == 1;

        //9
        $offset += 2 * 11;
        $v = unpack('S*', substr($memData, $offset, 2 * 13));
        $dataArray['机架1通讯失败'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架2通讯失败'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架3通讯失败'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架4通讯失败'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架5通讯失败'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架6通讯失败'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架1主机冲突'] = (($v[1] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架2主机冲突'] = (($v[1] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架3主机冲突'] = (($v[1] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架4主机冲突'] = (($v[1] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架5主机冲突'] = (($v[1] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架6主机冲突'] = (($v[1] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架地址冲突'] = (($v[1] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['并机参数不一致'] = (($v[1] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容41'] = (($v[1] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['软件包不存在'] = (($v[1] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['机架1通讯失败'] = ($v[1] & 0x1) == 1;
        $dataArray['AlertArray']['机架2通讯失败'] = (($v[1] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['机架3通讯失败'] = (($v[1] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['机架4通讯失败'] = (($v[1] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['机架5通讯失败'] = (($v[1] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['机架6通讯失败'] = (($v[1] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['机架1主机冲突'] = (($v[1] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['机架2主机冲突'] = (($v[1] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['机架3主机冲突'] = (($v[1] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['机架4主机冲突'] = (($v[1] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['机架5主机冲突'] = (($v[1] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['机架6主机冲突'] = (($v[1] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['机架地址冲突'] = (($v[1] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['并机参数不一致'] = (($v[1] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容41'] = (($v[1] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['软件包不存在'] = (($v[1] >> 15) & 0x1) == 1;

        //40168
        $dataArray['版本不兼容42'] = ($v[2] & 0x1) == 1 ? '异常' : '正常';
        $dataArray['拨码冲突'] = (($v[2] >> 1) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['系统输出空开断开'] = (($v[2] >> 2) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['系统维修空开闭合'] = (($v[2] >> 3) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['手动开机'] = (($v[2] >> 9) & 0x1) == 1 ? '手动开机' : '正常';
        $dataArray['手动关机'] = (($v[2] >> 10) & 0x1) == 1 ? '手动关机' : '正常';
        $dataArray['手动开机失败'] = (($v[2] >> 11) & 0x1) == 1 ? '手动开机失败' : '正常';
        $dataArray['并机开机'] = (($v[2] >> 12) & 0x1) == 1 ? '关机开机' : '正常';
        $dataArray['并机关机'] = (($v[2] >> 13) & 0x1) == 1 ? '关机开机' : '正常';
        $dataArray['并机开机失败'] = (($v[2] >> 14) & 0x1) == 1 ? '关机开机失败' : '正常';
        $dataArray['参数同步'] = (($v[2] >> 15) & 0x1) == 1 ? '参数同步' : '正常';
        //40169
        $dataArray['整流器异常1'] = ($v[3] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常2'] = (($v[3] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常3'] = (($v[3] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常4'] = (($v[3] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常5'] = (($v[3] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常6'] = (($v[3] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常7'] = (($v[3] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常8'] = (($v[3] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常9'] = (($v[3] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常10'] = (($v[3] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['放电器异常1'] = (($v[3] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['放电器异常2'] = (($v[3] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['放电器异常3'] = (($v[3] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['内部故障1'] = (($v[3] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['内部故障2'] = (($v[3] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容1'] = (($v[3] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['整流器异常1'] = ($v[3] & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常2'] = (($v[3] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常3'] = (($v[3] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常4'] = (($v[3] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常5'] = (($v[3] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常6'] = (($v[3] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常7'] = (($v[3] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常8'] = (($v[3] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常9'] = (($v[3] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常10'] = (($v[3] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['放电器异常1'] = (($v[3] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['放电器异常2'] = (($v[3] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['放电器异常3'] = (($v[3] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['内部故障1'] = (($v[3] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['内部故障2'] = (($v[3] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容1'] = (($v[3] >> 15) & 0x1) == 1;
        //40170
        $dataArray['版本不兼容2'] = ($v[4] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容3'] = (($v[4] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池接反'] = (($v[4] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池欠压'] = (($v[4] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池未接'] = (($v[4] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常11'] = (($v[4] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常12'] = (($v[4] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常13'] = (($v[4] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常26'] = (($v[4] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['整流器异常28'] = (($v[4] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['风扇异常1'] = (($v[4] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['未就绪'] = (($v[4] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['市电电池切换次数异常'] = (($v[4] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['电池过压保护'] = (($v[4] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容21'] = (($v[4] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['内部故障14'] = (($v[4] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['版本不兼容2'] = ($v[4] & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容3'] = (($v[4] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['电池接反'] = (($v[4] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['电池欠压'] = (($v[4] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['电池未接'] = (($v[4] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常11'] = (($v[4] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常12'] = (($v[4] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常13'] = (($v[4] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常26'] = (($v[4] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常28'] = (($v[4] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['风扇异常1'] = (($v[4] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['未就绪'] = (($v[4] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['市电电池切换次数异常'] = (($v[4] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['电池过压保护'] = (($v[4] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容21'] = (($v[4] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['内部故障14'] = (($v[4] >> 15) & 0x1) == 1;
        //40171
        $dataArray['充电器告警12'] = ($v[5] & 0x1) == 1 ? '异常' : '正常';
        $dataArray['整流器异常27'] = (($v[5] >> 1) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['主路相序反3'] = (($v[5] >> 2) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['整流器告警10'] = (($v[5] >> 3) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['充电器告警11'] = (($v[5] >> 4) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['充电器告警13'] = (($v[5] >> 5) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['放电器异常4'] = (($v[5] >> 6) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['放电器异常5'] = (($v[5] >> 7) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['接地故障1'] = (($v[5] >> 9) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['AlertArray']['充电器告警12'] = ($v[5] & 0x1) == 1;
        $dataArray['AlertArray']['整流器异常27'] = (($v[5] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['主路相序反3'] = (($v[5] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['整流器告警10'] = (($v[5] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['充电器告警11'] = (($v[5] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['充电器告警13'] = (($v[5] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['放电器异常4'] = (($v[5] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['放电器异常5'] = (($v[5] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['接地故障1'] = (($v[5] >> 9) & 0x1) == 1;
        //40172
        $dataArray['逆变器异常1'] = ($v[6] & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常2'] = (($v[6] >> 1) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常3'] = (($v[6] >> 2) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常4'] = (($v[6] >> 3) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常5'] = (($v[6] >> 4) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常6'] = (($v[6] >> 5) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常7'] = (($v[6] >> 6) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常8'] = (($v[6] >> 7) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常9'] = (($v[6] >> 8) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['机架内并机线异常1'] = (($v[6] >> 9) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['机架内并机线异常2'] = (($v[6] >> 10) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['机架内并机线异常3'] = (($v[6] >> 11) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['机架内并机线告警13'] = (($v[6] >> 12) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['机架内并机线异常5'] = (($v[6] >> 13) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['内部故障3'] = (($v[6] >> 14) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['内部故障4'] = (($v[6] >> 15) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['AlertArray']['逆变器异常1'] = ($v[6] & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常2'] = (($v[6] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常3'] = (($v[6] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常4'] = (($v[6] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常5'] = (($v[6] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常6'] = (($v[6] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常7'] = (($v[6] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常8'] = (($v[6] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常9'] = (($v[6] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['机架内并机线异常1'] = (($v[6] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['机架内并机线异常2'] = (($v[6] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['机架内并机线异常3'] = (($v[6] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['机架内并机线异常4'] = (($v[6] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['机架内并机线异常5'] = (($v[6] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['内部故障3'] = (($v[6] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['内部故障4'] = (($v[6] >> 15) & 0x1) == 1;
        //40173
        $dataArray['版本不兼容4'] = ($v[7] & 0x1) == 1 ? '异常' : '正常';
        $dataArray['版本不兼容5'] = (($v[7] >> 1) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['版本不兼容6'] = (($v[7] >> 2) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['过载超时'] = (($v[7] >> 3) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['平衡电路异常1'] = (($v[7] >> 4) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['输出过载'] = (($v[7] >> 5) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['版本不兼容22'] = (($v[7] >> 6) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常10'] = (($v[7] >> 7) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常11'] = (($v[7] >> 8) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器自检异常1'] = (($v[7] >> 9) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器自检异常2'] = (($v[7] >> 10) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器自检异常3'] = (($v[7] >> 11) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器自检异常4'] = (($v[7] >> 12) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常23'] = (($v[7] >> 13) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器告警9'] = (($v[7] >> 14) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器告警10'] = (($v[7] >> 15) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['AlertArray']['版本不兼容4'] = ($v[7] & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容5'] = (($v[7] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容6'] = (($v[7] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['过载超时'] = (($v[7] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['平衡电路异常1'] = (($v[7] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['输出过载'] = (($v[7] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容22'] = (($v[7] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常10'] = (($v[7] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常11'] = (($v[7] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器自检异常1'] = (($v[7] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器自检异常2'] = (($v[7] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器自检异常3'] = (($v[7] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器自检异常4'] = (($v[7] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常23'] = (($v[7] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器告警9'] = (($v[7] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['逆变器告警10'] = (($v[7] >> 15) & 0x1) == 1;
        //40174
        $dataArray['逆变器异常29'] = ($v[8] & 0x1) == 1 ? '异常' : '正常';
        $dataArray['自启次数限制'] = (($v[8] >> 1) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['节点地址异常'] = (($v[8] >> 2) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['自启次数限制2'] = (($v[8] >> 3) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['接地故障2'] = (($v[8] >> 4) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['接地故障3'] = (($v[8] >> 5) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['接地故障4'] = (($v[8] >> 6) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['AlertArray']['逆变器异常29'] = ($v[8] & 0x1) == 1;
        $dataArray['AlertArray']['自启次数限制'] = (($v[8] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['节点地址异常'] = (($v[8] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['自启次数限制2'] = (($v[8] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['接地故障2'] = (($v[8] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['接地故障3'] = (($v[8] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['接地故障4'] = (($v[8] >> 6) & 0x1) == 1;
        //40175
        $dataArray['逆变器异常15'] = ($v[9] & 0x1) == 1 ? '异常' : '正常';
        $dataArray['逆变器异常30'] = (($v[9] >> 1) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['AlertArray']['逆变器异常15'] = ($v[9] & 0x1) == 1;
        $dataArray['AlertArray']['逆变器异常30'] = (($v[9] >> 1) & 0x1) == 1;
        //40176
        $dataArray['旁路单元异常4'] = ($v[10] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['旁路单元异常5'] = (($v[10] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架内并机线异常6'] = (($v[10] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['内部故障5'] = (($v[10] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['内部故障6'] = (($v[10] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容7'] = (($v[10] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容8'] = (($v[10] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容9'] = (($v[10] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['未就绪2'] = (($v[10] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['风扇异常2'] = (($v[10] >> 9) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容17'] = (($v[10] >> 10) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容18'] = (($v[10] >> 11) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容23'] = (($v[10] >> 12) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容29'] = (($v[10] >> 13) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容30'] = (($v[10] >> 14) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['旁路单元告警'] = (($v[10] >> 15) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['旁路单元异常4'] = ($v[10] & 0x1) == 1;
        $dataArray['AlertArray']['旁路单元异常5'] = (($v[10] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['机架内并机线异常6'] = (($v[10] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['内部故障5'] = (($v[10] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['内部故障6'] = (($v[10] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容7'] = (($v[10] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容8'] = (($v[10] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容9'] = (($v[10] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['未就绪2'] = (($v[10] >> 8) & 0x1) == 1;
        $dataArray['AlertArray']['风扇异常2'] = (($v[10] >> 9) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容17'] = (($v[10] >> 10) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容18'] = (($v[10] >> 11) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容23'] = (($v[10] >> 12) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容29'] = (($v[10] >> 13) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容30'] = (($v[10] >> 14) & 0x1) == 1;
        $dataArray['AlertArray']['旁路单元告警'] = (($v[10] >> 15) & 0x1) == 1;
        //40177
        $dataArray['机架内并机线异常14'] = ($v[11] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架内并机线告警12'] = (($v[11] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['紧急关机'] = (($v[11] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['机架内并机线异常15'] = (($v[11] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['旁路零线缺失'] = (($v[11] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['旁路NTC异常'] = (($v[11] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['程序运行异常'] = (($v[11] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['节点地址冲突'] = (($v[11] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['版本不兼容36'] = (($v[11] >> 8) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['AlertArray']['机架内并机线异常14'] = ($v[11] & 0x1) == 1;
        $dataArray['AlertArray']['机架内并机线异常12'] = (($v[11] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['紧急关机'] = (($v[11] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['机架内并机线异常15'] = (($v[11] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['旁路零线缺失'] = (($v[11] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['旁路NTC异常'] = (($v[11] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['程序运行异常'] = (($v[11] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['节点地址冲突'] = (($v[11] >> 7) & 0x1) == 1;
        $dataArray['AlertArray']['版本不兼容36'] = (($v[11] >> 8) & 0x1) == 1;
        //40178
        $dataArray['整流器异常29'] = ($v[12] & 0x1) == 1 ? '异常' : '正常';
        $dataArray['电池低压3'] = (($v[12] >> 1) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['AlertArray']['整流器异常29'] = ($v[12] & 0x1) == 1;
        $dataArray['AlertArray']['电池低压3'] = (($v[12] >> 1) & 0x1) == 1;
        //40179
        $dataArray['电池低压1'] = ($v[13] & 0x1) == 1 ? '异常' : '正常';
        $dataArray['电池放电终止1'] = (($v[13] >> 1) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['电池放电终止2'] = (($v[13] >> 2) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['电池过温保护'] = (($v[13] >> 3) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['电池继电器闭合检测失败'] = (($v[13] >> 4) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['电池继电器开路'] = (($v[13] >> 5) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['电池继电器短路'] = (($v[13] >> 6) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['电池放电终止4'] = (($v[13] >> 7) & 0x1) == 1 ? '异常' : '正常';
        $dataArray['AlertArray']['电池低压1'] = ($v[13] & 0x1) == 1;
        $dataArray['AlertArray']['电池放电终止1'] = (($v[13] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['电池放电终止2'] = (($v[13] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['电池过温保护'] = (($v[13] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['电池继电器闭合检测失败'] = (($v[13] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['电池继电器开路'] = (($v[13] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['电池继电器短路'] = (($v[13] >> 6) & 0x1) == 1;
        $dataArray['AlertArray']['电池放电终止4'] = (($v[13] >> 7) & 0x1) == 1;


        //10
        $offset += 2 * 13 + 2;
        $v = unpack('S*', substr($memData, $offset, 2 * 3));
        $dataArray['旁路A相输入电流'] = number_format($v[1] / 10) . ' A';
        $dataArray['旁路B相输入电流'] = number_format($v[2] / 10) . ' A';
        $dataArray['旁路C相输入电流'] = number_format($v[3] / 10) . ' A';

        //11
        $offset += 2 * 3;
        $v = unpack('S*', substr($memData, $offset, 2 * 5));
        $dataArray['在线模块个数'] = $v[1] . '个';
        $dataArray['模块在位状态'] = $v[2];
        $dataArray['模块在位状态'] = $v[3];
        $dataArray['机架供电模块个数'] = $v[4] . '个';
        $dataArray['机架在位状态'] = $v[5] == 1 ? '在位' : '不在位';

        $offset += 2 * 5 + 4 * 2;
        $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $offset += 2;
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }

}
