<?php



function Get_unicom_yd2018_UnicomCategory()
{
    return "321";
}

function Is_unicom_yd2018_NeedExtraPara(){
    return true;
}

function Get_unicom_yd2018_RtData($memData, &$dataArray, $extraPara = false)
{
    if($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        $v = unpack("s*", substr($memData, 4 + 32 * 2 + 2*8, 3*2));
        $dataArray["电压范围"] = $uargS = $v[1];
        $dataArray["PT"] = $PT = $v[2] == 0 ? 1 : $v[2];
        $dataArray["CT"] = $CT = $v[3]*10 == 0 ? 1 : $v[3];
	if(isset($extraPara->pt)){
		$dataArray["PT"] = $CT = $extraPara->pt;
	}
	if(isset($extraPara->ct)){
		$dataArray["CT"] = $CT = $extraPara->ct;
	}

        $Uarg = $uargS == 0 ? 0.1 : 0.4;

        $v = unpack("S*", substr($memData, 4, 32 * 2));
        $dataArray["相电压Ua"] = number_format($v[1]*$PT*0.01, 2)." V";
        $dataArray["线电压Uca"] = number_format($v[2]*$PT*0.01, 2)." V";
        $dataArray["A相电流"] = number_format($v[3]*$CT*0.0001, 3)." A";
        $dataArray["A相频率"] = number_format($v[4]*0.00106813, 2)." Hz";
        $dataArray["A相视在功率"] = number_format($v[8]*$PT*$CT*0.2/1000, 3)." kVA";

        $dataArray["相电压Ub"] = number_format($v[9]*$PT*0.01, 2)." V";
        $dataArray["线电压Uab"] = number_format($v[10]*$PT*0.01, 2)." V";
        $dataArray["B相电流"] = number_format($v[11]*$CT*0.0001, 3)." A";
        $dataArray["B相频率"] = number_format($v[12]*0.00106813, 2)." Hz";   
        $dataArray["B相视在功率"] = number_format($v[16]*$PT*$CT*0.2/1000, 3)." kVA";

        $dataArray["相电压Uc"] = number_format($v[17]*$PT*0.01, 2)." V";
        $dataArray["线电压Ubc"] = number_format($v[18]*$PT*0.01, 2)." V";
        $dataArray["C相电流"] = number_format($v[19]*$CT*0.0001, 3)." A";
        $dataArray["C相频率"] = number_format($v[20]*0.00106813, 2)." Hz";   
        $dataArray["C相视在功率"] = number_format($v[24]*$PT*$CT*0.2/1000, 3)." kVA";

        $dataArray["三相平均相电压"] = number_format($v[25]*$PT*0.01, 2)." V";
        $dataArray["三相平均线电压"] = number_format($v[26]*$PT*0.01, 2)." V";
        $dataArray["三相平均相电流"] = number_format($v[27]*$CT*0.0001, 3)." A";
        $dataArray["频率"] = number_format($v[28]*0.00106813, 2)." Hz";   
        $dataArray["三相视在功率"] = number_format($v[32]*$PT*$CT*0.2/1000, 3,'.','')." kVA";

        $v = unpack("s*", substr($memData, 4, 32 * 2));
        $dataArray["A相有功功率"] = number_format($v[5]*$PT*$CT*$Uarg/1000, 3,'.','')." kW";
        $dataArray["A相功率因数"] = number_format($v[6]*0.0001, 4);
        $dataArray["A相无功功率"] = number_format($v[7]*$PT*$CT*$Uarg/1000, 3,'.','')." kvar";     

        $dataArray["B相有功功率"] = number_format($v[13]*$PT*$CT*$Uarg/1000, 3,'.','')." kW";
        $dataArray["B相功率因数"] = number_format($v[14]*0.0001, 4);
        $dataArray["B相无功功率"] = number_format($v[15]*$PT*$CT*$Uarg/1000, 3,'.','')." kvar";   
      
        $dataArray["C相有功功率"] = number_format($v[21]*$PT*$CT*$Uarg/1000, 3,'.','')." kW";
        $dataArray["C相功率因数"] = number_format($v[22]*0.0001, 4);
        $dataArray["C相无功功率"] = number_format($v[23]*$PT*$CT*$Uarg/1000, 3,'.','')." kvar";   
      
        $dataArray["三相有功功率"] = number_format($v[29]*$PT*$CT*$Uarg/1000, 3,'.','')." kW";
        $dataArray["三相总功率因数"] = number_format($v[30]*0.0001, 4);
        $dataArray["三相无功功率"] = number_format($v[31]*$PT*$CT*$Uarg/1000, 3,'.','')." kvar";   
        

        $v = unpack("S*", substr($memData, 4 + 32 * 2, 2*8));
        $dataArray["正向有功电能"] = number_format(((intval($v[2]) << 16) + $v[1]) * $CT / 1000, 3,'.','')." kWh";
        $dataArray["负向有功电能"] = number_format(((intval($v[4]) << 16) + $v[3]) * $CT / 1000, 3,'.','')." kWh";
        $dataArray["正向无功电能"] = number_format(((intval($v[6]) << 16) + $v[5]) * $CT / 1000, 3,'.','')." kWh";
        $dataArray["负向无功电能"] = number_format(((intval($v[8]) << 16) + $v[7]) * $CT / 1000, 3,'.','')." kWh";


        $v = unpack('v', substr($memData, 4 + 32 * 2 + 2*8 + 3*2, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 32 * 2 + 2*8 + 3*2 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }

}
