<?php
function Get_unicom_yd6600_Standard_Variable($dataArray, $varname)
{
    switch ($varname) {
        case "[总电能]":
            return array(0, $dataArray['正向有功总电能2']);
    }
    return array(1, '设备无此信号数据:' . $varname);
}

function Get_unicom_yd6600_Size()
{
    return 189;
}

function Is_unicom_yd6600_NeedExtraPara()
{
    return true;
}

function Get_unicom_yd6600_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

	$isKv = false;
	if(isset($extraPara->kv)){
           $isKv = $extraPara->kv;
        }

        //8000
        $offset = 4;
        $newMem = '';
        $mem = substr($memData, 4+7*4, 2 * 4);
        for ($i = 0; $i < strlen($mem); $i += 4) {
            $newMem .= $mem[$i + 2] . $mem[$i + 3] . $mem[$i] . $mem[$i + 1];
        }
        $v = unpack("I*", $newMem);
        $dataArray['电压变比'] = $v[1];
        $dataArray['电流变比'] = $ct = $v[2];

        $newMem = '';
        $mem = substr($memData, $offset, 7 * 4);
        for ($i = 0; $i < strlen($mem); $i += 4) {
            $newMem .= $mem[$i + 2] . $mem[$i + 3] . $mem[$i] . $mem[$i + 1];
        }
        $v = unpack("i*", $newMem);
        $dataArray['组合有功总电能'] = number_format($v[1]*$ct/100, 2, '.', '') . ' kWh';
        //800A
        $dataArray['正向有功总电能'] = number_format($v[2]*$ct / 100, 2) . ' kWh';
        $dataArray['正向有功总电能2'] = number_format($v[2]*$ct / 100, 2);
        //8014
        $dataArray['反向有功总电能'] = number_format($v[3]*$ct / 100, 2) . ' kWh';
        //801E
        $dataArray['组合无功1总电能'] = number_format($v[4]*$ct / 100, 2) . ' kvarh';
        //8028
        $dataArray['组合无功2总电能'] = number_format($v[5]*$ct / 100, 2) . ' kvarh';
        //805A
        $dataArray['正向视在总电能'] = number_format($v[6]*$ct / 100, 2) . ' kVAh';
        //8064
        $dataArray['反向视在总电能'] = number_format($v[7]*$ct / 100, 2) . ' kVAh';
        //A813
        $offset += 7 * 4;

        //A83D
        $offset += 2 * 4;
        $v = unpack("S*", substr($memData, $offset, 4 * 2));
        $dataArray['DI1告警状态'] = ($v[1] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DI2告警状态'] = (($v[1] >> 1) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DI3告警状态'] = (($v[1] >> 2) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DI4告警状态'] = (($v[1] >> 3) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DI5告警状态'] = (($v[1] >> 4) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DI6告警状态'] = (($v[1] >> 5) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DI7告警状态'] = (($v[1] >> 6) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['DI8告警状态'] = (($v[1] >> 7) & 0x1) == 1 ? '告警' : '正常';
        $dataArray['总功率因素超下限'] = (($v[1] >> 8) & 0x1) == 1 ? '超出' : '未超出';
        $dataArray['系统频率超下限'] = (($v[1] >> 9) & 0x1) == 1 ? '超出' : '未超出';
        $dataArray['系统频率超上限'] = (($v[1] >> 10) & 0x1) == 1 ? '超出' : '未超出';
        $alertarr = [
            ['A相失压告警', 'A相欠压告警', 'A相过压告警', 'A相失流告警', 'A相过流告警', 'A相过载告警', '', 'A相断相告警', 'A相断流告警'],
            ['B相失压告警', 'B相欠压告警', 'B相过压告警', 'B相失流告警', 'B相过流告警', 'B相过载告警', '', 'B相断相告警', 'B相断流告警'],
            ['C相失压告警', 'C相欠压告警', 'C相过压告警', 'C相失流告警', 'C相过流告警', 'C相过载告警', '', 'C相断相告警', 'C相断流告警']
        ];
        foreach ($alertarr as $k => $val) {
            foreach ($val as $zik => $ziv) {
                if (!empty($val[$zik])) {
                    $dataArray[$ziv] = ($v[$k + 2] >> $k & 0x1) == 1 ? '告警' : '正常';
                }
            }
        }
        //8d00
        $offset += 4 * 2;
        $newMem = '';
        $mem = substr($memData, $offset, 13 * 4);
        for ($i = 0; $i < strlen($mem); $i += 4) {
            $newMem .= $mem[$i + 2] . $mem[$i + 3] . $mem[$i] . $mem[$i + 1];
        }
        $v = unpack("i*", $newMem);
        $dataArray['A相电压'] = $isKv ? (number_format($v[1] / 10000, 4) . " kV") : (number_format($v[1] / 1000, 3) . " V");
	if(($v[2] / 1000) < 0 || ($v[2] / 1000) > 10000){
	    $dataArray['B相电压'] = "0 ".($isKv ? ' kV' : ' V');
	}else{
            $dataArray['B相电压'] = $isKv ? (number_format($v[2] / 10000, 4) . " kV") : (number_format($v[2] / 1000, 3) . " V");
	}
	if(($v[3] / 1000) < 0 || ($v[3] / 1000) > 10000){
	    $dataArray['C相电压'] = "0 ".($isKv ? ' kV' : ' V');
	}else{
            $dataArray['C相电压'] = $isKv ? (number_format($v[3] / 10000, 4) . " kV") : (number_format($v[3] / 1000, 3) . " V");
	}
        $dataArray['零地电压'] = $isKv ? (number_format($v[4] / 10000, 4) . " kV") : (number_format($v[4] / 1000, 3) . " V");
        $dataArray['AB线电压'] = $isKv ? (number_format($v[5] / 10000, 4) . " kV") : (number_format($v[5] / 1000, 3) . " V");
        $dataArray['BC线电压'] = $isKv ? (number_format($v[6] / 10000, 4) . " kV") : (number_format($v[6] / 1000, 3) . " V");
        $dataArray['CA线电压'] = $isKv ? (number_format($v[7] / 10000, 4) . " kV") : (number_format($v[7] / 1000, 3) . " V");
        $dataArray['A相电流'] = number_format($v[8] * $ct / 1000, 2) . ' A';
        $dataArray['B相电流'] = number_format($v[9] * $ct / 1000, 2) . ' A';
        $dataArray['C相电流'] = number_format($v[10] * $ct / 1000, 2) . ' A';
        $dataArray['零线电流'] = number_format($v[11] * $ct / 1000, 2) . ' A';
        $offset += 13 * 4;
        $newMem = '';
        $mem = substr($memData, $offset, 12 * 4);
        for ($i = 0; $i < strlen($mem); $i += 4) {
            $newMem .= $mem[$i + 2] . $mem[$i + 3] . $mem[$i] . $mem[$i + 1];
        }
        $v = unpack("i*", $newMem);
        $dataArray['有功总功率'] = number_format($v[1] * $ct / 10000, 2) . ' kW';
        $dataArray['A相有功总功率'] = number_format($v[2] * $ct / 10000, 2) . ' kW';
        $dataArray['B相有功总功率'] = number_format($v[3] * $ct / 10000, 2) . ' kW';
        $dataArray['C相有功总功率'] = number_format($v[4] * $ct / 10000, 2) . ' kW';
        $dataArray['无功总功率'] = number_format($v[5] * $ct / 10000, 2) . ' kvar';
        $dataArray['A相无功总功率'] = number_format($v[6] * $ct / 10000, 2) . ' kvar';
        $dataArray['B相无功总功率'] = number_format($v[7] * $ct / 10000, 2) . ' kvar';
        $dataArray['C相无功总功率'] = number_format($v[8] * $ct / 10000, 2) . ' kvar';
        $dataArray['总视在功率'] = number_format($v[9] * $ct / 10000, 2) . ' kVA';
        $dataArray['A相视在功率'] = number_format($v[10] * $ct / 10000, 2) . ' kVA';
        $dataArray['B相视在功率'] = number_format($v[11] * $ct / 10000, 2) . ' kVA';
        $dataArray['C相视在功率'] = number_format($v[12] * $ct / 10000, 2) . ' kVA';
        $offset += 12 * 4;
        $v = unpack("S*", substr($memData, $offset, 4 * 2));
        $dataArray['总功率因数'] = number_format($v[1] / 1000, 2);
        $dataArray['A相功率因数'] = number_format($v[2] / 1000, 2);
        $dataArray['B相功率因数'] = number_format($v[3] / 1000, 2);
        $dataArray['C相功率因数'] = number_format($v[4] / 1000, 2);
        $offset += 4 * 2;
        $v = unpack("S*", substr($memData, $offset, 13 * 2));
        $dataArray['A相电压与电流夹角'] = number_format($v[1] / 100, 2) . '°';
        $dataArray['B相电压与电流夹角'] = number_format($v[2] / 100, 2) . '°';
        $dataArray['C相电压与电流夹角'] = number_format($v[3] / 100, 2) . '°';
        $dataArray['A相电压夹角'] = number_format($v[4] / 100, 2) . '°';
        $dataArray['B相电压夹角'] = number_format($v[5] / 100, 2) . '°';
        $dataArray['C相电压夹角'] = number_format($v[6] / 100, 2) . '°';
        $dataArray['A相电流夹角'] = number_format($v[7] / 100, 2) . '°';
        $dataArray['B相电流夹角'] = number_format($v[8] / 100, 2) . '°';
        $dataArray['C相电流夹角'] = number_format($v[9] / 100, 2) . '°';
        $dataArray['电网频率'] = number_format($v[10] / 100, 2) . 'Hz';
        $dataArray['电压不平衡率'] = number_format($v[11] / 100, 2) . '%';
        $dataArray['电流不平衡率'] = number_format($v[12] / 100, 2) . '%';
        $dataArray['合相阻性'] = ($v[13] & 0x1) == 1 ? '告警' : '正常';
        $dataArray['合相感性'] = ($v[13] >> 1 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['合相容性'] = ($v[13] >> 2 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['A相阻性'] = ($v[13] >> 4 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['A相感性'] = ($v[13] >> 5 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['A相容性'] = ($v[13] >> 6 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['B相阻性'] = ($v[13] >> 8 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['B相感性'] = ($v[13] >> 9 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['B相容性'] = ($v[13] >> 10 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['C相阻性'] = ($v[13] >> 12 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['C相感性'] = ($v[13] >> 13 & 0x1) == 1 ? '告警' : '正常';
        $dataArray['C相容性'] = ($v[13] >> 14 & 0x1) == 1 ? '告警' : '正常';

        $offset += 13 * 2;
        $v = unpack('v', substr($memData, $offset, 2));
        $offset += 2;
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
