<?php


function Get_unicom_yd8771y_Signals($type){
    switch($type){
        case "AI":
            return array("911143200001","911143200001");
        case "DI":
            return array();
        case "AO":
            return array("911643201001");
        case "DO":
            return array();
        case "ALARM":
            return array();
        default:
            return array();
    }

}


function Get_unicom_yd8771y_UnicomCategory()
{
    return "911";
}

function Get_unicom_yd8771y_RtData($memData, &$dataArray, $extraPara = false)
{
    if($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        $v = unpack('f*', substr($memData, 4, 4*2));

        $dataArray["温度"] = number_format($v[1], 2)."℃";
        $dataArray["AI"]["911143000001"] = "温度";
        $dataArray["湿度"] = number_format($v[2], 2)."%";
        $dataArray["AI"]["911143200001"] = "湿度";

        $v = unpack('v',substr($memData, 4 + 4*2, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 4*2 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));

    }
    
}
