<?php

function Get_unicom_yn194e2s4_Standard_Variable($dataArray, $varname)
{
    switch ($varname) {
        case "[总电能]":
            return array(0, $dataArray['正向有功电能2']);
    }
    return array(1, '设备无此信号数据:' . $varname);
}

function Get_unicom_yn194e2s4_Size()
{
    return 69;
}


function Get_unicom_yn194e2s4_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $offset = 4;
        $v = unpack("S*", substr($memData, 4 + 13 * 2 + 10 * 2 + 2 * 4, 2 * 2));
        $dataArray['电压倍率'] = $v[1];
        $dataArray['电流倍率'] = $ct = $v[2];
        $v = unpack("S*", substr($memData, $offset, 13 * 2));
        $dataArray['A相电压'] = number_format($v[1] / 10, 2) . ' V';
        $dataArray['B相电压'] = number_format($v[2] / 10, 2) . ' V';
        $dataArray['C相电压'] = number_format($v[3] / 10, 2) . ' V';
        $dataArray['AB相电压'] = number_format($v[4] / 10, 2) . ' V';
        $dataArray['BC相电压'] = number_format($v[5] / 10, 2) . ' V';
        $dataArray['CA相电压'] = number_format($v[6] / 10, 2) . ' V';
        $dataArray['A相电流'] = number_format($v[7] * $ct /1000, 2) . ' A';
        $dataArray['B相电流'] = number_format($v[8] * $ct /1000, 2) . ' A';
        $dataArray['C相电流'] = number_format($v[9] * $ct /1000, 2) . ' A';
        $dataArray['A相有功功率'] = number_format($v[10] * $ct, 2) . ' W';
        $dataArray['B相有功功率'] = number_format($v[11] * $ct, 2) . ' W';
        $dataArray['C相有功功率'] = number_format($v[12] * $ct, 2) . ' W';
        $dataArray['三相总有功功率'] = number_format($v[13] * $ct, 2) . ' W';

        $offset += 13 * 2;
        $v = unpack("S*", substr($memData, $offset, 10 * 2));
        $dataArray['A相无功功率'] = number_format($v[1] * $ct, 2) . ' VA';
        $dataArray['B相无功功率'] = number_format($v[2] * $ct, 2) . ' VA';
        $dataArray['C相无功功率'] = number_format($v[3] * $ct, 2) . ' VA';
        $dataArray['三相总无功功率'] = number_format($v[4] * $ct, 2) . ' VA';
        $dataArray['A相视在功率'] = number_format($v[5] * $ct, 2) . ' VA';
        $dataArray['B相视在功率'] = number_format($v[6] * $ct, 2) . ' VA';
        $dataArray['C相视在功率'] = number_format($v[7] * $ct, 2) . ' VA';
        $dataArray['三相总视在功率'] = number_format($v[8] * $ct, 2) . ' VA';
        $dataArray['功率因数'] = $v[9] . ' VA';
        $dataArray['频率'] = number_format($v[10] / 100, 2) . ' Hz';
        $offset += 10 * 2;
        $v = unpack("S*", substr($memData, $offset, 2 * 4));
        $dataArray['正向有功电能'] = number_format($v[2] * $ct, 2) . ' Wh';
        $dataArray['正向有功电能2'] = number_format($v[2] * $ct, 2);
        $dataArray['反向有功电能'] = number_format($v[1] * $ct, 2) . ' Wh';

        $offset += 2 * 4;

        $offset += 2 * 2;
        $v = unpack('v', substr($memData, $offset, 2));
        $offset += 2;
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
