<?php

function Get_unicomzytmeter_Signals($type){
    switch($type){
        case "AI":
            return array("911143200001");
        case "DI":
            return array();
        case "AO":
            return array("911643201001");
        case "DO":
            return array();
        case "ALARM":
            return array();
        default:
            return array();
    }

}

function Get_unicomzytmeter_Size()
{
    return 559;
}


function Get_unicomzytmeter_UnicomCategory()
{
    return "911";
}

function Get_unicomzytmeter_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case "[总电能]":
            return array(0, $dataArray['I主路合相有功电量kWh'], $dataArray['II主路合相有功电量kWh']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_unicomzytmeter_Active_Power($dataArray){
    return array(0 , floatval($dataArray['I主路合相有功电量kWh']) + floatval('II主路合相有功电量kWh'));

}




function Get_unicomzytmeter_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('C*',substr($memData, 4 , 52*1));
        $dataArray["I交流主路开关1QF"] = $v[1] == 1 ? "断开" : "闭合";
        $dataArray["I交流主路开关1QF脱扣"] = $v[2] == 1 ? "断开" : "闭合";
        $dataArray["II交流主路开关2QF"] = $v[3] == 1 ? "断开" : "闭合";
        $dataArray["II交流主路开关2QF脱扣"] = $v[4] == 1 ? "断开" : "闭合";
        $dataArray["I交流防雷器"] = $v[5] == 1 ? "断开" : "闭合";
        $dataArray["II交流防雷器"] = $v[6] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF1L1开关"] = $v[7] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF1L2开关"] = $v[8] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF1L3开关"] = $v[9] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF2开关"] = $v[10] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF3开关"] = $v[11] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF4开关"] = $v[12] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF5开关"] = $v[13] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF6开关"] = $v[14] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF7开关"] = $v[15] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF8开关"] = $v[16] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF9开关"] = $v[17] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF10开关"] = $v[18] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF11开关"] = $v[19] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF12开关"] = $v[20] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF13开关"] = $v[21] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF14开关"] = $v[22] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF15开关"] = $v[23] == 1 ? "断开" : "闭合";
        $dataArray["I交流支路1QF16开关"] = $v[24] == 1 ? "断开" : "闭合";


        $dataArray["II交流支路2QF1L1开关"] = $v[25] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF1L2开关"] = $v[26] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF1L3开关"] = $v[27] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF2开关"] = $v[28] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF3开关"] = $v[29] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF4开关"] = $v[30] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF5开关"] = $v[31] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF6开关"] = $v[32] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF7开关"] = $v[33] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF8开关"] = $v[34] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF9开关"] = $v[35] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF10开关"] = $v[36] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF11开关"] = $v[37] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF12开关"] = $v[38] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF13开关"] = $v[39] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF14开关"] = $v[40] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF15开关"] = $v[41] == 1 ? "断开" : "闭合";
        $dataArray["II交流支路2QF16开关"] = $v[42] == 1 ? "断开" : "闭合";

        $dataArray["交流主路过压"] = $v[43] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["交流主路过压"] = $v[43] == 1;
        $dataArray["交流主路欠压"] = $v[44] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["交流主路欠压"] = $v[44] == 1;
        $dataArray["交流主路缺相"] = $v[45] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["交流主路缺相"] = $v[45] == 1;
        $dataArray["交流主路过流"] = $v[46] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["交流主路过流"] = $v[46] == 1;
        $dataArray["交流支路越限"] = $v[47] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["交流支路越限"] = $v[47] == 1;
        $dataArray["交流开关异常"] = $v[48] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["交流开关异常"] = $v[48] == 1;
        $dataArray["交流频率超限"] = $v[49] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["交流频率超限"] = $v[49] == 1;
        $dataArray["站4通信异常"] = $v[50] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["站4通信异常"] = $v[50] == 1;
        $dataArray["站5通信异常"] = $v[51] == 1 ? "告警" : "正常";
        $dataArray['AlertArray']["站5通信异常"] = $v[51] == 1;

        $v = unpack('S*',substr($memData, 4 + 52*1,248*2));



        $dataArray['I主路A相电压V'] =  number_format($v[1] * 0.01,2);
        $dataArray['I主路B相电压V'] =  number_format($v[2] * 0.01,2);
        $dataArray['I主路C相电压V'] =  number_format($v[3] * 0.01,2);
        $dataArray['I主路合相电压V'] =  number_format($v[4] * 0.01,2);
        $dataArray['I主路A相电流A'] =  number_format($v[5] * 0.01,2);
        $dataArray['I主路B相电流A'] =  number_format($v[6] * 0.01,2);
        $dataArray['I主路C相电流A'] =  number_format($v[7] * 0.01,2);
        $dataArray['I主路合相电流A'] =  number_format($v[8] * 0.01,2);
        $dataArray['I主路A相有功功率kW'] =  number_format($v[9] * 0.01,2);
        $dataArray['I主路B相有功功率kW'] =  number_format($v[10] * 0.01,2);
        $dataArray['I主路C相有功功率kW'] =  number_format($v[11] * 0.01,2);
        $dataArray['I主路合相有功功率kW'] =  number_format($v[12] * 0.01,2);
        $dataArray['I主路A相无功功率kVar'] =  number_format($v[13] * 0.01,2);
        $dataArray['I主路B相无功功率kVar'] =  number_format($v[14] * 0.01,2);
        $dataArray['I主路C相无功功率kVar'] =  number_format($v[15] * 0.01,2);
        $dataArray['I主路合相无功功率kVar'] =  number_format($v[16] * 0.01,2);
        $dataArray['I主路A相视在功率kVA'] =  number_format($v[17] * 0.01,2);
        $dataArray['I主路B相视在功率kVA'] =  number_format($v[18] * 0.01,2);
        $dataArray['I主路C相视在功率kVA'] =  number_format($v[19] * 0.01,2);
        $dataArray['I主路合相视在功率kVA'] =  number_format($v[20] * 0.01,2);
        $dataArray['I主路A相功率因数'] =  number_format($v[21] * 0.001,2);
        $dataArray['I主路B相功率因数'] =  number_format($v[22] * 0.001,2);
        $dataArray['I主路C相功率因数'] =  number_format($v[23] * 0.001,2);
        $dataArray['I主路合相功率因数'] =  number_format($v[24] * 0.001,2);
        $dataArray['I主路频率Hz'] =  number_format($v[25] * 0.01,2);
        $dataArray['I主路A相有功电量kWh'] =  number_format((((int)$v[27] << 16) + $v[26]) * 0.01,2);
        $dataArray['I主路B相有功电量kWh'] =  number_format((((int)$v[29] << 16) + $v[28]) * 0.01,2);
        $dataArray['I主路C相有功电量kWh'] =  number_format((((int)$v[31] << 16) + $v[30]) * 0.01,2);
        $dataArray['I主路合相有功电量kWh'] =  number_format((((int)$v[33] << 16) + $v[32]) * 0.01,2);
        $dataArray['I主路A相无功电量kVarh'] =  number_format((((int)$v[35] << 16) + $v[34]) * 0.01,2);
        $dataArray['I主路B相无功电量kVarh'] =  number_format((((int)$v[37] << 16) + $v[36]) * 0.01,2);
        $dataArray['I主路C相无功电量kVarh'] =  number_format((((int)$v[39] << 16) + $v[38]) * 0.01,2);
        $dataArray['I主路合相无功电量kVarh'] =  number_format((((int)$v[41] << 16) + $v[40]) * 0.01,2);
        $dataArray['I主路AB线电压V'] =  number_format($v[42] * 0.01,2);
        $dataArray['I主路BC线电压V'] =  number_format($v[43] * 0.01,2);
        $dataArray['I主路CA线电压V'] =  number_format($v[44] * 0.01,2);
        //jump 45
        $dataArray['I零地电压V'] =  number_format($v[46] * 0.01,2);
        $dataArray['I路THD_UA'] =  number_format($v[47] * 0.01,2);
        $dataArray['I路THD_UB'] =  number_format($v[48] * 0.01,2);
        $dataArray['I路THD_UC'] =  number_format($v[49] * 0.01,2);
        $dataArray['I路THD_IA'] =  number_format($v[50] * 0.01,2);
        $dataArray['I路THD_IB'] =  number_format($v[51] * 0.01,2);
        $dataArray['I路THD_IC'] =  number_format($v[52] * 0.01,2);

        $offset = 53;
        $dataArray['II主路A相电压V'] =  number_format($v[$offset] * 0.01,2);
        $dataArray['II主路B相电压V'] =  number_format($v[$offset+1] * 0.01,2);
        $dataArray['II主路C相电压V'] =  number_format($v[$offset+2] * 0.01,2);
        $dataArray['II主路合相电压V'] =  number_format($v[$offset+3] * 0.01,2);
        $dataArray['II主路A相电流A'] =  number_format($v[$offset+4] * 0.01,2);
        $dataArray['II主路B相电流A'] =  number_format($v[$offset+5] * 0.01,2);
        $dataArray['II主路C相电流A'] =  number_format($v[$offset+6] * 0.01,2);
        $dataArray['II主路合相电流A'] =  number_format($v[$offset+7] * 0.01,2);
        $dataArray['II主路A相有功功率kW'] =  number_format($v[$offset+8] * 0.01,2);
        $dataArray['II主路B相有功功率kW'] =  number_format($v[$offset+9] * 0.01,2);
        $dataArray['II主路C相有功功率kW'] =  number_format($v[$offset+10] * 0.01,2);
        $dataArray['II主路合相有功功率kW'] =  number_format($v[$offset+11] * 0.01,2);
        $dataArray['II主路A相无功功率kVar'] =  number_format($v[$offset+12] * 0.01,2);
        $dataArray['II主路B相无功功率kVar'] =  number_format($v[$offset+13] * 0.01,2);
        $dataArray['II主路C相无功功率kVar'] =  number_format($v[$offset+14] * 0.01,2);
        $dataArray['II主路合相无功功率kVar'] =  number_format($v[$offset+15] * 0.01,2);
        $dataArray['II主路A相视在功率kVA'] =  number_format($v[$offset+16] * 0.01,2);
        $dataArray['II主路B相视在功率kVA'] =  number_format($v[$offset+17] * 0.01,2);
        $dataArray['II主路C相视在功率kVA'] =  number_format($v[$offset+18] * 0.01,2);
        $dataArray['II主路合相视在功率kVA'] =  number_format($v[$offset+19] * 0.01,2);
        $dataArray['II主路A相功率因数'] =  number_format($v[$offset+20] * 0.001,2);
        $dataArray['II主路B相功率因数'] =  number_format($v[$offset+21] * 0.001,2);
        $dataArray['II主路C相功率因数'] =  number_format($v[$offset+22] * 0.001,2);
        $dataArray['II主路合相功率因数'] =  number_format($v[$offset+23] * 0.001,2);
        $dataArray['II主路频率Hz'] =  number_format($v[$offset+24] * 0.01,2);
        $dataArray['II主路A相有功电量kWh'] =  number_format((((int)$v[$offset+26] << 16) + $v[$offset+25]) * 0.01,2);
        $dataArray['II主路B相有功电量kWh'] =  number_format((((int)$v[$offset+28] << 16) + $v[$offset+27]) * 0.01,2);
        $dataArray['II主路C相有功电量kWh'] =  number_format((((int)$v[$offset+30] << 16) + $v[$offset+29]) * 0.01,2);
        $dataArray['II主路合相有功电量kWh'] =  number_format((((int)$v[$offset+32] << 16) + $v[$offset+31]) * 0.01,2);
        $dataArray['II主路A相无功电量kVarh'] =  number_format((((int)$v[$offset+34] << 16) + $v[$offset+33]) * 0.01,2);
        $dataArray['II主路B相无功电量kVarh'] =  number_format((((int)$v[$offset+36] << 16) + $v[$offset+35]) * 0.01,2);
        $dataArray['II主路C相无功电量kVarh'] =  number_format((((int)$v[$offset+38] << 16) + $v[$offset+37]) * 0.01,2);
        $dataArray['II主路合相无功电量kVarh'] =  number_format((((int)$v[$offset+40] << 16) + $v[$offset+39]) * 0.01,2);
        $dataArray['II主路AB线电压V'] =  number_format($v[$offset+41] * 0.01,2);
        $dataArray['II主路BC线电压V'] =  number_format($v[$offset+42] * 0.01,2);
        $dataArray['II主路CA线电压V'] =  number_format($v[$offset+43] * 0.01,2);
        //jump 44
        $dataArray['II零地电压V'] =  number_format($v[$offset+45] * 0.01,2);
        $dataArray['II路THD_UA'] =  number_format($v[$offset+46] * 0.01,2);
        $dataArray['II路THD_UB'] =  number_format($v[$offset+47] * 0.01,2);
        $dataArray['II路THD_UC'] =  number_format($v[$offset+48] * 0.01,2);
        $dataArray['II路THD_IA'] =  number_format($v[$offset+49] * 0.01,2);
        $dataArray['II路THD_IB'] =  number_format($v[$offset+50] * 0.01,2);
        $dataArray['II路THD_IC'] =  number_format($v[$offset+51] * 0.01,2);

        $offset = 104 + 1;
        $dataArray['I交流支路1QF1L1_电流A'] =  number_format($v[$offset] * 0.01,2);
        $dataArray['I交流支路1QF1L2_电流A'] =  number_format($v[$offset+1] * 0.01,2);
        $dataArray['I交流支路1QF1L3_电流A'] =  number_format($v[$offset+2] * 0.01,2);
        $dataArray['I交流支路1QF2_电流A'] =  number_format($v[$offset+3] * 0.01,2);
        $dataArray['I交流支路1QF3_电流A'] =  number_format($v[$offset+4] * 0.01,2);
        $dataArray['I交流支路1QF4_电流A'] =  number_format($v[$offset+5] * 0.01,2);
        $dataArray['I交流支路1QF5_电流A'] =  number_format($v[$offset+6] * 0.01,2);
        $dataArray['I交流支路1QF6_电流A'] =  number_format($v[$offset+7] * 0.01,2);
        $dataArray['I交流支路1QF7_电流A'] =  number_format($v[$offset+8] * 0.01,2);
        $dataArray['I交流支路1QF8_电流A'] =  number_format($v[$offset+9] * 0.01,2);
        $dataArray['I交流支路1QF9_电流A'] =  number_format($v[$offset+10] * 0.01,2);
        $dataArray['I交流支路1QF10_电流A'] =  number_format($v[$offset+11] * 0.01,2);
        $dataArray['I交流支路1QF11_电流A'] =  number_format($v[$offset+12] * 0.01,2);
        $dataArray['I交流支路1QF12_电流A'] =  number_format($v[$offset+13] * 0.01,2);
        $dataArray['I交流支路1QF13_电流A'] =  number_format($v[$offset+14] * 0.01,2);
        $dataArray['I交流支路1QF14_电流A'] =  number_format($v[$offset+15] * 0.01,2);
        $dataArray['I交流支路1QF15_电流A'] =  number_format($v[$offset+16] * 0.01,2);
        $dataArray['I交流支路1QF16_电流A'] =  number_format($v[$offset+17] * 0.01,2);

        $offset = 104 + 18 + 1;

        $dataArray['II交流支路2QF1L1_电流A'] =  number_format($v[$offset] * 0.01,2);
        $dataArray['II交流支路2QF1L2_电流A'] =  number_format($v[$offset+1] * 0.01,2);
        $dataArray['II交流支路2QF1L3_电流A'] =  number_format($v[$offset+2] * 0.01,2);
        $dataArray['II交流支路2QF2_电流A'] =  number_format($v[$offset+3] * 0.01,2);
        $dataArray['II交流支路2QF3_电流A'] =  number_format($v[$offset+4] * 0.01,2);
        $dataArray['II交流支路2QF4_电流A'] =  number_format($v[$offset+5] * 0.01,2);
        $dataArray['II交流支路2QF5_电流A'] =  number_format($v[$offset+6] * 0.01,2);
        $dataArray['II交流支路2QF6_电流A'] =  number_format($v[$offset+7] * 0.01,2);
        $dataArray['II交流支路2QF7_电流A'] =  number_format($v[$offset+8] * 0.01,2);
        $dataArray['II交流支路2QF8_电流A'] =  number_format($v[$offset+9] * 0.01,2);
        $dataArray['II交流支路2QF9_电流A'] =  number_format($v[$offset+10] * 0.01,2);
        $dataArray['II交流支路2QF10_电流A'] =  number_format($v[$offset+11] * 0.01,2);
        $dataArray['II交流支路2QF11_电流A'] =  number_format($v[$offset+12] * 0.01,2);
        $dataArray['II交流支路2QF12_电流A'] =  number_format($v[$offset+13] * 0.01,2);
        $dataArray['II交流支路2QF13_电流A'] =  number_format($v[$offset+14] * 0.01,2);
        $dataArray['II交流支路2QF14_电流A'] =  number_format($v[$offset+15] * 0.01,2);
        $dataArray['II交流支路2QF15_电流A'] =  number_format($v[$offset+16] * 0.01,2);
        $dataArray['II交流支路2QF16_电流A'] =  number_format($v[$offset+17] * 0.01,2);

        $offset = 104 + 18 + 18 + 1;

        $dataArray['I交流支路1QF1L1_有功功率kW'] =  number_format($v[$offset] * 0.01,2);
        $dataArray['I交流支路1QF1L2_有功功率kW'] =  number_format($v[$offset+1] * 0.01,2);
        $dataArray['I交流支路1QF1L3_有功功率kW'] =  number_format($v[$offset+2] * 0.01,2);
        $dataArray['I交流支路1QF2_有功功率kW'] =  number_format($v[$offset+3] * 0.01,2);
        $dataArray['I交流支路1QF3_有功功率kW'] =  number_format($v[$offset+4] * 0.01,2);
        $dataArray['I交流支路1QF4_有功功率kW'] =  number_format($v[$offset+5] * 0.01,2);
        $dataArray['I交流支路1QF5_有功功率kW'] =  number_format($v[$offset+6] * 0.01,2);
        $dataArray['I交流支路1QF6_有功功率kW'] =  number_format($v[$offset+7] * 0.01,2);
        $dataArray['I交流支路1QF7_有功功率kW'] =  number_format($v[$offset+8] * 0.01,2);
        $dataArray['I交流支路1QF8_有功功率kW'] =  number_format($v[$offset+9] * 0.01,2);
        $dataArray['I交流支路1QF9_有功功率kW'] =  number_format($v[$offset+10] * 0.01,2);
        $dataArray['I交流支路1QF10_有功功率kW'] =  number_format($v[$offset+11] * 0.01,2);
        $dataArray['I交流支路1QF11_有功功率kW'] =  number_format($v[$offset+12] * 0.01,2);
        $dataArray['I交流支路1QF12_有功功率kW'] =  number_format($v[$offset+13] * 0.01,2);
        $dataArray['I交流支路1QF13_有功功率kW'] =  number_format($v[$offset+14] * 0.01,2);
        $dataArray['I交流支路1QF14_有功功率kW'] =  number_format($v[$offset+15] * 0.01,2);
        $dataArray['I交流支路1QF15_有功功率kW'] =  number_format($v[$offset+16] * 0.01,2);
        $dataArray['I交流支路1QF16_有功功率kW'] =  number_format($v[$offset+17] * 0.01,2);

        $offset = 104 + 18 + 18 + 18 + 1;

        $dataArray['II交流支路2QF1L1_有功功率kW'] =  number_format($v[$offset] * 0.01,2);
        $dataArray['II交流支路2QF1L2_有功功率kW'] =  number_format($v[$offset+1] * 0.01,2);
        $dataArray['II交流支路2QF1L3_有功功率kW'] =  number_format($v[$offset+2] * 0.01,2);
        $dataArray['II交流支路2QF2_有功功率kW'] =  number_format($v[$offset+3] * 0.01,2);
        $dataArray['II交流支路2QF3_有功功率kW'] =  number_format($v[$offset+4] * 0.01,2);
        $dataArray['II交流支路2QF4_有功功率kW'] =  number_format($v[$offset+5] * 0.01,2);
        $dataArray['II交流支路2QF5_有功功率kW'] =  number_format($v[$offset+6] * 0.01,2);
        $dataArray['II交流支路2QF6_有功功率kW'] =  number_format($v[$offset+7] * 0.01,2);
        $dataArray['II交流支路2QF7_有功功率kW'] =  number_format($v[$offset+8] * 0.01,2);
        $dataArray['II交流支路2QF8_有功功率kW'] =  number_format($v[$offset+9] * 0.01,2);
        $dataArray['II交流支路2QF9_有功功率kW'] =  number_format($v[$offset+10] * 0.01,2);
        $dataArray['II交流支路2QF10_有功功率kW'] =  number_format($v[$offset+11] * 0.01,2);
        $dataArray['II交流支路2QF11_有功功率kW'] =  number_format($v[$offset+12] * 0.01,2);
        $dataArray['II交流支路2QF12_有功功率kW'] =  number_format($v[$offset+13] * 0.01,2);
        $dataArray['II交流支路2QF13_有功功率kW'] =  number_format($v[$offset+14] * 0.01,2);
        $dataArray['II交流支路2QF14_有功功率kW'] =  number_format($v[$offset+15] * 0.01,2);
        $dataArray['II交流支路2QF15_有功功率kW'] =  number_format($v[$offset+16] * 0.01,2);
        $dataArray['II交流支路2QF16_有功功率kW'] =  number_format($v[$offset+17] * 0.01,2);

        $offset = 104 + 18 + 18 + 18 + 18 + 1;

        $dataArray['I交流支路1QF1L1_电能kWh'] =  number_format((((int)$v[$offset+1] << 16) + $v[$offset]) * 0.01,2);
        $dataArray['I交流支路1QF1L2_电能kWh'] =  number_format((((int)$v[$offset+3] << 16) + $v[$offset+2]) * 0.01,2);
        $dataArray['I交流支路1QF1L3_电能kWh'] =  number_format((((int)$v[$offset+5] << 16) + $v[$offset+4]) * 0.01,2);
        $dataArray['I交流支路1QF2_电能kWh'] =  number_format((((int)$v[$offset+7] << 16) + $v[$offset+6]) * 0.01,2);
        $dataArray['I交流支路1QF3_电能kWh'] =  number_format((((int)$v[$offset+9] << 16) + $v[$offset+8]) * 0.01,2);
        $dataArray['I交流支路1QF4_电能kWh'] =  number_format((((int)$v[$offset+11] << 16) + $v[$offset+10]) * 0.01,2);
        $dataArray['I交流支路1QF5_电能kWh'] =  number_format((((int)$v[$offset+13] << 16) + $v[$offset+12]) * 0.01,2);
        $dataArray['I交流支路1QF6_电能kWh'] =  number_format((((int)$v[$offset+15] << 16) + $v[$offset+14]) * 0.01,2);
        $dataArray['I交流支路1QF7_电能kWh'] =  number_format((((int)$v[$offset+17] << 16) + $v[$offset+16]) * 0.01,2);
        $dataArray['I交流支路1QF8_电能kWh'] =  number_format((((int)$v[$offset+19] << 16) + $v[$offset+18]) * 0.01,2);
        $dataArray['I交流支路1QF9_电能kWh'] =  number_format((((int)$v[$offset+21] << 16) + $v[$offset+20]) * 0.01,2);
        $dataArray['I交流支路1QF10_电能kWh'] =  number_format((((int)$v[$offset+23] << 16) + $v[$offset+22]) * 0.01,2);
        $dataArray['I交流支路1QF11_电能kWh'] =  number_format((((int)$v[$offset+25] << 16) + $v[$offset+24]) * 0.01,2);
        $dataArray['I交流支路1QF12_电能kWh'] =  number_format((((int)$v[$offset+27] << 16) + $v[$offset+26]) * 0.01,2);
        $dataArray['I交流支路1QF13_电能kWh'] =  number_format((((int)$v[$offset+29] << 16) + $v[$offset+28]) * 0.01,2);
        $dataArray['I交流支路1QF14_电能kWh'] =  number_format((((int)$v[$offset+31] << 16) + $v[$offset+30]) * 0.01,2);
        $dataArray['I交流支路1QF15_电能kWh'] =  number_format((((int)$v[$offset+33] << 16) + $v[$offset+32]) * 0.01,2);
        $dataArray['I交流支路1QF16_电能kWh'] =  number_format((((int)$v[$offset+35] << 16) + $v[$offset+34]) * 0.01,2);

        $offset = 104 + 18 + 18 + 18 + 18 + 36 + 1;

        $dataArray['II交流支路2QF1L1_电能kWh'] =  number_format((((int)$v[$offset+1] << 16) + $v[$offset]) * 0.01,2);
        $dataArray['II交流支路2QF1L2_电能kWh'] =  number_format((((int)$v[$offset+3] << 16) + $v[$offset+2]) * 0.01,2);
        $dataArray['II交流支路2QF1L3_电能kWh'] =  number_format((((int)$v[$offset+5] << 16) + $v[$offset+4]) * 0.01,2);
        $dataArray['II交流支路2QF2_电能kWh'] =  number_format((((int)$v[$offset+7] << 16) + $v[$offset+6]) * 0.01,2);
        $dataArray['II交流支路2QF3_电能kWh'] =  number_format((((int)$v[$offset+9] << 16) + $v[$offset+8]) * 0.01,2);
        $dataArray['II交流支路2QF4_电能kWh'] =  number_format((((int)$v[$offset+11] << 16) + $v[$offset+10]) * 0.01,2);
        $dataArray['II交流支路2QF5_电能kWh'] =  number_format((((int)$v[$offset+13] << 16) + $v[$offset+12]) * 0.01,2);
        $dataArray['II交流支路2QF6_电能kWh'] =  number_format((((int)$v[$offset+15] << 16) + $v[$offset+14]) * 0.01,2);
        $dataArray['II交流支路2QF7_电能kWh'] =  number_format((((int)$v[$offset+17] << 16) + $v[$offset+16]) * 0.01,2);
        $dataArray['II交流支路2QF8_电能kWh'] =  number_format((((int)$v[$offset+19] << 16) + $v[$offset+18]) * 0.01,2);
        $dataArray['II交流支路2QF9_电能kWh'] =  number_format((((int)$v[$offset+21] << 16) + $v[$offset+20]) * 0.01,2);
        $dataArray['II交流支路2QF10_电能kWh'] =  number_format((((int)$v[$offset+23] << 16) + $v[$offset+22]) * 0.01,2);
        $dataArray['II交流支路2QF11_电能kWh'] =  number_format((((int)$v[$offset+25] << 16) + $v[$offset+24]) * 0.01,2);
        $dataArray['II交流支路2QF12_电能kWh'] =  number_format((((int)$v[$offset+27] << 16) + $v[$offset+26]) * 0.01,2);
        $dataArray['II交流支路2QF13_电能kWh'] =  number_format((((int)$v[$offset+29] << 16) + $v[$offset+28]) * 0.01,2);
        $dataArray['II交流支路2QF14_电能kWh'] =  number_format((((int)$v[$offset+31] << 16) + $v[$offset+30]) * 0.01,2);
        $dataArray['II交流支路2QF15_电能kWh'] =  number_format((((int)$v[$offset+33] << 16) + $v[$offset+32]) * 0.01,2);
        $dataArray['II交流支路2QF16_电能kWh'] =  number_format((((int)$v[$offset+35] << 16) + $v[$offset+34]) * 0.01,2);

        $v = unpack('v', substr($memData,   4 + 52*1+248*2, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 52*1+248*2 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
