<?php
function Get_ups5000_Standard_Variable($dataArray, $varname){
   
    switch ($varname){
        case 'A相输出电流':
            return array(0, $dataArray['输出模拟信号']['A相输出电流']);
        case 'B相输出电流':
            return array(0, $dataArray['输出模拟信号']['B相输出电流']);
        case 'C相输出电流':
            return array(0, $dataArray['输出模拟信号']['C相输出电流']);
        case 'UPS主机A相输出百分比':    
            return array(0,$dataArray['输出模拟信号']['A相输出负载百分比']);
        case 'UPS主机B相输出百分比':    
            return array(0,$dataArray['输出模拟信号']['B相输出负载百分比']);
        case 'UPS主机C相输出百分比':    
            return array(0,$dataArray['输出模拟信号']['C相输出负载百分比']);
        case 'UPS主机输入相电压Ua':    
            return array(0,$dataArray['输入模拟信号']['A相输入电压']);   
        case 'UPS主机输入相电压Ub':    
            return array(0,$dataArray['输入模拟信号']['B相输入电压']);  
         case 'UPS主机输入相电压Uc':    
            return array(0,$dataArray['输入模拟信号']['C相输入电压']);
         case 'UPS主机输入线电压Uab':    
            return array(0,$dataArray['输入模拟信号']['AB输入线电压']);   
        case 'UPS主机输入线电压Ubc':    
            return array(0,$dataArray['输入模拟信号']['BC输入线电压']);  
         case 'UPS主机输入线电压Uca':    
            return array(0,$dataArray['输入模拟信号']['CA相输入线电压']);  
         case 'UPS主机输入相电流Ia':    
            return array(0,$dataArray['输入模拟信号']['A相输入电流']);   
        case 'UPS主机输入相电流Ib':    
            return array(0,$dataArray['输入模拟信号']['B相输入电流']);  
         case 'UPS主机输入相电流Ic':    
            return array(0,$dataArray['输入模拟信号']['C相输入电流']);
        case 'UPS主机A相输入功率Pa':    
            return array(0,$dataArray['输入模拟信号']['A相输入功率因数']);   
        case 'UPS主机B相输入功率Pb':    
            return array(0,$dataArray['输入模拟信号']['B相输入功率因数']);  
         case 'UPS主机C相输入功率Pc':    
            return array(0,$dataArray['输入模拟信号']['C相输入功率因数']);
        case 'UUPS主机A相输入功率Pa':    
            return array(0,$dataArray['输入模拟信号']['A相输入功率因数']);   
        case 'UPS主机B相输入功率Pb':    
            return array(0,$dataArray['输入模拟信号']['B相输入功率因数']);  
         case 'UPS主机C相输入功率Pc':    
            return array(0,$dataArray['输入模拟信号']['C相输入功率因数']);
        case 'UPS主机输入频率':    
            return array(0,$dataArray['输入模拟信号']['输入频率']);   
        case 'UPS零线环流':    
            return array(0,$dataArray['输入模拟信号']['零序电流']);  
         case 'UPS主机模块温度':    
            return array(0,$dataArray['输入模拟信号']['模块温度']);
         case 'UPS主机旁路A相电压Ua':    
            return array(0,$dataArray['旁路模拟信号']['A相旁路输入电压']);   
        case 'UPS主机旁路B相电压Ub':    
            return array(0,$dataArray['旁路模拟信号']['B相旁路输入电压']);  
         case 'UPS主机旁路C相电压Uc':    
            return array(0,$dataArray['旁路模拟信号']['C相旁路输入电压']);
        case 'UPS主机L1-L2旁路电压':    
            return array(0,$dataArray['旁路模拟信号']['AB旁路输入线电压']);   
        case 'UPS主机L2-L3旁路电压':    
            return array(0,$dataArray['旁路模拟信号']['BC旁路输入线电压']);  
         case 'UPS主机L3-L1旁路电压':    
            return array(0,$dataArray['旁路模拟信号']['CA旁路输入线电压']);
        case 'UPS主机旁路频率':    
            return array(0,$dataArray['旁路模拟信号']['旁路输入频率']);
        case 'UPS主机温度':    
            return array(0,$dataArray['旁路模拟信号']['环境温度']);

         case 'UPS主机输出相电压Ua':    
            return array(0,$dataArray['输出模拟信号']['A相输出电压']);   
        case 'UPS主机输出相电压Ub':    
            return array(0,$dataArray['输出模拟信号']['B相输出电压']);  
         case 'UPS主机输出相电压Uc':    
            return array(0,$dataArray['输出模拟信号']['C相输出电压']);
        case 'UPS主机输出线电压Uab':    
            return array(0,$dataArray['输出模拟信号']['AB输出线电压']);   
        case 'UPS主机输出线电压Ubc':    
            return array(0,$dataArray['输出模拟信号']['BC输出线电压']);  
         case 'UPS主机输出线电压Uca':    
            return array(0,$dataArray['输出模拟信号']['CA输出线电压']);
        case 'UPS主机输出相电流Ia':    
            return array(0,$dataArray['输出模拟信号']['A相输出电流']);
        case 'UPS主机输出相电流Ib':    
            return array(0,$dataArray['输出模拟信号']['B相输出电流']);
        case 'UPS主机输出相电流Ic':    
            return array(0,$dataArray['输出模拟信号']['C相输出电流']);
        case 'UPS主机输出A相视在功率Sa':    
            return array(0,$dataArray['输出模拟信号']['A相输出视在功率']);
        case 'UPS主机输出B相视在功率Sb':    
            return array(0,$dataArray['输出模拟信号']['B相输出视在功率']);
        case 'UPS主机输出C相视在功率Sc':    
            return array(0,$dataArray['输出模拟信号']['C相输出视在功率']);
         case 'UPS主机A相输出功率Pa':    
            return array(0,$dataArray['输出模拟信号']['A相输出功率因数']);
        case 'UPS主机B相输出功率Pb':    
            return array(0,$dataArray['输出模拟信号']['B相输出功率因数']);
        case 'UPS主机C相输出功率Pc':    
            return array(0,$dataArray['输出模拟信号']['C相输出功率因数']);
         case 'UPS主机输出A相视在功率Sa':    
            return array(0,$dataArray['输出模拟信号']['A相输出视在功率']);
        case 'UPS主机输出B相视在功率Sb':    
            return array(0,$dataArray['输出模拟信号']['B相输出视在功率']);
        case 'UPS主机输出C相视在功率Sc':    
            return array(0,$dataArray['输出模拟信号']['C相输出视在功率']);
         case 'UPS主机输出频率':    
            return array(0,$dataArray['输出模拟信号']['输出频率']);
         case 'UPS主机正电池电压':    
            return array(0,$dataArray['电池模拟信号']['正组电池电压']);
         case 'UPS主机负电池电压':    
            return array(0,$dataArray['电池模拟信号']['负组电池电压']);
         case 'UPS主机正电池电流':    
            return array(0,$dataArray['电池模拟信号']['正组电池电流']);
         case 'UPS主机负电池电流':    
            return array(0,$dataArray['电池模拟信号']['负组电池电流']);
         case 'UPS主机蓄电池组电压':    
            return array(0,$dataArray['电池模拟信号']['电池总电压']);
         case 'UPS主机电池电流':    
            return array(0,$dataArray['电池模拟信号']['电池总电流']);
         case 'UPS主机蓄电池温度':    
            return array(0,$dataArray['电池模拟信号']['电池温度']);
         case 'UPS主机电池剩余时间':    
            return array(0,$dataArray['电池模拟信号']['电池后备时间']);
         case 'UPS主机电池电量':    
            return array(0,$dataArray['电池模拟信号']['电池剩余容量']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}    


function Get_ups5000_RtData($memData, &$dataArray, $extraPara = false)
{
        if (empty($memData)) {
            $dataArray['更新时间'] = '无';
            $dataArray['无数据'] = true;
            $dataArray['错误'] = '数据长度不一致';
        } else {
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //输入模拟信号
            $dataArray['输入模拟信号'] = array();
            $v = unpack('S*',substr($memData, 4 , 10*2));
            $dataArray['输入模拟信号']['A相输入电压'] = ($v[1] / 10).' V';
            $dataArray['输入模拟信号']['B相输入电压'] = ($v[2] / 10).' V';
            $dataArray['输入模拟信号']['C相输入电压'] = ($v[3] / 10).' V';
            $dataArray['输入模拟信号']['AB输入线电压'] = ($v[4] / 10).' V';
            $dataArray['输入模拟信号']['BC输入线电压'] = ($v[5] / 10).' V';
            $dataArray['输入模拟信号']['CA输入线电压'] = ($v[6] / 10).' V';
            $dataArray['输入模拟信号']['A相输入电流'] = ($v[7] / 10).' A';
            $dataArray['输入模拟信号']['B相输入电流'] = ($v[8] / 10).' A';
            $dataArray['输入模拟信号']['C相输入电流'] = ($v[9] / 10).' A';
            $dataArray['输入模拟信号']['输入频率'] = ($v[10] / 100).' Hz';
            $v = unpack('s*',substr($memData, 4 + 10*2 , 3*2));
            $dataArray['输入模拟信号']['A相输入功率因数'] = ($v[1] / 100);
            $dataArray['输入模拟信号']['B相输入功率因数'] = ($v[2] / 100);
            $dataArray['输入模拟信号']['C相输入功率因数'] = ($v[3] / 100);
            $v = unpack('S*',substr($memData, 4 + 13*2 , 4*2));
            $dataArray['输入模拟信号']['正母线电压'] = ($v[1] / 10).' V';
            $dataArray['输入模拟信号']['负母线电压'] = ($v[2] / 10).' V';
            $dataArray['输入模拟信号']['零序电流'] = ($v[3] / 10).' A';
            $dataArray['输入模拟信号']['模块温度'] = ($v[4] / 10).' ℃';
            //旁路模拟信号
            $dataArray['旁路模拟信号'] = array();
            $v = unpack('S*',substr($memData, 4 + 17*2, 7*2));
            $dataArray['旁路模拟信号']['A相旁路输入电压'] = ($v[1] / 10).' V';
            $dataArray['旁路模拟信号']['B相旁路输入电压'] = ($v[2] / 10).' V';
            $dataArray['旁路模拟信号']['C相旁路输入电压'] = ($v[3] / 10).' V';
            $dataArray['旁路模拟信号']['AB旁路输入线电压'] = ($v[4] / 10).' V';
            $dataArray['旁路模拟信号']['BC旁路输入线电压'] = ($v[5] / 10).' V';
            $dataArray['旁路模拟信号']['CA旁路输入线电压'] = ($v[6] / 10).' V';
            $dataArray['旁路模拟信号']['旁路输入频率'] = ($v[7] / 100).' Hz';
            $v = unpack('s*',substr($memData, 4 + 24*2, 1*2));
            $dataArray['旁路模拟信号']['环境温度'] = ($v[1] / 10).' ℃';
            $v = unpack('S*',substr($memData, 4 + 25*2, 1*2));
            $dataArray['旁路模拟信号']['环境湿度'] = $v[1] == 65535 ? '0 %' : ($v[1] / 10).' %';
            //输出模拟信号
            $dataArray['输出模拟信号'] = array();
            $v = unpack('S*',substr($memData, 4 + 26*2, 10*2));
            $dataArray['输出模拟信号']['A相输出电压'] = ($v[1] / 10).' V';
            $dataArray['输出模拟信号']['B相输出电压'] = ($v[2] / 10).' V';
            $dataArray['输出模拟信号']['C相输出电压'] = ($v[3] / 10).' V';
            $dataArray['输出模拟信号']['AB输出线电压'] = ($v[4] / 10).' V';
            $dataArray['输出模拟信号']['BC输出线电压'] = ($v[5] / 10).' V';
            $dataArray['输出模拟信号']['CA输出线电压'] = ($v[6] / 10).' V';
            $dataArray['输出模拟信号']['A相输出电流'] = ($v[7] / 10).' A';
            $dataArray['输出模拟信号']['B相输出电流'] = ($v[8] / 10).' A';
            $dataArray['输出模拟信号']['C相输出电流'] = ($v[9] / 10).' A';
            $dataArray['输出模拟信号']['输出频率'] = ($v[10] / 100).' Hz';
            $v = unpack('s*',substr($memData, 4 + 36*2, 12*2));
            $dataArray['输出模拟信号']['A相输出有功功率'] = ($v[1] / 10).' KW';
            $dataArray['输出模拟信号']['B相输出有功功率'] = ($v[2] / 10).' KW';
            $dataArray['输出模拟信号']['C相输出有功功率'] = ($v[3] / 10).' KW';
            $dataArray['输出模拟信号']['A相输出视在功率'] = ($v[4] / 10).' KVA';
            $dataArray['输出模拟信号']['B相输出视在功率'] = ($v[5] / 10).' KVA';
            $dataArray['输出模拟信号']['C相输出视在功率'] = ($v[6] / 10).' KVA';
            $dataArray['输出模拟信号']['A相输出无功功率'] = ($v[7] / 10).' KVAR';
            $dataArray['输出模拟信号']['B相输出无功功率'] = ($v[8] / 10).' KVAR';
            $dataArray['输出模拟信号']['C相输出无功功率'] = ($v[9] / 10).' KVAR';
            $dataArray['输出模拟信号']['A相输出功率因数'] = ($v[10] / 100);
            $dataArray['输出模拟信号']['B相输出功率因数'] = ($v[11] / 100);
            $dataArray['输出模拟信号']['C相输出功率因数'] = ($v[12] / 100);
            $v = unpack('S*',substr($memData, 4 + 48*2, 6*2));
            $dataArray['输出模拟信号']['A相输出负载百分比'] = ($v[1] / 10).' %';
            $dataArray['输出模拟信号']['B相输出负载百分比'] = ($v[2] / 10).' %';
            $dataArray['输出模拟信号']['C相输出负载百分比'] = ($v[3] / 10).' %';
            $dataArray['输出模拟信号']['A相输出峰值比'] = ($v[4] / 10);
            $dataArray['输出模拟信号']['B相输出峰值比'] = ($v[5] / 10);
            $dataArray['输出模拟信号']['C相输出峰值比'] = ($v[6] / 10);
            $v = unpack('i*',substr($memData, 4 + 54*2, 4*4));
            //$dataArray['系统A相输出有功功率1'] = ($v[1] / 10).' KW';
            //$dataArray['系统B相输出有功功率1'] = ($v[2] / 10).' KW';
            //$dataArray['系统C相输出有功功率1'] = ($v[3] / 10).' KW';
            //$dataArray['系统A相输出视在功率1'] = ($v[4] / 10).' KVA';
            $v = unpack('s*',substr($memData, 4 + 54*2 + 4*4, 9*2));
            $dataArray['输出模拟信号']['系统A相输出有功功率'] = ($v[1] / 10).' KW';
            $dataArray['输出模拟信号']['系统B相输出有功功率'] = ($v[2] / 10).' KW';
            $dataArray['输出模拟信号']['系统C相输出有功功率'] = ($v[3] / 10).' KW';
            $dataArray['输出模拟信号']['系统A相输出视在功率'] = ($v[4] / 10).' KVA';
            $dataArray['输出模拟信号']['系统B相输出视在功率'] = ($v[5] / 10).' KVA';
            $dataArray['输出模拟信号']['系统C相输出视在功率'] = ($v[6] / 10).' KVA';
            $dataArray['输出模拟信号']['系统A相输出无功功率'] = ($v[7] / 10).' KVAR';
            $dataArray['输出模拟信号']['系统B相输出无功功率'] = ($v[8] / 10).' KVAR';
            $dataArray['输出模拟信号']['系统C相输出无功功率'] = ($v[9] / 10).' KVAR';
            $v = unpack('i*',substr($memData, 4 + 63*2 + 4*4, 5*4));
            //$dataArray['系统B相输出视在功率1'] = ($v[1] / 10).' KVA';
            //$dataArray['系统C相输出视在功率1'] = ($v[2] / 10).' KVA';
            //$dataArray['系统A相输出无功功率1'] = ($v[3] / 10).' KVAR';
            //$dataArray['系统B相输出无功功率1'] = ($v[4] / 10).' KVAR';
            //$dataArray['系统C相输出无功功率1'] = ($v[5] / 10).' KVAR';
            //电池模拟信号
            $dataArray['电池模拟信号'] = array();
            $v = unpack('S*',substr($memData, 4 + 63*2 + 9*4, 2*2));
            $dataArray['电池模拟信号']['正组电池电压'] = ($v[1] / 10).' V';
            $dataArray['电池模拟信号']['负组电池电压'] = ($v[2] / 10).' V';
            $v = unpack('s*',substr($memData, 4 + 65*2 + 9*4, 2*2));
            $dataArray['电池模拟信号']['正组电池电流'] = ($v[1] / 10).' A';
            $dataArray['电池模拟信号']['负组电池电流'] = ($v[2] / 10).' A';
            $v = unpack('S*',substr($memData, 4 + 67*2 + 9*4, 2*1));
            $dataArray['电池模拟信号']['电池总电压'] = ($v[1] / 10).' V';
            $v = unpack('s*',substr($memData, 4 + 68*2 + 9*4, 2*2));
            $dataArray['电池模拟信号']['电池总电流'] = ($v[1] / 10).' A';
            $dataArray['电池模拟信号']['电池温度'] = $v[2] = 32767 ? '0 ℃' : ($v[2] / 10).' ℃';
            $v = unpack('S*',substr($memData, 4 + 70*2 + 9*4, 2*2));
            $dataArray['电池模拟信号']['电池后备时间'] = $v[1].' S';
            $dataArray['电池模拟信号']['电池剩余容量'] = $v[2].' %';
            $v = unpack('i*',substr($memData, 4 + 72*2 + 9*4, 3*4));
            //$dataArray['正组电池电流'] = $v[1] == 65535 ? '0 A' : ($v[1] / 10).' A';
            //$dataArray['负组电池电流'] = $v[2] == 65535 ? '0 A' : ($v[2] / 10).' A';
            //$dataArray['电池总电流'] = $v[3] == 65535 ? '0 A' : ($v[3] / 10).' A';
            
            //系统状态
            $v = unpack('S*',substr($memData, 4 + 72*2 + 12*4, 28*2));
            //系统状态
            switch (($v[1] >> 7) & 0x7){
                case 0: $dataArray['UPS供电状态'] = '均不供电'; break;
                case 1: $dataArray['UPS供电状态'] = '旁路供电'; break;
                case 2: $dataArray['UPS供电状态'] = '市电供电'; break;
                case 3: $dataArray['UPS供电状态'] = '电池供电'; break;
                case 4: $dataArray['UPS供电状态'] = '联合供电'; break;
                default: $dataArray['UPS供电状态'] = '无效';
            }
            switch (($v[1] >> 10) & 0x7){
                case 0: $dataArray['UPS运行状态'] = '单机在线'; break;
                case 1: $dataArray['UPS运行状态'] = '并机'; break;
                case 2: $dataArray['UPS运行状态'] = '单机ECO'; break;
                case 3: $dataArray['UPS运行状态'] = '并机ECO'; break;
                case 4: $dataArray['UPS运行状态'] = '老化模式'; break;
                case 5: $dataArray['UPS运行状态'] = '变频器模式'; break;
                default: $dataArray['UPS运行状态'] = '无效';
            }
            switch (($v[1] >> 13) & 0x7){
                case 0 : $dataArray['电池运行状态'] = '未接入'; break;
                case 1 : $dataArray['电池运行状态'] = '非充非放'; break;
                case 2 : $dataArray['电池运行状态'] = '休眠'; break;
                case 3 : $dataArray['电池运行状态'] = '浮充'; break;
                case 4 : $dataArray['电池运行状态'] = '均充'; break;
                case 5 : $dataArray['电池运行状态'] = '放电'; break;
                default : $dataArray['电池运行状态'] = '无效';
            }
            //整流综合
            $dataArray['整流综合状态']  = array();
            $dataArray['整流综合状态']['整流器限功率状态'] = ($v[2] & 0x1) == 1 ? '限功率' : '未限功率';
            $dataArray['整流综合状态']['充电器限功率状态'] = (($v[2] >> 1) & 0x1) == 1 ? '限功率' : '未限功率';
            $dataArray['整流综合状态']['电池自检状态'] = (($v[2] >> 2) & 0x1) == 1 ? '自检中' : '没自检';
            if(($v[2] >> 3) & 0x3 == 0){
                $dataArray['整流综合状态']['整流侧供电状态'] = '均不供电';
            }else if(($v[2] >> 3) & 0x3 == 1){
                $dataArray['整流综合状态']['整流侧供电状态'] = '市电供电';
            }else if(($v[2] >> 3) & 0x3 == 2){
                $dataArray['整流综合状态']['整流侧供电状态'] = '电池供电';
            }else{
                $dataArray['整流综合状态']['整流侧供电状态'] = '无效';
            }
            $dataArray['整流综合状态']['市电输入告警状态'] = (($v[2] >> 5) & 0x3) == 1 ? '异常' : '正常';
            if(($v[2] >> 7) & 0x3 == 1){
                $dataArray['整流综合状态']['电池告警状态'] = '有次要告警';
            }else if(($v[2] >> 7) & 0x3 == 2){
                $dataArray['整流综合状态']['电池告警状态'] = '有紧急告警';
            }else{
                $dataArray['整流综合状态']['电池告警状态'] = '正常';
            }
            switch (($v[2] >> 9) & 0x3){
                case 1: $dataArray['整流综合状态']['整流器告警状态'] = '有次要告警'; break;
                case 2: $dataArray['整流综合状态']['整流器告警状态'] = '有紧急告警'; break;
                default : $dataArray['整流综合状态']['整流器告警状态'] = '正常';
            }
            switch (($v[2] >> 11) & 0x3){
                case 1: $dataArray['整流综合状态']['充电器告警状态'] = '有次要告警'; break;
                case 2: $dataArray['整流综合状态']['充电器告警状态'] = '有紧急告警'; break;
                default : $dataArray['整流综合状态']['充电器告警状态'] = '正常';
            }
            switch (($v[2] >> 13) & 0x3){
                case 1: $dataArray['整流综合状态']['放电器告警状态'] = '有次要告警'; break;
                case 2: $dataArray['整流综合状态']['放电器告警状态'] = '有紧急告警'; break;
                default : $dataArray['整流综合状态']['放电器告警状态'] = '正常';
            }
            
            switch ($v[3] & 0x3){
                case 0: $dataArray['整流综合状态']['整流器工作状态'] = '停止'; break;
                case 1: $dataArray['整流综合状态']['整流器工作状态'] = 'SCR软启动'; break;
                case 2: $dataArray['整流综合状态']['整流器工作状态'] = 'AC-BOOST软启动'; break;
                default: $dataArray['整流综合状态']['整流器工作状态'] = '正常运行';
            }
            $dataArray['整流综合状态']['整流器休眠状态'] = (($v[3] >> 2) & 0x1) == 1 ? '休眠' : '未休眠';
            switch (($v[3] >> 3) & 0x3){
                case 0: $dataArray['整流综合状态']['充电器工作状态'] = '停止'; break;
                case 1: $dataArray['整流综合状态']['充电器工作状态'] = '软启动'; break;
                case 2: $dataArray['整流综合状态']['充电器工作状态'] = '正常运行'; break;
                default: $dataArray['整流综合状态']['充电器工作状态'] = '无效';
            }
            switch (($v[3] >> 5) & 0x3){
                case 0: $dataArray['整流综合状态']['放电器工作状态'] = '停止'; break;
                case 1: $dataArray['整流综合状态']['放电器工作状态'] = '电池冷启动'; break;
                case 2: $dataArray['整流综合状态']['放电器工作状态'] = 'DC-BOOST软启动'; break;
                default: $dataArray['整流综合状态']['放电器工作状态'] = '正常运行';
            }
            //逆变综合
            $dataArray['逆变综合状态'] = array();
            $dataArray['逆变综合状态']['逆变器休眠状态'] = $v[4] & 0x1 == 1 ? '休眠' : '未休眠';
            $dataArray['逆变综合状态']['降额运行'] = ($v[4] >> 1) & 0x1 == 1 ? '降额' : '未降额';
            $dataArray['逆变综合状态']['开机允许状态'] = ($v[4] >> 2) & 0x1 == 1 ? '允许' : '不允许';
            switch (($v[4] >> 3) & 0x3){
                case 0: $dataArray['逆变综合状态']['逆变侧供电状态'] = '均不供电'; break;
                case 1: $dataArray['逆变综合状态']['逆变侧供电状态'] = '旁路供电'; break;
                case 2: $dataArray['逆变综合状态']['逆变侧供电状态'] = '逆变供电'; break;
                default: $dataArray['逆变综合状态']['逆变侧供电状态'] = '无效';
            }
            $dataArray['逆变综合状态']['自老化状态']  = (($v[4] >> 5) & 0x1) == 1 ? '自老化' : '非自老化';
            switch (($v[4] >> 6) & 0x3){
                case 1: $dataArray['逆变综合状态']['逆变器告警状态'] = '有次要告警'; break;
                case 2: $dataArray['逆变综合状态']['逆变器告警状态'] = '有紧急告警'; break;
                default : $dataArray['逆变综合状态']['逆变器告警状态'] = '正常';
            }
            switch (($v[4] >> 8) & 0x3){
                case 0: $dataArray['逆变综合状态']['逆变器工作状态'] = '停止'; break;
                case 1: $dataArray['逆变综合状态']['逆变器工作状态'] = '软启动'; break;
                default : $dataArray['逆变综合状态']['逆变器工作状态'] = '正常运行';
            }
            $dataArray['逆变综合状态']['逆变器自检状态'] = (($v[4] >> 10) & 0x1) == 1 ? '自检中' : '未自检';
            $dataArray['逆变综合状态']['逆变继电器状态'] = (($v[4] >> 11) & 0x1) == 1 ? '闭合' : '断开';
            $dataArray['逆变综合状态']['输出电压谐波含量状态'] = (($v[4] >> 12) & 0x1) == 1 ? '偏大' : '正常';
            //旁路
            $dataArray['旁路状态'] = array();
            $dataArray['旁路状态']['维修空开闭合'] = ($v[5] & 0x1) == 1 ? '闭合' : '断开';
            $dataArray['旁路状态']['配电柜旁路输入闭合'] = (($v[5] >> 1) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['旁路状态']['配电柜市电输入闭合'] = (($v[5] >> 2) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['旁路状态']['配电柜输出空开闭合'] = (($v[5] >> 3) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['旁路状态']['配电柜维修空开闭合'] = (($v[5] >> 4) & 0x1) == 1 ? '闭合' : '断开';
            $dataArray['旁路状态']['市电输入空开闭合'] = (($v[5] >> 5) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['旁路状态']['旁路输入空开闭合'] = (($v[5] >> 6) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['旁路状态']['输出空开闭合'] = (($v[5] >> 7) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['旁路状态']['旁路告警状态'] = (($v[5] >> 8) & 0x3) == 1 ? '异常' : '正常';
            $dataArray['旁路状态']['旁路通讯失败'] = (($v[5] >> 10) & 0x1) == 1 ? '通讯失败' : '正常';
            $dataArray['旁路状态']['旁路配置失败'] = (($v[5] >> 11) & 0x1) == 1 ? '配置失败' : '正常';
            $dataArray['旁路状态']['旁路供电状态'] = (($v[5] >> 13) & 0x1) == 1 ? '旁路供电' : '非旁路供电';
            $dataArray['旁路状态']['旁路接管状态'] = (($v[5] >> 14) & 0x1) == 1 ? '旁路被接管' : '旁路未被接管';
            //电池
            $dataArray['电池状态'] = array();
            $dataArray['电池状态']['强制均充'] = ($v[6] & 0x1) == 1 ? '强制均充' : '未强制均充';
            $dataArray['电池状态']['浅放电测试'] = (($v[6] >> 1) & 0x1) == 1 ? '测试中' : '未测试';
            $dataArray['电池状态']['周期浅放电测试'] = (($v[6] >> 2) & 0x1) == 1 ? '测试中' : '未测试';
            $dataArray['电池状态']['核对性容量测试'] = (($v[6] >> 3) & 0x1) == 1 ? '测试中' : '未测试';
            //ECU综合
            $dataArray['ECU综合状态'] = array();
            $dataArray['ECU综合状态']['维修空开状态'] = ($v[7] & 0x1) == 1 ? '闭合' : '断开';
            $dataArray['ECU综合状态']['配电柜旁路输入空开状态'] = (($v[7] >> 1) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['ECU综合状态']['配电柜市电输入空开状态'] = (($v[7] >> 2) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['ECU综合状态']['配电柜输出空开状态'] = (($v[7] >> 3) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['ECU综合状态']['配电柜维修空开状态'] = (($v[7] >> 4) & 0x1) == 1 ? '闭合' : '断开';
            $dataArray['ECU综合状态']['市电输入空开状态'] = (($v[7] >> 5) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['ECU综合状态']['旁路输入空开状态'] = (($v[7] >> 6) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['ECU综合状态']['输出空开状态'] = (($v[7] >> 7) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['ECU综合状态']['电池空开状态'] = (($v[7] >> 8) & 0x1) == 1 ? '断开' : '闭合';
            $dataArray['ECU综合状态']['发电机接入'] = (($v[7] >> 10) & 0x1) == 1 ? '接入' : '断开';
            switch(($v[7] >> 11) & 0x7){
                case 0: $dataArray['ECU综合状态']['切换提示'] = '无提示'; break;
                case 1: $dataArray['ECU综合状态']['切换提示'] = '关机导致系统过载'; break;
                case 2: $dataArray['ECU综合状态']['切换提示'] = '关机导致系统切旁路'; break;
                case 3: $dataArray['ECU综合状态']['切换提示'] = '关机导致系统间断切旁路'; break;
                case 4: $dataArray['ECU综合状态']['切换提示'] = '关机导致系统掉电'; break;
                default : $dataArray['ECU综合状态']['切换提示'] = '无效';
            }
            switch(($v[7] >> 14) & 0x3){
                case 0: $dataArray['ECU综合状态']['BCB状态'] = '未接入'; break;
                case 1: $dataArray['ECU综合状态']['BCB状态'] = '闭合'; break;
                case 2: $dataArray['ECU综合状态']['BCB状态'] = '断开'; break;
                default: $dataArray['ECU综合状态']['BCB状态'] = '无效';
            }
            switch($v[8] & 0xF){
                case 0: $dataArray['ECU综合状态']['切换方式']  = '无切换'; break;
                case 1: $dataArray['ECU综合状态']['切换方式']  = '无输出切旁路'; break;
                case 2: $dataArray['ECU综合状态']['切换方式']  = '无输出切INV'; break;
                case 3: $dataArray['ECU综合状态']['切换方式']  = '旁路切无输出'; break;
                case 4: $dataArray['ECU综合状态']['切换方式']  = 'INV切无输出'; break;
                case 5: $dataArray['ECU综合状态']['切换方式']  = 'INV无间断切旁路'; break;
                case 6: $dataArray['ECU综合状态']['切换方式']  = '旁路无间断切INV'; break;
                case 7: $dataArray['ECU综合状态']['切换方式']  = 'INV间断切旁路'; break;
                case 8: $dataArray['ECU综合状态']['切换方式']  = '旁路间断切INV'; break;
                default : $dataArray['ECU综合状态']['切换方式']  = '无效';
            }
            switch(($v[8] >> 4) & 0x3){
                case 0: $dataArray['ECU综合状态']['机架供电状态'] = '均不供电'; break;
                case 1: $dataArray['ECU综合状态']['机架供电状态'] = '旁路供电'; break;
                case 2: $dataArray['ECU综合状态']['机架供电状态'] = '逆变供电'; break;
                default: $dataArray['ECU综合状态']['机架供电状态'] = '无效';
            }
            $dataArray['ECU综合状态']['机架供电模块个数'] = (($v[8] >> 6) & 0xF).' 个';
            $dataArray['ECU综合状态']['集中控制器身份'] = (($v[8] >> 10) & 0x1) == 1 ? '机架主机' : '从机';
            $dataArray['ECU综合状态']['集中控制器系统身份'] = (($v[8] >> 11) & 0x1) == 1 ? '系统主机' : '从机';
            switch(($v[8] >> 12) & 0x3){
                case 1: $dataArray['ECU综合状态']['ECM告警状态'] = '有次要告警'; break;
                case 2: $dataArray['ECU综合状态']['ECM告警状态'] = '有紧急告警'; break;
                default: $dataArray['ECU综合状态']['ECM告警状态'] = '正常';
            }
            $dataArray['ECU综合状态']['旁路输入告警状态'] = ($v[8] >> 14) & 0x3 == 1 ? '异常' : '正常';
            switch($v[9] & 0x3){
                case 1: $dataArray['ECU综合状态']['旁路单元告警状态'] = '有次要告警'; break;
                case 2: $dataArray['ECU综合状态']['旁路单元告警状态'] = '有紧急告警'; break;
                default: $dataArray['ECU综合状态']['旁路单元告警状态'] = '正常';
            }
            $dataArray['ECU综合状态']['输出允许状态'] = ($v[9] >> 2) & 0x1 == 1 ? '允许' : '禁止输出';
            $dataArray['ECU综合状态']['输出状态'] = ($v[9] >> 3) & 0x1 == 1 ? '有输出' : '无输出';
            switch(($v[9] >> 4) & 0x3){
                case 0: $dataArray['ECU综合状态']['系统供电状态'] = '均不供电'; break;
                case 1: $dataArray['ECU综合状态']['系统供电状态'] = '旁路供电'; break;
                case 2: $dataArray['ECU综合状态']['系统供电状态'] = '逆变供电'; break;
                default: $dataArray['ECU综合状态']['系统供电状态'] = '无效';
            }
            switch(($v[9] >> 7) & 0x3){
                case 0: $dataArray['ECU综合状态']['BSC系统状态'] = '未激活'; break;
                case 1: $dataArray['ECU综合状态']['BSC系统状态'] = 'BSC主系统'; break;
                case 2: $dataArray['ECU综合状态']['BSC系统状态'] = 'BSC从系统'; break;
                default: $dataArray['ECU综合状态']['BSC系统状态'] = '无效';
            }
            $dataArray['ECU综合状态']['系统逆变开启容量不足'] = ($v[9] >> 9) & 0x1 == 1 ? '容量不足' : '容量足';
            //系统告警
            //40153
            $dataArray['机架数目不符'] = ($v[10] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['模块数目不符1'] = (($v[10] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['模块数目不符2'] = (($v[10] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池巡检仪数目不符1'] = (($v[10] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['MUE07A板通讯失败1'] = (($v[10] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池温度传感器通讯失败1'] = (($v[10] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池温度传感器通讯失败2'] = (($v[10] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池温度传感器通讯失败3'] = (($v[10] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池温度传感器通讯失败4'] = (($v[10] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['环境传感器通讯失败1'] = (($v[10] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['环境传感器通讯失败2'] = (($v[10] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['环境传感器通讯失败3'] = (($v[10] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['环境传感器通讯失败4'] = (($v[10] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池温度传感器数目不符'] = (($v[10] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['环境传感器数目不符'] = (($v[10] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['NTC失效'] = (($v[10] >> 15) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['机架数目不符'] = ($v[10] & 0x1) == 1;
            $dataArray['AlertArray']['模块数目不符1'] = (($v[10] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['模块数目不符2'] = (($v[10] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['电池巡检仪数目不符1'] = (($v[10] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['MUE07A板通讯失败1'] = (($v[10] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['电池温度传感器通讯失败1'] = (($v[10] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['电池温度传感器通讯失败2'] = (($v[10] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['电池温度传感器通讯失败3'] = (($v[10] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['电池温度传感器通讯失败4'] = (($v[10] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['环境传感器通讯失败1'] = (($v[10] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['环境传感器通讯失败2'] = (($v[10] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['环境传感器通讯失败3'] = (($v[10] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['环境传感器通讯失败4'] = (($v[10] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['电池温度传感器数目不符'] = (($v[10] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['环境传感器数目不符'] = (($v[10] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['NTC失效'] = (($v[10] >> 15) & 0x1) == 1;
            //40154
            $dataArray['发电机接入'] = (($v[11] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['发电机启动失败'] = (($v[11] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['发电机关闭失败'] = (($v[11] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ATS故障'] = (($v[11] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['功率单元数目不符1'] = (($v[11] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['功率单元数目不符2'] = (($v[11] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机型参数读取失败'] = (($v[11] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['DRYB通讯失败1'] = (($v[11] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['BCB断开异常'] = (($v[11] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['发电机接入'] = (($v[11] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['发电机启动失败'] = (($v[11] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['发电机关闭失败'] = (($v[11] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['ATS故障'] = (($v[11] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['功率单元数目不符1'] = (($v[11] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['功率单元数目不符2'] = (($v[11] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['机型参数读取失败'] = (($v[11] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['DRYB通讯失败1'] = (($v[11] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['BCB断开异常1'] = (($v[11] >> 9) & 0x1) == 1;
            //40167
            $dataArray['机架1通讯失败'] = ($v[12] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架2通讯失败'] = (($v[12] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架3通讯失败'] = (($v[12] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架4通讯失败'] = (($v[12] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架5通讯失败'] = (($v[12] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架6通讯失败'] = (($v[12] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架1主机冲突'] = (($v[12] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架2主机冲突'] = (($v[12] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架3主机冲突'] = (($v[12] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架4主机冲突'] = (($v[12] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架5主机冲突'] = (($v[12] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架6主机冲突'] = (($v[12] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['机架地址冲突1'] = (($v[12] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['参数不一致1'] = (($v[12] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['版本不兼容41'] = (($v[12] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['软件包不存在1'] = (($v[12] >> 15) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['机架1通讯失败'] = ($v[12] & 0x1) == 1;
            $dataArray['AlertArray']['机架2通讯失败'] = (($v[12] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['机架3通讯失败'] = (($v[12] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['机架4通讯失败'] = (($v[12] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['机架5通讯失败'] = (($v[12] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['机架6通讯失败'] = (($v[12] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['机架1主机冲突'] = (($v[12] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['机架2主机冲突'] = (($v[12] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['机架3主机冲突'] = (($v[12] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['机架4主机冲突'] = (($v[12] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['机架5主机冲突'] = (($v[12] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['机架6主机冲突'] = (($v[12] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['机架地址冲突1'] = (($v[12] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['参数不一致1'] = (($v[12] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['版本不兼容41'] = (($v[12] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['软件包不存在1'] = (($v[12] >> 15) & 0x1) == 1;
            //整流综合告警
            $dataArray['整流综合告警'] = array();
            //40155
            $dataArray['整流综合告警']['整流器告警1'] = ($v[13] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器告警2'] = (($v[13] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['充电器告警1'] = (($v[13] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['充电器告警2'] = (($v[13] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['充电器告警3'] = (($v[13] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['充电器告警4'] = (($v[13] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['充电器告警5'] = (($v[13] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['充电器告警6'] = (($v[13] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['充电器告警7'] = (($v[13] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['充电器告警8'] = (($v[13] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['主路电压异常1'] = (($v[13] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['主路欠压1'] = (($v[13] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['主路电压异常2'] = (($v[13] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['主路电压异常3'] = (($v[13] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['主路相序反'] = (($v[13] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['主路零线缺失'] = (($v[13] >> 15) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['整流综合告警']['整流器告警1'] = ($v[13] & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器告警2'] = (($v[13] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['充电器告警1'] = (($v[13] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['充电器告警2'] = (($v[13] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['充电器告警3'] = (($v[13] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['充电器告警4'] = (($v[13] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['充电器告警5'] = (($v[13] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['充电器告警6'] = (($v[13] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['充电器告警7'] = (($v[13] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['充电器告警8'] = (($v[13] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['主路电压异常1'] = (($v[13] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['主路欠压1'] = (($v[13] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['主路电压异常2'] = (($v[13] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['主路电压异常3'] = (($v[13] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['主路相序反'] = (($v[13] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['主路零线缺失'] = (($v[13] >> 15) & 0x1) == 1;
            //40169
            $dataArray['整流综合告警']['整流器异常1'] = ($v[14] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常2'] = (($v[14] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常3'] = (($v[14] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常4'] = (($v[14] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常5'] = (($v[14] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常6'] = (($v[14] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常7'] = (($v[14] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常8'] = (($v[14] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常9'] = (($v[14] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['整流器异常10'] = (($v[14] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['放电器异常1'] = (($v[14] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['放电器异常2'] = (($v[14] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['放电器异常3'] = (($v[14] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['内部故障1'] = (($v[14] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['内部故障2'] = (($v[14] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['版本不兼容1'] = (($v[14] >> 15) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['整流综合告警']['整流器异常1'] = ($v[14] & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常2'] = (($v[14] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常3'] = (($v[14] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常4'] = (($v[14] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常5'] = (($v[14] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常6'] = (($v[14] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常7'] = (($v[14] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常8'] = (($v[14] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常9'] = (($v[14] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['整流器异常10'] = (($v[14] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['放电器异常1'] = (($v[14] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['放电器异常2'] = (($v[14] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['放电器异常3'] = (($v[14] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['内部故障1'] = (($v[14] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['内部故障2'] = (($v[14] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['整流综合告警']['版本不兼容1'] = (($v[14] >> 15) & 0x1) == 1;
            //40170
            $dataArray['整流综合告警']['版本不兼容2'] = ($v[15] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['版本不兼容3'] = (($v[15] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['电池接反'] = (($v[15] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['电池欠压'] = (($v[15] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['电池未接'] = (($v[15] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['风扇异常1'] = (($v[15] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['未就绪1'] = (($v[15] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['市电电池切换次数异常'] = (($v[15] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['电池过压保护'] = (($v[15] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['版本不兼容21'] = (($v[15] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['整流综合告警']['内部故障14'] = (($v[15] >> 15) & 0x1) == 1 ? '告警' : '正常';
            //逆变综合告警
            $dataArray['逆变综合告警'] = array();
            //40158
            $dataArray['逆变综合告警']['逆变器告警1'] = ($v[16] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警2'] = (($v[16] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警3'] = (($v[16] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警4'] = (($v[16] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['负载冲击转旁路1'] = (($v[16] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线告警1'] = (($v[16] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线告警2'] = (($v[16] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线告警3'] = (($v[16] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线告警4'] = (($v[16] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警6'] = (($v[16] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警7'] = (($v[16] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警8'] = (($v[16] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警5'] = (($v[16] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警1'] = ($v[16] & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警2'] = (($v[16] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警3'] = (($v[16] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警4'] = (($v[16] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['负载冲击转旁路1'] = (($v[16] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线告警1'] = (($v[16] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线告警2'] = (($v[16] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线告警3'] = (($v[16] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线告警4'] = (($v[16] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警6'] = (($v[16] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警7'] = (($v[16] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警8'] = (($v[16] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警5'] = (($v[16] >> 13) & 0x1) == 1;
            //40172
            $dataArray['逆变综合告警']['逆变器异常1'] = ($v[17] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常2'] = (($v[17] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常3'] = (($v[17] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常4'] = (($v[17] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常5'] = (($v[17] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常6'] = (($v[17] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常7'] = (($v[17] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常8'] = (($v[17] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常9'] = (($v[17] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线异常1'] = (($v[17] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线异常2'] = (($v[17] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线异常3'] = (($v[17] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线异常4'] = (($v[17] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['机架内并机线异常5'] = (($v[17] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['内部故障3'] = (($v[17] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['内部故障4'] = (($v[17] >> 15) & 0x1) == 1 ? '告警' : '正常';  
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常1'] = ($v[17] & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常2'] = (($v[17] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常3'] = (($v[17] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常4'] = (($v[17] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常5'] = (($v[17] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常6'] = (($v[17] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常7'] = (($v[17] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常8'] = (($v[17] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常9'] = (($v[17] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线异常1'] = (($v[17] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线异常2'] = (($v[17] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线异常3'] = (($v[17] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线异常4'] = (($v[17] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['机架内并机线异常5'] = (($v[17] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['内部故障3'] = (($v[17] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['内部故障4'] = (($v[17] >> 15) & 0x1) == 1;
            //40173
            $dataArray['逆变综合告警']['版本不兼容4'] = ($v[18] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['版本不兼容5'] = (($v[18] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['版本不兼容6'] = (($v[18] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['过载超时1'] = (($v[18] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['输出过载1'] = (($v[18] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['版本不兼容22'] = (($v[18] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常10'] = (($v[18] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常11'] = (($v[18] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器自检异常1'] = (($v[18] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器自检异常2'] = (($v[18] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器自检异常3'] = (($v[18] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器自检异常4'] = (($v[18] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器异常23'] = (($v[18] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警9'] = (($v[18] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['逆变综合告警']['逆变器告警10'] = (($v[18] >> 15) & 0x1) == 1 ? '告警' : '正常';
            
            $dataArray['AlertArray']['逆变综合告警']['版本不兼容4'] = ($v[18] & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['版本不兼容5'] = (($v[18] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['版本不兼容6'] = (($v[18] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['过载超时1'] = (($v[18] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['输出过载1'] = (($v[18] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['版本不兼容22'] = (($v[18] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常10'] = (($v[18] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常11'] = (($v[18] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器自检异常1'] = (($v[18] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器自检异常2'] = (($v[18] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器自检异常3'] = (($v[18] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器自检异常4'] = (($v[18] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器异常23'] = (($v[18] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警9'] = (($v[18] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['逆变综合告警']['逆变器告警10'] = (($v[18] >> 15) & 0x1) == 1;
            //旁路告警
            $dataArray['旁路告警'] = array();
            //40161
            $dataArray['旁路告警']['机架内并机线告警5'] = ($v[19] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['旁路电压异常1'] = (($v[19] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['旁路电压异常2'] = (($v[19] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['旁路相序反'] = (($v[19] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['旁路告警']['机架内并机线告警5'] = ($v[19] & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['旁路电压异常1'] = (($v[19] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['旁路电压异常2'] = (($v[19] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['旁路相序反'] = (($v[19] >> 3) & 0x1) == 1;
            //40176
            $dataArray['旁路告警']['旁路单元异常4'] = ($v[20] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['旁路单元异常5'] = (($v[20] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['机架内并机线异常6'] = (($v[20] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['内部故障5'] = (($v[20] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['内部故障6'] = (($v[20] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['版本不兼容7'] = (($v[20] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['版本不兼容8'] = (($v[20] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['版本不兼容9'] = (($v[20] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['未就绪2'] = (($v[20] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['风扇异常2'] = (($v[20] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['版本不兼容17'] = (($v[20] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['版本不兼容18'] = (($v[20] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['版本不兼容23'] = (($v[20] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['版本不兼容29'] = (($v[20] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['版本不兼容30'] = (($v[20] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['旁路单元告警1'] = (($v[20] >> 15) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['旁路告警']['旁路单元异常4'] = ($v[20] & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['旁路单元异常5'] = (($v[20] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['机架内并机线异常6'] = (($v[20] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['内部故障5'] = (($v[20] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['内部故障6'] = (($v[20] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['版本不兼容7'] = (($v[20] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['版本不兼容8'] = (($v[20] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['版本不兼容9'] = (($v[20] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['未就绪2'] = (($v[20] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['风扇异常2'] = (($v[20] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['版本不兼容17'] = (($v[20] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['版本不兼容18'] = (($v[20] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['版本不兼容23'] = (($v[20] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['版本不兼容29'] = (($v[20] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['版本不兼容30'] = (($v[20] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['旁路单元告警1'] = (($v[20] >> 15) & 0x1) == 1;
            //40177
            $dataArray['旁路告警']['机架内并机线异常14'] = ($v[21] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['旁路告警']['机架内并机线异常12'] = (($v[21] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['旁路告警']['机架内并机线异常14'] = ($v[21] & 0x1) == 1;
            $dataArray['AlertArray']['旁路告警']['机架内并机线异常12'] = (($v[21] >> 1) & 0x1) == 1;
            //电池告警
            $dataArray['电池告警'] = array();
            //40163
            $dataArray['电池告警']['电池过温'] = ($v[22] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池告警']['电池低温'] = (($v[22] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池告警']['电池过压'] = (($v[22] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池告警']['电池充电过流'] = (($v[22] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池告警']['电池剩余备电时间预告警'] = (($v[22] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池告警']['电池剩余容量预告警'] = (($v[22] >> 7) & 0x1) == 1 ? '告警' : '正常'; 
            $dataArray['AlertArray']['电池告警']['电池过温'] = ($v[22] & 0x1) == 1;
            $dataArray['AlertArray']['电池告警']['电池低温'] = (($v[22] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['电池告警']['电池过压'] = (($v[22] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['电池告警']['电池充电过流'] = (($v[22] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['电池告警']['电池剩余备电时间预告警'] = (($v[22] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['电池告警']['电池剩余容量预告警'] = (($v[22] >> 7) & 0x1) == 1;
            //40179
            $dataArray['电池告警']['电池电压低1'] = ($v[23] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池告警']['电池放电终止1'] = (($v[23] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池告警']['电池放电终止2'] = (($v[23] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['电池告警']['电池过温保护1'] = (($v[23] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['电池告警']['电池电压低1'] = ($v[23] & 0x1) == 1;
            $dataArray['AlertArray']['电池告警']['电池放电终止1'] = (($v[23] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['电池告警']['电池放电终止2'] = (($v[23] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['电池告警']['电池过温保护1'] = (($v[23] >> 3) & 0x1) == 1;
            //ECU综合告警
            $dataArray['ECU综合告警'] = array();
            //40165
            $dataArray['ECU综合告警']['ECM告警1'] = ($v[24] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['邻机旁路单元告警1'] = (($v[24] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路切换次数限制1'] = (($v[24] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['邻机请求转旁路1'] = (($v[24] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['ECM1异常'] = (($v[24] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['ECM2异常'] = (($v[24] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路零线缺失'] = (($v[24] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路电压异常1'] = (($v[24] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路相序反'] = (($v[24] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['输入防雷器告警1'] = (($v[24] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['输出防雷器告警1'] = (($v[24] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路电压异常2'] = (($v[24] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线告警6'] = (($v[24] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['ECO电压异常1'] = (($v[24] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线告警9'] = (($v[24] >> 15) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['ECU综合告警']['ECM告警1'] = ($v[24] & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['邻机旁路单元告警1'] = (($v[24] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路切换次数限制1'] = (($v[24] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['邻机请求转旁路1'] = (($v[24] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['ECM1异常'] = (($v[24] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['ECM2异常'] = (($v[24] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路零线缺失'] = (($v[24] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路电压异常1'] = (($v[24] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路相序反'] = (($v[24] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['输入防雷器告警1'] = (($v[24] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['输出防雷器告警1'] = (($v[24] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路电压异常2'] = (($v[24] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线告警6'] = (($v[24] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['ECO电压异常1'] = (($v[24] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线告警9'] = (($v[24] >> 15) & 0x1) == 1;
            //40166
            $dataArray['ECU综合告警']['机架内并机线告警10'] = ($v[25] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线告警11'] = (($v[25] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线告警1'] = (($v[25] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线告警2'] = (($v[25] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线告警3'] = (($v[25] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线告警4'] = (($v[25] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['系统机架冗余不足'] = (($v[25] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架模块冗余不足'] = (($v[25] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路不均流1'] = (($v[25] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['逆变器不同步1'] = (($v[25] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['ECM告警2'] = (($v[25] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线告警10'] = ($v[25] & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线告警11'] = (($v[25] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线告警1'] = (($v[25] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线告警2'] = (($v[25] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线告警3'] = (($v[25] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线告警4'] = (($v[25] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['系统机架冗余不足'] = (($v[25] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架模块冗余不足'] = (($v[25] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路不均流1'] = (($v[25] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['逆变器不同步1'] = (($v[25] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['ECM告警2'] = (($v[25] >> 11) & 0x1) == 1;
            //40181
            $dataArray['ECU综合告警']['ECM异常1'] = (($v[26] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['ECM异常2'] = (($v[26] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线异常7'] = (($v[26] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['邻机请求转逆变'] = (($v[26] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['邻机请求转无输出'] = (($v[26] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线异常10'] = (($v[26] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线异常11'] = (($v[26] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线异常12'] = (($v[26] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架内并机线异常13'] = (($v[26] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架间并机线异常1'] = (($v[26] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架间并机线异常2'] = (($v[26] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架间并机线异常3'] = (($v[26] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架间并机线异常4'] = (($v[26] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架间并机线异常5'] = (($v[26] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架间并机线异常6'] = (($v[26] >> 15) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['ECU综合告警']['ECM异常1'] = (($v[26] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['ECM异常2'] = (($v[26] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线异常7'] = (($v[26] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['邻机请求转逆变'] = (($v[26] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['邻机请求转无输出'] = (($v[26] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线异常10'] = (($v[26] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线异常11'] = (($v[26] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线异常12'] = (($v[26] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架内并机线异常13'] = (($v[26] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架间并机线异常1'] = (($v[26] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架间并机线异常2'] = (($v[26] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架间并机线异常3'] = (($v[26] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架间并机线异常4'] = (($v[26] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架间并机线异常5'] = (($v[26] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架间并机线异常6'] = (($v[26] >> 15) & 0x1) == 1;
            //40182
            $dataArray['ECU综合告警']['旁路单元异常1'] = ($v[27] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路单元异常2'] = (($v[27] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路单元异常3'] = (($v[27] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['内部故障7'] = (($v[27] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['版本不兼容12'] = (($v[27] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['紧急关机1'] = (($v[27] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路并机相序不一致'] = (($v[27] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['电池接地故障1'] = (($v[27] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['版本不兼容10'] = (($v[27] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['版本不兼容11'] = (($v[27] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['内部故障8'] = (($v[27] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['干接点板故障1'] = (($v[27] >> 11) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['干接点板故障2'] = (($v[27] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['干接点板12V欠压1'] = (($v[27] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['干接点板12V欠压2'] = (($v[27] >> 14) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['BSC信号异常1'] = (($v[27] >> 15) & 0x1) == 1 ? '告警' : '正常';           
            $dataArray['AlertArray']['ECU综合告警']['旁路单元异常1'] = ($v[27] & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路单元异常2'] = (($v[27] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路单元异常3'] = (($v[27] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['内部故障7'] = (($v[27] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['版本不兼容12'] = (($v[27] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['紧急关机1'] = (($v[27] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路并机相序不一致'] = (($v[27] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['电池接地故障1'] = (($v[27] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['版本不兼容10'] = (($v[27] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['版本不兼容11'] = (($v[27] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['内部故障8'] = (($v[27] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['干接点板故障1'] = (($v[27] >> 11) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['干接点板故障2'] = (($v[27] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['干接点板12V欠压1'] = (($v[27] >> 13) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['干接点板12V欠压2'] = (($v[27] >> 14) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['BSC信号异常1'] = (($v[27] >> 15) & 0x1) == 1;
            //40183
            $dataArray['ECU综合告警']['维修空开误操作1'] = ($v[28] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['机架输出过载1'] = (($v[28] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路过流'] = (($v[28] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['风扇异常3'] = (($v[28] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['风扇异常4'] = (($v[28] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['风扇异常5'] = (($v[28] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['风扇异常2'] = (($v[28] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['内部故障6'] = (($v[28] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路单元异常4'] = (($v[28] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['旁路单元异常6'] = (($v[28] >> 9) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['BCB故障1'] = (($v[28] >> 10) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['未就绪3'] = (($v[28] >> 12) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['ECU综合告警']['版本不兼容24'] = (($v[28] >> 13) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['ECU综合告警']['维修空开误操作1'] = ($v[28] & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['机架输出过载1'] = (($v[28] >> 1) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路过流'] = (($v[28] >> 2) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['风扇异常3'] = (($v[28] >> 3) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['风扇异常4'] = (($v[28] >> 4) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['风扇异常5'] = (($v[28] >> 5) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['风扇异常2'] = (($v[28] >> 6) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['内部故障6'] = (($v[28] >> 7) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路单元异常4'] = (($v[28] >> 8) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['旁路单元异常6'] = (($v[28] >> 9) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['BCB故障1'] = (($v[28] >> 10) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['未就绪3'] = (($v[28] >> 12) & 0x1) == 1;
            $dataArray['AlertArray']['ECU综合告警']['版本不兼容24'] = (($v[28] >> 13) & 0x1) == 1;
            $v = unpack('v', substr($memData, 4 + 100*2 + 12*4, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4 + 100*2 + 12*4 + 2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
