<?php 
function Is_upsbattery_30_NeedExtraPara(){
    return true;
}

function Get_upsbattery_30_RtData($memData , &$dataArray , $extraPara = false , $pi = false , $time = false , $dynamic_config = false){
    if(empty($memData)){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        if ($pi != null) {
            foreach ($pi as $piObj) {
                $piObj->value = number_format($piObj->value, 3);
            }
        }
        $dataArray["pi"] = $pi;
        $v = unpack('f*', substr($memData, 4, 32 * 4));
        $dataArray['电池电压'] = array();
        foreach ($v as $key => $val) {
            array_push($dataArray['电池电压'], number_format($val,3));
        }
        $v = unpack('f*', substr($memData, 4 + 32 * 4, 8));
        $dataArray['整组电压'] = number_format($v[1], 3).' V';
        $dataArray['整组电流'] = number_format($v[2], 2).' A';
        $v = unpack('C', substr($memData, 32 * 4 + 4 + 4 + 4, 1));
        $dataArray['no_i'] = number_format($v[1], 2);
        $v = unpack('f', substr($memData, 32 * 4 + 4 + 4 + 4 + 1, 4));
        $dataArray['温度'] = number_format($v[1], 2).' ℃';
        $val = unpack('v', substr($memData, 32 * 4 + 4 + 4 + 4 + 4 + 1, 2));
        $year = $val[1];
        $val = unpack('C*', substr($memData, 32 * 4 + 4 + 4 + 4 + 4 + 1 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $val[1] . '-' . $val[2] . ' ' . $val[3] . ':' . $val[4] . ':' . $val[5]));
        
        $dataArray["dynamic_config"] = $dynamic_config;
        
        if ($time == false) {
            //没有时间的
            $dataArray["status"] = false;
            $dataArray["last_update"] = "无最后更新时间";
        } else if ((time() - intval($time)) > 600) {
            //超时5分钟
            $dataArray["status"] = false;
            $dataArray["last_update"] = date("Y-m-d H:i:s", intval($time));
        } else {
            $dataArray["status"] = true;
            $dataArray["last_update"] = date("Y-m-d H:i:s", intval($time));
        }
    }
}
