<?php

function Get_upskstar_RtData($memData, &$dataArray, $extraPara = false)
{
    if($memData == false){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    } else {
        $dataArray["无数据"] = false;
        $offset = 4;
        $v = unpack("S*", substr($memData, 4, 2*55));
        $dataArray["输入A相电压"] = number_format($v[1]/10, 1)."V";
        $dataArray["输入B相电压"] = number_format($v[2]/10, 1)."V";
        $dataArray["输入C相电压"] = number_format($v[3]/10, 1)."V";
        $dataArray["输入频率"] = number_format($v[4]/10, 1)."Hz";
        $dataArray["输入A相电流"] = number_format($v[5]/10, 1)."A";
        $dataArray["输入B相电流"] = number_format($v[6]/10, 1)."A";
        $dataArray["输入C相电流"] = number_format($v[7]/10, 1)."A";
        $dataArray["输入A相功率因数"] = number_format($v[8]/100, 2);
        $dataArray["输入B相功率因数"] = number_format($v[9]/100, 2);
        $dataArray["输入C相功率因数"] = number_format($v[10]/100, 2);

        $dataArray["输出A相电压"] = number_format($v[11]/10, 1)."V";
        $dataArray["输出B相电压"] = number_format($v[12]/10, 1)."V";
        $dataArray["输出C相电压"] = number_format($v[13]/10, 1)."V";
        $dataArray["输出频率"] = number_format($v[14]/10, 1)."Hz";
        $dataArray["输出A相电流"] = number_format($v[15]/10, 1)."A";
        $dataArray["输出B相电流"] = number_format($v[16]/10, 1)."A";
        $dataArray["输出C相电流"] = number_format($v[17]/10, 1)."A";
        $dataArray["输出A相有功功率"] = number_format($v[18]/10, 1)."kW";
        $dataArray["输出B相有功功率"] = number_format($v[19]/10, 1)."kW";
        $dataArray["输出C相有功功率"] = number_format($v[20]/10, 1)."kW";
        $dataArray["输出A相负载率"] = number_format($v[21]/100, 2);
        $dataArray["输出B相负载率"] = number_format($v[22]/100, 2);
        $dataArray["输出C相负载率"] = number_format($v[23]/100, 2);
        $dataArray["输出A相负载峰值比"] = number_format($v[24]/100, 2);
        $dataArray["输出B相负载峰值比"] = number_format($v[25]/100, 2);
        $dataArray["输出C相负载峰值比"] = number_format($v[26]/100, 2);

        $dataArray["旁路A相电压"] = number_format($v[27]/10, 1)."V";
        $dataArray["旁路B相电压"] = number_format($v[28]/10, 1)."V";
        $dataArray["旁路C相电压"] = number_format($v[29]/10, 1)."V";
        $dataArray["旁路频率"] = number_format($v[30]/10, 1)."Hz";

        $dataArray["正组电池电压"] = number_format($v[31]/10, 1)."V";
        $dataArray["负组电池电压"] = number_format($v[32]/10, 1)."V";
        $dataArray["正组电池放电电流"] = number_format($v[33]/10, 1)."A";
        $dataArray["负组电池放电电流"] = number_format($v[34]/10, 1)."A";
        $dataArray["正组电池充电电流"] = number_format($v[35]/10, 1)."A";
        $dataArray["负组电池充电电流"] = number_format($v[36]/10, 1)."A";
        $dataArray["电池容量率"] = $v[37]."%";
        $dataArray["电池后备时间"] = $v[38]."分钟";
        $dataArray["电池温度"] = number_format($v[39]/10, 1)."℃";
        $dataArray["环境温度"] = number_format($v[40]/10, 1)."℃";
        $dataArray["电池放电时间"] = $v[41]."分钟";
        
        $dataArray["输出A相视在功率"] = number_format($v[47]/10, 1)."kW";
        $dataArray["输出B相视在功率"] = number_format($v[48]/10, 1)."kW";
        $dataArray["输出C相视在功率"] = number_format($v[49]/10, 1)."kW";
        $dataArray["输入AB线电压"] = number_format($v[50]/10, 1)."V";
        $dataArray["输入BC线电压"] = number_format($v[51]/10, 1)."V";
        $dataArray["输入CA线电压"] = number_format($v[52]/10, 1)."V";
        $dataArray["旁路AB线电压"] = number_format($v[53]/10, 1)."V";
        $dataArray["旁路BC线电压"] = number_format($v[54]/10, 1)."V";
        $dataArray["旁路CA线电压"] = number_format($v[55]/10, 1)."V";


        $v = unpack('v', substr($memData, 4 + 2*83, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*83 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>