<?php

function Get_wotpclevel3_UnicomCategory()
{
    return "911";
}


function Get_wotpclevel3_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        $v = unpack('S*', substr($memData, 4, 2*111));
        $dataArray["额定工作频率设置"] = $v[1] == 0 ? "50 Hz" : "60 Hz";
        $dataArray["基准电压设置"] = $v[2];
	$dataArray["互感器变比"] = $v[3];
	$dataArray["S1 Uab/Uan"] = $v[6];
	$dataArray["S1 Uca/Ubn"] = $v[7];
	$dataArray["S1 Ucb/Ucn"] = $v[8];
	$dataArray["S2 Uab/Uan"] = $v[9];
	$dataArray["S2 Uca/Ubn"] = $v[10];
	$dataArray["S2 Ucb/Ucn"] = $v[11];
	$dataArray["IA电流"] = $v[12];
        $dataArray["IB电流"] = $v[13];
        $dataArray["IC电流"] = $v[14];
        $dataArray["功率方向"] = $v[15];
	$dataArray["有功功率"] = ($v[16] << 16 | $v[17]). " kW";
	$dataArray["有功电能"] = ($v[18] << 16 | $v[19]). " kWh";

	$dataArray["S1频率"] = $v[20];
	$dataArray["S2频率"] = $v[21];
	$dataArray["S1三相不平衡度"] = $v[22];
	$dataArray["S2三相不平衡度"] = $v[23];
	switch($v[22]){
		case 0:
			$dataArray["S1相序"] = "电源故障";
			break;
		case 1:
			$dataArray["S1相序"] = "正序";
			break;
		case 2:
			$dataArray["S1相序"] = "负序";
			break;
	}
	switch($v[23]){
                case 0:
                        $dataArray["S2相序"] = "电源故障";
                        break;
                case 1:
                        $dataArray["S2相序"] = "正序";
                        break;
                case 2:
                        $dataArray["S2相序"] = "负序";
                        break;
        }
	$dataArray["温度1"] = ($v[29]/10)."℃";
	$dataArray["温度2"] = ($v[30]/10)."℃";
	$dataArray["温度3"] = ($v[31]/10)."℃";
	$dataArray["温度4"] = ($v[32]/10)."℃";
	
	$dataArray["漏电数值"] = $v[33]."mA";
	$dataArray["总转换次数"] = $v[34];
	

	$dataArray['相线和中性线接反报警'] = ($v[38] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['相线和中性线接反报警'] = $v[38];
	$dataArray['转换超时报警'] = ($v[39] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['转换超时报警'] = $v[39];
	$dataArray['双合故障报警'] = ($v[40] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['双合故障报警'] = $v[40];
	$dataArray['双分故障报警'] = ($v[41] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['双分故障报警'] = $v[41];
	$dataArray['频繁切换≥6次/min报警'] = ($v[42] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['频繁切换≥6次/min报警'] = $v[42];
	$dataArray['主备相序不一致报警'] = ($v[43] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['主备相序不一致报警'] = $v[43];
	$dataArray['过载报警'] = ($v[44] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['过载报警'] = $v[44];
	$dataArray['温度报警'] = ($v[45] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['温度报警'] = $v[45];
	$dataArray['漏电报警'] = ($v[46] == 0) ? "正常" : "告警";
        $dataArray['AlertArray']['漏电报警'] = $v[46];

	switch($v[51]){
                case 0:
                        $dataArray["S1开关/触头状态"] = "分闸";
                        break;
                case 1:
                        $dataArray["S1开关/触头状态"] = "合闸";
                        break;
                case 2:
                        $dataArray["S1开关/触头状态"] = "脱扣";
                        break;
        }
	switch($v[52]){
                case 0:
                        $dataArray["S2开关/触头状态"] = "分闸";
                        break; 
                case 1:
                        $dataArray["S2开关/触头状态"] = "合闸";
                        break;
                case 2:
                        $dataArray["S2开关/触头状态"] = "脱扣";
                        break;
        }
	$dataArray['S1电压状态'] = ($v[53] == 0) ? "不正常" : "正常";
	$dataArray['S2电压状态'] = ($v[54] == 0) ? "不正常" : "正常";
	switch($v[55]){
                case 0:
                        $dataArray["控制器状态"] = "自动";
                        break; 
                case 1:
                        $dataArray["控制器状态"] = "通讯";
                        break;
                case 2:
                        $dataArray["控制器状态"] = "远程";
                        break;
                case 3:
                        $dataArray["控制器状态"] = "按键";
                        break;
                case 4:
                        $dataArray["控制器状态"] = "禁止";
                        break;
                case 5:
                        $dataArray["控制器状态"] = "消防";
                        break;
                case 6:
                        $dataArray["控制器状态"] = "退出";
                        break;
        }
	$dataArray['电源类型设置'] = ($v[56] == 0) ? "市电-市电" : "市电-发电机";
	switch($v[57]){
                case 0:
                        $dataArray["工作模式"] = "自复自复";
                        break;
                case 1:
                        $dataArray["工作模式"] = "自投不自复";
                        break;
                case 2:
                        $dataArray["工作模式"] = "互为备用";
                        break;
        }
	$dataArray['主电选择'] = ($v[58] == 0) ? "S1为主电源" : "S2为主电源";

	$dataArray["相序保护功能开关"] = $v[103] == 0 ? "关":"开";
	$dataArray["频率保护开关"] = $v[104] == 0 ? "关":"开";
	$dataArray["三相不平衡开关"] = $v[105] == 0 ? "关":"开";
	$dataArray["过载保护开关"] = $v[106] == 0 ? "关":"开";
	$dataArray["温度保护开关"] = $v[107] == 0 ? "关":"开";
	$dataArray["漏电保护开关"] = $v[108] == 0 ? "关":"开";
	$dataArray["相角检测开关"] = $v[109] == 0 ? "关":"开";
	$dataArray["定时转换开关"] = $v[110] == 0 ? "关":"开";
	$dataArray["定时启动发电机开关"] = $v[111] == 0 ? "关":"开";

        $v = unpack('v',substr($memData, 4 + 4*2, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 4*2 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
