<?php

function Get_xfc500_DeviceIoControl_Parameter($action, $parameter)
{
    return pack("S", $parameter);
}
function Get_xfc500_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '变频器状态':
            return array(0, $dataArray['变频器状态']);
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_xfc500_RtData($memData, &$dataArray, $extraPara = false)
{
   if(empty($memData)) {
       $dataArray['无数据'] = true;
       $dataArray['更新时间'] = '无';
       $dataArray['错误'] = '数据长度不一致';
   } else {
       $dataArray['无数据'] = false;
       $v = unpack('S*', substr($memData, 4, 2*33));
       $dataArray['运行频率'] = $v[1]/100;
       $dataArray['母线电压'] = $v[2]/100;
       $dataArray['输出电压'] = $v[3]/100;
       $dataArray['输出电流'] = $v[4]/100;
       $dataArray['输出功率'] = $v[5]/100;
       $dataArray['输出转矩'] = $v[6]/100;
       $dataArray['运行速度'] = $v[7]/100;
       $dataArray['DI输入标志'] = $v[8];
       $dataArray['DO输出标志'] = $v[9];
       $dataArray['AI1电压'] = $v[10]/100;
       $dataArray['AI2电压'] = $v[11]/100;
       $dataArray['AI3电压'] = $v[12]/100;

       $dataArray['计数值输入'] = $v[13];
       $dataArray['长度值输入'] = $v[14];
       $dataArray['负载速度'] = $v[15];
       $dataArray['PID设置'] = $v[16];
       $dataArray['PID反馈'] = $v[17];
       $dataArray['PID步骤'] = $v[18];
       $dataArray['PULSE输入脉冲频率'] = $v[19]/100;
       $dataArray['反馈速度'] = ($v[20]/10)."Hz";
       $dataArray['剩余运行时间'] = $v[21];
        
       $dataArray['AI1校正前电压'] = $v[22]/100;
       $dataArray['AI2校正前电压'] = $v[23]/100;
       $dataArray['AI3校正前电压'] = $v[24]/100;
       $dataArray['线速度'] = $v[25];
       $dataArray['当前上电时间'] = $v[26];
       $dataArray['当前运行时间'] = $v[27];
       $dataArray['PULSE输入脉冲频率'] = $v[28];
    
       $dataArray['主频率X显示'] = $v[31];
       $dataArray['主频率Y显示'] = $v[32];
        switch($v[33]){
            case 1:
               $dataArray['变频器状态'] = "正转运行";
               break;
            case 2:
               $dataArray['变频器状态'] = "反转运行";
               break;
            case 3:
               $dataArray['变频器状态'] = "停机";
               break;
            default:
               $dataArray['变频器状态'] = "无效值";
               break;
        }
       $val = unpack('v', substr($memData, 4 + 2*33, 2));
       $year = $val[1];
       $val = unpack('C*', substr($memData, 4 + 2*33 + 2, 5));
       $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $val[1] . '-' . $val[2] . ' ' . $val[3] . ':' . $val[4] . ':' . $val[5]));
   }
}
