<?php

function Get_xwpc3_RtData($memData, &$dataArray, $extraPara = false)
{
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('S*',substr($memData, 4,2*6));

        $dataArray['水浸告警'] = $v[1] & 0x1 == 1 ? "异常" : "正常";
        $dataArray['电流大于定位电流阈值'] = ($v[1] >> 1) & 0x1 == 1 ? "异常" : "正常";
        $dataArray['控制器未检测到接线'] = ($v[1] >> 2) & 0x1 == 1 ? "异常" : "正常";
        $dataArray['回路阻抗/差值/平均大于增量阈值'] = ($v[1] >> 3) & 0x1 == 1 ? "异常" : "正常";
        $dataArray['EEPROM读错'] = ($v[1] >> 4) & 0x1 == 1 ? "异常" : "正常";
        $dataArray['EEPROM写错'] = ($v[1] >> 5) & 0x1 == 1 ? "异常" : "正常";
        $dataArray['EEPROM校正错'] = ($v[1] >> 6) & 0x1 == 1 ? "异常" : "正常";

        $dataArray['AlertArray']['漏水告警'] = ($v[1] & 0x1) == 1;
        $dataArray['AlertArray']['电流大于定位电流阈值'] = (($v[1] >> 1) & 0x1) == 1;
        $dataArray['AlertArray']['控制器未检测到接线'] = (($v[1] >> 2) & 0x1) == 1;
        $dataArray['AlertArray']['回路阻抗/差值/平均大于增量阈值'] = (($v[1] >> 3) & 0x1) == 1;
        $dataArray['AlertArray']['EEPROM读错'] = (($v[1] >> 4) & 0x1) == 1;
        $dataArray['AlertArray']['EEPROM写错'] = (($v[1] >> 5) & 0x1) == 1;
        $dataArray['AlertArray']['EEPROM校正错'] = (($v[1] >> 6) & 0x1) == 1;


        $dataArray['位置阻抗（Ω）'] = $v[2];
        $dataArray['检测阻抗（KΩ）'] = $v[3];
        $dataArray['检测电流（μA）'] = $v[4];
        $dataArray['RG电流（Ω）'] = $v[5];
        $dataArray['YB电流（Ω）'] = $v[6];

        $v = unpack('v',substr($memData, 4 + 2*6, 2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,4 + 2*6 + 2,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}

?>
