<?php
function Get_yananac_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case '温度设定点':
            return array(0,  $dataArray['回风温度设定点']);
        case '回风温度':
            return array(0, $dataArray['回风温度']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}

function Get_yananac_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('S*',substr($memData, 4 , 19*2));
        $dataArray['空调告警1'] = $v[1] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['空调告警1'] = $v[1] != 0;
        $dataArray['空调告警2'] = $v[2] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['空调告警2'] = $v[2] != 0;
        $dataArray['空调告警3'] = $v[3] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['空调告警3'] = $v[3] != 0;
        $dataArray['空调告警4'] = $v[4] == 0 ? "正常" : "告警";
        $dataArray['AlertArray']['空调告警4'] = $v[4] != 0;

        $dataArray['机组运行状态'] = $v[5] == 1 ? "运行" : "关闭";
        $dataArray['风扇控制模式'] = $v[6] == 3 ? "回风温度模式" : "其他模式";
        $dataArray['水阀控制模式'] = $v[7] == 3 ? "回风温度模式" : "其他模式";
        $dataArray['风机转速'] = $v[8];
        $dataArray['水阀开度'] = ($v[9] / 10);
        $dataArray['回风温度'] = ($v[10] / 10);
        $dataArray['回风湿度'] = ($v[11] / 10)."%RH";
        $dataArray['风压平均'] = ($v[12] / 100);
        $dataArray['监控开关机'] = $v[13];
        $dataArray['风压设定点'] = ($v[14] / 10);
        $dataArray['回风湿度设定点'] = ($v[15] / 10);
        $dataArray['回风温度设定点'] = ($v[16] / 10);
        $dataArray['送风温度设定点'] = ($v[17] / 10);
        $dataArray['远程平均温度设定点'] = ($v[18] / 10);
        $dataArray['远程最高温度设定点'] = ($v[19] / 10);

        $v = unpack('v',substr($memData,42,2));
        $year = $v[1];
        $v = unpack('C*',substr($memData,44,5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s',strtotime($year.'-'.$v[1].'-'.$v[2].' '.$v[3].':'.$v[4].':'.$v[5]));
    }
}
?>
