<?php

function Get_yd2037yr_Active_Power($dataArray){
    return array(0 , floatval($dataArray['正向有功电能']));
}


function Get_yd2037yr_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        /* $dataObj->isEmpty = true;
        $dataObj->update_datetime = '无'; */
    } else {
        $dataArray["无数据"] = false;
        $v = unpack('S*', substr($memData, 4, 2*43));
        $dataArray["PT"] = $v[42];
        $dataArray["CT"] = $v[43];

        $dataArray["相电压Ua"] = number_format($v[1] * $v[42] / 10, 1) ."V";
        $dataArray["线电压Uca"] = number_format($v[2] * $v[42] / 10, 1) ."V";
        $dataArray["A相电流"] = number_format($v[3] * $v[43]  / 1000, 3) ."A";

        $dataArray["A相有功功率"] = number_format($v[5] * $v[42] * $v[43] / 1000, 3). "KW";
        $dataArray["A相功率因数"] = number_format($v[6] / 10000, 4);
        $dataArray["A相无功功率"] = number_format($v[7] * $v[42] * $v[43] / 1000, 3). "Kvar";
        $dataArray["A相视在功率"] = number_format($v[8] * $v[42] * $v[43] / 1000, 3). "KVA";

        $dataArray["相电压Ub"] = number_format($v[9] * $v[42] / 10, 1) ."V";
        $dataArray["线电压Uab"] = number_format($v[10] * $v[42] / 10, 1) ."V";
        $dataArray["B相电流"] = number_format($v[11] * $v[43] / 1000, 3) ."A";
        
        $dataArray["B相有功功率"] = number_format($v[13] * $v[42] * $v[43] / 1000, 3). "KW";
        $dataArray["B相功率因数"] = number_format($v[14] / 10000, 4);
        $dataArray["B相无功功率"] = number_format($v[15] * $v[42] * $v[43] / 1000, 3). "Kvar";
        $dataArray["B相视在功率"] = number_format($v[16] * $v[42] * $v[43] / 1000, 3). "KVA";

        $dataArray["相电压Uc"] = number_format($v[17] * $v[42] / 10, 1) ."V";
        $dataArray["线电压Ubc"] = number_format($v[18] * $v[42] / 10, 1) ."V";
        $dataArray["C相电流"] = number_format($v[19] * $v[43]  / 1000, 3) ."A";
        
        $dataArray["C相有功功率"] = number_format($v[21] * $v[42] * $v[43] / 1000, 3). "KW";
        $dataArray["C相功率因数"] = number_format($v[22] / 10000, 4);
        $dataArray["C相无功功率"] = number_format($v[23] * $v[42] * $v[43] / 1000, 3). "Kvar";
        $dataArray["C相视在功率"] = number_format($v[24] * $v[42] * $v[43] / 1000, 3). "KVA";

        $dataArray["三相平均线电压"] = number_format($v[25] * $v[42] / 10, 1) ."V";
        $dataArray["三相平均相电压"] = number_format($v[26] * $v[42] / 10, 1) ."V";
        $dataArray["三相平均相电流"] = number_format($v[27] * $v[43] / 10 / 1000, 3) ."A";
        $dataArray["频率"] = number_format($v[28] * 0.00106813, 2)."Hz";
        $dataArray["三相有功功率"] = number_format($v[29] * $v[42] * $v[43] / 1000, 3). "KW";
        $dataArray["三相总功率因数"] = number_format($v[30] / 10000, 4);
        $dataArray["三相无功功率"] = number_format($v[31] * $v[42] * $v[43] / 1000, 3). "Kvar";
        $dataArray["三相视在功率"] = number_format($v[32] * $v[42] * $v[43] / 1000, 3). "KVA";

        $dataArray["正向有功电能"] = number_format( (intval($v[34]) + (intval($v[35])<<16) )*$v[42]*$v[43]/1000, 3, '.', '')."KWh";
        $dataArray["负向有功电能"] = number_format( (intval($v[36]) + (intval($v[37])<<16) )*$v[42]*$v[43]/1000, 3, '.', '')."KWh";
        $dataArray["正向无功电能"] = number_format( (intval($v[38]) + (intval($v[39])<<16) )*$v[42]*$v[43]/1000, 3, '.', '')."Kvarh";
        $dataArray["负向无功电能"] = number_format( (intval($v[40]) + (intval($v[41])<<16) )*$v[42]*$v[43]/1000, 3, '.', '')."Kvarh";

        $dataArray['智能电表电流和'] = number_format((floatval($dataArray['A相电流']) + floatval($dataArray['B相电流']) + floatval($dataArray['C相电流'])),2) . ' A';
        $dataArray['智能电表电压'] = $dataArray['相电压Ua'];
        $dataArray['智能电表有功功率'] = number_format((floatval($dataArray['智能电表电流和']) * floatval($dataArray['智能电表电压']))/1000,2 ,'.','') . ' kW';
        $dataArray['智能电表耗电量'] = number_format((floatval($dataArray['智能电表有功功率']) * 24),2 ,'.','') . ' kWh';

        $v = unpack('v', substr($memData, 4 + 2*43, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*43 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
