<?php

function Get_yd_dems_bd2_rht_Standard_Variable($dataArray, $varname)
{
    switch ($varname) {
        case '温度设定点':
            return array(0, $dataArray['温度设定点']);
        case '回风温度':
            return array(0, $dataArray['回风温度']);
        default:
            break;
    }
    return array(1, '设备无此信号数据:' . $varname);
}


function Get_yd_dems_bd2_rht_Active_Power($dataArray){
    return array(0 , $dataArray["第1路进线回路基本数据"]['正向有功电能(kWh)'] + $dataArray["第2路进线回路基本数据"]['正向有功电能(kWh)']);
}

function _yd_dems_bd2_rht_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

function Get_yd_dems_bd2_rht_RtData($memData, &$dataArray, $extraPara = false)
{
    if ($memData == false){// || strlen($memData) != 6375) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;

        //第一路进线回路基本数据(浮点)
        $offset = 4;
        $v = unpack('f*', substr($memData, $offset, 60 * 4));
        $ydstrarr = [
            'A相电压UA（V）', 'B相电压UB（V）', 'C相电压UC（V）', '三相平均相电压（V）', '线电压UAB（V）', '线电压U23（V）', '线电压U31（V）', '三相平均线电压（V）', 'A相电流IA（A）', 'B相电流IB（A）',
            'C相电流IC（A）', '三相平均电流Iavg（A）', '零线电流In（A）', 'A相有功PA（kW）', 'B相有功PB（kW）', 'C相有功PC（kW）', '系统有功P（kW）', 'A相无功QA（kvar）', 'B相无功QB（kvar）', 'C相无功QC（kvar）',
            '系统无功Q（kvar）', 'A相视在功率SA（kVA）', 'B相视在功率SB（kVA）', 'C相视在功率SC（kVA）', '系统视在功率S（kVA）', 'A相功率因数PFA', 'B相功率因数PFB', 'C相功率因数PFC',
            '系统功率因数PF', '频率F（Hz）', '电压不平衡度UNBL-V（%）', '电流不平衡度UNBL-I（%）', 'A相电压正序（V）', 'A相电压负序（V）', 'A相电压零序（V）', 'A相电流正序（V）',
            'A相电流负序（A）', 'A相电流零序（A）', '零地电压（V）', '漏电电流（A）', '正向有功电能（kWh）', '负向有功电能（kWh）', '正向无功电能（kvar）', '负向无功电能（kvar）', 'A相有功功率需量（kW）',
            'B相有功功率需量（kW）', 'C相有功功率需量（kW）', '系统有功功率需量（kW）', 'A相电流需量（A）', 'B相电流需量（A）', 'C相电流需量（A）', '三相平均电流需量（A）', 'A相电压百分比（%）',
            'B相电压百分比（%）', 'C相电压百分比（%）', '三相平均电压百分比（%）', 'A相电流百分比（%）', 'B相电流百分比（%）', 'C相电流百分比（%）', '三相平均电流百分比（%）'];
        $dataArray["第1路进线回路基本数据"] = array();
        foreach ($ydstrarr as $k => $val) {
            $dataArray["第1路进线回路基本数据"][$val] = number_format($v[$k + 1], 2, ".", "");
        }
        $offset += 60 * 4;
        /*$v = unpack('S*', substr($memData, $offset, 2));
        $dataArray["第1路进线回路基本数据"]['开入开出状态'] = $v[1] == 0 ? '开入' : '开出';
        $dataArray["第1路进线回路基本数据"]['AlertArray']['开入开出状态'] = $v[1] == 1;*/
        $offset += 4;
        $v = unpack('f*', substr($memData, $offset, 99 * 4));
        $ydstrarr1 = ['温度1（℃）', '温度2（℃）', '湿度（HR）'];
        foreach ($ydstrarr1 as $k => $val) {
            $dataArray["第1路进线回路基本数据"][$val] = number_format($v[$k + 1], 2);
        }
        $offset += 99 * 4;
        $v = unpack('f*', substr($memData, $offset, 62 * 4));
        $ydstrarr2 = [
            '本月有功电能（kWh）', '上1月有功电能（kWh）', '上2月有功电能（kWh）', '上3月有功电能（kWh）', '上4月有功电能（kWh）', '上5月有功电能（kWh）', '上6月有功电能（kWh）',
            '上7月有功电能（kWh）', '上8月有功电能（kWh）', '上9月有功电能（kWh）', '上10月有功电能（kWh）', '上11月有功电能（kWh）', '上12月有功电能（kWh）', '本年有功电能（kWh）',
            '上1年有功电能（kWh）', '上2年有功电能（kWh）', '上3年有功电能（kWh）', '上4年有功电能（kWh）', '上5年有功电能（kWh）', '尖时段有功电能（kWh）', '峰时段有功电能（kWh）',
            '平时段有功电能（kWh）', '谷时段有功电能（kWh）', '本月尖时段有功电能（kWh）', '本月峰时段有功电能（kWh）', '本月平时段有功电能（kWh）', '本月谷时段有功电能（kWh）',
            '上月尖时段有功电能（kWh）', '上月峰时段有功电能（kWh）', '上月平时段有功电能（kWh）', '上月谷时段有功电能（kWh）', '上上月尖时段有功电能（kWh）', '上上月峰时段有功电能（kWh）',
            '上上月平时段有功电能（kWh）', '上上月谷时段有功电能（kWh）', '基波 VA（一次值）（V）', '基波 VB（一次值）（V）', '基波 VC（一次值）（V）', '基波 IA（一次值）（A）',
            '基波 IB（一次值）（A）', '基波 IC（一次值）（A）', '基波 PA（一次值）（kW）', '基波 PB（一次值）（kW）', '基波 PC（一次值）（kW）', '基波 有功电能（一次值）（kWh）',
            '谐波 VA（一次值）（V）', '谐波 VB（一次值）（V）', '谐波 V3（一次值）（V）', '谐波 IA（一次值）（A）', '谐波 IB（一次值）（A）', '谐波 IC（一次值）（A）',
            '谐波 PA（一次值）（kW）', '谐波 PB（一次值）（kW）', '谐波 PC（一次值）（kW）', 'VA总谐波畸变率 THD_VA（%）', 'VB总谐波畸变率 THD_VB（%）',
            'VC总谐波畸变率 THD_VC（%）', '相电压平均总谐波畸变率 THD_V（%）', 'IA总谐波畸变率THD_IA（%）', 'IB总谐波畸变率THD_IB（%）',
            'IC总谐波畸变率THD_IC（%）', '相电流平均总谐波畸变率THD_I（%）'];
        foreach ($ydstrarr2 as $k => $val) {
            $dataArray["第1路进线回路基本数据"][$val] = number_format($v[$k + 1], 2);
        }

        //第二路进线回路基本数据(浮点)
        $offset += 62 * 4;
        $v = unpack('f*', substr($memData, $offset, 60 * 4));
        $dataArray["第2路进线回路基本数据"] = array();
        foreach ($ydstrarr as $k => $val) {
            $dataArray["第2路进线回路基本数据"][$val] = number_format($v[$k + 1], 2, ".", "");
        }
        $offset += 60 * 4;
        //$v = unpack('S', substr($memData, $offset, 2));
        //$dataArray["第2路进线回路基本数据"]['开入开出状态'] = $v[1] == 0 ? '开入' : '开出';
        $offset += 4;
        $v = unpack('f*', substr($memData, $offset, 99 * 4));
        foreach ($ydstrarr1 as $k => $val) {
            $dataArray["第2路进线回路基本数据"][$val] = number_format($v[$k + 1], 2);
        }
        $offset += 99 * 4;
        $v = unpack('f*', substr($memData, $offset, 62 * 4));
        foreach ($ydstrarr2 as $k => $val) {
            $dataArray["第2路进线回路基本数据"][$val] = number_format($v[$k + 1], 2);
        }

        //第一路进线回路谐波数据区
        $offset += 62 * 4;

        $v = unpack('S*', substr($memData, $offset, 10 * 2));
        $ydstrarr3 = [
            '基波 VA或VAB（二次值）（V）'=>0.1, '基波 VB或VBC（二次值）（V）'=>0.1, '基波 VC或VCA（二次值）（V）'=>0.1, '基波 IA（二次值）（A）'=>0.001, '基波 IB（二次值）（A）'=>0.001, '基波 IC（二次值）（A）'=>0.001,
            '基波 PA（二次值）（W）'=>1, '基波 PB（二次值）（W）'=>1, '基波 PC（二次值）（W）'=>1
        ];
        $dataArray["第1路进线回路谐波数据区"] = array();
        $k  = 0;
        foreach ($ydstrarr3 as $key => $val) {
            $dataArray["第1路进线回路谐波数据区"][$key] = number_format($v[$k++ + 1] * $val, 2);
        }

        $offset += 10 * 2;
        $v = unpack('I', substr($memData, $offset, 4));
        $dataArray["第1路进线回路谐波数据区"]['基波 有功电能（二次值）（Wh）'] = $v[1];

        $offset += 4;
        $v = unpack('S*', substr($memData, $offset, 17 * 2));
        $ydstrarr4 = [
            '谐波 VA或VAB（二次值）（V）'=>0.1, '谐波 VB或VBC（二次值）（V）'=>0.1,
            '谐波 VC或VCA（二次值）（V）'=>0.1, '谐波 IA（二次值）（A）'=>0.001, '谐波 IB（二次值）（A）'=>0.001, '谐波 IC（二次值）（A）'=>0.001, '谐波 PA（二次值）（W）'=>1, '谐波 PB（二次值）（W）'=>1,
            '谐波 PC（二次值）（W）'=>1, 'VA 或VAB 总谐波畸变率 THD_VA（%）'=>0.01, 'VB 或VBC 总谐波畸变率 THD_VB（%）'=>0.01, 'VC 或VCA 总谐波畸变率 THD_VC（%）'=>0.01,
            '相/线电压平均总谐波畸变率 THD_V（%）'=>0.01, 'IA 总谐波畸变率THD_IA（%）'=>0.01, 'IB 总谐波畸变率THD_IB（%）'=>0.01, 'IC 总谐波畸变率THD_IC（%）'=>0.01, '相电流平均总谐波畸变率THD_I（%）'=>0.01,
        ];
        $k  = 0;
        foreach ($ydstrarr4 as $key => $val) {
            $dataArray["第1路进线回路谐波数据区"][$key] = number_format($v[$k + 1]*$val, 2);
        }

        $offset += 17 * 2;
        //$v = unpack('C*', substr($memData, $offset, 3 * 2));

        $offset += 3 * 2;
        $v = unpack('S*', substr($memData, $offset, 66 * 2));
        $dataArray["第1路进线回路谐波数据区"]["A相电压奇谐波畸变率（%）"] = number_format($v[1]*0.01, 2);
        $dataArray["第1路进线回路谐波数据区"]['A相电压偶谐波畸变率（%）'] = number_format($v[2]*0.01, 2);
        $dataArray["第1路进线回路谐波数据区"]['A相电压波峰系数'] = number_format($v[3]*0.0001, 2);
        $dataArray["第1路进线回路谐波数据区"]['A相电压电话谐波波形因数（%）'] = number_format($v[4]*0.01, 2);
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第1路进线回路谐波数据区"]['A相电压' . $i . '次谐波含有率'] = ($v[$i+3]*0.01) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第1路进线回路谐波数据区"]["B相电压奇谐波畸变率（%）"] = number_format($v[1]*0.01, 2);
        $dataArray["第1路进线回路谐波数据区"]['B相电压偶谐波畸变率（%）'] = number_format($v[2]*0.01, 2);
        $dataArray["第1路进线回路谐波数据区"]['B相电压波峰系数'] = number_format($v[3]*0.0001, 2);
        $dataArray["第1路进线回路谐波数据区"]['B相电压电话谐波波形因数（%）'] = number_format($v[4]*0.01, 2);
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第1路进线回路谐波数据区"]['B相电压' . $i . '次谐波含有率'] = ($v[$i-1]*0.01) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第1路进线回路谐波数据区"]["C相电压奇谐波畸变率（%）"] = number_format($v[1]*0.01, 2);
        $dataArray["第1路进线回路谐波数据区"]['C相电压偶谐波畸变率（%）'] = number_format($v[2]*0.01, 2);
        $dataArray["第1路进线回路谐波数据区"]['C相电压波峰系数'] = number_format($v[3]*0.0001, 2);
        $dataArray["第1路进线回路谐波数据区"]['C相电压电话谐波波形因数（%）'] = number_format($v[4]*0.01, 2);
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第1路进线回路谐波数据区"]['C相电压' . $i . '次谐波含有率'] = ($v[$i-1]*0.01) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第1路进线回路谐波数据区"]['A相电流奇谐波畸变率'] = $v[1]*0.01 . '%';
        $dataArray["第1路进线回路谐波数据区"]['A相电流偶谐波畸变率'] = $v[2]*0.01 . '%';
        $dataArray["第1路进线回路谐波数据区"]['A相电流K系数'] = $v[3]*0.01 . '%';
        //$dataArray['保留'] = $v[5] . '0.01%'; //TODO
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第1路进线回路谐波数据区"]['A相电流' . $i . '次谐波含有率'] = ($v[$i+3]) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第1路进线回路谐波数据区"]['B相电流奇谐波畸变率'] = $v[1]*0.01 . '%';
        $dataArray["第1路进线回路谐波数据区"]['B相电流偶谐波畸变率'] = $v[2]*0.01 . '%';
        $dataArray["第1路进线回路谐波数据区"]['B相电流K系数'] = $v[3]*0.01 . '%';
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第1路进线回路谐波数据区"]['B相电流' . $i . '次谐波含有率'] = ($v[$i-1]*0.01) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第1路进线回路谐波数据区"]['C相电流奇谐波畸变率'] = $v[1]*0.01 . '%';
        $dataArray["第1路进线回路谐波数据区"]['C相电流偶谐波畸变率'] = $v[2]*0.01 . '%';
        $dataArray["第1路进线回路谐波数据区"]['C相电流K系数'] = $v[3]*0.01 . '%';
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第1路进线回路谐波数据区"]['C相电流' . $i . '次谐波含有率'] = ($v[$i-1]*0.01) . '%';
            $j++;
        }
        //第二路进线回路谐波数据
        $dataArray["第2路进线回路谐波数据区"] = array();
        $offset += 66 * 2;
        $v = unpack('S*', substr($memData, $offset, 10 * 2));
        $ydstrarr3 = [
            '基波 VA或VAB（二次值）（V）'=>0.1, '基波 VB或VBC（二次值）（V）'=>0.1, '基波 VC或VCA（二次值）（V）'=>0.1, '基波 IA（二次值）（A）'=>0.001, '基波 IB（二次值）（A）'=>0.001, '基波 IC（二次值）（A）'=>0.001,
            '基波 PA（二次值）（W）'=>1, '基波 PB（二次值）（W）'=>1, '基波 PC（二次值）（W）'=>1
        ];
        $dataArray["第2路进线回路谐波数据区"] = array();
        $k  = 0;
        foreach ($ydstrarr3 as $key => $val) {
            $dataArray["第2路进线回路谐波数据区"][$key] = number_format($v[$k++ + 1] * $val, 2);
        }

        $offset += 10 * 2;
        $v = unpack('I', substr($memData, $offset, 4));
        $dataArray["第2路进线回路谐波数据区"]['基波 有功电能（二次值）（Wh）'] = $v[1];

        $offset += 4;
        $v = unpack('S*', substr($memData, $offset, 17 * 2));
        $ydstrarr4 = [
            '谐波 VA或VAB（二次值）（V）'=>0.1, '谐波 VB或VBC（二次值）（V）'=>0.1,
            '谐波 VC或VCA（二次值）（V）'=>0.1, '谐波 IA（二次值）（A）'=>0.001, '谐波 IB（二次值）（A）'=>0.001, '谐波 IC（二次值）（A）'=>0.001, '谐波 PA（二次值）（W）'=>1, '谐波 PB（二次值）（W）'=>1,
            '谐波 PC（二次值）（W）'=>1, 'VA 或VAB 总谐波畸变率 THD_VA（%）'=>0.01, 'VB 或VBC 总谐波畸变率 THD_VB（%）'=>0.01, 'VC 或VCA 总谐波畸变率 THD_VC（%）'=>0.01,
            '相/线电压平均总谐波畸变率 THD_V（%）'=>0.01, 'IA 总谐波畸变率THD_IA（%）'=>0.01, 'IB 总谐波畸变率THD_IB（%）'=>0.01, 'IC 总谐波畸变率THD_IC（%）'=>0.01, '相电流平均总谐波畸变率THD_I（%）'=>0.01,
        ];
        $k  = 0;
        foreach ($ydstrarr4 as $key => $val) {
            $dataArray["第2路进线回路谐波数据区"][$key] = number_format($v[$k + 1]*$val, 2);
        }

        $offset += 17 * 2;
        //$v = unpack('C*', substr($memData, $offset, 3 * 2));

        $offset += 3 * 2;
        $v = unpack('S*', substr($memData, $offset, 66 * 2));
        $dataArray["第2路进线回路谐波数据区"]["A相电压奇谐波畸变率（%）"] = number_format($v[1]*0.01, 2);
        $dataArray["第2路进线回路谐波数据区"]['A相电压偶谐波畸变率（%）'] = number_format($v[2]*0.01, 2);
        $dataArray["第2路进线回路谐波数据区"]['A相电压波峰系数'] = number_format($v[3]*0.0001, 2);
        $dataArray["第2路进线回路谐波数据区"]['A相电压电话谐波波形因数（%）'] = number_format($v[4]*0.01, 2);
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第2路进线回路谐波数据区"]['A相电压' . $i . '次谐波含有率'] = ($v[$i+3]*0.01) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第2路进线回路谐波数据区"]["B相电压奇谐波畸变率（%）"] = number_format($v[1]*0.01, 2);
        $dataArray["第2路进线回路谐波数据区"]['B相电压偶谐波畸变率（%）'] = number_format($v[2]*0.01, 2);
        $dataArray["第2路进线回路谐波数据区"]['B相电压波峰系数'] = number_format($v[3]*0.0001, 2);
        $dataArray["第2路进线回路谐波数据区"]['B相电压电话谐波波形因数（%）'] = number_format($v[4]*0.01, 2);
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第2路进线回路谐波数据区"]['B相电压' . $i . '次谐波含有率'] = ($v[$i-1]*0.01) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第2路进线回路谐波数据区"]["C相电压奇谐波畸变率（%）"] = number_format($v[1]*0.01, 2);
        $dataArray["第2路进线回路谐波数据区"]['C相电压偶谐波畸变率（%）'] = number_format($v[2]*0.01, 2);
        $dataArray["第2路进线回路谐波数据区"]['C相电压波峰系数'] = number_format($v[3]*0.0001, 2);
        $dataArray["第2路进线回路谐波数据区"]['C相电压电话谐波波形因数（%）'] = number_format($v[4]*0.01, 2);
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第2路进线回路谐波数据区"]['C相电压' . $i . '次谐波含有率'] = ($v[$i-1]*0.01) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第2路进线回路谐波数据区"]['A相电流奇谐波畸变率'] = $v[1]*0.01 . '%';
        $dataArray["第2路进线回路谐波数据区"]['A相电流偶谐波畸变率'] = $v[2]*0.01 . '%';
        $dataArray["第2路进线回路谐波数据区"]['A相电流K系数'] = $v[3]*0.01 . '%';
        //$dataArray['保留'] = $v[5] . '0.01%'; //TODO
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第2路进线回路谐波数据区"]['A相电流' . $i . '次谐波含有率'] = ($v[$i+3]) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第2路进线回路谐波数据区"]['B相电流奇谐波畸变率'] = $v[1]*0.01 . '%';
        $dataArray["第2路进线回路谐波数据区"]['B相电流偶谐波畸变率'] = $v[2]*0.01 . '%';
        $dataArray["第2路进线回路谐波数据区"]['B相电流K系数'] = $v[3]*0.01 . '%';
        //$dataArray['保留'] = $v[5] . '0.01%'; //TODO        
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第2路进线回路谐波数据区"]['B相电流' . $i . '次谐波含有率'] = ($v[$i-1]*0.01) . '%';
        }
        $offset += 66 * 2;
        $v = unpack('C*', substr($memData, $offset, 66 * 2));
        $dataArray["第2路进线回路谐波数据区"]['C相电流奇谐波畸变率'] = $v[1]*0.01 . '%';
        $dataArray["第2路进线回路谐波数据区"]['C相电流偶谐波畸变率'] = $v[2]*0.01 . '%';
        $dataArray["第2路进线回路谐波数据区"]['C相电流K系数'] = $v[3]*0.01 . '%';
        for ($i = 2; $i <= 63; $i++) {
            $dataArray["第2路进线回路谐波数据区"]['C相电流' . $i . '次谐波含有率'] = ($v[$i-1]*0.01) . '%';
            $j++;
        }
        $offset += 66 * 2;
       
        //温度数据区        
        $v = unpack('C*', substr($memData, $offset, 144 * 2));
        for ($i = 1; $i <= 144; $i++) {
            $dataArray['温度' . $i] = ($v[$i]*0.1) . '°';
        }
        //所有开关状态(重组)
        $offset += 144 * 2;
        $v = unpack('S*', substr($memData, $offset, 9 * 2));
        for($i=1;$i<=9;$i++)
        {
            for($j=0; $j<16; $j++)
            {
                $dataArray["开关".( 16*($i-1) + $j + 1)."OF状态"] = ($v[$i] >> $j) & 0x1 ? '开' : '关';
            }
        }

        //当支路需要监测SD故障时
        $offset += 9 * 2;
        $v = unpack('S*', substr($memData, $offset, 9 * 2));
        for($i=1;$i<=9;$i++)
        {
            for($j=0; $j<16; $j++)
            {
                $dataArray["开关".( 16*($i-1) + $j + 1)."SD状态"] = ($v[$i] >> $j) & 0x1 ? '开' : '关';
            }
        }

        //主开关状态、防雷器状态、DO状态
        $offset += 9 * 2;
        $v = unpack('S*', substr($memData, $offset, 3 * 2));
        $dataArray['第一主路主开关OF'] = ($v[1]&0x1) ? '开' : '关';
        $dataArray['第一主路主开关SD'] = (($v[1]>>1)&0x1) ? '开' : '关';
        $dataArray['第一主路防雷器开关'] = (($v[1]>>2)&0x1) ? '开' : '关';
        _yd_dems_bd2_rht_ShowAlert($dataArray, '第一主路防雷状态', (($v[1]>>3)&0x1), 0);
        $dataArray['第一主路备用开关状态'] = (($v[1]>>8)&0x1) ? '开' : '关';
        $dataArray['第一主路备用开关SD'] = (($v[1]>>9)&0x1) ? '开' : '关';
	
	    $dataArray['第二主路主开关OF'] = ($v[2]&0x1) ? '开' : '关';
        $dataArray['第二主路主开关SD'] = (($v[2]>>1)&0x1) ? '开' : '关';
        $dataArray['第二主路防雷器开关'] = (($v[2]>>2)&0x1) ? '开' : '关';
        _yd_dems_bd2_rht_ShowAlert($dataArray, '第二主路防雷状态', (($v[2]>>3)&0x1), 0);
        $dataArray['第二主路备用开关状态'] = (($v[2]>>8)&0x1) ? '开' : '关';
        $dataArray['第二主路备用开关SD'] = (($v[2]>>9)&0x1) ? '开' : '关';

        $dataArray['DO1状态'] = ($v[3]&0x1)   ? '开' : '关';
        $dataArray['DO2状态'] = (($v[3]>>1)&0x1) ? '开' : '关';

        //系统运行时间
        $offset += 3 * 2;
        $v = unpack('v', substr($memData, $offset, 1 * 2));

        //重组馈出回路部分数据区
        $offset += 1 * 2;
        $v = unpack('f*', substr($memData, $offset, 576 * 4));
        for ($i = 0; $i < 144; $i++) {
            $dataArray['第' . ($i + 1) . '回路数据电压U'] = number_format($v[$i * 4 + 1], 2) . 'V';
            $dataArray['第' . ($i + 1) . '回路数据电流I'] = number_format($v[$i * 4 + 2], 2) . 'A';
            $dataArray['第' . ($i + 1) . '回路数据有功功率P'] = number_format($v[$i * 4 + 3], 2) . 'kW';
            $dataArray['第' . ($i + 1) . '回路数据有功电能'] = number_format($v[$i * 4 + 4], 2) . 'kWh';
        }

        //告警状态
        $offset += 576 * 4;
        $v = unpack('S*', substr($memData, $offset, 120 * 2));
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路U1上限告警", ($v[2] >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路U1下限告警", ($v[2] >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路U2上限告警", ($v[2] >> 5) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路U2下限告警", ($v[2] >> 7) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路U3上限告警", ($v[2] >> 9) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路U3下限告警", ($v[2] >> 11) & 0x1, 0);
        
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路I1上限告警", ($v[3] >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路I1下限告警", ($v[3] >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路I2上限告警", ($v[3] >> 5) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路I2上限告警", ($v[3] >> 7) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路I3上限告警", ($v[3] >> 9) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路I3下限告警", ($v[3] >> 11) & 0x1, 0);
        
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路F上限告警", ($v[6] >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路F下限告警", ($v[6] >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路A相缺相告警", ($v[6] >> 4) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路B相缺相告警", ($v[6] >> 5) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路C相缺相告警", ($v[6] >> 6) & 0x1, 0);
            
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路主开关跳闸告警", ($v[7]  >> 0) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路主开关SD告警", ($v[7]  >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路防雷器开关告警",  ($v[7]  >> 2) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路防雷状态告警",  ($v[7]  >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路备用开关跳闸告警", ($v[7]  >> 4) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第一路主路备用开关SD告警",  ($v[7]  >> 5) & 0x1, 0);

        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路U1上限告警", ($v[9] >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路U1下限告警", ($v[9] >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路U2上限告警", ($v[9] >> 5) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路U2下限告警", ($v[9] >> 7) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路U3上限告警", ($v[9] >> 9) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路U3下限告警", ($v[9] >> 11) & 0x1, 0);
        
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路I1上限告警", ($v[10] >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路I1下限告警", ($v[10] >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路I2上限告警", ($v[10] >> 5) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路I2上限告警", ($v[10] >> 7) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路I3上限告警", ($v[10] >> 9) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路I3下限告警", ($v[10] >> 11) & 0x1, 0);
        
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路F上限告警", ($v[13] >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路F下限 告警", ($v[13] >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路A相缺相告警",  ($v[13] >> 4) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路B相缺相告警",  ($v[13] >> 5) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路C相缺相告警",  ($v[13] >> 6) & 0x1, 0);
            
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路主开关跳闸告警", ($v[14]  >> 0) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路主开关SD告警",($v[14]  >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路防雷器开关告警", ($v[14]  >> 2) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路防雷状态告警", ($v[14]  >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路备用开关跳闸告警", ($v[14]  >> 4) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "第二路主路备用开关SD告警",  ($v[14]  >> 5) & 0x1, 0);
        
        
        _yd_dems_bd2_rht_ShowAlert($dataArray, "支路电流模块通讯告警", $v[15], 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "支路开关模块通讯告警", $v[16], 0);
        //温度
        _yd_dems_bd2_rht_ShowAlert($dataArray, "温度1上限告警", ($v[17] >> 1) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "温度1下限告警",  ($v[17] >> 3) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray,  "温度2上限告警", ($v[17] >> 5) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "温度2下限告警",  ($v[17] >> 7) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "湿度上限告警", ($v[17] >> 9) & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "湿度下限告警", ($v[17] >> 11) & 0x1, 0);
        
        //支路开关OF跳闸告警
        for($i=0; $i<9; $i++)
        {
            for($j=0; $j<16; $j++)
            {
                $subject = "开关".(16*$i + $j + 1);
                _yd_dems_bd2_rht_ShowAlert($dataArray, $subject."分闸告警", ($v[18 + $i] >> $j) & 0x1, 0);
                
                _yd_dems_bd2_rht_ShowAlert($dataArray, $subject."SD故障告警", ($v[27 + $i] >> $j) & 0x1, 0);
            }
        }
        //35
        for($i=0; $i<9; $i++)
        {
            for($j=0; $j<4; $j++)
            {
                $subject = "回路".(4*$i + $j + 1);
                _yd_dems_bd2_rht_ShowAlert($dataArray,  $subject."电流上上限告警", ($v[36 + $i] >> (4*$j) ) & 0x1, 0);
                _yd_dems_bd2_rht_ShowAlert($dataArray,  $subject."电流上限告警",  ($v[36 + $i] >> (4*$j+1) ) & 0x1, 0);
                _yd_dems_bd2_rht_ShowAlert($dataArray,  $subject."电流下下限告警", ($v[36 + $i] >> (4*$j +2 ) ) & 0x1, 0);
                _yd_dems_bd2_rht_ShowAlert($dataArray,  $subject."电流下限告警",  ($v[36 + $i] >> (4*$j + 3) ) & 0x1, 0);
                
                $temperatureSubject = "温度模块".(4*$i + $j + 1);
                _yd_dems_bd2_rht_ShowAlert($dataArray,  $temperatureSubject."越上上限", ($v[84 + $i] >> (4*$j) ) & 0x1, 0);
                _yd_dems_bd2_rht_ShowAlert($dataArray,  $temperatureSubject."越上限", ($v[84 + $i] >> (4*$j+1) ) & 0x1, 0);
                _yd_dems_bd2_rht_ShowAlert($dataArray,  $temperatureSubject."越下限", ($v[84 + $i] >> (4*$j +2 ) ) & 0x1, 0);
                _yd_dems_bd2_rht_ShowAlert($dataArray,  $temperatureSubject."越下下限", ($v[84 + $i] >> (4*$j + 3) ) & 0x1, 0);
            }
        }
        //119
        _yd_dems_bd2_rht_ShowAlert($dataArray, "温度模块1通讯告警", "温度模块1通讯告警", $v[120] & 0x1, 0);
        _yd_dems_bd2_rht_ShowAlert($dataArray, "温度模块6通讯告警", "温度模块6通讯告警", ($v[120] >> 5 ) &0x1, 0);

	$dataArray['列头柜总有功功率'] = floatval($dataArray['第1路进线回路基本数据']['系统有功P（kW）']) + floatval($dataArray['第2路进线回路基本数据']['系统有功P（kW）']);
        $offset += 120 * 2;
        $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $offset += 2;
        $v = unpack('C*', substr($memData, $offset, 5));
        //echo $offset+5;die;
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

?>
