<?php

function Get_yinjia_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'A相输出电流':
            return array(0, $dataArray['输出L1电流']);
        case 'B相输出电流':
            return array(0, $dataArray['输出L2电流']);
        case 'C相输出电流':
            return array(0, $dataArray['输出L3电流']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}    


function Get_yinjia_RtData($memData, &$dataArray, $extraPara = false){
        if(empty($memData)){
            $dataArray['无数据'] = true;
            $dataArray['更新时间'] = '无';
            $dataArray['错误'] = '数据长度不一致';
        }else{
            $dataArray['无数据'] = false;
            $dataArray['AlertArray'] = array();
            //充电机整流数据
            $v = unpack('S*',substr($memData, 4, 2*16));
            $dataArray['充电机1充电电压'] = ($v[1] / 10).' V';
            $dataArray['充电机1充电电流'] = ($v[2] / 10).' A';
            $dataArray['充电机1输出电压上限'] = ($v[3] / 10).' V';
            $dataArray['充电机1输出电压下限'] = ($v[4] / 10).' V';
            $dataArray['充电机2充电电压'] = ($v[5] / 10).' V';
            $dataArray['充电机2充电电流'] = ($v[6] / 10).' A';
            $dataArray['充电机2输出电压上限'] = ($v[7] / 10).' V';
            $dataArray['充电机2输出电压下限'] = ($v[8] / 10).' V';
            $dataArray['充电机3充电电压'] = ($v[9] / 10).' V';
            $dataArray['充电机3充电电流'] = ($v[10] / 10).' A';
            $dataArray['充电机3输出电压上限'] = ($v[11] / 10).' V';
            $dataArray['充电机3输出电压下限'] = ($v[12] / 10).' V';
            $dataArray['充电机4充电电压'] = ($v[13] / 10).' V';
            $dataArray['充电机4充电电流'] = ($v[14] / 10).' A';
            $dataArray['充电机4输出电压上限'] = ($v[15] / 10).' V';
            $dataArray['充电机4输出电压下限'] = ($v[16] / 10).' V';
            //电池组单体电压数据
            $v = unpack('S*',substr($memData, 4 + 2*16, 2*41));
            $dataArray['电池组1'] = array();
            for($j = 1 ; $j <= 41 ; $j++){
                $dataArray['电池组1'][$j.' 节电压'] = ($v[$j] / 100).' V';
            }
            $v = unpack('S*',substr($memData, 4 + 2*16 + 2*41, 2*41));
            $dataArray['电池组2'] = array();
            for($j = 1 ; $j <= 41 ; $j++){
                $dataArray['电池组2'][$j.' 节电压'] = ($v[$j] / 100).' V';
            }
            $v = unpack('S*',substr($memData, 4 + 2*16 + 2*82, 2*41));
            $dataArray['电池组3'] = array();
            for($j = 1 ; $j <= 41 ; $j++){
                $dataArray['电池组3'][$j.' 节电压'] = ($v[$j] / 100).' V';
            }
            $v = unpack('S*',substr($memData, 4 + 2*16 + 2*123, 2*41));
            $dataArray['电池组4'] = array();
            for($j = 1 ; $j <= 41 ; $j++){
                $dataArray['电池组4'][$j.' 节电压'] = ($v[$j] / 100).' V';
            }
            //电池组平均电压   模拟量  告警状态
            $v = unpack('S*',substr($memData, 4 + 2*16 + 2*164, 2*17));
            $dataArray['第一组电池平均电压'] = ($v[1] / 100).' V';
            $dataArray['第二组电池平均电压'] = ($v[2] / 100).' V';
            $dataArray['第三组电池平均电压'] = ($v[3] / 100).' V';
            $dataArray['第四组电池平均电压'] = ($v[4] / 100).' V';
            $dataArray['市电L1相电压'] = $v[5].' V';
            $dataArray['市电L2相电压'] = $v[6].' V';
            $dataArray['市电L3相电压'] = $v[7].' V';
            $dataArray['逆变L1相电压'] = $v[8].' V';
            $dataArray['逆变L2相电压'] = $v[9].' V';
            $dataArray['逆变L3相电压'] = $v[10].' V';
            $dataArray['输出L1相电压'] = $v[11].' V';
            $dataArray['输出L2相电压'] = $v[12].' V';
            $dataArray['输出L3相电压'] = $v[13].' V';
            $dataArray['输出L1电流'] = ($v[14] / 10).' A';
            $dataArray['输出L2电流'] = ($v[15] / 10).' A';
            $dataArray['输出L3电流'] = ($v[16] / 10).' A';
            $dataArray['市电状态'] = ($v[17] & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['市电状态'] = ($v[17] & 0x1) == 1;
            $dataArray['逆变状态'] = (($v[17] >> 1) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['逆变状态'] = (($v[17] >> 1) & 0x1) == 1;
            $dataArray['负载位置'] = (($v[17] >> 2) & 0x1) == 1 ? '应急' : '市电';
            $dataArray['负载应急'] = (($v[17] >> 2) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['负载应急'] = (($v[17] >> 2) & 0x1) == 1;
            $dataArray['电池状态'] = (($v[17] >> 3) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['电池状态'] = (($v[17] >> 3) & 0x1) == 1;
            $dataArray['充电器状态'] = (($v[17] >> 4) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['充电器状态'] = (($v[17] >> 4) & 0x1) == 1;
            $dataArray['电池检测1通讯状态'] = (($v[17] >> 5) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['电池检测1通讯状态'] = (($v[17] >> 5) & 0x1) == 1;
            $dataArray['电池检测2通讯状态'] = (($v[17] >> 6) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['电池检测2通讯状态'] = (($v[17] >> 6) & 0x1) == 1;
            $dataArray['电池检测3通讯状态'] = (($v[17] >> 7) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['电池检测3通讯状态'] = (($v[17] >> 7) & 0x1) == 1;
            $dataArray['电池检测4通讯状态'] = (($v[17] >> 8) & 0x1) == 1 ? '告警' : '正常';
            $dataArray['AlertArray']['电池检测4通讯状态'] = (($v[17] >> 8) & 0x1) == 1;
            $v = unpack('v', substr($memData, 4 + 2*16 + 2*164 + 2*17, 2));
            $year = $v[1];
            $v = unpack('C*', substr($memData, 4 + 2*16 + 2*164 + 2*17 +2, 5));
            $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
        }
}
