<?php

function _ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}
function Get_zhm15m_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $v = unpack('S*', substr($memData, 4, 2*19));
        $dataArray["输入1路交流A相电压"] = number_format($v[1]/100, 2)."V";
        $dataArray["输入1路交流B相电压"] = number_format($v[2]/100, 2)."V";
        $dataArray["输入1路交流C相电压"] = number_format($v[3]/100, 2)."V";
        $dataArray["输入2路交流A相电压"] = number_format($v[4]/100, 2)."V";
        $dataArray["输入2路交流B相电压"] = number_format($v[5]/100, 2)."V";
        $dataArray["输入2路交流C相电压"] = number_format($v[6]/100, 2)."V";

        $dataArray["输入1路交流A相电流"] = number_format($v[7]/100, 2)."A";
        $dataArray["输入2路交流B相电流"] = number_format($v[8]/100, 2)."A";
        $dataArray["输入3路交流C相电流"] = number_format($v[9]/100, 2)."A";
        $dataArray["输入1路交流A相电流"] = number_format($v[10]/100, 2)."A";
        $dataArray["输入2路交流B相电流"] = number_format($v[11]/100, 2)."A";
        $dataArray["输入3路交流C相电流"] = number_format($v[12]/100, 2)."A";

        $dataArray["输出汇流排电压"] = number_format($v[1]/100, 2)."V";
        $dataArray["模块输出总电流"] = number_format($v[2]/100, 2)."V";
        $dataArray["负载总电流"] = number_format($v[3]/100, 2)."A";
        $dataArray["电池总电流"] = number_format($v[4]/100, 2)."A";
        $dataArray["系统总功率"] = number_format($v[5]/100, 2)."kW";
        $dataArray["电池温度"] = number_format($v[6]/100, 2)."℃";
        $dataArray["环境温度"] = number_format($v[6]/100, 2)."℃";

        for($i=0; $i<24; $i++){
            $v = unpack('S*', substr($memData, 4 + 2*19 + 2*7*$i, 2*7));
            $dataArray[($i+1)."#整流器机号"] = $v[1] << 16 | $v[2];
            $dataArray[($i+1)."#整流器输出电压"] = number_format($v[3]/100, 2)."V";
            $dataArray[($i+1)."#整流器输出电流"] = number_format($v[4]/100, 2)."A";
            $dataArray[($i+1)."#整流器温度"] = number_format($v[5], 2)."℃";
            
            $dataArray[($i+1)."#整流器运行状态"] = $v[6] == 0 ? "正常" : "故障";
            switch($v[7])
            {
                case 0:
                    $dataArray[($i+1)."#整流器开关状态"] = "开机";
                    break;
                case 1:
                    $dataArray[($i+1)."#整流器开关状态"] = "关机";
                    break;
                case 2:
                    $dataArray[($i+1)."#整流器开关状态"] = "休眠关机";
                    break;
            }
        }
        for($i=0; $i<4; $i++){
            $v = unpack('S*', substr($memData, 4 + 2*19 + 2*7*24 + 2*24*$i, 2*24));
            for($j=1;$j<24;$j++)
            {
                $dataArray[($i+1).'#电池组'.$j.'节电池电压'] = number_format($v[$j]/1000, 3)."V";
            }
        }

        $v = unpack('S*', substr($memData, 4 + 2*19 + 2*7*24 + 2*24*4, 2*30));
        $dataArray["均充"] = $v[1] & 0x1 == 1 ? "是" : "否";
        $dataArray["电池测试"] = ($v[1] >> 1) & 0x1 == 1 ? "是" : "否";
        $dataArray["电池限流"] = ($v[1] >> 2) & 0x1 == 1 ? "是" : "否";
        $dataArray["整流器休眠"] = ($v[1] >> 3) & 0x1 == 1 ? "是" : "否";
        $dataArray["整流器限流"] = ($v[1] >> 4) & 0x1 == 1 ? "是" : "否";
        
        _ShowAlert($dataArray, "交流故障", (($v[2] >> 0) & 0x1), 0);
        _ShowAlert($dataArray, "交流输入高", (($v[2] >> 1) & 0x1), 0);
        _ShowAlert($dataArray, "交流输入低", (($v[2] >> 2) & 0x1), 0);
        _ShowAlert($dataArray, "负载高压", (($v[2] >> 3) & 0x1), 0);
        _ShowAlert($dataArray, "负载低压", (($v[2] >> 4) & 0x1), 0);
        _ShowAlert($dataArray, "单个整流器故障", (($v[2] >> 5) & 0x1), 0);
        _ShowAlert($dataArray, "多个整流器故障", (($v[2] >> 6) & 0x1), 0);
        _ShowAlert($dataArray, "单个整流器通信丢失", (($v[2] >> 7) & 0x1), 0);
        _ShowAlert($dataArray, "多个整流器通信丢失", (($v[2] >> 8) & 0x1), 0);
        _ShowAlert($dataArray, "整流器过温", (($v[2] >> 9) & 0x1), 0);
        _ShowAlert($dataArray, "所有整流器关闭", (($v[2] >> 10) & 0x1), 0);
        _ShowAlert($dataArray, "电池测试失败", (($v[2] >> 11) & 0x1), 0);
        _ShowAlert($dataArray, "单体电池高电压", (($v[2] >> 12) & 0x1), 0);
        _ShowAlert($dataArray, "单体电池低电压", (($v[2] >> 13) & 0x1), 0);

        _ShowAlert($dataArray, "LVD1断开", (($v[3] >> 0) & 0x1), 0);
        _ShowAlert($dataArray, "LVD2断开", (($v[3] >> 1) & 0x1), 0);
        _ShowAlert($dataArray, "LVD3断开", (($v[3] >> 2) & 0x1), 0);
        _ShowAlert($dataArray, "LVD4断开", (($v[3] >> 3) & 0x1), 0);
        _ShowAlert($dataArray, "LVD5断开", (($v[3] >> 4) & 0x1), 0);
        _ShowAlert($dataArray, "LVD1故障", (($v[3] >> 5) & 0x1), 0);
        _ShowAlert($dataArray, "LVD2故障", (($v[3] >> 6) & 0x1), 0);
        _ShowAlert($dataArray, "LVD3故障", (($v[3] >> 7) & 0x1), 0);
        _ShowAlert($dataArray, "LVD4故障", (($v[3] >> 8) & 0x1), 0);
        _ShowAlert($dataArray, "LVD5故障", (($v[3] >> 9) & 0x1), 0);

        _ShowAlert($dataArray, "电压传感器故障", (($v[4] >> 0) & 0x1), 0);
        _ShowAlert($dataArray, "电流传感器故障", (($v[4] >> 1) & 0x1), 0);
        _ShowAlert($dataArray, "电池温度传感器故障", (($v[4] >> 2) & 0x1), 0);
        _ShowAlert($dataArray, "环境温度传感器故障", (($v[4] >> 3) & 0x1), 0);
        _ShowAlert($dataArray, "电池温度低", (($v[4] >> 4) & 0x1), 0);
        _ShowAlert($dataArray, "电池温度高", (($v[4] >> 5) & 0x1), 0);
        _ShowAlert($dataArray, "环境温度低", (($v[4] >> 6) & 0x1), 0);
        _ShowAlert($dataArray, "环境温度高", (($v[4] >> 7) & 0x1), 0);
        _ShowAlert($dataArray, "数字量输入1", (($v[4] >> 8) & 0x1), 0);
        _ShowAlert($dataArray, "数字量输入2", (($v[4] >> 9) & 0x1), 0);
        _ShowAlert($dataArray, "数字量输入3", (($v[4] >> 10) & 0x1), 0);
        _ShowAlert($dataArray, "数字量输入4", (($v[4] >> 11) & 0x1), 0);
        _ShowAlert($dataArray, "数字量输入5", (($v[4] >> 12) & 0x1), 0);
        _ShowAlert($dataArray, "数字量输入6", (($v[4] >> 13) & 0x1), 0);

        _ShowAlert($dataArray, "电池熔丝故障", (($v[5] >> 0) & 0x1), 0);
        _ShowAlert($dataArray, "负载熔丝故障", (($v[5] >> 1) & 0x1), 0);
        _ShowAlert($dataArray, "MOV故障", (($v[5] >> 2) & 0x1), 0);
        _ShowAlert($dataArray, "ACD风扇故障", (($v[5] >> 3) & 0x1), 0);
        _ShowAlert($dataArray, "输入故障", (($v[5] >> 4) & 0x1), 0);
        _ShowAlert($dataArray, "交流采样盒1丢失", (($v[5] >> 5) & 0x1), 0);
        _ShowAlert($dataArray, "交流采样盒2丢失", (($v[5] >> 6) & 0x1), 0);

        _ShowAlert($dataArray, "电池盒1丢失", (($v[5] >> 8) & 0x1), 0);
        _ShowAlert($dataArray, "电池盒2丢失", (($v[5] >> 9) & 0x1), 0);
        _ShowAlert($dataArray, "电池盒3丢失", (($v[5] >> 10) & 0x1), 0);
        _ShowAlert($dataArray, "电池盒4丢失", (($v[5] >> 11) & 0x1), 0);
        _ShowAlert($dataArray, "电池盒5丢失", (($v[5] >> 12) & 0x1), 0);
        _ShowAlert($dataArray, "电池盒6丢失", (($v[5] >> 13) & 0x1), 0);
        _ShowAlert($dataArray, "电池盒7丢失", (($v[5] >> 14) & 0x1), 0);
        _ShowAlert($dataArray, "电池盒8丢失", (($v[5] >> 15) & 0x1), 0);

        _ShowAlert($dataArray, "PSIB盒1丢失", (($v[6] >> 0) & 0x1), 0);
        _ShowAlert($dataArray, "PSIB盒2丢失", (($v[6] >> 1) & 0x1), 0);
        _ShowAlert($dataArray, "PSIB盒3丢失", (($v[6] >> 2) & 0x1), 0);
        _ShowAlert($dataArray, "PSIB盒4丢失", (($v[6] >> 3) & 0x1), 0);
        _ShowAlert($dataArray, "PSIB盒5丢失", (($v[6] >> 4) & 0x1), 0);
        _ShowAlert($dataArray, "PSIB盒6丢失", (($v[6] >> 5) & 0x1), 0);
        _ShowAlert($dataArray, "PSIB盒7丢失", (($v[6] >> 6) & 0x1), 0);
        _ShowAlert($dataArray, "PSIB盒8丢失", (($v[6] >> 7) & 0x1), 0);
        //空开脱扣告警
        for($i=0; $i<16; $i++)
        {
            _ShowAlert($dataArray, "空开".($i+1)."脱扣", (($v[7] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(16 + $i+1)."脱扣", (($v[8] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(32 + $i+1)."脱扣", (($v[9] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(48 + $i+1)."脱扣", (($v[10] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(64 + $i+1)."脱扣", (($v[11] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(80 + $i+1)."脱扣", (($v[12] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(96 + $i+1)."脱扣", (($v[13] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(112 + $i+1)."脱扣", (($v[14] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(128 + $i+1)."脱扣", (($v[15] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(144 + $i+1)."脱扣", (($v[16] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(160 + $i+1)."脱扣", (($v[17] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(176 + $i+1)."脱扣", (($v[18] >> $i) & 0x1), 0);

            _ShowAlert($dataArray, "空开".($i+1)."断开", (($v[19] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(16 + $i+1)."断开", (($v[20] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(32 + $i+1)."断开", (($v[21] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(48 + $i+1)."断开", (($v[22] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(64 + $i+1)."断开", (($v[23] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(80 + $i+1)."断开", (($v[24] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(96 + $i+1)."断开", (($v[25] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(112 + $i+1)."断开", (($v[26] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(128 + $i+1)."断开", (($v[27] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(144 + $i+1)."断开", (($v[28] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(160 + $i+1)."断开", (($v[29] >> $i) & 0x1), 0);
            _ShowAlert($dataArray, "空开".(176 + $i+1)."断开", (($v[30] >> $i) & 0x1), 0);
        }

        $v = unpack('v', substr($memData, 4 + 2*19 + 2*7*24 + 2*24*4 + 2*30, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 2*19 + 2*7*24 + 2*24*4 + 2*30 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
