<?php

function Get_zmdoc_RtData($memData, &$dataArray, $extraPara = false){
    if(empty($memData)){
        $dataArray["无数据"] = true;
        $dataArray["更新时间"] = '无';
        $dataArray["错误"] = "数据长度不一致";
    }else{
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('f*',substr($memData, 4 , 20));
        $dataArray['电压'] = number_format($v[1], 2).' V';
        $dataArray['频率'] = number_format($v[2], 2).' Hz';
        $dataArray['电流'] = number_format($v[3], 2).' A';
        $dataArray['有功功率'] = number_format($v[4]/1000, 2).' KW';
        $dataArray['无功功率'] = $v[5].' W';

        $v = unpack('S',substr($memData, 4 + 20, 2));
        $dataArray['功率因素'] = $v[1].' %';

        $v = unpack('f*',substr($memData, 4 + 20 + 2, 4*2));
        $dataArray['有功电能'] = $v[1].' WH';
        $dataArray['无功电能'] = $v[2].' WH';

        $v = unpack('v', substr($memData, 24 + 2 + 4*2 , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 24 +2 + 4*2 +2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    }
}
?>
