<?php
function _znvbm41_2ac_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

function Get_znvbm41_DeviceIoControl_Parameter($action, $parameter)
{
    switch($action)
    {
        case 2://START_RESIST
        {
            return "";
        }
        default:
            return "";
    }
}
function Get_znvbm41_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
        /* $dataObj->isEmpty = true;
        $dataObj->update_datetime = '无'; */
    } else {
        $dataArray["无数据"] = false;
        $dataArray['AlertArray'] = array();
        $v = unpack('S*', substr($memData, 4, 2*120));
        $vIndex = 1;
        for($i=1; $i<=120; $i++)
        {
            $dataArray["电池".$i."电压"] = number_format($v[$vIndex++]/1000, 3).'V';   
        }
        $v = unpack('S*', substr($memData, 4 + 2*120, 2*120));
        $vIndex = 1;
        for($i=1; $i<=120; $i++)
        {
            $dataArray["电池".$i."内阻"] = $v[$vIndex++].'uΩ';   
        }
        $v = unpack('S*', substr($memData, 4 + 2*120 + 2*120, 2*120));
        $vIndex = 1;
        for($i=1; $i<=120; $i++)
        {
            $dataArray["电池".$i."温度"] = number_format($v[$vIndex++]/10 - 50, 3).'℃';   
        }
        $v = unpack('S*', substr($memData, 4 + 2*120 + 2*120 + 2*120, 2*120));
        $vIndex = 1;
        for($i=1; $i<=120; $i++)
        {
            $dataArray["电池".$i."soc"] =  $v[$vIndex++]."%";   
        }
        $v = unpack('S*', substr($memData, 4 + 2*120 + 2*120 + 2*120 + 2*120, 2*120));
        $vIndex = 1;
        for($i=1; $i<=120; $i++)
        {
            $s = "";
            if($v[$vIndex] & 0x1)
            {
                $s .= "单体电压高;";
            }
            if( ($v[$vIndex] >> 1) & 0x1 )
            {
                $s .= "单体电压低";
            }
            if( ($v[$vIndex] >> 2) & 0x1 )
            {
                $s .= "单体内阻低";
            }
            if( ($v[$vIndex] >> 3) & 0x1 )
            {
                $s .= "单体内阻低";
            }
            if( ($v[$vIndex] >> 4) & 0x1 )
            {
                $s .= "电池温度高";
            }
            if( ($v[$vIndex] >> 5) & 0x1 )
            {
                $s .= "电池温度低";
            }
            if( ($v[$vIndex] >> 6) & 0x1 )
            {
                $s .= "单体SOC低";
            }
            if( ($v[$vIndex] >> 7) & 0x1 )
            {
                $s .= "单体电压不均";
            }
            if( ($v[$vIndex] >> 8) & 0x1 )
            {
                $s .= "单体内阻不均 ";
            }
            if( ($v[$vIndex] >> 9) & 0x1 )
            {
                $s .= "单体温度不均 ";
            }
            if( ($v[$vIndex] >> 10) & 0x1 )
            {
                $s .= "电压模块通信故障 ";
            }
            if( ($v[$vIndex] >> 11) & 0x1 )
            {
                $s .= "电池温度传感器故障 ";
            }
            if( ($v[$vIndex] >> 12) & 0x1 )
            {
                $s .= "内阻测试电压异常 ";
            }
            if( ($v[$vIndex] >> 13) & 0x1 )
            {
                $s .= "内阻测试电流异常 ";
            } 
            $vIndex++;
            if(empty($s)){
                $dataArray["电池".$i."报警状态"]  =  '正常';   
            }else{
                $dataArray["电池".$i."报警状态"]  =  $s;   
                $dataArray['AlertArray']["电池".$i."报警状态"]  = 1;
            }   
        }
        $v = unpack('S*', substr($memData, 4 + 2*120 + 2*120 + 2*120 + 2*120 + 2*120, 2*2));
        _znvbm41_2ac_ShowAlert($dataArray, "组压高", $v[1] & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "组压低",  ( $v[1] >> 1) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "充电电流大",  ( $v[1] >> 2) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "放电电流大",  ( $v[1] >> 3) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "环境温度高",  ( $v[1] >> 4) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "环境温度低",  ( $v[1] >> 5) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "SOC低",  ( $v[1] >> 6) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "组压模块通信",  ( $v[1] >> 7) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "充放电电流模块通信",  ( $v[1] >> 8) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "环境温度模块通信",  ( $v[1] >> 9) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "环境温度传感器1故障",  ( $v[1] >> 10) & 0x1, 0);
        _znvbm41_2ac_ShowAlert($dataArray, "环境温度传感器2故障",  ( $v[1] >> 11) & 0x1, 0);
        
        $v = unpack("f",substr($memData, 4 + 2*120 + 2*120 + 2*120 + 2*120 + 2*120 + 2*2, 4));
        $dataArray["整组电压"] = number_format($v[1], 3).'V';
        $v = unpack('v', substr($memData, 4 + 2*120 + 2*120 + 2*120 + 2*120 + 2*120+ 2*2 + 4, 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, 4 + 2*120 + 2*120 + 2*120 + 2*120 + 2*120+2*2 + 4 + 2, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}


?>
