<?php
function Get_znvh3ga0_Size()
{
    return 1257;
}

function Get_znvh3ga0_RtData($memData, &$dataArray, $extraPara = false)
{
    if (empty($memData)) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $offset = 4;
        //05eb
        $v = unpack("S*", substr($memData, $offset, 121 * 2));
        $dataArray['电池报警状态-总'] = $v[1];
        for ($i = 1; $i < 122; $i++) {
            $dataArray[$i . '#电压模块通信'] = ($v[$i + 1] >> 0) & 0x1 == 1 ? '告警' : '正常';
            $dataArray['AlertArray'][$i . '#电压模块通信'] = ($v[$i + 1] >> 0) & 0x1 == 1;

            $dataArray[$i . '#单体电压低'] = ($v[$i + 1] >> 1) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#单体电压低'] = ($v[$i + 1] >> 1) & 0x1 == 1;

            $dataArray[$i . '#单体电压高'] = ($v[$i + 1] >> 2) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#单体电压高'] = ($v[$i + 1] >> 2) & 0x1 == 1;

            $dataArray[$i . '#内阻模块通信'] = ($v[$i + 1] >> 3) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#内阻模块通信'] = ($v[$i + 1] >> 3) & 0x1 == 1;

            $dataArray[$i . '#单体内阻高'] = ($v[$i + 1] >> 4) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#单体内阻高'] = ($v[$i + 1] >> 4) & 0x1 == 1;

            $dataArray[$i . '#连接条电阻'] = ($v[$i + 1] >> 5) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#连接条电阻'] = ($v[$i + 1] >> 5) & 0x1 == 1;

            $dataArray[$i . '#连接条电阻'] = ($v[$i + 1] >> 5) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#连接条电阻'] = ($v[$i + 1] >> 5) & 0x1 == 1;

            switch (($v[$i + 1] >> 6) & 0x3) {
                case 0:
                    $dataArray[$i . '#内阻故障'] = "正常";
                    break;
                case 1:
                    $dataArray[$i . '#内阻故障'] = "电压超限";
                    break;
                case 2:
                    $dataArray[$i . '#内阻故障'] = "放电流超限";
                    break;
                case 3:
                    $dataArray[$i . '#内阻故障'] = "浮充电流超限";
                    break;
                default:
                    $dataArray[$i . '#内阻故障'] = "无效数值";
                    break;
            }

            $dataArray[$i . '#电池温度通信'] = ($v[$i + 1] >> 8) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#电池温度通信'] = ($v[$i + 1] >> 8) & 0x1 == 1;

            $dataArray[$i . '#电池温度高'] = ($v[$i + 1] >> 9) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#电池温度高'] = ($v[$i + 1] >> 9) & 0x1 == 1;

            $dataArray[$i . '#电池温度传感器故障'] = ($v[$i + 1] >> 10) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#电池温度传感器故障'] = ($v[$i + 1] >> 10) & 0x1 == 1;

            $dataArray[$i . '#单体电压不均'] = ($v[$i + 1] >> 13) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#单体电压不均'] = ($v[$i + 1] >> 13) & 0x1 == 1;

            $dataArray[$i . '#电池温度不均'] = ($v[$i + 1] >> 14) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#电池温度不均'] = ($v[$i + 1] >> 14) & 0x1 == 1;

            $dataArray[$i . '#内阻值不均'] = ($v[$i + 1] >> 15) & 0x1 == 1 ? "告警" : "正常";
            $dataArray['AlertArray'][$i . '#内阻值不均'] = ($v[$i + 1] >> 15) & 0x1 == 1;
        }

        //0718
        $offset += 121 * 2;
        $v = unpack("S*", substr($memData, $offset, 17 * 2));
        $dataArray['组压'] = number_format($v[1]/10, 2) . ' V';
        if( ($v[2] >> 15) & 0x1 ){
            $val = 0- $v[2] & 0x7FFF;
            $dataArray['充放电电流'] = number_format($val, 2) . ' A';
        }else{
            $dataArray['充放电电流'] = number_format($v[2], 2) . ' A';
        }
        
        $dataArray['充放电电流补码'] = $v[3];
        $dataArray['浮充电流'] = number_format($v[4], 2) . ' A';
        $dataArray["环境温度1"] = number_format($v[5]/10, 2) . ' ℃';
        $dataArray["环境温度2"] = number_format($v[6]/10, 2) . ' ℃';
        $dataArray["最高电压电池号"] = $v[7];
        $dataArray["最低电压电池号"] = $v[8];
        $dataArray["最高内阻电池号"] = $v[9];
        $dataArray["电池电压均差值"] = number_format($v[10], 2) . ' mV';
        $dataArray["电池电压极差值"] = number_format($v[11], 2) . ' mV';
        $dataArray["按最低电池整组SOH/SOC"] = $v[12];
        $dataArray["按最低电池整组带载时间"] = $v[13] . ' 分钟';
        $dataArray["按组压整组SOH/SOC"] = $v[14];
        $dataArray["按组压整组带载时间"] = $v[15] . ' 分钟';

        $dataArray['组压模块通信'] = $v[17] & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['组压模块通信'] = $v[17] & 0x1 == 1;

        $dataArray['组压低'] = ($v[17] >> 1) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['组压低'] = ($v[17] >> 1) & 0x1 == 1;

        $dataArray['组压高'] = ($v[17] >> 2) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['组压高'] = ($v[17] >> 2) & 0x1 == 1;

        $dataArray['充放电流模块通信'] = ($v[17] >> 3) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['充放电流模块通信'] = ($v[17] >> 3) & 0x1 == 1;

        $dataArray['充放电流超限'] = ($v[17] >> 4) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['充放电流超限'] = ($v[17] >> 4) & 0x1 == 1;

        $dataArray['浮充电流模块通信'] = ($v[17] >> 5) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['浮充电流模块通信'] = ($v[17] >> 5) & 0x1 == 1;

        $dataArray['浮充电流超限'] = ($v[17] >> 6) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['浮充电流超限'] = ($v[17] >> 6) & 0x1 == 1;

        $dataArray['环境温度模块通信'] = ($v[17] >> 7) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['环境温度模块通信'] = ($v[17] >> 7) & 0x1 == 1;

        $dataArray['环境温度1超限'] = ($v[17] >> 8) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['环境温度1超限'] = ($v[17] >> 8) & 0x1 == 1;

        $dataArray['环境温度1传感器'] = ($v[17] >> 9) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['环境温度1传感器'] = ($v[17] >> 9) & 0x1 == 1;

        $dataArray['环境温度2超限'] = ($v[17] >> 10) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['环境温度2超限'] = ($v[17] >> 10) & 0x1 == 1;

        $dataArray['环境温度2传感器'] = ($v[17] >> 11) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['环境温度2传感器'] = ($v[17] >> 11) & 0x1 == 1;

        $dataArray['按最低电池整组SOC低'] = ($v[17] >> 12) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['按最低电池整组SOC低'] = ($v[17] >> 12) & 0x1 == 1;

        $dataArray['按组压整组SOH低'] = ($v[17] >> 13) & 0x1 == 1 ? "告警" : "正常";
        $dataArray['AlertArray']['按组压整组SOH低'] = ($v[17] >> 13) & 0x1 == 1;

        //0774
        $offset += 17 * 2;
        $v = unpack("S*", substr($memData, $offset, 2));
        switch ($v[1]) {
            case 0:
                $dataArray['电池状态'] = '浮充';
                break;
            case 1:
                $dataArray['电池状态'] = '放电';
                break;
            case 2:
                $dataArray['电池状态'] = '充电';
                break;
            default:
                $dataArray['电池状态'] = '未定义';
                break;
        }

        //fba1
        $offset += 2 + 2;
        //fa00
        $offset += 3 * 2;

        //0003
        $v = unpack("S*", substr($memData, $offset, 120 * 2));
        for ($i = 1; $i < 121; $i++) {
            $dataArray[$i . '#单体电压'] = number_format($v[$i]/1000, 2) . ' V';
        }

        //0132
        $offset += 120 * 2;
        $v = unpack("S*", substr($memData, $offset, 120 * 2));
        for ($i = 1; $i < 121; $i++) {
            $dataArray[$i . '#单体内阻'] = number_format($v[$i]/1000, 2);
        }

        //038d
        $offset += 120 * 2;
        $v = unpack("S*", substr($memData, $offset, 120 * 2));
        for ($i = 1; $i < 121; $i++) {
            $dataArray[$i . '#电池温度'] = number_format($v[$i]/10,2);
        }

        //04bc
        $offset += 120 * 2 + 60 * 2;

        //0555
        $offset += 60 * 2;

        $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $offset += 2;
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}
