<?php

function Get_zxdu300_500_419_UnicomCategory()
{
    return "419";
}

function Get_zxdu300_500_419_config()
{
    $config = array(
	"ac" => array(
                        "airlock" => 0, "p40_43" => 4, "p40_41" => 0, "p40_44" => 3,
                        'p40_41_label' => array(''),
                        'p40_43_label' => array("交流输入空开1断" => true, "交流输入空开2断" => true, "交流辅助输出开关断" => true, "系统供电状态" => true),
                        'p40_43_rules' => array(
                                0 => array(array(0 => "闭合", 1 => "断开"), "无效状态"), 1 => array(array(0 => "闭合", 1 => "断开"), "无效状态"),
                                2 => array(array(0 => "闭合", 1 => "断开"), "无效状态"), 3 => array(array(0 => "市电1", 1 => "市电2(油机)", 2 => "电池"), "无效状态")
                        ),
                        'p40_44_label' => array("整流器输入主空开" => true, "停电" => true, "防雷器坏" => true),
                        'p40_44_rules' => array(
                                0 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "缺项", 4 => "熔丝断", 5 => "开关断开或损坏", 0xe0 => "停电", 0xe1 => "防雷器坏/空开断", 0xFF => "其他故障"), "无效"),
                                1 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "缺项", 4 => "熔丝断", 5 => "开关断开或损坏", 0xe0 => "停电", 0xe1 => "防雷器坏/空开断", 0xFF => "其他故障"), "无效"),
                                2 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "缺项", 4 => "熔丝断", 5 => "开关断开或损坏", 0xe0 => "停电", 0xe1 => "防雷器坏/空开断", 0xFF => "其他故障"), "无效"),
                        )
                ),
                "rc" => array(
                        "p42_46" => 14, "p42_46_size" => 56, "p41_41" => 0, "p41_43" => 1, "p41_44" => 0,
                        'p41_41_label' => array(),
                        'p41_43_label' => array("在位状态" => true),
                        'p41_43_rules' => array(0 => array(array(0x0 => "非在位", 0x01 => "在位"), "无效")),
                        'p41_44_label' => array()
                ),
                "dc" => array(
                        "m" => 3, "n" => 0, "p" => 6, "alert_m" => 20, "alert_p" => 11,
                        "p_label" => array("电池1温度" => true, "电池1电压" => true, "电池2温度" => true, "电池2电压" => true, "电池3温度" => true, "电池3电压" => true),
                        "alert_p_label" => array("一次下电" => true, "二次下电" => true, "电池1熔丝断" => true, "电池1电压低" => true, "电池1温度高" => true, "电池2熔丝断" => true, "电池2电压低" => true, "电池2温度高" => true, "电池3熔丝断" => true, "电池3电压低" => true, "电池3温度高" => true),
	                "alert_p_rules" => array(
                        0 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        1 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        2 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        3 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        4 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        5 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        6 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        7 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        8 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        9 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                        10 => array(array(0 => "正常", 1 => "低于下限", 2 => "高于上限", 3 => "熔丝断", 4 => "开关断开", 0xe1 => "防雷器坏/空开断", 0xF0 => "一次下电", 0xF1 => "二次下电", 0xF2 => "回路异常"), "无效"),
                	)
		)
    );
    return $config;
}

function Get_zxdu300_500_419_RtData($memData,&$dataArray,$extraPara = false) {
	if (!$memData) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {       
        $dataArray['无数据'] = false;
        $config = Get_zxdu300_500_419_config();
        require_once "./application/helpers/device/pmbuspower_419.php";
        _Get_PMBusPower_RtData($memData, $dataArray, $extraPara, $config);
    }
}


?>
