<?php

function Get_zxdu68_419_UnicomCategory()
{
    return "419";
}


function Get_zxdu68_419_config()
{
    $config = array("ac" => array(
        "airlock" => 1, "p40_43" => 1, "p40_41" => 0, "p40_44" => 5,
        "p40_41_label" => array(),
        "p40_43_label" => array("系统供电状态"=>true),
        "p40_43_rules" => array(0=>array(array(0=>"市电1/AC1",1=>"市电2(油机)/AC2(GEN)", 2=>"电池/BATT"),"无效状态")),
        "p40_44_label" => array("交流输出空开断"=>true,"交流防雷器异常"=>true,"交流1输入空开断"=>true,"交流停电"=>false,"交流2输入空开断"=>true),
        "p40_44_rules" => array(
                        0=>array(array(0=>"正常", 1=>"低于下限", 2=>"高于上限", 3=>"缺项",4=>"熔丝断", 5=>"开关断开或损坏",0xe0=>"停电", 0xe1=>"防雷器坏/空开断", 0xFF=>"其他故障"),"无效"),
                        1=>array(array(0=>"正常", 1=>"低于下限", 2=>"高于上限", 3=>"缺项",4=>"熔丝断", 5=>"开关断开或损坏",0xe0=>"停电", 0xe1=>"防雷器坏/空开断", 0xFF=>"其他故障"),"无效"),
                        2=>array(array(0=>"正常", 1=>"低于下限", 2=>"高于上限", 3=>"缺项",4=>"熔丝断", 5=>"开关断开或损坏",0xe0=>"停电", 0xe1=>"防雷器坏/空开断", 0xFF=>"其他故障"),"无效"),
                        3=>array(array(0=>"正常", 1=>"低于下限", 2=>"高于上限", 3=>"缺项",4=>"熔丝断", 5=>"开关断开或损坏",0xe0=>"停电", 0xe1=>"防雷器坏/空开断", 0xFF=>"其他故障"),"无效"),
                        4=>array(array(0=>"正常", 1=>"低于下限", 2=>"高于上限", 3=>"缺项",4=>"熔丝断", 5=>"开关断开或损坏",0xe0=>"停电", 0xe1=>"防雷器坏/空开断", 0xFF=>"其他故障"),"无效")),
        "ia_support" => true, "ib_support" => true, "ic_support" => true,
        "ia_alert_support" => true, "ib_alert_support" => true, "ic_alert_support" => true
    ),
    "rc" => array( 
        "p42_46" => 32, "p42_46_size" => 128, "p41_41" => 1, "p41_43" => 0, "p41_44" => 1,
        'p41_41_label' => array('温度'=>true),
        "p41_43_label" => array(),
        "p41_43_rules" => array(),
        "p41_44_label" => array("模块通讯故障" => true),
        'p41_44_rules' => array( 0 => array(array(0=>"正常", 1=>"通讯断"), "无效")
        ),
        'params' => array()
    ),
    "dc" => array(
        "m" => 4, "n" => 0, "p" => 10, "alert_m" => 4, "alert_p" => 46,
        "p_label" => array('电池1温度' => true, '电池1电压' => true, "电池1实时容量百分比" => true, '电池2温度' => true, '电池2电压' => true, "电池2实时容量百分比" => true,'电池3温度' => true, '电池3电压' => true, "电池3实时容量百分比" => true,'电池4温度' => true, '电池4电压' => true, "电池4实时容量百分比" => true),
        "alert_p_label" => array(),
        "alert_p_rules" => array()
    ));
    return $config;
}

function Get_zxdu68_419_RtData($memData,&$dataArray,$extraPara = false) {
    if (!$memData) {
	$dataArray['无数据'] = true;
	$dataArray['更新时间'] = '无';
	$dataArray['错误'] = '数据长度不一致';
    } else {       
        $dataArray['无数据'] = false;
        $config = Get_zxdu68_419_config();
        require_once "./application/helpers/device/pmbuspower_419.php";
        _Get_PMBusPower_RtData($memData, $dataArray, $extraPara, $config);
    }
}


?>
