<?php


function Get_ruipu_ups_RtData($memData, &$dataArray, $extraPara = false)
{
    if (strlen($memData) == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    } else {
        $dataArray['无数据'] = false;
        $offset = 4;
	$v = unpack('f*', substr($memData, 4, 4*5));
	$dataArray["输入电压"] = number_format($v[1], 1)."V";
	$dataArray["输入频率"] = number_format($v[2], 1)."Hz";
	$dataArray["输出电压"] = number_format($v[3], 1)."V";
	$dataArray["输出频率"] = number_format($v[4], 1)."Hz";
	$dataArray["输出电流"] = number_format($v[5], 1)."A";
	
	$offset += 4*5;
	$v = unpack('I*', substr($memData, $offset, 4));
	$dataArray["输出负载百分比"] = $v[1]."%";

	$offset += 4;	
	$v = unpack('f*', substr($memData, $offset, 4*5));
        $dataArray["正总线电压"] = number_format($v[1], 1)."V";
        $dataArray["负总线电压"] = number_format($v[2], 1)."V";
        $dataArray["P电池电压"] = number_format($v[3], 1)."V";
        $dataArray["N电池电压"] = number_format($v[4], 1)."V";
        $dataArray["检测指针的最高温度"] = number_format($v[5], 1)."°C";

	$offset += 4*5;
	$ss = substr($memData, $offset , 12);
	$s = substr($ss, 0, 2);
	$status = [];
	if(strcmp($s, "00") == 0)
	{
	    $status[] = "待机";
	}else if(strcmp($s, "01") == 0)
        {
	    $status[] = "在线互动式";
	}else if(strcmp($s, "10") == 0)
        {
            $status[] = "在线式";
        }else{
            $status[] = "未知状态";
	}
	if($ss[2]){
            $status[] = "市电异常";
	}
	if($ss[3]){
            $status[] = "电池电量低";
	}
	if($ss[4]){
            $status[] = "旁路使能";
	}
	if($ss[5]){
            $status[] = "UPS故障";
        }
	if($ss[6]){
            $status[] = "紧急关机";
        }
	if($ss[7]){
            $status[] = "测试";
        }
	if($ss[8]){
            $status[] = "掉电";
        }
	if($ss[9]){
            $status[] = "电池报警";
        }
	if($ss[10]){
            $status[] = "电池自检失败";
        }
	if($ss[11]){
            $status[] = "电池自检OK";
        }
	$dataArray["UPS状态"] = join(",", $status);
	$offset += 12;
	$v = unpack("I", substr($memData, $offset, 4));
	if($v[1] == 0){
	    $dataArray["故障名称"] = '';
	    $dataArray["故障前的输入电压"] = '';
	    $dataArray["故障前的输入频率"] = '';
	    $dataArray["故障前的输出电压"] = '';
	    $dataArray["故障前的输出频率"] = '';
	    $dataArray["故障前的输出负载"] = '';
	    $dataArray["故障前的输出电流"] = '';
	    $dataArray["故障前的正Bus电压"] = '';
	    $dataArray["故障前的负Bus电压"] = '';
	    $dataArray["故障前的电池电压"] = '';
	    $dataArray["故障前的温度值"] = '';
	    $dataArray["故障前的UPS工作状态"]= '';
	}else{
	   switch($v[1]){
	    case 1:
		$dataArray["故障名称"] = "Bus启动失败";
		break;
	    case 2:
		$dataArray["故障名称"] = "Bus过压";
		break;
	    case 3:
		$dataArray["故障名称"] = "Bus低压";
		break;
	    case 4:
		$dataArray["故障名称"] = "Bus电压不平稳";
		break;
	    case 6:
		$dataArray["故障名称"] = "整流器过流";
		break;
	    case 0x11:
		$dataArray["故障名称"] = "逆变软启故障";
		break;
	    case 0x12:
		$dataArray["故障名称"] = "逆变软启故障";
		break;
	    case 0x13:
		$dataArray["故障名称"] = "逆变器电压低";
		break;
	    case 0x14:
		$dataArray["故障名称"] = "L1逆变器短路";
		break;
	    case 0x15:
		$dataArray["故障名称"] = "L2逆变器短路";
		break;
	    case 0x16:
		$dataArray["故障名称"] = "L3逆变器短路";
		break;
	    case 0x17:
		$dataArray["故障名称"] = "L1-L2逆变器短路";
		break;
	    case 0x18:
		$dataArray["故障名称"] = "L2-L3逆变器短路";
		break;
	    case 0x19:
		$dataArray["故障名称"] = "L3-L1逆变器短路";
		break;
	    case 0x1A:
		$dataArray["故障名称"] = "L1逆变器负功";
		break;
	    case 0x1B:
		$dataArray["故障名称"] = "L2逆变器负功";
		break;
	    case 0x1C:
		$dataArray["故障名称"] = "L3逆变器负功";
		break;
	    case 0x21:
		$dataArray["故障名称"] = "电池SCR故障";
		break;
	    case 0x24:
		$dataArray["故障名称"] = "逆变器继电器短路";
		break;
	    case 0x29:
		$dataArray["故障名称"] = "电池保险丝开路";
		break;
	    case 0x31:
		$dataArray["故障名称"] = "CAN总线通信故障";
		break;
	    case 0x36:
		$dataArray["故障名称"] = "并行输出电流不平衡";
		break;
	    case 0x41:
		$dataArray["故障名称"] = "过温";
		break;
	    case 0x42:
		$dataArray["故障名称"] = "CPU通信故障";
		break;
	    case 0x43:
		$dataArray["故障名称"] = "过载";
		break;
	    case 0x46:
		$dataArray["故障名称"] = "类型错误";
		break;
	    case 0x47:
		$dataArray["故障名称"] = "MCU 通信故障";
		break;
	   }
	   $v = unpack("f*", substr($memData, $offset + 4, 4*4));
	   $dataArray["故障前的输入电压"] = number_format($v[1], 1)."V";
	   $dataArray["故障前的输入频率"] = number_format($v[2], 1)."Hz";
	   $dataArray["故障前的输出电压"] = number_format($v[3], 1)."V";
	   $dataArray["故障前的输出频率"] = number_format($v[4], 1)."Hz";
	   $v = unpack("I", substr($memData, $offset + 4 + 4*4, 4));
	   $dataArray["故障前的输出负载"] = $v[1]."%";
	   $v = unpack("f*", substr($memData, $offset + 4 + 4*4 + 4, 4*5));
	   $dataArray["故障前的输出电流"] = number_format($v[1], 1)."%";
	   $dataArray["故障前的正Bus电压"] = number_format($v[2], 1)."V";
	   $dataArray["故障前的负Bus电压"] = number_format($v[3], 1)."V";
	   $dataArray["故障前的电池电压"] = number_format($v[4], 1)."V";
	   $dataArray["故障前的温度值"] = number_format($v[4], 1)."°C";
	   $ss = substr($memData, $offset + 4 + 4*4 + 4 + 4*5, 8);
	   $status = [];
	   if($ss[0]){
	      $status[] = 'DC TO DC 工作';
	   }
	   if($ss[1]){
	      $status[] = 'PFC 工作';
	   }
	   if($ss[2]){
	      $status[] = '逆变器工作';
	   }
	   if($ss[4]){
	      $status[] = '输入继电器工作';
	   }
	   if($ss[5]){
	      $status[] = '输出继电器工作';
	   }
	   $dataArray["故障前的UPS工作状态"] = join(',', $status);
	}
	$offset += (4 + 4*4 + 4 + 4*5 + 8)
	
	$ss = substr($memData, $offset, 64);
	$sLabel = [0=>"电池开路",1=>"输入市电N线丢失",3=>"市电相序错误",4=>"旁路相序错误",6=>"电池过压",7=>"电池电量低",8=>"过载",9=>"风扇故障警告",10=>"紧急关机",12=>"温度过高",13=>"充电器故障",15=>"L1输入保险丝断开",16=>"L2输入保险丝断开",17=>"L3输入保险丝断开",32=>"市电不一致", 33=>"旁路不一致", 50=>"30 分钟内三次过载，锁旁路", 51=>"三相整流电流不平衡", 52=>"电池保险丝断开", 57=>"维修旁路", 59=>"市电电压不平衡", 60=>"旁路电压不稳定"];
	$status = [];
	foreach($sLabel as $i => $label){
	   if($ss[$i]){
		$status[] = $label;
	   }
	}
	$dataArray["警告状态"] = join(",", $status);
	$offset += 64;
	$v = substr($memData, $offset , 1);
	switch($v){
	  case 'P':
		$dataArray["UPS类型"] = "上电模式";
		break;
	  case 'S':
		$dataArray["UPS类型"] = "待机模式";
		break;
	  case 'Y':
		$dataArray["UPS类型"] = "旁路模式";
		break;
	  case 'L':
		$dataArray["UPS类型"] = "市电模式";
		break;
	  case 'B':
		$dataArray["UPS类型"] = "电池模式";
		break;
	  case 'T':
		$dataArray["UPS类型"] = "电池自检模式";
		break;
	  case 'F':
		$dataArray["UPS类型"] = "故障模式";
		break;
	  case 'E':
		$dataArray["UPS类型"] = "高效模式";
		break;
	  case 'C':
		$dataArray["UPS类型"] = "CVCF模式";
		break;
	  case 'D':
                $dataArray["UPS类型"] = "D模式";
                break;
	}
	$offset += 1;
	$v = unpack('f*', substr($memData, $offset, 4*6));
	$dataArray["输入R相电压"] = number_format($v[1], 1)."V";
	$dataArray["输入S相电压"] = number_format($v[2], 1)."V";
	$dataArray["输入T相电压"] = number_format($v[3], 1)."V";
	$dataArray["输入RS相电压"] = number_format($v[4], 1)."V";
	$dataArray["输入ST相电压"] = number_format($v[5], 1)."V";
	$dataArray["输入TR相电压"] = number_format($v[6], 1)."V";
	$offset += 4*6;
	$v = unpack('f*', substr($memData, $offset, 4*3));
	$dataArray["输入R相电流"] = number_format($v[1], 1)."A";
	$dataArray["输入S相电流"] = number_format($v[2], 1)."A";
	$dataArray["输入T相电流"] = number_format($v[3], 1)."A";
	$offset += 4*3;
	$v = unpack('f*', substr($memData, $offset, 4*6));
        $dataArray["输出R相电压"] = number_format($v[1], 1)."V";
        $dataArray["输出S相电压"] = number_format($v[2], 1)."V";
        $dataArray["输出T相电压"] = number_format($v[3], 1)."V";
        $dataArray["输出RS相电压"] = number_format($v[4], 1)."V";
        $dataArray["输出ST相电压"] = number_format($v[5], 1)."V";
        $dataArray["输出TR相电压"] = number_format($v[6], 1)."V";
        $offset += 4*6;
        $v = unpack('f*', substr($memData, $offset, 4*3));
        $dataArray["输出R相电流"] = number_format($v[1], 1)."A";
        $dataArray["输出S相电流"] = number_format($v[2], 1)."A";
        $dataArray["输出T相电流"] = number_format($v[3], 1)."A";
	$offset += 4*3;
	$v = unpack('f*', substr($memData, $offset, 4*6));
        $dataArray["R相旁路电压"] = number_format($v[1], 1)."V";
        $dataArray["S相旁路电压"] = number_format($v[2], 1)."V";
        $dataArray["T相旁路电压"] = number_format($v[3], 1)."V";
        $dataArray["RS相旁路电压"] = number_format($v[4], 1)."V";
        $dataArray["ST相旁路电压"] = number_format($v[5], 1)."V";
        $dataArray["TR相旁路电压"] = number_format($v[6], 1)."V";
        $offset += 4*6;
	$v = unpack('f*', substr($memData, $offset, 4));
        $dataArray["旁路频率"] = number_format($v[1], 1)."Hz";
	$offset += 4;
	$v = unpack('f*', substr($memData, $offset, 4*3));
        $dataArray["旁路R相电流"] = number_format($v[1], 1)."A";
        $dataArray["旁路S相电流"] = number_format($v[2], 1)."A";
        $dataArray["旁路T相电流"] = number_format($v[3], 1)."A";
	$offset += 4*3;
	$v = unpack('f*', substr($memData, $offset, 4*4));
        $dataArray["R相负载"] = number_format($v[1], 1)."%";
        $dataArray["S相负载"] = number_format($v[2], 1)."%";
        $dataArray["T相负载"] = number_format($v[3], 1)."%";
        $dataArray["总负载"] = number_format($v[4], 1)."%";
	$offset += 4*4;

	$v = unpack('f', substr($memData, $offset , 4));
	$dataArray["电池电压"] = number_format($v[1], 1)."V";
	$offset += 4;
	
	$v = unpack('I*', substr($memData, $offset, 4*4));
	$dataArray["电池个数"] = $v[1];
	$dataArray["电池组个数"] = $v[2];
	$dataArray["电池容量"] = $v[3];
	$dataArray["电池剩余时间"] = $v[4].'分';
	$offset =+ 4*4;

	$v = unpack('I*', substr($memData, $offset, 4*2));
	$dataArray["有功负载"] = $v[1];
	$dataArray["视在负载"] = $v[2];
	$offset += 4*2;
	
	$v = unpack('f*', substr($memData, $offset, 4*4));
        $dataArray["温度1"] = number_format($v[1], 1)."℃";
        $dataArray["温度2"] = number_format($v[2], 1)."℃";
        $dataArray["温度3"] = number_format($v[3], 1)."℃";
        $dataArray["温度4"] = number_format($v[4], 1)."℃";
	$offset += 4*4;	

	 $v = unpack('v', substr($memData, $offset, 2));
        $year = $v[1];
        $offset += 2;
        $v = unpack('C*', substr($memData, $offset, 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

	
	




