<?php

function _ups_3u_hq_m_ShowAlert_Abnormal(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '告警' : '正常';
    $dataArray['AlertArray'][$label] = $value == $vsValue;
}
function _ups_3u_hq_m_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
    $dataArray['AlertArray'][$label] = $value != $vsValue;
}

function Get_ups_3u_hq_m_Standard_Variable($dataArray, $varname){
    switch ($varname){
        case 'A相输出电流':
            return array(0, $dataArray["A相输出电流（A）"]);
        case 'B相输出电流':
            return array(0, $dataArray["B相输出电流（A）"]);
        case 'C相输出电流':
            return array(0, $dataArray["C相输出电流（A）"]);
        case 'A相输出负载百分比':    
            return array(0,$dataArray['e2整机']['-A相输出负载百分比']);
        case 'B相输出负载百分比':    
            return array(0,$dataArray['e2整机']['-B相输出负载百分比']);
        case 'C相输出负载百分比':    
            return array(0,$dataArray['e2整机']['-C相输出负载百分比']);
        default:
            break;
    }
    return array(1 , '设备无此信号数据:'. $varname);
}


function Get_ups_3u_hq_m_RtData($memData, &$dataArray, $extraPara = false)
{
    if($memData == false) {
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '无数据';
    } else {
        $dataArray['无数据'] = false;
	for($i=0;$i<21;$i++)
	{
	   $label = ($i == 0) ? "整机" : "模块".$i;
	   $dataArray[$label] = array();
	   $v = unpack('f*', substr($memData, 4 + $i*(4*50+1) + 1, 4 * 50));
	   $dataArray[$label]["A相输入电压"] = number_format($v[1], 2)." V";
	   $dataArray[$label]["B相输入电压"] = number_format($v[2], 2)." V";
	   $dataArray[$label]["C相输入电压"] = number_format($v[3], 2)." V";
	   $dataArray[$label]["A相输出电压"] = number_format($v[4], 2)." V";
	   $dataArray[$label]["B相输出电压"] = number_format($v[5], 2)." V";
	   $dataArray[$label]["C相输出电压"] = number_format($v[6], 2)." V";
	   $dataArray[$label]["A相输出电流"] = number_format($v[7], 2)." A";
	   $dataArray[$label]["B相输出电流"] = number_format($v[8], 2)." A";
	   $dataArray[$label]["C相输出电流"] = number_format($v[9], 2)." A";
	   $dataArray[$label]["直流输入电压"] = number_format($v[10], 2)." V";
	   $dataArray[$label]["输出频率"] = number_format($v[11], 2)." Hz";

	   $dataArray[$label]["交流输入线电压AB"] = number_format($v[12], 2)." V";
	   $dataArray[$label]["交流输入线电压BC"] = number_format($v[13], 2)." V";
	   $dataArray[$label]["交流输入线电压CA"] = number_format($v[14], 2)." V";
	   $dataArray[$label]["A相旁路电压"] = number_format($v[15], 2)." V";
	   $dataArray[$label]["B相旁路电压"] = number_format($v[16], 2)." V";
	   $dataArray[$label]["C相旁路电压"] = number_format($v[17], 2)." V";
	   $dataArray[$label]["A相输入电流"] = number_format($v[18], 2)." A";
	   $dataArray[$label]["B相输入电流"] = number_format($v[19], 2)." A";
	   $dataArray[$label]["C相输入电流"] = number_format($v[20], 2)." A";
	   $dataArray[$label]["A相输入功率因数"] = number_format($v[21], 2);
	   $dataArray[$label]["B相输入功率因数"] = number_format($v[22], 2);
	   $dataArray[$label]["C相输入功率因数"] = number_format($v[23], 2);
	   $dataArray[$label]["输入频率"] = number_format($v[24], 2);
	   $dataArray[$label]["旁路频率"] = number_format($v[25], 2);

	   $dataArray[$label]["A相输出有功功率"] = number_format($v[26], 2)." kW";
	   $dataArray[$label]["B相输出有功功率"] = number_format($v[27], 2)." kW";
	   $dataArray[$label]["C相输出有功功率"] = number_format($v[28], 2)." kW";
	   $dataArray[$label]["A相输出无功功率"] = number_format($v[29], 2)." kVAR";
	   $dataArray[$label]["B相输出无功功率"] = number_format($v[30], 2)." kVAR";
	   $dataArray[$label]["C相输出无功功率"] = number_format($v[31], 2)." kVAR";
	   $dataArray[$label]["A相输出视在功率"] = number_format($v[32], 2)." kVA";
	   $dataArray[$label]["B相输出视在功率"] = number_format($v[33], 2)." kVA";
	   $dataArray[$label]["C相输出视在功率"] = number_format($v[34], 2)." kVA";

	   $dataArray[$label]["A相输出百分比"] = number_format($v[35], 2);
	   $dataArray[$label]["B相输出百分比"] = number_format($v[36], 2);
	   $dataArray[$label]["C相输出百分比"] = number_format($v[37], 2);
	   $dataArray[$label]["A相输出功率因数"] = number_format($v[38], 2);
	   $dataArray[$label]["B相输出功率因数"] = number_format($v[39], 2);
	   $dataArray[$label]["C相输出功率因数"] = number_format($v[40], 2);
	   $dataArray[$label]["A相输出峰值比"] = number_format($v[41], 2);
	   $dataArray[$label]["B相输出峰值比"] = number_format($v[42], 2);
	   $dataArray[$label]["C相输出峰值比"] = number_format($v[43], 2);

	   $dataArray[$label]["正电池电压"] = number_format($v[44], 2)." V";
           $dataArray[$label]["负电池电压"] = number_format($v[45], 2)." V";
           $dataArray[$label]["正电池电流"] = number_format($v[46], 2)." A";
           $dataArray[$label]["负电池电流"] = number_format($v[47], 2)." A";
           $dataArray[$label]["电池后备时间"] = number_format($v[48], 2)." 分";
           $dataArray[$label]["电池温度"] = number_format($v[49], 2)." ℃";
           $dataArray[$label]["环境温度"] = number_format($v[50], 2)." ℃";

	}
	$label = '系统数据';
        $v = unpack('f*', substr($memData, 4+ 21*(4*50+1), 4 * 9));
        $dataArray[$label]["系统A相输出有功功率"] = number_format($v[1], 2)." kW";
        $dataArray[$label]["系统B相输出有功功率"] = number_format($v[2], 2)." kW";
        $dataArray[$label]["系统C相输出有功功率"] = number_format($v[3], 2)." kW";
        $dataArray[$label]["系统A相输出无功功率"] = number_format($v[4], 2)." kVA";
        $dataArray[$label]["系统B相输出无功功率"] = number_format($v[5], 2)." kVA";
        $dataArray[$label]["系统C相输出无功功率"] = number_format($v[6], 2)." kVA";
        $dataArray[$label]["系统A相输出视在功率"] = number_format($v[7], 2)." kVAR";
        $dataArray[$label]["系统B相输出视在功率"] = number_format($v[8], 2)." kVAR";
        $dataArray[$label]["系统C相输出视在功率"] = number_format($v[9], 2)." kVAR";


        $v = unpack('C*', substr($memData, 4 + 21*(4*50+1) + 4*9 ,39 * 1));
        switch ($v[1]){
            case 1: $dataArray[$label]['供电方式'] = '逆变供电';break;
            case 2: $dataArray[$label]['供电方式'] = '旁路供电';break;
            case 0xE3: $dataArray[$label]['供电方式'] = '电池逆变模式供电';break;
            case 0xE4: $dataArray[$label]['供电方式'] = '联合运行模式供电';break;
            case 0xE5: $dataArray[$label]['供电方式'] = '均不供电';break;
            default: $dataArray[$label]['供电方式'] = '不支持';
        }
        switch ($v[2]){
            case 0xE0: $dataArray[$label]['整流器供电状态'] = '主路逆变供电';break;
            case 0xE1: $dataArray[$label]['整流器供电状态'] = '电池逆变供电';break;
            case 0xE3: $dataArray[$label]['整流器供电状态'] = '均不供电';break;
            default: $dataArray[$label]['整流器供电状态'] = '不支持';
        }
        switch ($v[3]){
            case 0xE0: $dataArray[$label]['逆变器开/关状态'] = '关闭';break;
            case 0xE1: $dataArray[$label]['逆变器开/关状态'] = '开启';break;
            default: $dataArray[$label]['逆变器开/关状态'] = '不支持';
        }
        switch ($v[4]){
            case 0xE0: $dataArray[$label]['电池充电状态'] = '浮充';break;
            case 0xE1: $dataArray[$label]['电池充电状态'] = '均充';break;
            case 0xE2: $dataArray[$label]['电池充电状态'] = '非充电状态';break;
            default: $dataArray[$label]['电池充电状态'] = '不支持';
        }
        switch ($v[5]){
            case 0xE0: $dataArray[$label]['电池自检状态'] = '自检中';break;
            case 0xE1: $dataArray[$label]['电池自检状态'] = '没在自检';break;
            default: $dataArray[$label]['电池自检状态'] = '不支持';
        }
        switch ($v[7]){
            case 0xE0: $dataArray[$label]['输入空开状态'] = '断开';break;
            case 0xE1: $dataArray[$label]['输入空开状态'] = '闭合';break;
            default: $dataArray[$label]['输入空开状态'] = '不支持';
        }
        switch ($v[8]){
            case 0xE0: $dataArray[$label]['维修旁路空开状态'] = '断开';break;
            case 0xE1: $dataArray[$label]['维修旁路空开状态'] = '闭合 ';break;
            default: $dataArray[$label]['维修旁路空开状态'] = '不支持';
        }
        switch ($v[9]){
            case 0xE0: $dataArray[$label]['旁路空开状态'] = '断开';break;
            case 0xE1: $dataArray[$label]['旁路空开状态'] = '闭合 ';break;
            default: $dataArray[$label]['旁路空开状态'] = '不支持';
        }
        switch ($v[10]){
            case 0xE0: $dataArray[$label]['输出空开状态'] = '断开';break;
            case 0xE1: $dataArray[$label]['输出空开状态'] = '闭合 ';break;
            default: $dataArray[$label]['输出空开状态'] = '不支持';
        }
        switch ($v[12]){
            case 0xE0: $dataArray[$label]['发电机接入状态'] = '接入';break;
            case 0xE1: $dataArray[$label]['发电机接入状态'] = '未接入';break;
            default: $dataArray[$label]['发电机接入状态'] = '不支持';
	}
        switch ($v[13]){
            case 0xE0: $dataArray[$label]['并机系统供电状态'] = '均不供电';break;
            case 0xE1: $dataArray[$label]['并机系统供电状态'] = '旁路供电 ';break;
            case 0xE2: $dataArray[$label]['并机系统供电状态'] = '市电供电 ';break;
            case 0xE3: $dataArray[$label]['并机系统供电状态'] = '电池逆变供电 ';break;
            case 0xE4: $dataArray[$label]['并机系统供电状态'] = '联合供电';break;
            case 0xE5: $dataArray[$label]['并机系统供电状态'] = '输出禁止 ';break;
            default: $dataArray[$label]['并机系统供电状态'] = '不支持';
        }
	switch ($v[14]){
            case 0xE0: $dataArray[$label]['整机工作模式'] = '正常模式';break;
            case 0xE1: $dataArray[$label]['整机工作模式'] = '变频器模式';break;
            case 0xE2: $dataArray[$label]['整机工作模式'] = 'ECO模式';break;
            default: $dataArray[$label]['整机工作模式'] = '不支持';
        }
        $index = 1;
        for($i = 1;$i <= 20;$i++) {
            switch ($v[14 + $i]){
                case 0xE0: $dataArray[$label]["模块{$index}在线状态"] = '在线';break;
                case 0xE1: $dataArray[$label]["模块{$index}在线状态"] = '不在线 ';break;
                default: $dataArray[$label]["模块{$index}在线状态"] = '不支持';
            }
            $index++;
        }

        switch ($v[35]){
            case 0xE0: $dataArray[$label]['内置电池空开状态'] = '断开';break;
            case 0xE1: $dataArray[$label]['内置电池空开状态'] = '闭合';break;
            default: $dataArray[$label]['内置电池空开状态'] = '不支持';
        }
        $index = 1;
	for($i=1;$i<=4;$i++){
        switch ($v[35+$i]){
            case 0: $dataArray[$label]['BCB'.$i.'状态'] = '未接入';break;
            case 0xE0: $dataArray[$label]['BCB'.$i.'状态'] = '闭合';break;
            case 0xE1: $dataArray[$label]['BCB'.$i.'状态'] = '断开 ';break;
            default: $dataArray[$label]['BCB'.$i.'状态'] = '不支持';
        }
	}

        $v = unpack('C*', substr($memData, 4 + 21*(4*50+1) + 4*9 + 39 * 1 ,95 * 1));
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "逆变器同步/不同步", $v[1], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "主路电压", $v[2], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "整流器", $v[3], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "逆变器", $v[4], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路状态（电压或频率）", $v[5], 0);
	_ups_3u_hq_m_ShowAlert_Abnormal($dataArray['告警'], "电池预告警", $v[6], 0xF3);
	_ups_3u_hq_m_ShowAlert_Abnormal($dataArray['告警'], "电池接反", $v[6], 0xF4);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "紧急关机", $v[9], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "LBS异常", $v[10], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路相序反", $v[11], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路异常关机", $v[12], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "切换次数限制", $v[13], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路过流", $v[14], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路晶闸管故障", $v[15], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路无效", $v[16], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "ECO切换次数限制", $v[17], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路缺零故障", $v[18], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路接管", $v[19], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "BCB1状态异常", $v[20], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "BCB2状态异常", $v[21], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "BCB3状态异常", $v[22], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "BCB4状态异常", $v[23], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路SCR风扇异常", $v[24], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路过流超时", $v[25], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路熔丝断", $v[26], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "电池放电限流", $v[27], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "放电器故障", $v[28], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "充电器过温", $v[29], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "电池端口短路", $v[30], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "电池房环境异常", $v[31], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "电池组充电器故障", $v[32], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "电池组寿命情况", $v[33], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "电池过温", $v[34], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "电池接地故障", $v[35], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "主路频率异常", $v[36], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "平衡电路过温", $v[37], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "平衡电路故障", $v[40], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "平衡电路过流", $v[41], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "主路熔丝断", $v[42], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "主路相序反", $v[43], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "整流器过流", $v[44], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "软启动失败", $v[45], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "并机连接线异常", $v[46], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "模块通讯故障", $v[47], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "并机通讯故障", $v[48], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "风扇1故障", $v[49], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "风扇2故障", $v[50], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "风扇3故障", $v[51], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "环境过温", $v[52], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "辅助电源掉电", $v[53], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "用户操作错误", $v[58], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "输出熔丝断", $v[59], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "输出过载", $v[60], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "系统过载", $v[61], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "输出过载超时", $v[62], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "负载冲击转旁路", $v[65], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "并机均流异常", $v[66], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "母线异常关机", $v[67], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "邻机请求转旁路", $v[68], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "直流母线过压", $v[69], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "MonCAN通讯故障", $v[70], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "输入缺零故障", $v[72], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "逆变继电器故障", $v[73], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "输入电流异常", $v[75], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "输出电压异常", $v[76], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "输入电流超限", $v[77], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "旁路过温", $v[78], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "邻机旁路晶闸管故障", $v[79], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "上抽风风扇异常", $v[83], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "失去冗余", $v[84], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "容量过载", $v[85], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "均充超时", $v[86], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "模块过温", $v[87], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "LBS连接线异常", $v[88], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "主路反灌", $v[89], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "系统A相输出熔丝断", $v[90], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "系统B相输出熔丝断", $v[91], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "系统C相输出熔丝断", $v[92], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "输出零地过压", $v[93], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "滤波电容预告警", $v[94], 0);
	_ups_3u_hq_m_ShowAlert($dataArray['告警'], "风扇故障预告警", $v[95], 0);
        $v = unpack('v', substr($memData, 4 + 21*(4*50+1) + 4*9 + 39 * 1 +95 * 1, 2));
        $start += 2;
        $year = $v[1];
        $v = unpack('C*', substr($memData,  4 + 21*(4*50+1) + 4*9 + 39 * 1 +95 * 1 + 2, 5));
        $dataArray["更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
   }
}
?>
