<?php

function Get_cscp_419_UnicomCategory()
{
    return "419";
}

function Get_cscp_419_config()
{
    $config = array("model"=>"cscp_419",
	"ac" => array(
                        "airlock" => 1, "p40_43" => 3, "p40_41" => 1, "p40_44" => 10,
                    "p40_41_label" => array("环境温度"=>true),
                    "p40_43_label" => array("上次电池放电测试结果" => true),
                    "p40_43_rules" => array(0 => array(array(0x90 => "失败", 0x91 => "通过", 0x92 => "无效", 0x93 => "负载过低退出", 0x94 => "系统过载退出", 0x95 => "整理模块失控退出", 0x96 => "被用户手动退出", 0x97 => "测试中AC无退出", 0x98 => "电池电压过低退出", 0x99 => "电池电流传感器失效退出"), "无效状态")),
                    "p40_44_label" => array("避雷器告警" => true),
                    "p40_44_rules" => array(0 => array(array(0 => "正常", 0xF0 => "告警"), "无效")),
                    "ia_support" => true, "ib_support" => true, "ic_support" => true,
                    "ia_alert_support" => true, "ib_alert_support" => true, "ic_alert_support" => true
                ),
                "rc" => array(
                        "p42_46" => 8, "p42_46_size" => 16, "p41_41" => 1, "p41_43" => 1, "p41_44" => 3,
                    'p41_41_label' => array(),
                    "p41_43_label" => array(),
                    "p41_43_rules" => array(),
                    "p41_44_label" => array("高压关机" => true, "通讯故障" => true, "风扇故障" => true),
                    'p41_44_rules' => array(
                        0 => array(array(0 => "正常", 1 => "告警", 0xf0 => "模块屏蔽"), "无效"),
                        1 => array(array(0 => "正常", 1 => "告警", 0xf0 => "模块屏蔽"), "无效"),
                        2 => array(array(0 => "正常", 1 => "告警", 0xf0 => "模块屏蔽"), "无效")
                    ),

                ),
                "dc" => array(
                        "m" => 2, "n" => 0, "p" => 4, "alert_m" => 2, "alert_p" => 10,
                    "p_label" => array('环境温度' => true, '电池温度' => true, "第1个电池剩余容量" => true, "第2个电池剩余容量" => true),
                    "alert_p_label" => array(
                        '限流' => true, '电池放电告警' => true, '电池熔丝断' => true,
                        'CSUAlarm[0]' => array("直流高压" => true, "直流低压" => true, "单相交流1高压" => true, "单相交流1低压" => true, "单相交流1停电" => true, "高压关机" => true, "均充" => true, "放电" => true),
                        'CSUAlarm[1]' => array("电池低压放电" => true, "环境温度过高" => true, "电池温度过高" => true, "充电过流告警" => true, "电池限流" => true, "熔丝1熔断" => true, "电池下电跳脱" => true, "负载下电跳脱" => true),
                        'CSUAlarm[2]' => array("单体电池过压" => true, "单体电池欠压" => true, "单体电池漂移高" => true, "单体电池漂移低" => true, "电池测试失败" => true, "交流避雷器告警" => true, "模块通讯故障" => true, "交流输入中断" => true),
                        'CSUAlarm[3]' => array("直流侦测#1告警" => true, "自定义告警1" => true, "自定义告警2" => true, "电池组中位电压异常" => true, "熔丝2熔断" => true, "三相交流1停电" => true, "三相交流2停电" => true, "模块关机告警" => true),
                        'CSUAlarm[4]' => array("模块风扇告警" => true, "模块限流" => true, "电池温度失效" => true, "单相交流1过流" => true, "电池下电失控" => true, "负载下电失控" => true, "强制吸合告警" => true, "电池 LVDS 手动" => true),
                        'CSUAlarm[5]' => array("负载LVDS手动" => true, "单相交流2高压" => true, "单相交流2低压" => true, "单相交流2停电" => true, "放电不平衡告警" => true, "模块严重告警" => true, "投入信号故障" => true, "油机开机失败" => true),
                        'CSUAlarm[6]' => array("模块其它告警" => true, "CSU 故障" => true, "模块类型不匹配" => true, "蓄电池故障" => true, "IO 侦测板告警" => true, "熔丝侦测板告警" => true, "自定义告警 3" => true, "保留" => true),
                        'CSUAlarm[7]' => array("三相交流1A高压" => true, "三相交流1B高压" => true, "三相交流1C高压" => true, "三相交流1A低压" => true, "三相交流1B低压" => true, "三相交流1C低压" => true, "三相交流1A缺相" => true, "三相交流1B缺相" => true),
                        'CSUAlarm[8]' => array("三相交流1C缺相" => true, "三相交流1A过流" => true, "三相交流1B过流" => true, "三相交流1C过流" => true, "三相交流1低频" => true, "三相交流1高频" => true, "三相交流2A高压" => true, "三相交流2B高压" => true),
                        'CSUAlarm[9]' => array("三相交流2C高压" => true, "三相交流2A低压" => true, "三相交流2B低压" => true, "三相交流2C低压" => true, "三相交流2A缺相" => true, "三相交流2B缺相" => true, "三相交流2C缺相" => true, "三相交流2A过流" => true),
                        'CSUAlarm[10]' => array("三相交流2B过流" => true, "三相交流2C过流" => true, "三相交流2低频" => true, "三相交流2高频" => true, "保留" => false, "保留" => false, "保留" => false, "保留" => false),
                        '干节点输出状态' => true,
                        'p_15' => array('电池LVDS状态' => true, '负载 LVDS 状态' => true,),
                        '交流投入状态' => true,
                        '系统状态' => true,
                        /*'CSUAlarm[11]'=>array("循环风扇1故障"=>true,"循环风扇2故障"=>true,"循环风扇3故障"=>true,"循环风扇4故障"=>true,"电池风扇1故障"=>true,"电池风扇2故障"=>true,"电池舱加热故障"=>true,"门禁告警"=>true),
                    'CSUAlarm[12]'=>array("直流防雷器告警"=>true,"交流空开断开"=>true,"接口板 CPU 告警"=>true,"室外扩展板告警"=>true,"保留"=>true,"保留"=>true,"保留"=>true,"保留"=>true,)*/
                    ),
                    "alert_p_rules" => array(
                        0 => array(array(0x0 => "正常", 0xF0 => "告警"), "无效"),
                        1 => array(array(0x0 => "正常", 0xF0 => "告警"), "无效"),
                        2 => array(array(0x0 => "正常", 0x3 => "告警"), "无效"),

                        14 => array(array(0x0 => "正常", 0x03 => "告警"), "无效"),

                        16 => array(array(0x0 => "正常", 0x03 => "告警"), "无效"),
                        17 => array(array(0x0 => "正常", 0x03 => "告警"), "无效"),
                        18 => array(array(0x0 => "正常", 0x03 => "告警"), "无效"),
                    )

                )
	);

    return $config;
}

function Get_cscp_419_RtData($memData,&$dataArray,$extraPara = false) {
	if (!$memData) {
		$dataArray['无数据'] = true;
		$dataArray['更新时间'] = '无';
		$dataArray['错误'] = '数据长度不一致';
	} else {       
        $dataArray['无数据'] = false;
        $config = Get_cscp_419_config();
        require_once "./application/helpers/device/pmbuspower_419.php";
        _Get_PMBusPower_RtData($memData, $dataArray, $extraPara, $config);
    }
}
?>
