<?php
function _hds_sbms_ShowNormal(&$dataArray, $label, $value, $vsValue)
{
    // if($value == 0xFFFF || $value == 0x20){
    //   $dataArray[$label] = "无效值";
    // }else{
      $dataArray[$label] = $value == $vsValue ? '告警' : '正常';
      $dataArray['AlertArray'][$label] = $value == $vsValue;
    //}
}

function _hds_sbms_ShowAlert(&$dataArray, $label, $value, $vsValue)
{
    // if($value == 0xFFFF || $value == 0x20){
    //   $dataArray[$label] = "无效值";
    // }else{
      $dataArray[$label] = $value == $vsValue ? '正常' : '告警';
      $dataArray['AlertArray'][$label] = $value != $vsValue;
    //}
}

function _hds_sbms_GroupAlarm(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
    $v = unpack("S*" , $memData);
      
        $name = $prefix.sprintf("第%s组电池组告警-组电压过压", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, ($v[1]&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-组电压欠压", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>1)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-充电电流异常", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>2)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-放电电流异常", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>3)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-电池开关断开", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>4)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-电流模块通讯故障", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>5)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-电池组容量低", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>6)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-组压模块通讯故障", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>7)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-剩余时间5分钟报警", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>8)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-剩余时间10分钟报警", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>9)&0x1), 0);
      
        $name = $prefix.sprintf("第%s组电池组告警-剩余时间20分钟报警", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>10)&0x1), 0);
}
function _hds_sbms_BatteryAlarm(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
    $v = unpack("S*" , $memData);
      
        $name = $prefix.sprintf("第%s号电池告警-电池电压超上限", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, ($v[1]&0x1), 0);
      
        $name = $prefix.sprintf("第%s号电池告警-电池电压超下限", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>1)&0x1), 0);
      
        $name = $prefix.sprintf("第%s号电池告警-电池内阻超限", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>2)&0x1), 0);
      
        $name = $prefix.sprintf("第%s号电池告警-电池温度超上限", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>3)&0x1), 0);
      
        $name = $prefix.sprintf("第%s号电池告警-电池内阻差异超上限", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>4)&0x1), 0);
      
        $name = $prefix.sprintf("第%s号电池告警-电压模块通讯故障", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>5)&0x1), 0);
      
        $name = $prefix.sprintf("第%s号电池告警-电压差异超限", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>7)&0x1), 0);
      
        $name = $prefix.sprintf("第%s号电池告警-温度差异超限", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>10)&0x1), 0);
}
function _hds_sbms_GroupStatus(&$dataArray, $memData, $prefix, $index  )
{
    $offset = 0;
    $v = unpack("S*" , $memData);
      
        $name = $prefix.sprintf("第%s号电池组状态及告警-电池组工作状态", strval($index));
          
          switch(($v[1]&0x7)){
            case 0:
            $dataArray[$name] = "断开状态";
              break;
            case 1:
            $dataArray[$name] = "浮充状态";
              break;
            case 2:
            $dataArray[$name] = "均充状态";
              break;
            case 3:
            $dataArray[$name] = "放电状态";
              break;
            case 4:
            $dataArray[$name] = "闲置状态";
              break;
            default:
            $dataArray[$name]  = "无效值";
              break;
          }
      
        $name = $prefix.sprintf("第%s号电池告警-电池组告警状态", strval($index));
          _hds_sbms_ShowAlert($dataArray, $name, (($v[1]>>3)&0x3), 0);
}


function Get_hds_sbms_RtData($memData, &$dataArray, $extraPara = false){
    if($memData == false){
        $dataArray['无数据'] = true;
        $dataArray['更新时间'] = '无';
        $dataArray['错误'] = '数据长度不一致';
    }else{
        $dataArray['无数据'] = false;
        $dataArray['AlertArray'] = array();

        //InitSetting


        $offset = 4;
            $v = unpack("S*" , substr($memData , $offset, 2*4));
$lMemData = substr($memData , $offset, 2*4);
      $lOffset = 0;
      
        $dataArray["第1号电池总电压"] = number_format($v[1]/10, 2) ."V";
      

      
        $dataArray["第2组电池组总电压"] = number_format($v[2]/10, 2) ."V";
      

      
        $dataArray["第3组电池组总电压"] = number_format($v[3]/10, 2) ."V";
      

      
        $dataArray["第4组电池组总电压"] = number_format($v[4]/10, 2) ."V";
      

      $offset += 8;

                    
$v = unpack("s*" , substr($memData , $offset, 2*4));
$lMemData = substr($memData , $offset, 2*4);
      $lOffset = 0;
      
        $dataArray["第1组电池组总电流"] = number_format($v[1]/10, 2) ."A";
      

      
        $dataArray["第2组电池组总电流"] = number_format($v[2]/10, 2) ."A";
      

      
        $dataArray["第3组电池组总电流"] = number_format($v[3]/10, 2) ."A";
      

      
        $dataArray["第4组电池组总电流"] = number_format($v[4]/10, 2) ."A";
      

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*4));
$lMemData = substr($memData , $offset, 2*4);
      $lOffset = 0;
      
          for($i=1;$i<=4;$i++)
          {
            $tMemData = substr($lMemData, $lOffset, 2);            
            _hds_sbms_GroupAlarm($dataArray, $tMemData, "", $i);
            $lOffset += 2;
          }

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=0;$i<125;$i++){
            $name = sprintf("第%d号电池的电压", 1 + $i);
            $kIndex = 1 + $i;
            $dataArray[$name] = number_format($v[$kIndex]/1000, 3)."V";
          }
      

      $offset += 250;

            $v = unpack("S*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=0;$i<125;$i++){
            $name = sprintf("第%d号电池的电压", 126 + $i);
            $kIndex = 1 + $i;
            $dataArray[$name] = number_format($v[$kIndex]/1000, 3)."V";
          }
      

      $offset += 250;

                    
$v = unpack("s*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=0;$i<125;$i++){
            $name = sprintf("第%d号电池温度", 1 + $i);
            $kIndex = 1 + $i;
            $dataArray[$name] = number_format($v[$kIndex]/10, 3)."℃";
          }
      

      $offset += 250;

                    
$v = unpack("s*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=0;$i<125;$i++){
            $name = sprintf("第%d号电池温度", 126 + $i);
            $kIndex = 1 + $i;
            $dataArray[$name] = number_format($v[$kIndex]/10, 3)."℃";
          }
      

      $offset += 250;

            $v = unpack("S*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=0;$i<125;$i++){
            $name = sprintf("第%d号电池内阻", 1 + $i);
            $kIndex = 1 + $i;
            $dataArray[$name] = number_format($v[$kIndex]/1000, 3)."mΩ";
          }
      

      $offset += 250;

            $v = unpack("S*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=0;$i<125;$i++){
            $name = sprintf("第%d号电池内阻", 126 + $i);
            $kIndex = 1 + $i;
            $dataArray[$name] = number_format($v[$kIndex]/1000, 3)."mΩ";
          }
      

      $offset += 250;

            $v = unpack("S*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=1;$i<=125;$i++)
          {
            $tMemData = substr($lMemData, $lOffset, 2);            
            _hds_sbms_BatteryAlarm($dataArray, $tMemData, "", $i);
            $lOffset += 2;
          }

      $offset += 250;

            $v = unpack("S*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=126;$i<=250;$i++)
          {
            $tMemData = substr($lMemData, $lOffset, 2);            
            _hds_sbms_BatteryAlarm($dataArray, $tMemData, "", $i);
            $lOffset += 2;
          }

      $offset += 250;

            $v = unpack("S*" , substr($memData , $offset, 2*40));
$lMemData = substr($memData , $offset, 2*40);
      $lOffset = 0;
      
        $dataArray["第1组平均电压"] = number_format($v[1]/1000, 2) ."V";
      

      
        $dataArray["第2组平均电压"] = number_format($v[2]/1000, 2) ."V";
      

      
        $dataArray["第3组平均电压"] = number_format($v[3]/1000, 2) ."V";
      

      
        $dataArray["第4组平均电压"] = number_format($v[4]/1000, 2) ."V";
      

      
        $dataArray["第1组最大电压"] = number_format($v[5]/1000, 2) ."V";
      

      
        $dataArray["第2组最大电压"] = number_format($v[6]/1000, 2) ."V";
      

      
        $dataArray["第3组最大电压"] = number_format($v[7]/1000, 2) ."V";
      

      
        $dataArray["第4组最大电压"] = number_format($v[8]/1000, 2) ."V";
      

      
        $dataArray["第1组最大电压ID"] = number_format($v[9], 0) ;
      

      
        $dataArray["第2组最大电压ID"] = number_format($v[10], 0) ;
      

      
        $dataArray["第3组最大电压ID"] = number_format($v[11], 0) ;
      

      
        $dataArray["第4组最大电压ID"] = number_format($v[12], 0) ;
      

      
        $dataArray["第1组最小电压"] = number_format($v[13]/1000, 2) ."V";
      

      
        $dataArray["第2组最小电压"] = number_format($v[14]/1000, 2) ."V";
      

      
        $dataArray["第3组最小电压"] = number_format($v[15]/1000, 2) ."V";
      

      
        $dataArray["第4组最小电压"] = number_format($v[16]/1000, 2) ."V";
      

      
        $dataArray["第1组最小电压ID"] = number_format($v[17], 0) ;
      

      
        $dataArray["第2组最小电压ID"] = number_format($v[18], 0) ;
      

      
        $dataArray["第3组最小电压ID"] = number_format($v[19], 0) ;
      

      
        $dataArray["第4组最小电压ID"] = number_format($v[20], 0) ;
      

      
        $dataArray["第1组平均内阻"] = number_format($v[21]/1000, 2) ."mΩ";
      

      
        $dataArray["第2组平均内阻"] = number_format($v[22]/1000, 2) ."mΩ";
      

      
        $dataArray["第3组平均内阻"] = number_format($v[23]/1000, 2) ."mΩ";
      

      
        $dataArray["第4组平均内阻"] = number_format($v[24]/1000, 2) ."mΩ";
      

      
        $dataArray["第1组最大内阻"] = number_format($v[25]/1000, 2) ."mΩ";
      

      
        $dataArray["第2组最大内阻"] = number_format($v[26]/1000, 2) ."mΩ";
      

      
        $dataArray["第3组最大内阻"] = number_format($v[27]/1000, 2) ."mΩ";
      

      
        $dataArray["第4组最大内阻"] = number_format($v[28]/1000, 2) ."mΩ";
      

      
        $dataArray["第1组最大内阻ID"] = number_format($v[29], 0) ;
      

      
        $dataArray["第2组最大内阻ID"] = number_format($v[30], 0) ;
      

      
        $dataArray["第3组最大内阻ID"] = number_format($v[31], 0) ;
      

      
        $dataArray["第4组最大内阻ID"] = number_format($v[32], 0) ;
      

      
        $dataArray["第1组最小内阻"] = number_format($v[33]/1000, 2) ."mΩ";
      

      
        $dataArray["第2组最小内阻"] = number_format($v[34]/1000, 2) ."mΩ";
      

      
        $dataArray["第3组最小内阻"] = number_format($v[35]/1000, 2) ."mΩ";
      

      
        $dataArray["第4组最小内阻"] = number_format($v[36]/1000, 2) ."mΩ";
      

      
        $dataArray["第1组最小内阻ID"] = number_format($v[37], 0) ;
      

      
        $dataArray["第2组最小内阻ID"] = number_format($v[38], 0) ;
      

      
        $dataArray["第3组最小内阻ID"] = number_format($v[39], 0) ;
      

      
        $dataArray["第4组最小内阻ID"] = number_format($v[40], 0) ;
      

      $offset += 80;

                    
$v = unpack("s*" , substr($memData , $offset, 2*20));
$lMemData = substr($memData , $offset, 2*20);
      $lOffset = 0;
      
        $dataArray["第1组平均温度"] = number_format($v[1]/10, 2) ."℃";
      

      
        $dataArray["第2组平均温度"] = number_format($v[2]/10, 2) ."℃";
      

      
        $dataArray["第3组平均温度"] = number_format($v[3]/10, 2) ."℃";
      

      
        $dataArray["第4组平均温度"] = number_format($v[4]/10, 2) ."℃";
      

      
        $dataArray["第1组最大温度"] = number_format($v[5]/10, 2) ."℃";
      

      
        $dataArray["第2组最大温度"] = number_format($v[6]/10, 2) ."℃";
      

      
        $dataArray["第3组最大温度"] = number_format($v[7]/10, 2) ."℃";
      

      
        $dataArray["第4组最大温度"] = number_format($v[8]/10, 2) ."℃";
      

      
        $dataArray["第1组最大温度ID"] = number_format($v[9], 0) ;
      

      
        $dataArray["第2组最大温度ID"] = number_format($v[10], 0) ;
      

      
        $dataArray["第3组最大温度ID"] = number_format($v[11], 0) ;
      

      
        $dataArray["第4组最大温度ID"] = number_format($v[12], 0) ;
      

      
        $dataArray["第1组最小温度"] = number_format($v[13]/10, 2) ."℃";
      

      
        $dataArray["第2组最小温度"] = number_format($v[14]/10, 2) ."℃";
      

      
        $dataArray["第3组最小温度"] = number_format($v[15]/10, 2) ."℃";
      

      
        $dataArray["第4组最小温度"] = number_format($v[16]/10, 2) ."℃";
      

      
        $dataArray["第1组最小温度ID"] = number_format($v[17], 0) ;
      

      
        $dataArray["第2组最小温度ID"] = number_format($v[18], 0) ;
      

      
        $dataArray["第3组最小温度ID"] = number_format($v[19], 0) ;
      

      
        $dataArray["第4组最小温度ID"] = number_format($v[20], 0) ;
      

      $offset += 40;

            $v = unpack("S*" , substr($memData , $offset, 2*20));
$lMemData = substr($memData , $offset, 2*20);
      $lOffset = 0;
      
        $dataArray["第1组电池SOC"] = number_format($v[1]/10, 2) ."%";
      

      
        $dataArray["第2组电池SOC"] = number_format($v[2]/10, 2) ."%";
      

      
        $dataArray["第3组电池SOC"] = number_format($v[3]/10, 2) ."%";
      

      
        $dataArray["第4组电池SOC"] = number_format($v[4]/10, 2) ."%";
      

      
        $dataArray["第1组电池SOH"] = number_format($v[5]/10, 2) ."%";
      

      
        $dataArray["第2组电池SOH"] = number_format($v[6]/10, 2) ."%";
      

      
        $dataArray["第3组电池SOH"] = number_format($v[7]/10, 2) ."%";
      

      
        $dataArray["第4组电池SOH"] = number_format($v[8]/10, 2) ."%";
      

      
        $dataArray["第1组电池均衡ID1"] = number_format($v[9], 2) ;
      

      
        $dataArray["第1组电池均衡ID2"] = number_format($v[10], 2) ;
      

      
        $dataArray["第2组电池均衡ID1"] = number_format($v[11], 2) ;
      

      
        $dataArray["第2组电池均衡ID2"] = number_format($v[12], 2) ;
      

      
        $dataArray["第3组电池均衡ID1"] = number_format($v[13], 2) ;
      

      
        $dataArray["第3组电池均衡ID2"] = number_format($v[14], 2) ;
      

      
        $dataArray["第4组电池均衡ID1"] = number_format($v[15], 2) ;
      

      
        $dataArray["第4组电池均衡ID2"] = number_format($v[16], 2) ;
      

      
        $dataArray["第1组后备时间"] = number_format($v[17], 2) ."Min";
      

      
        $dataArray["第2组后备时间"] = number_format($v[18], 2) ."Min";
      

      
        $dataArray["第3组后备时间"] = number_format($v[19], 2) ."Min";
      

      
        $dataArray["第4组后备时间"] = number_format($v[20], 2) ."Min";
      

      $offset += 40;

            $v = unpack("S*" , substr($memData , $offset, 2*5));
$lMemData = substr($memData , $offset, 2*5);
      $lOffset = 0;
      
        $dataArray["主板硬件版本号"] = number_format($v[1], 0) ;
      

      
        $dataArray["主板软件版本号"] = number_format($v[2], 0) ;
      

      
        $dataArray["主板协议版本号"] = number_format($v[3], 0) ;
      

      
        $dataArray["电压模块版本"] = number_format($v[4], 0) ;
      

      
        $dataArray["电流模块版本"] = number_format($v[5], 0) ;
      

      $offset += 10;

            $v = unpack("S*" , substr($memData , $offset, 2*1));
$lMemData = substr($memData , $offset, 2*1);
      $lOffset = 0;
      
        _hds_sbms_ShowAlert($dataArray, "系统状态及告警-SBMS 系统告警状态", ($v[1]>>1)&0x3, 0);       
      

      
        switch(($v[1]>>3)&0x1){
          case 0:
          $dataArray["系统状态及告警-当前内阻测试状态"] = "不在内阻测试";
            break;
          case 1:
          $dataArray["系统状态及告警-当前内阻测试状态"] = "内阻测试中";
            break;
          default:
            $dataArray["系统状态及告警-当前内阻测试状态"] = "无效值";
            break;
        }
      

      
        $dataArray["系统状态及告警-干接点告警状态"] = (($v[1]>>8)&0x3);
      

      $offset += 2;

            $v = unpack("S*" , substr($memData , $offset, 2*4));
$lMemData = substr($memData , $offset, 2*4);
      $lOffset = 0;
      
          for($i=1;$i<=4;$i++)
          {
            $tMemData = substr($lMemData, $lOffset, 2);            
            _hds_sbms_GroupStatus($dataArray, $tMemData, "", $i);
            $lOffset += 2;
          }

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*17));
$lMemData = substr($memData , $offset, 2*17);
      $lOffset = 0;
      
        $dataArray["电池组数"] = number_format($v[1], 2) ;
      

      
        $dataArray["第1组电池节数"] = number_format($v[2], 2) ;
      

      
        $dataArray["第2组电池节数"] = number_format($v[3], 2) ;
      

      
        $dataArray["第3组电池节数"] = number_format($v[4], 2) ;
      

      
        $dataArray["第4组电池节数"] = number_format($v[5], 2) ;
      

      
        switch($v[6]){
          case 0:
          $dataArray["第1组电池类型"] = "2V";
            break;
          case 1:
          $dataArray["第1组电池类型"] = "6V";
            break;
          case 2:
          $dataArray["第1组电池类型"] = "12V";
            break;
          default:
            $dataArray["第1组电池类型"] = "无效值";
            break;
        }
      

      
        switch($v[7]){
          case 0:
          $dataArray["第2组电池类型"] = "2V";
            break;
          case 1:
          $dataArray["第2组电池类型"] = "6V";
            break;
          case 2:
          $dataArray["第2组电池类型"] = "12V";
            break;
          default:
            $dataArray["第2组电池类型"] = "无效值";
            break;
        }
      

      
        switch($v[8]){
          case 0:
          $dataArray["第3组电池类型"] = "2V";
            break;
          case 1:
          $dataArray["第3组电池类型"] = "6V";
            break;
          case 2:
          $dataArray["第3组电池类型"] = "12V";
            break;
          default:
            $dataArray["第3组电池类型"] = "无效值";
            break;
        }
      

      
        switch($v[9]){
          case 0:
          $dataArray["第4组电池类型"] = "2V";
            break;
          case 1:
          $dataArray["第4组电池类型"] = "6V";
            break;
          case 2:
          $dataArray["第4组电池类型"] = "12V";
            break;
          default:
            $dataArray["第4组电池类型"] = "无效值";
            break;
        }
      

      
        $dataArray["第1组电池安时数"] = number_format($v[10], 2) ."AH";
      

      
        $dataArray["第2组电池安时数"] = number_format($v[11], 2) ."AH";
      

      
        $dataArray["第3组电池安时数"] = number_format($v[12], 2) ."AH";
      

      
        $dataArray["第4组电池安时数"] = number_format($v[13], 2) ."AH";
      

      
        $dataArray["第1组电池霍尔量程"] = number_format($v[14], 2) ."A";
      

      
        $dataArray["第2组电池霍尔量程"] = number_format($v[15], 2) ."A";
      

      
        $dataArray["第3组电池霍尔量程"] = number_format($v[16], 2) ."A";
      

      
        $dataArray["第4组电池霍尔量程"] = number_format($v[17], 2) ."A";
      

      $offset += 34;

            $v = unpack("S*" , substr($memData , $offset, 2*6));
$lMemData = substr($memData , $offset, 2*6);
      $lOffset = 0;
      
        $dataArray["网络IP地址"] = ((($v[1]>>8)&0xFF).".".($v[1]&0xFF).".".(($v[2]>>8)&0xFF).".".($v[2]&0xFF));
      

      
        $dataArray["网络网关"] = ((($v[3]>>8)&0xFF).".".($v[3]&0xFF).".".(($v[4]>>8)&0xFF).".".($v[4]&0xFF));
      

      
        $dataArray["网络掩码1"] = ((($v[5]>>8)&0xFF).".".($v[5]&0xFF).".".(($v[6]>>8)&0xFF).".".($v[6]&0xFF));
      

      $offset += 12;

            $v = unpack("S*" , substr($memData , $offset, 2*12));
$lMemData = substr($memData , $offset, 2*12);
      $lOffset = 0;
      
        $dataArray["第1组浮充电流率"] = number_format($v[1]/100, 2) ."C";
      

      
        $dataArray["第2组浮充电流率"] = number_format($v[2]/100, 2) ."C";
      

      
        $dataArray["第3组浮充电流率"] = number_format($v[3]/100, 2) ."C";
      

      
        $dataArray["第4组浮充电流率"] = number_format($v[4]/100, 2) ."C";
      

      
        $dataArray["第1组最大放电电流率"] = number_format($v[5]/10, 2) ."C";
      

      
        $dataArray["第2组最大放电电流率"] = number_format($v[6]/10, 2) ."C";
      

      
        $dataArray["第3组最大放电电流率"] = number_format($v[7]/10, 2) ."C";
      

      
        $dataArray["第4组最大放电电流率"] = number_format($v[8]/10, 2) ."C";
      

      
        $dataArray["第1组最大充电电流率"] = number_format($v[9]/10, 2) ."C";
      

      
        $dataArray["第2组最大充电电流率"] = number_format($v[10]/10, 2) ."C";
      

      
        $dataArray["第3组最大充电电流率"] = number_format($v[11]/10, 2) ."C";
      

      
        $dataArray["第4组最大充电电流率"] = number_format($v[12]/10, 2) ."C";
      

      $offset += 24;

            $v = unpack("S*" , substr($memData , $offset, 2*28));
$lMemData = substr($memData , $offset, 2*28);
      $lOffset = 0;
      
        $dataArray["第1组电池电压单体报警上限"] = number_format($v[1]/1000, 2) ."V";
      

      
        $dataArray["第2组电池电压单体报警上限"] = number_format($v[2]/1000, 2) ."V";
      

      
        $dataArray["第3组电池电压单体报警上限"] = number_format($v[3]/1000, 2) ."V";
      

      
        $dataArray["第4组电池电压单体报警上限"] = number_format($v[4]/1000, 2) ."V";
      

      
        $dataArray["第1组电池电压单体报警下限"] = number_format($v[5]/1000, 2) ."V";
      

      
        $dataArray["第2组电池电压单体报警下限"] = number_format($v[6]/1000, 2) ."V";
      

      
        $dataArray["第3组电池电压单体报警下限"] = number_format($v[7]/1000, 2) ."V";
      

      
        $dataArray["第4组电池电压单体报警下限"] = number_format($v[8]/1000, 2) ."V";
      

      
        $dataArray["第1组电池电阻报警上限"] = number_format($v[9]/1000, 2) ."mΩ";
      

      
        $dataArray["第2组电池电阻报警上限"] = number_format($v[10]/1000, 2) ."mΩ";
      

      
        $dataArray["第3组电池电阻报警上限"] = number_format($v[11]/1000, 2) ."mΩ";
      

      
        $dataArray["第4组电池电阻报警上限"] = number_format($v[12]/1000, 2) ."mΩ";
      

      
        $dataArray["第1组电池电阻差异报警上限"] = number_format($v[13], 2) ."%";
      

      
        $dataArray["第2组电池电阻差异报警上限"] = number_format($v[14], 2) ."%";
      

      
        $dataArray["第3组电池电阻差异报警上限"] = number_format($v[15], 2) ."%";
      

      
        $dataArray["第4组电池电阻差异报警上限"] = number_format($v[16], 2) ."%";
      

      
        $dataArray["第1组电池温度报警上限"] = number_format($v[17]/10, 2) ."℃";
      

      
        $dataArray["第2组电池温度报警上限"] = number_format($v[18]/10, 2) ."℃";
      

      
        $dataArray["第3组电池温度报警上限"] = number_format($v[19]/10, 2) ."℃";
      

      
        $dataArray["第4组电池温度报警上限"] = number_format($v[20]/10, 2) ."℃";
      

      
        $dataArray["第1组电池电压差异报警上限"] = number_format($v[21]/10, 2) ."%";
      

      
        $dataArray["第2组电池电压差异报警上限"] = number_format($v[22]/10, 2) ."%";
      

      
        $dataArray["第3组电池电压差异报警上限"] = number_format($v[23]/10, 2) ."%";
      

      
        $dataArray["第4组电池电压差异报警上限"] = number_format($v[24]/10, 2) ."%";
      

      
        $dataArray["第1组电池温度差异报警上限"] = number_format($v[25]/10, 2) ."℃";
      

      
        $dataArray["第2组电池温度差异报警上限"] = number_format($v[26]/10, 2) ."℃";
      

      
        $dataArray["第3组电池温度差异报警上限"] = number_format($v[27]/10, 2) ."℃";
      

      
        $dataArray["第4组电池温度差异报警上限"] = number_format($v[28]/10, 2) ."℃";
      

      $offset += 56;

                    
$v = unpack("s*" , substr($memData , $offset, 2*4));
$lMemData = substr($memData , $offset, 2*4);
      $lOffset = 0;
      
        $dataArray["第1组电池环境温度"] = number_format($v[1]/10, 2) ."℃";
      

      
        $dataArray["第2组电池环境温度"] = number_format($v[2]/10, 2) ."℃";
      

      
        $dataArray["第3组电池环境温度"] = number_format($v[3]/10, 2) ."℃";
      

      
        $dataArray["第4组电池环境温度"] = number_format($v[4]/10, 2) ."℃";
      

      $offset += 8;

            $v = unpack("S*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=0;$i<125;$i++){
            $name = sprintf("第%d号电池内阻初始值", 1 + $i);
            $kIndex = 1 + $i;
            $dataArray[$name] = number_format($v[$kIndex]/1000, 3)."mΩ";
          }
      

      $offset += 250;

            $v = unpack("S*" , substr($memData , $offset, 2*125));
$lMemData = substr($memData , $offset, 2*125);
      $lOffset = 0;
      
          for($i=0;$i<125;$i++){
            $name = sprintf("第%d号电池内阻初始值", 126 + $i);
            $kIndex = 1 + $i;
            $dataArray[$name] = number_format($v[$kIndex]/1000, 3)."mΩ";
          }
      

      $offset += 250;

        $v = unpack('v', substr($memData, $offset , 2));
        $year = $v[1];
        $v = unpack('C*', substr($memData, $offset + 2 , 5));
        $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    }
}

