<?php

function _GetPMBusCheckMsg($value, $model = '')
{
        switch ($value) {
            case 0:
                return "正常";
            case 1:
                return "低于下限";
            case 2:
                return "高于上限";
            case 3:
                return "缺相";
            case 4:
                return "熔丝断";
            case 5:
                return "开关断开";
            case 0xe0:
                return "交流输入不平衡";
            case 0xe1:
                return "交流停电";
            case 0xe2:
                return "通讯中断";
            case 0xe3:
                return "市电切换失败";
            default:
                return "正常";
        }
        return "无效";
}

function _CheckAlertMap($value, $rules)
{
        if (isset($rules)) {
            if (isset($rules[0][$value])) {
                return $rules[0][$value];
            }
            return $rules[1];
        }
        //default handler
        if ($value == 0) {
            return "正常";
        } else if ($value == 1) {
            return "故障";
        }
        return "无效";
}

function _GetPMBus41_44Msg($v, $model = '')
{
        switch ($v) {
            case 0:
                return "正常";
            case 1:
                return "故障";
        }
        return "未知告警" . dechex($v);
}

function _GetAlertM($value)
{
        switch ($value) {
            case 0:
                return "正常";
            case 3:
                return "熔丝断";
            case 4:
                return "开";
            default:
                break;
        }

        return "无效";
}

function _Get_PMBusPower_RtData($memData,&$dataArray,$extraPara,$config)
{
    $airlock_number = $config["ac"]["airlock"];
    $p40_43_number = $config["ac"]["p40_43"];
    $p40_41_number = $config["ac"]["p40_41"];
    $p40_44_number = $config["ac"]["p40_44"];
    $acLen = (18 + $airlock_number + 1 + $p40_43_number + 3 + 7);
    $acChannelLen = (16 + 6 + 4 * $p40_41_number + $p40_44_number);


    $offset = 4;
    $v = @unpack('f*', substr($memData, $offset + 4 , 3 * 4));
    $dataArray["交流屏输出电流A"] = number_format($v[1], 2);
    $dataArray["交流屏输出电流B"] = number_format($v[2], 2);
    $dataArray["交流屏输出电流C"] = number_format($v[3], 2);
    $v = @unpack('C', substr($memData, $offset + 4 + 3 * 4, 1));
    $dataArray["交流通道数"] = $v[1];
    $v = @unpack('C', substr($memData, $offset + 4 + 3 * 4 + 1, 1));
    $dataArray["交流空开数"] = $v[1];
    $v = @unpack('C*', substr($memData, $offset + 4 + 3 * 4 + 1 + 1, $airlock_number));
    $v = @unpack('C', substr($memData, $offset + 4 + 3 * 4 + 1 + 1 + $airlock_number, 1));
    $p40_43_count = $v[1];
    if ($p40_43_count != $p40_43_number) {
        $dataArray["40_43"] = false;
    }
    $v = @unpack('C*', substr($memData, $offset + 4 + 3 * 4 + 1 + 1 + $airlock_number + 1, $p40_43_number));
    $p40_43_index = -1;
    $p40_43_label = $config["ac"]["p40_43_label"];
    $p40_43_rules = $config["ac"]["p40_43_rules"];
    foreach ($p40_43_label as $key => $show) {
        $p40_43_index++;
        if ($show) {
            $dataArray[$key] = _CheckAlertMap($v[$p40_43_index + 1], $p40_43_rules[$p40_43_index]);
        }
    }

    $v = @unpack('C*', substr($memData, $offset + 4 + 3 * 4 + 1 + 1 + $airlock_number + 1 + $p40_43_number, 3));
    $dataArray["A相输入电流告警状态"] = _GetPMBusCheckMsg($v[1], '');
    $dataArray["B相输入电流告警状态"] = _GetPMBusCheckMsg($v[2], '');
    $dataArray["C相输入电流告警状态"] = _GetPMBusCheckMsg($v[3], '');

    $v = @unpack('v', substr($memData, $offset + 4 + 3 * 4 + 1 + 1 + $airlock_number + 1 + $p40_43_number + 3, 2));
    //$year = $v[1];
    $v = @unpack('C*', substr($memData, $offset + 4 + 3 * 4 + 1 + 1 + $airlock_number + 1 + $p40_43_number + 3 + 2, 5));
    //$dataArray["交流更新时间"] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));

    $p40_44_label = $config["ac"]["p40_44_label"];
    $p40_44_rules = $config["ac"]["p40_44_rules"];

    $offset = $offset + 4 + 3 * 4 + 1 + 1 + $airlock_number + 1 + $p40_43_number + 3 + 2 + 5;
    for ($i = 0; $i < 2; $i++) {
        $channelData = substr($memData, $offset  + $i * $acChannelLen, $acChannelLen);
        $v = @unpack('f*', substr($channelData, 0, 4 * 4));
        $dataArray["交流输入".($i+1)."输入线/相电压AB/A"] = number_format($v[1], 2);
        $dataArray["交流输入".($i+1)."输入线/相电压BC/B"] = number_format($v[2], 2);
        $dataArray["交流输入".($i+1)."输入线/相电压CA/C"] = number_format($v[3], 2);
        $dataArray["交流输入".($i+1)."输入频率"] = number_format($v[4], 2);
	$dataArray["交流输入".($i+1)."自定义停电"] = ($v[1] < 150) && ($v[2] < 150) && ($v[3] < 150) ? "告警" : "正常";
        $v = @unpack('C', substr($channelData, 4 * 4, 1));
        
        // $channelObj->p40_41_count = $v[1];
        // if ($channelObj->p40_41_count != $p40_41_number) {
        //     $dataObj->isMatch = false;
        // }
        // $v = unpack('f*', substr($channelData, 4 * 4 + 1, 4 * $p40_41_number));
        // $channelObj->p40_41 = array();
        // foreach ($v as $val) {
        //     if (abs($val - (-0.1)) < 0.1) {
        //         $channelObj->p40_41[] = "未监测";
        //     } else {
        //         $channelObj->p40_41[] = number_format($val, 2);
        //     }
        // }
        $v = @unpack('C*', substr($channelData, 4 * 4 + 1 + 4 * $p40_41_number, 5));
        $dataArray["交流输入".($i+1)."输入线/相电压AB/A告警"] = _GetPMBusCheckMsg($v[1], '');
        $dataArray["交流输入".($i+1)."输入线/相电压BC/B告警"] = _GetPMBusCheckMsg($v[2], '');
        $dataArray["交流输入".($i+1)."输入线/相电压CA/C告警"] = _GetPMBusCheckMsg($v[3], '');
        $dataArray["交流输入".($i+1)."频率告警"] = _GetPMBusCheckMsg($v[4], '');
        //$channelObj->p40_44_count = $v[5];
        $v = @unpack('C*', substr($channelData, 4 * 4 + 1 + 4 * $p40_41_number + 5, $p40_44_number));


        $p40_44_index = -1;
        foreach ($p40_44_label as $key => $show) {
            $p40_44_index++;
            $dataArray["交流输入".($i+1).$key] = _CheckAlertMap($v[$p40_44_index + 1], $p40_44_rules[$p40_44_index]);
        }        
    }
    //rc
    $p41_41_number = $config["rc"]["p41_41"];
    $p41_43_number = $config["rc"]["p41_43"];
    $p41_44_number = $config["rc"]["p41_44"];
    $p41_41_label =  $config["rc"]["p41_41_label"];
    $p41_43_label = $config["rc"]["p41_43_label"];
    $p41_43_rules = $config["rc"]["p41_43_rules"];
    $p41_44_label = $config["rc"]["p41_44_label"];
    $p41_44_rules = $config["rc"]["p41_44_rules"];


    $v = @unpack('f', substr($memData, $offset + 2 * $acChannelLen, 4));
    $dataArray["整流模块输出电压"] = number_format($v[1], 2);
    $v = @unpack('C', substr($memData, $offset + 2 * $acChannelLen + 4, 1));
    $dataArray["整流模块数量"] = $v[1];
    $rcChannelLen = (1 + $p41_41_number) * 4 + 7 + $p41_43_number + $p41_44_number;

    for ($i = 0; $i < $dataArray["整流模块数量"]; $i++) {
        $label = "整流模块".($i+1);
        $channelData = substr($memData, $offset + 2 * $acChannelLen + 4 + 1 + $rcChannelLen * $i, $rcChannelLen);
        $v = @unpack('f', substr($channelData, 0, 4));
        $dataArray[$label."输出电流"] = number_format($v[1], 2);
        //$dataArray[$label."输出电压"] = number_format($v[1], 2);
        $v = @unpack('C', substr($channelData, 4, 1));

	if($p41_41_number){
        $v = @unpack('f*', substr($channelData, 4 + 1, 4*$p41_41_number));
        $p41_41_index = 0;
        foreach ($p41_41_label as $key => $show) {
            $p41_41_index++;
            $dataArray[$label.$key] = number_format($v[$p41_41_index], 2);
            
        }
	}
        $v = @unpack('C*', substr($channelData, 4 + 1 + 4 * $p41_41_number, 4));
        if ($v[1] == 0) {
            $dataArray[$label."开关机状态"] = "开机";
        } else if ($v[1] == 1) {
            $dataArray[$label."开关机状态"] = "关机";
        } else if ($v[1] == 2) {
            $dataArray[$label."开关机状态"] = "休眠";
        } else {
            $dataArray[$label."开关机状态"] = "未知";
        }
        if ($v[2] == 0) {
            $dataArray[$label."限流/不限流状态"] = "限流";
        } else if ($v[2] == 1) {
            $dataArray[$label."限流/不限流状态"] = "不限流";
        } else {
            $dataArray[$label."限流/不限流状态"] = "未知";
        }
        if ($v[3] == 0) {
            $dataArray[$label."浮充/均充/测试状态"] = "浮充";
        } else if ($v[3] == 1) {
            $dataArray[$label."浮充/均充/测试状态"] = "均充";
        } else if ($v[3] == 2) {
            $dataArray[$label."浮充/均充/测试状态"] = "测试";
        } else {
            $dataArray[$label."浮充/均充/测试状态"] = "未知";
        }

        $v = @unpack('C', substr($channelData, 4 + 1 + 4 * $p41_41_number + 4, $p41_43_number));
        
        $p41_43_index = -1;
        foreach ($p41_43_label as $key => $show) {
            $p41_43_index++;
            $dataArray[$label.$key] = _CheckAlertMap($v[$p41_43_index + 1], $p41_43_rules[$p41_43_index]);
        }

        $v = @unpack('C*', substr($channelData, 4 + 1 + 4 * $p41_41_number + 4 + $p41_43_number, 2));
        $dataArray[$label."故障"] = _GetPMBus41_44Msg($v[1]);
        //$channelObj->p41_44_count = $v[2];

        $v = @unpack('C*', substr($channelData, 4 + 1 + 4 * $p41_41_number + 4 + $p41_43_number + 2, $p41_44_number));
        
        
        $p41_44_index = -1;
        foreach ($p41_44_label as $key => $show) {
            $p41_44_index++;
            $dataArray[$label.$key] = _CheckAlertMap($v[$p41_44_index + 1], $p41_44_rules[$p41_44_index]);
        }
    }
    //DC
    $dcOffset = $offset + 2 * $acChannelLen + 4 + 1 + $rcChannelLen * 40;

    $m_number = $config["dc"]["m"];
    $n_number = $config["dc"]["n"];
    $p_number = $config["dc"]["p"];
    $alert_m_number = $config["dc"]["alert_m"];
    $alert_p_number = $config["dc"]["alert_p"];
    $p_label = $config["dc"]["p_label"];
    $alert_p_label = $config["dc"]["alert_p_label"];
    $alert_p_rules = $config["dc"]["alert_p_rules"];


    $dcLen = (4 * 3 + 1 + 4 * $m_number + 1 + 4 * $n_number + 1 + 4 * $p_number + 2 + $alert_m_number + 1 + $alert_p_number + 7);


    $v = @unpack('f*', substr($memData, $dcOffset + 4, 4 * 2));
    if(is_nan($v[1])){  
        $dataArray["直流输出电压"] = "无效值";
    }else{
        $dataArray["直流输出电压"] = number_format($v[1], 2) . "V";
    }
    if(is_nan($v[2])){
        $dataArray["总负载电流"] = "无效值";
    }else{
        $dataArray["总负载电流"] = number_format($v[2], 2) . "A";
    }
    $v = @unpack('C', substr($memData, $dcOffset + 4 + 4 * 2, 1));
    $dataArray["监测电池分路电流数量"] = $v[1];
    $v = @unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1, $m_number * 4));
    foreach ($v as $i=>$val) {
        if(is_nan($val)){
            $dataArray["电池电流".$i] = "无效值"; 
        }else{
            $dataArray["电池电流".$i] = number_format($val, 2) . "A";
        }
    }
    $v = @unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4, 1));
    $dataArray["监测直流分路电流数"] = $v[1];
    $v = @unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1, $n_number * 4));
    foreach ($v as $i=>$val) {
        if (is_nan($val)) {
            $dataArray["直流分路电流".$i] = 0.0;
        } else {
            $dataArray["直流分路电流".$i] = $val;
        }
    }
    $v = @unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4, 1));
    $p_count = $v[1];
    if ($p_count != $p_number) {
        $dataArray["msg"] .= "p_count != " . $p_number;
    }
    $v = @unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1, $p_number * 4));
    $i = 1;
    foreach ($p_label as $label=>$val) {
        if (abs($v[$i] - (-0.1)) < 0.01) {
            $dataArray[$label] = "未监测";
        } else {
	    //2025-10-17 cscp_419特殊处理
	    if($config["model"] == "cscp_419" && $label == "环境温度"){
              $dataArray[$label] = number_format($v[$i]/100, 2);
	    }else if($config["model"] == "cscp_419" && $label == "电池温度"){
              $dataArray[$label] = number_format($v[$i]/10, 2);
	    }else{
              $dataArray[$label] = number_format($v[$i], 2);
	    }
        }
        $i++;
    }
    $v = @unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4, 2));
    $dataArray["直流电压告警"] = _GetPMBusCheckMsg($v[1]);
    //$dataObj->alert_m_count = $v[2];
    $v = @unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2, $alert_m_number));
    foreach ($v as $i=>$k) {
        $dataArray["熔丝".$i] = _GetAlertM($k);
    }
    $v = @unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number, 1));
    $alert_p_count = $v[1];
    if ($alert_p_count != $alert_p_number) {
        $dataArray["msg"] .= "alert_p_count != " . $alert_p_number;
    }
    $v = @unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1, $alert_p_number));
    $alert_p_index = -1;
    foreach ($alert_p_label as $key => $show) {
        $alert_p_index++;
        if (is_array($show)) {
            $avIndex = 0;
            foreach ($show as $kv => $av) {
                if ($av) {
                    $bValue = ($v[$alert_p_index + 1] >> $avIndex++) & 0x1;
                    if ($bValue == 0) {
                        $dataArray[$key] = "正常";
                    } else if ($bValue == 1) {
                        $dataArray[$key] = "告警";
                    } else {
                        $dataArray[$key] = "无效";
                    }
                }
            }
        } else {
            if ($show) {
                $dataArray[$key] = _CheckAlertMap($v[$alert_p_index + 1], isset($alert_p_rules[$alert_p_index]) ? $alert_p_rules[$alert_p_index] : $alert_p_rules[0]);
            }
        }
    }
    //Last
    $offset = $dcOffset + $dcLen;
    $v = @unpack('v',substr($memData, $offset , 2));
    $year = $v[1];		
    $v = @unpack('C*', substr($memData, $offset+2 , 5));
    $dataArray['更新时间'] = date('Y-m-d H:i:s', strtotime($year . '-' . $v[1] . '-' . $v[2] . ' ' . $v[3] . ':' . $v[4] . ':' . $v[5]));
    //DC2
    $dcOffset = $offset + 7;
    $v = @unpack('f*', substr($memData, $dcOffset + 4, 4 * 2));
    if(is_nan($v[1])){
        $dataArray["直流屏2直流输出电压"] = "无效值";
    }else{
        $dataArray["直流屏2直流输出电压"] = number_format($v[1], 2) . "V";
    }
    if(is_nan($v[2])){
        $dataArray["直流屏2总负载电流"] = "无效值";
    }else{
        $dataArray["直流屏2总负载电流"] = number_format($v[2], 2) . "A";
    }
    $v = @unpack('C', substr($memData, $dcOffset + 4 + 4 * 2, 1));
    $dataArray["直流屏2监测电池分路电流数量"] = $v[1];
    $v = @unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1, $m_number * 4));
    foreach ($v as $i=>$val) {
        if(is_nan($val)){
            $dataArray["直流屏2电池电流".$i] = "无效值";
        }else{
            $dataArray["直流屏2电池电流".$i] = number_format($val, 2) . "A";
        }
    }
    $v = @unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4, 1));
    $dataArray["直流屏2监测直流分路电流数"] = $v[1];
    $v = @unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1, $n_number * 4));
    foreach ($v as $i=>$val) {
        if (is_nan($val)) {
            $dataArray["直流屏2直流分路电流".$i] = 0.0;
        } else {
            $dataArray["直流屏2直流分路电流".$i] = $val;
        }
    }
    $v = @unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4, 1));
    $p_count = $v[1];
    if ($p_count != $p_number) {
        $dataArray["msg"] .= "p_count != " . $p_number;
    }
    $v = @unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1, $p_number * 4));
    $i = 1;
    foreach ($p_label as $label=>$val) {
        if (abs($v[$i] - (-0.1)) < 0.01) {
            $dataArray["直流屏2".$label] = "未监测";
        } else {
            $dataArray["直流屏2".$label] = number_format($v[$i], 2);
        }
        $i++;
    }
    $v = @unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4, 2));
    $dataArray["直流屏2直流电压告警"] = _GetPMBusCheckMsg($v[1]);
    //$dataObj->alert_m_count = $v[2];
    $v = @unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2, $alert_m_number));
    foreach ($v as $i=>$k) {
        $dataArray["直流屏2熔丝".$i] = _GetAlertM($k);
    }
    $v = @unpack('C', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number, 1));
    $alert_p_count = $v[1];
    if ($alert_p_count != $alert_p_number) {
        $dataArray["msg"] .= "alert_p_count != " . $alert_p_number;
    }
    $v = @unpack('C*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1, $alert_p_number));
    $alert_p_index = -1;
    foreach ($alert_p_label as $key => $show) {
        $alert_p_index++;
        if (is_array($show)) {
            $avIndex = 0;
            foreach ($show as $kv => $av) {
                if ($av) {
                    $bValue = ($v[$alert_p_index + 1] >> $avIndex++) & 0x1;
                    if ($bValue == 0) {
                        $dataArray["直流屏2".$key] = "正常";
                    } else if ($bValue == 1) {
                        $dataArray["直流屏2".$key] = "告警";
                    } else {
                        $dataArray["直流屏2".$key] = "无效";
                    }
                }
            }
        } else {
            if ($show) {
                $dataArray["直流屏2".$key] = _CheckAlertMap($v[$alert_p_index + 1], isset($alert_p_rules[$alert_p_index]) ? $alert_p_rules[$alert_p_index] : $alert_p_rules[0]);
            }
        }
    }
   if(isset($config["model"]) && $config["model"] == "dkd46"){
	$v = unpack('f*', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1 + $alert_p_number, 4*2));
	$dataArray["温度"] = $v[1];
	$dataArray["湿度"] = $v[2];
   }else if(isset($config["model"]) && $config["model"] == "cuc0609h_419"){
        $v = unpack('S', substr($memData, $dcOffset + 4 + 4 * 2 + 1 + $m_number * 4 + 1 + $n_number * 4 + 1 + $p_number * 4 + 2 + $alert_m_number + 1 + $alert_p_number , 2));
        $dataArray["电池放电测试电流"] = $v[1];
   }
}
